/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.DefaultBindableScrollableComboBox;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.ImageUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.awt.Mnemonics;

public class AlboPicturePanel
extends JPanel
implements CidsBeanStore,
ConnectionContextStore,
Disposable {
    private static final Logger LOG = Logger.getLogger(AlboPicturePanel.class);
    private CidsBean cidsBean;
    private ConnectionContext cc;
    private boolean editable;
    private WebDavTunnelHelper webDavHelper;
    private SwingWorker<ImageIcon, Void> imageLoader;
    private JComboBox<String> cbType;
    private JScrollPane jScrollPane1;
    private JLabel labBeschreibung;
    private JLabel labName;
    private JLabel labPreview;
    private JLabel labTyp;
    private JLabel labVorschau;
    private JPanel panPreview;
    private JTextArea txtBeschrei;
    private JTextField txtName;
    private BindingGroup bindingGroup;

    public AlboPicturePanel() {
        this.initComponents();
    }

    public AlboPicturePanel(boolean editable) {
        this.editable = editable;
        this.initComponents();
        if (!editable) {
            RendererTools.makeReadOnly(this.cbType);
            this.cbType.setEditable(false);
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtBeschrei);
        }
    }

    public void setWebDavHelper(WebDavTunnelHelper webDavHelper) {
        this.webDavHelper = webDavHelper;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panPreview = new JPanel();
        this.labTyp = new JLabel();
        this.cbType = new DefaultBindableScrollableComboBox();
        this.txtName = new JTextField();
        this.labName = new JLabel();
        this.labBeschreibung = new JLabel();
        this.labPreview = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtBeschrei = new JTextArea();
        this.labVorschau = new JLabel();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.panPreview.setBorder(BorderFactory.createTitledBorder("Dokument"));
        this.panPreview.setName("panPreview");
        this.panPreview.setOpaque(false);
        this.panPreview.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTyp, (String)"Typ:");
        this.labTyp.setName("labTyp");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.labTyp, gridBagConstraints);
        ((DefaultBindableScrollableComboBox)this.cbType).setNullable(true);
        this.cbType.setName("cbType");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.dokumentart}"), this.cbType, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add(this.cbType, gridBagConstraints);
        this.txtName.setName("txtName");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.txtName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labName, (String)"Name:");
        this.labName.setName("labName");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.labName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labBeschreibung, (String)"Beschreibung:");
        this.labBeschreibung.setName("labBeschreibung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.labBeschreibung, gridBagConstraints);
        this.labPreview.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.labPreview, (String)"nicht verf\u00fcgbar");
        this.labPreview.setName("labPreview");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.labPreview, gridBagConstraints);
        this.jScrollPane1.setName("jScrollPane1");
        this.txtBeschrei.setColumns(20);
        this.txtBeschrei.setRows(5);
        this.txtBeschrei.setName("txtBeschrei");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.beschreibung}"), (Object)this.txtBeschrei, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane1.setViewportView(this.txtBeschrei);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labVorschau, (String)"Vorschau:");
        this.labVorschau.setName("labVorschau");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panPreview.add((Component)this.labVorschau, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panPreview, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public void setCidsBean(final CidsBean cidsBean) {
        try {
            this.bindingGroup.unbind();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean, (ConnectionContext)this.getConnectionContext());
            this.cidsBean = cidsBean;
            this.bindingGroup.bind();
            if (cidsBean.getProperty("dateiname") instanceof String && this.webDavHelper != null) {
                String filename = (String)cidsBean.getProperty("dateiname");
                this.labPreview.setPreferredSize(this.labPreview.getPreferredSize());
                this.labPreview.setIcon(null);
                this.labPreview.setText("wird geladen");
                if (filename.toLowerCase().endsWith("png") || filename.toLowerCase().endsWith("jpg")) {
                    SwingWorker<ImageIcon, Void> worker = new SwingWorker<ImageIcon, Void>(){

                        @Override
                        protected ImageIcon doInBackground() throws Exception {
                            InputStream is = AlboPicturePanel.this.webDavHelper.getFileFromWebDAV((String)cidsBean.getProperty("dateiname"), AlboPicturePanel.this.getConnectionContext());
                            BufferedImage image = ImageIO.read(is);
                            if (this.isCancelled()) {
                                return null;
                            }
                            ImageIcon ic = AlboPicturePanel.this.labPreview.getWidth() > 40 && AlboPicturePanel.this.labPreview.getHeight() > 40 ? new ImageIcon(ImageUtil.adjustScale((BufferedImage)image, (int)(AlboPicturePanel.this.labPreview.getWidth() - 10), (int)(AlboPicturePanel.this.labPreview.getHeight() - 10), (int)20, (int)20)) : new ImageIcon(image);
                            if (this.isCancelled()) {
                                return null;
                            }
                            return ic;
                        }

                        @Override
                        protected void done() {
                            try {
                                ImageIcon ii = (ImageIcon)this.get();
                                if (ii != null) {
                                    AlboPicturePanel.this.labPreview.setText("");
                                    AlboPicturePanel.this.labPreview.setIcon(ii);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex);
                            }
                        }
                    };
                    if (this.imageLoader != null) {
                        this.imageLoader.cancel(true);
                    }
                    this.imageLoader = worker;
                    this.imageLoader.execute();
                } else {
                    this.labPreview.setIcon(null);
                    this.labPreview.setText("F\u00fcr diesen Datentyp ist keine Vorschau verf\u00fcgbar");
                }
            } else {
                this.labPreview.setIcon(null);
                this.labPreview.setText("Vorschau kann nicht geladen werden");
            }
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void initWithConnectionContext(ConnectionContext cc) {
        this.cc = cc;
    }

    public ConnectionContext getConnectionContext() {
        return this.cc;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void dispose() {
        this.setCidsBean(null);
    }
}

