/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import de.cismet.cids.custom.objecteditors.wunda_blau.albo.ComboBoxFilterDialogEnabledFilter;
import de.cismet.cids.custom.wunda_blau.search.server.AbstractMonToLwmoSearch;
import de.cismet.cids.editors.FastBindableReferenceCombo;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ComboBoxFilterDialog
extends JDialog
implements ConnectionContextProvider {
    private final JComboBox comboBox;
    private final AbstractMonToLwmoSearch search;
    private final ConnectionContext connectionContext;
    private ComboBoxFilterDialogEnabledFilter filter = null;
    private SwingWorker<Void, Void> refreshWorker;
    private JButton btnApply;
    private JButton btnCancel;
    private JComboBox<String> cbSearch;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable table;
    private JTextField txtFilter;

    public ComboBoxFilterDialog() {
        this(null, null, null, ConnectionContext.createDummy());
    }

    public ComboBoxFilterDialog(AbstractMonToLwmoSearch search, ConnectionContext connectionContext) {
        this(null, search, null, connectionContext);
    }

    public ComboBoxFilterDialog(JComboBox comboBox, ConnectionContext connectionContext) {
        this(comboBox, null, null, connectionContext);
    }

    public ComboBoxFilterDialog(AbstractMonToLwmoSearch search, String title, ConnectionContext connectionContext) {
        this(null, search, title, connectionContext);
    }

    public ComboBoxFilterDialog(JComboBox comboBox, String title, ConnectionContext connectionContext) {
        this(comboBox, null, title, connectionContext);
    }

    public ComboBoxFilterDialog(JComboBox comboBox, AbstractMonToLwmoSearch search, String title, ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.search = search;
        this.initComponents();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private int lastSelectedRow = -1;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = ComboBoxFilterDialog.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    int step = -1;
                    int index = selectedRow;
                    int indexModel = ComboBoxFilterDialog.this.getRowSorter().convertRowIndexToModel(selectedRow);
                    String selectedValue = String.valueOf(ComboBoxFilterDialog.this.comboBox.getModel().getElementAt(ComboBoxFilterDialog.this.getRowSorter().convertRowIndexToModel(selectedRow)));
                    if (this.lastSelectedRow < selectedRow) {
                        step = 1;
                    }
                    while (ComboBoxFilterDialog.this.filter != null && !ComboBoxFilterDialog.this.filter.selectionOfDisabledElementsAllowed() && !ComboBoxFilterDialog.this.filter.isEnabled(selectedValue, indexModel)) {
                        if ((index += step) >= ComboBoxFilterDialog.this.table.getRowSorter().getViewRowCount() || index <= -1) {
                            index = -1;
                            break;
                        }
                        indexModel = ComboBoxFilterDialog.this.getRowSorter().convertRowIndexToModel(index);
                        selectedValue = String.valueOf(ComboBoxFilterDialog.this.comboBox.getModel().getElementAt(indexModel));
                    }
                    if (index != -1) {
                        ComboBoxFilterDialog.this.table.getSelectionModel().setSelectionInterval(index, index);
                    } else {
                        ComboBoxFilterDialog.this.table.getSelectionModel().clearSelection();
                    }
                }
                this.lastSelectedRow = ComboBoxFilterDialog.this.table.getSelectedRow();
            }
        });
        this.comboBox = search != null ? this.cbSearch : comboBox;
        this.setTitle(title != null ? title : "Auswahlfilter");
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.getSelectionTableModel());
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        sorter.setRowFilter(new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                String filterText = ComboBoxFilterDialog.this.txtFilter.getText().trim();
                if (entry == null || entry.getValue(0) == null) {
                    return false;
                }
                if (filterText.isEmpty()) {
                    return true;
                }
                return entry.getValue(0).toString().toLowerCase().contains(filterText.toLowerCase());
            }
        });
        this.getTable().setRowSorter(sorter);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ComboBoxFilterDialog.this.btnApply.setEnabled(ComboBoxFilterDialog.this.table.getSelectedRow() >= 0);
                }
            }
        });
        this.getTable().getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int modelRow = ComboBoxFilterDialog.this.getRowSorter().convertRowIndexToModel(row);
                if (ComboBoxFilterDialog.this.filter != null && !ComboBoxFilterDialog.this.filter.isEnabled(value, modelRow)) {
                    c.setEnabled(false);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setToolTipText(ComboBoxFilterDialog.this.filter.getTooltip(value, modelRow));
                    }
                } else if (ComboBoxFilterDialog.this.filter != null) {
                    c.setEnabled(true);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setToolTipText(ComboBoxFilterDialog.this.filter.getTooltip(value, modelRow));
                    }
                }
                return c;
            }
        });
        this.getRootPane().setDefaultButton(this.btnApply);
        this.refresh();
    }

    public void refresh() {
        if (this.search != null) {
            if (this.refreshWorker != null) {
                this.refreshWorker.cancel(true);
            }
            this.refreshWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    ((FastBindableReferenceCombo)ComboBoxFilterDialog.this.cbSearch).setMetaClassFromTableName(ComboBoxFilterDialog.this.search.getDomain(), ComboBoxFilterDialog.this.search.getTableName());
                    ((FastBindableReferenceCombo)ComboBoxFilterDialog.this.cbSearch).refreshModel();
                    return null;
                }

                @Override
                protected void done() {
                    ComboBoxFilterDialog.this.getSelectionTableModel().fireTableDataChanged();
                    ComboBoxFilterDialog.this.txtFilter.requestFocus();
                }
            };
            this.txtFilter.setText("");
            this.cbSearch.setModel(new DefaultComboBoxModel<String>(new String[]{"Objekte werden geladen..."}));
            this.refreshWorker.execute();
        } else {
            this.getSelectionTableModel().fireTableDataChanged();
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private TableModel getSelectionTableModel() {
        return (TableModel)this.table.getModel();
    }

    private TableRowSorter getRowSorter() {
        return (TableRowSorter)this.table.getRowSorter();
    }

    private ListSelectionModel getSelectionModel() {
        return this.table.getSelectionModel();
    }

    private JTable getTable() {
        return this.table;
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    private void initComponents() {
        this.cbSearch = this.search != null ? new FastBindableReferenceCombo((LightweightMetaObjectsSearch)this.search, this.search.getRepresentationPattern(), this.search.getRepresentationFields()) : new FastBindableReferenceCombo();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.txtFilter = new JTextField();
        this.jPanel2 = new JPanel();
        this.btnApply = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.table.setModel(new TableModel());
        this.table.setSelectionMode(0);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setTableHeader(null);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ComboBoxFilterDialog.this.tableMouseClicked(evt);
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ComboBoxFilterDialog.this.tableKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.txtFilter.setText(NbBundle.getMessage(ComboBoxFilterDialog.class, (String)"ComboBoxFilterDialog.txtFilter.text"));
        this.txtFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ComboBoxFilterDialog.this.txtFilterKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                ComboBoxFilterDialog.this.txtFilterKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.txtFilter, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnApply, (String)NbBundle.getMessage(ComboBoxFilterDialog.class, (String)"ComboBoxFilterDialog.btnApply.text"));
        this.btnApply.setEnabled(false);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComboBoxFilterDialog.this.btnApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel2.add((Component)this.btnApply, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(ComboBoxFilterDialog.class, (String)"ComboBoxFilterDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComboBoxFilterDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void tableKeyPressed(KeyEvent evt) {
        if (10 == evt.getKeyCode()) {
            evt.consume();
            this.btnApplyActionPerformed(null);
        } else if (38 == evt.getKeyCode()) {
            if (this.table.getSelectedRow() == 0) {
                this.txtFilter.requestFocus();
            }
        } else if (37 == evt.getKeyCode()) {
            this.txtFilter.requestFocus();
        } else if (27 == evt.getKeyCode()) {
            this.dispose();
        }
    }

    private void txtFilterKeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBoxFilterDialog.this.getRowSorter().sort();
                boolean singleSelected = ComboBoxFilterDialog.this.getRowSorter().getViewRowCount() == 1;
                int rowIndex = singleSelected ? 0 : -1;
                ComboBoxFilterDialog.this.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                ComboBoxFilterDialog.this.btnApply.setEnabled(singleSelected);
            }
        });
    }

    private void txtFilterKeyPressed(KeyEvent evt) {
        if (40 == evt.getKeyCode() || 39 == evt.getKeyCode()) {
            this.getTable().requestFocus();
            this.getSelectionModel().setSelectionInterval(0, 0);
        } else if (27 == evt.getKeyCode()) {
            this.dispose();
        }
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        if (this.getTable().getSelectedRow() >= 0) {
            TableRowSorter rowSorter = this.getRowSorter();
            this.getComboBox().setSelectedIndex(((RowSorter)rowSorter).convertRowIndexToModel(this.getTable().getSelectedRow()));
            this.dispose();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.getTable().getSelectedRow() >= 0) {
            TableRowSorter rowSorter = this.getRowSorter();
            this.getComboBox().setSelectedIndex(((RowSorter)rowSorter).convertRowIndexToModel(this.getTable().getSelectedRow()));
            this.dispose();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (this.getComboBox() != null) {
            this.getComboBox().setSelectedIndex(-1);
        }
        super.setVisible(b);
    }

    public Object showAndGetSelected() {
        if (this.getComboBox().getSelectedItem() != null) {
            this.table.requestFocus();
        } else {
            this.txtFilter.requestFocus();
        }
        StaticSwingTools.showDialog((Component)this.getParent(), (JDialog)this, (boolean)true);
        return this.getComboBox() != null ? this.getComboBox().getSelectedItem() : null;
    }

    public void setEnabledFilter(ComboBoxFilterDialogEnabledFilter filter) {
        this.filter = filter;
    }

    public static Object showForCombobox(JComboBox comboBox, ConnectionContext connectionContext) {
        return ComboBoxFilterDialog.showForCombobox(comboBox, null, connectionContext);
    }

    public static Object showForCombobox(JComboBox comboBox, String title, ConnectionContext connectionContext) {
        return new ComboBoxFilterDialog(comboBox, title, connectionContext).showAndGetSelected();
    }

    public static Object showForCombobox(JComboBox comboBox, String title, ComboBoxFilterDialogEnabledFilter filter, ConnectionContext connectionContext) {
        ComboBoxFilterDialog dialog = new ComboBoxFilterDialog(comboBox, title, connectionContext);
        dialog.setEnabledFilter(filter);
        return dialog.showAndGetSelected();
    }

    public static Object showForSearch(AbstractMonToLwmoSearch search, String title, ConnectionContext connectionContext) {
        return new ComboBoxFilterDialog(search, title, connectionContext).showAndGetSelected();
    }

    class TableModel
    extends AbstractTableModel {
        TableModel() {
        }

        @Override
        public int getRowCount() {
            return ComboBoxFilterDialog.this.comboBox != null ? ComboBoxFilterDialog.this.comboBox.getModel().getSize() : 0;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ComboBoxFilterDialog.this.comboBox != null ? (ComboBoxFilterDialog.this.comboBox.getModel().getElementAt(rowIndex) != null ? ComboBoxFilterDialog.this.comboBox.getModel().getElementAt(rowIndex).toString() : null) : null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return null;
        }
    }
}

