/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.mauer;

import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.wunda_blau.MauerEditor;
import de.cismet.cids.custom.objecteditors.wunda_blau.TreppeEditor;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MauerBauteilZustandKostenPanel
extends JPanel
implements CidsBeanStore,
Disposable,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(MauerBauteilZustandKostenPanel.class);
    private static final TreppeEditor.IntegerToLongConverter CONVERTER_INT = new TreppeEditor.IntegerToLongConverter();
    private static final double[][][] MATRIX_DSV = new double[][][]{new double[][]{{1.0, 1.1, 2.0, 2.5, 4.0}, {1.2, 1.3, 2.1, 2.6, 4.0}, {2.1, 2.2, 2.3, 2.7, 4.0}, {3.0, 3.2, 3.4, 3.6, 4.0}, {4.0, 4.0, 4.0, 4.0, 4.0}}, new double[][]{{1.1, 1.3, 2.1, 2.6, 4.0}, {1.5, 1.7, 2.2, 2.7, 4.0}, {2.2, 2.3, 2.4, 2.8, 4.0}, {3.1, 3.3, 3.5, 3.7, 4.0}, {4.0, 4.0, 4.0, 4.0, 4.0}}, new double[][]{{1.8, 2.1, 2.2, 2.7, 4.0}, {2.2, 2.3, 2.4, 2.8, 4.0}, {2.3, 2.5, 2.6, 2.9, 4.0}, {3.2, 3.4, 3.6, 3.8, 4.0}, {4.0, 4.0, 4.0, 4.0, 4.0}}, new double[][]{{2.5, 2.6, 2.7, 2.8, 4.0}, {2.7, 2.8, 2.9, 3.0, 4.0}, {2.8, 3.0, 3.1, 3.2, 4.0}, {3.3, 3.5, 3.7, 3.8, 4.0}, {4.0, 4.0, 4.0, 4.0, 4.0}}, new double[][]{{3.0, 3.1, 3.2, 3.3, 4.0}, {3.2, 3.3, 3.4, 3.5, 4.0}, {3.3, 3.5, 3.6, 3.7, 4.0}, {3.3, 3.5, 3.7, 3.8, 4.0}, {3.4, 3.6, 3.8, 4.0, 4.0}}};
    private final boolean editable;
    private CidsBean cidsBean;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final PropertyChangeListener propChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (("verkehrssicherheit".equalsIgnoreCase(name) || "standsicherheit".equalsIgnoreCase(name) || "dauerhaftigkeit".equalsIgnoreCase(name)) && evt.getOldValue() != evt.getNewValue()) {
                MauerBauteilZustandKostenPanel.this.recalculateGesamt();
            }
        }
    };
    private final MauerEditor mauerEditor;
    private final NumberFormatter nf = new NumberFormatter(new DecimalFormat("#0"));
    private final String bauteilName;
    private final boolean manual;
    DefaultBindableReferenceCombo cbEingriffGruendung;
    JFormattedTextField jFormattedTextField1;
    JFormattedTextField jFormattedTextField2;
    JFormattedTextField jFormattedTextField3;
    JFormattedTextField jFormattedTextField4;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JLabel jLabel4;
    JSpinner jSpinner1;
    JTextArea jTextArea1;
    JTextArea tfBeschreibung;
    private BindingGroup bindingGroup;

    public MauerBauteilZustandKostenPanel() {
        this(null, null, false, false);
    }

    public MauerBauteilZustandKostenPanel(MauerEditor mauerEditor, String bauteilName) {
        this(mauerEditor, bauteilName, false, false);
    }

    public MauerBauteilZustandKostenPanel(MauerEditor mauerEditor, String bauteilName, boolean editable) {
        this(mauerEditor, bauteilName, editable, false);
    }

    public MauerBauteilZustandKostenPanel(MauerEditor mauerEditor, String bauteilName, boolean editable, boolean manual) {
        this.mauerEditor = mauerEditor;
        this.bauteilName = bauteilName;
        this.editable = editable;
        this.manual = manual;
        this.nf.setMinimum(Integer.valueOf(0));
        this.nf.setMaximum(Integer.valueOf(4));
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        MauerEditor.setLimitDocumentFilter(this.tfBeschreibung, 500);
        MauerEditor.setLimitDocumentFilter(this.jTextArea1, 500);
        this.jTextArea1.addKeyListener(new RendererTools.NoTabTextAreaKeyAdapter());
        RendererTools.makeDoubleSpinnerWithoutButtons(this.jSpinner1, 2);
        if (!this.editable) {
            RendererTools.makeReadOnly(this.jFormattedTextField1);
            RendererTools.makeReadOnly(this.jFormattedTextField2);
            RendererTools.makeReadOnly(this.jFormattedTextField3);
            RendererTools.makeReadOnly(this.jFormattedTextField4);
            RendererTools.makeReadOnly(this.jSpinner1);
            RendererTools.makeReadOnly(this.jTextArea1);
            RendererTools.makeReadOnly(this.tfBeschreibung);
            RendererTools.makeReadOnly((JComponent)this.cbEingriffGruendung);
        }
        this.jLabel1.setVisible(!this.manual);
        this.jFormattedTextField1.setVisible(!this.manual);
        this.jLabel2.setVisible(!this.manual);
        this.jFormattedTextField2.setVisible(!this.manual);
        this.jLabel3.setVisible(!this.manual);
        this.jFormattedTextField3.setVisible(!this.manual);
        this.jLabel4.setVisible(!this.manual);
    }

    public String getBauteilName() {
        return this.bauteilName;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        RoundedPanel panZusammenfassung = new RoundedPanel();
        SemiRoundedPanel panZusammenfassungTitle = new SemiRoundedPanel();
        JLabel lblHeaderAllgemein = new JLabel();
        JPanel panZusammenfassungContent = new JPanel();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane10 = new JScrollPane();
        this.tfBeschreibung = new JTextArea();
        JLabel lblbeschreibungGruendung = new JLabel();
        Box.Filler filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        JLabel lblEingriffAnsicht1 = new JLabel();
        this.cbEingriffGruendung = new DefaultBindableReferenceCombo();
        JLabel jLabel5 = new JLabel();
        Box.Filler filler9 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        JPanel jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jFormattedTextField1 = new JFormattedTextField(this.nf);
        this.jFormattedTextField2 = new JFormattedTextField(this.nf);
        this.jFormattedTextField3 = new JFormattedTextField(this.nf);
        this.jFormattedTextField4 = new JFormattedTextField(this.nf);
        Box.Filler filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        Box.Filler filler5 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        Box.Filler filler6 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        Box.Filler filler7 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        JLabel jLabel11 = new JLabel();
        Box.Filler filler8 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        JLabel jLabel6 = new JLabel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel7 = new JLabel();
        Box.Filler filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        Box.Filler filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jSpinner1 = new JSpinner();
        JSeparator jSeparator1 = new JSeparator();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        panZusammenfassung.setName("panZusammenfassung");
        panZusammenfassung.setLayout((LayoutManager)new GridBagLayout());
        panZusammenfassungTitle.setBackground(new Color(51, 51, 51));
        panZusammenfassungTitle.setName("panZusammenfassungTitle");
        panZusammenfassungTitle.setLayout((LayoutManager)new FlowLayout());
        lblHeaderAllgemein.setForeground(new Color(255, 255, 255));
        lblHeaderAllgemein.setName("lblHeaderAllgemein");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${bauteilName}"), (Object)lblHeaderAllgemein, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"Zustand & Sanierung");
        binding.setSourceUnreadableValue((Object)"Zustand & Sanierung");
        this.bindingGroup.addBinding((Binding)binding);
        panZusammenfassungTitle.add((Component)lblHeaderAllgemein);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        panZusammenfassung.add((Component)panZusammenfassungTitle, (Object)gridBagConstraints);
        panZusammenfassungContent.setName("panZusammenfassungContent");
        panZusammenfassungContent.setOpaque(false);
        panZusammenfassungContent.setLayout(new GridBagLayout());
        jPanel2.setName("jPanel2");
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());
        jScrollPane10.setMinimumSize(new Dimension(26, 70));
        jScrollPane10.setName("jScrollPane10");
        jScrollPane10.setPreferredSize(new Dimension(0, 70));
        this.tfBeschreibung.setLineWrap(true);
        this.tfBeschreibung.setMinimumSize(new Dimension(500, 70));
        this.tfBeschreibung.setName("tfBeschreibung");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.beschreibung}"), (Object)this.tfBeschreibung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        jScrollPane10.setViewportView(this.tfBeschreibung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel2.add((Component)jScrollPane10, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)lblbeschreibungGruendung, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.lblbeschreibungGruendung.text"));
        lblbeschreibungGruendung.setName("lblbeschreibungGruendung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel2.add((Component)lblbeschreibungGruendung, gridBagConstraints);
        filler3.setName("filler3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(19, 0, 19, 0);
        jPanel2.add((Component)filler3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)lblEingriffAnsicht1, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.lblEingriffAnsicht1.text"));
        lblEingriffAnsicht1.setName("lblEingriffAnsicht1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel2.add((Component)lblEingriffAnsicht1, gridBagConstraints);
        this.cbEingriffGruendung.setName("cbEingriffGruendung");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_eingriff}"), (Object)this.cbEingriffGruendung, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel2.add((Component)this.cbEingriffGruendung, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)jLabel5, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel5.text"));
        jLabel5.setName("jLabel5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        filler9.setName("filler9");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)filler9, gridBagConstraints);
        jPanel4.setName("jPanel4");
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel1.text"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel1.toolTipText"));
        this.jLabel1.setName("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 0, 1, 7);
        jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel2.text"));
        this.jLabel2.setToolTipText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel2.toolTipText"));
        this.jLabel2.setName("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 10, 1, 7);
        jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel3.text"));
        this.jLabel3.setToolTipText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel3.toolTipText"));
        this.jLabel3.setName("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 10, 1, 7);
        jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel4.text"));
        this.jLabel4.setToolTipText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel4.toolTipText"));
        this.jLabel4.setName("jLabel4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(1, 10, 1, 7);
        jPanel4.add((Component)this.jLabel4, gridBagConstraints);
        this.jFormattedTextField1.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.jFormattedTextField1.setHorizontalAlignment(0);
        this.jFormattedTextField1.setText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jFormattedTextField1.text"));
        this.jFormattedTextField1.setMinimumSize(new Dimension(50, 32));
        this.jFormattedTextField1.setName("jFormattedTextField1");
        this.jFormattedTextField1.setPreferredSize(new Dimension(50, 32));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.standsicherheit}"), (Object)this.jFormattedTextField1, (Property)BeanProperty.create((String)"value"));
        binding.setConverter((Converter)CONVERTER_INT);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel4.add((Component)this.jFormattedTextField1, gridBagConstraints);
        this.jFormattedTextField2.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.jFormattedTextField2.setHorizontalAlignment(0);
        this.jFormattedTextField2.setText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jFormattedTextField1.text"));
        this.jFormattedTextField2.setMinimumSize(new Dimension(50, 32));
        this.jFormattedTextField2.setName("jFormattedTextField2");
        this.jFormattedTextField2.setPreferredSize(new Dimension(50, 32));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.verkehrssicherheit}"), (Object)this.jFormattedTextField2, (Property)BeanProperty.create((String)"value"));
        binding.setConverter((Converter)CONVERTER_INT);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel4.add((Component)this.jFormattedTextField2, gridBagConstraints);
        this.jFormattedTextField3.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.jFormattedTextField3.setHorizontalAlignment(0);
        this.jFormattedTextField3.setText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jFormattedTextField1.text"));
        this.jFormattedTextField3.setMinimumSize(new Dimension(50, 32));
        this.jFormattedTextField3.setName("jFormattedTextField3");
        this.jFormattedTextField3.setPreferredSize(new Dimension(50, 32));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.dauerhaftigkeit}"), (Object)this.jFormattedTextField3, (Property)BeanProperty.create((String)"value"));
        binding.setConverter((Converter)CONVERTER_INT);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 2);
        jPanel4.add((Component)this.jFormattedTextField3, gridBagConstraints);
        this.jFormattedTextField4.setEditable(false);
        this.jFormattedTextField4.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0"))));
        this.jFormattedTextField4.setHorizontalAlignment(0);
        this.jFormattedTextField4.setText(NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jFormattedTextField4.text_1"));
        this.jFormattedTextField4.setMinimumSize(new Dimension(50, 32));
        this.jFormattedTextField4.setName("jFormattedTextField4");
        this.jFormattedTextField4.setPreferredSize(new Dimension(50, 32));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gesamt}"), (Object)this.jFormattedTextField4, (Property)BeanProperty.create((String)"value"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        jPanel4.add((Component)this.jFormattedTextField4, gridBagConstraints);
        filler4.setName("filler4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        jPanel4.add((Component)filler4, gridBagConstraints);
        filler5.setName("filler5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        jPanel4.add((Component)filler5, gridBagConstraints);
        filler6.setName("filler6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        jPanel4.add((Component)filler6, gridBagConstraints);
        filler7.setName("filler7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        jPanel4.add((Component)filler7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)jLabel11, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel11.text"));
        jLabel11.setName("jLabel11");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel2.add((Component)jLabel11, gridBagConstraints);
        filler8.setName("filler8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(19, 0, 19, 0);
        jPanel2.add((Component)filler8, gridBagConstraints);
        jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(4);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setName("jTextArea1");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.sanierungsmassnahmen}"), (Object)this.jTextArea1, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        jScrollPane1.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel2.add((Component)jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)jLabel6, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel6.text"));
        jLabel6.setName("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        jPanel3.setName("jPanel3");
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)jLabel7, (String)NbBundle.getMessage(MauerBauteilZustandKostenPanel.class, (String)"MauerBauteilZustandKostenPanel.jLabel7.text"));
        jLabel7.setName("jLabel7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)jLabel7, gridBagConstraints);
        filler2.setName("filler2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 45, 0, 45);
        jPanel3.add((Component)filler2, gridBagConstraints);
        filler1.setName("filler1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)filler1, gridBagConstraints);
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)0.01));
        this.jSpinner1.setName("jSpinner1");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.kosten}"), (Object)this.jSpinner1, (Property)BeanProperty.create((String)"value"));
        binding.setSourceNullValue((Object)0.0);
        binding.setSourceUnreadableValue((Object)0.0);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        jPanel3.add((Component)this.jSpinner1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jSeparator1.setName("jSeparator1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel2.add((Component)jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        panZusammenfassungContent.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panZusammenfassung.add((Component)panZusammenfassungContent, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)panZusammenfassung, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void recalculateGesamt() {
        final CidsBean cidsBean = this.cidsBean;
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Integer standsicherheit = (Integer)cidsBean.getProperty("standsicherheit");
                Integer verkehrssicherheit = (Integer)cidsBean.getProperty("verkehrssicherheit");
                Integer dauerhaftigkeit = (Integer)cidsBean.getProperty("dauerhaftigkeit");
                try {
                    if (standsicherheit != null && verkehrssicherheit != null && dauerhaftigkeit != null && standsicherheit >= 0 && verkehrssicherheit >= 0 && dauerhaftigkeit >= 0 && standsicherheit < MATRIX_DSV[0].length && verkehrssicherheit < MATRIX_DSV[0][0].length && dauerhaftigkeit < MATRIX_DSV.length) {
                        double zustand = MATRIX_DSV[dauerhaftigkeit][standsicherheit][verkehrssicherheit];
                        cidsBean.setProperty("gesamt", (Object)zustand);
                    } else {
                        cidsBean.setProperty("gesamt", null);
                    }
                    MauerBauteilZustandKostenPanel.this.mauerEditor.recalculateOverview();
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Zustand konnte nicht berechnet werden.", (Throwable)ex);
                }
                return null;
            }
        }.execute();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener(this.propChangeListener);
        }
        if (this.bindingGroup != null) {
            this.bindingGroup.unbind();
            if (cidsBean != null) {
                DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean, (ConnectionContext)this.getConnectionContext());
            }
            this.cidsBean = cidsBean;
            this.bindingGroup.bind();
        }
        if (cidsBean != null) {
            cidsBean.addPropertyChangeListener(this.propChangeListener);
        }
        if (this.editable) {
            this.recalculateGesamt();
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener(this.propChangeListener);
            this.cidsBean = null;
        }
    }
}

