/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.treppe;

import de.cismet.cids.custom.objecteditors.wunda_blau.TreppeEditor;
import de.cismet.cids.custom.objecteditors.wunda_blau.treppe.TreppeLeitelementPanel;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class TreppeLeitelementePanel
extends JPanel
implements Disposable,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(TreppeLeitelementePanel.class);
    private final boolean netbeansDesignDummy;
    private List<CidsBean> cidsBeans;
    private final boolean editable;
    private final ConnectionContext connectionContext;
    JButton btnAddArt1;
    Box.Filler filler1;
    JPanel jPanel1;
    TreppeLeitelementPanel treppeLeitelementPanel1;

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        if (this.netbeansDesignDummy) {
            this.treppeLeitelementPanel1 = new TreppeLeitelementPanel();
        }
        this.btnAddArt1 = new JButton();
        FormListener formListener = new FormListener();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        jScrollPane1.setBorder(null);
        jScrollPane1.setName("jScrollPane1");
        jScrollPane1.setOpaque(false);
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.filler1.setName("filler1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        if (this.netbeansDesignDummy) {
            this.treppeLeitelementPanel1.setName("treppeLeitelementPanel1");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            this.jPanel1.add((Component)this.treppeLeitelementPanel1, gridBagConstraints);
        }
        jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane1, gridBagConstraints);
        jScrollPane1.getViewport().setOpaque(false);
        this.btnAddArt1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        this.btnAddArt1.setBorderPainted(false);
        this.btnAddArt1.setContentAreaFilled(false);
        this.btnAddArt1.setName("btnAddArt1");
        this.btnAddArt1.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.btnAddArt1, gridBagConstraints);
    }

    public TreppeLeitelementePanel() {
        this(ConnectionContext.createDeprecated());
    }

    public TreppeLeitelementePanel(ConnectionContext connectionContext) {
        this(true, true, connectionContext);
    }

    public TreppeLeitelementePanel(boolean editable, ConnectionContext connectionContext) {
        this(editable, false, connectionContext);
    }

    public TreppeLeitelementePanel(boolean editable, boolean netbeansDesignDummy, ConnectionContext connectionContext) {
        this.netbeansDesignDummy = netbeansDesignDummy;
        this.editable = editable;
        this.connectionContext = connectionContext;
        this.initComponents();
        this.btnAddArt1.setVisible(editable);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setCidsBeans(List<CidsBean> cidsBeans) {
        this.jPanel1.removeAll();
        this.cidsBeans = cidsBeans;
        if (cidsBeans != null) {
            Collections.sort(cidsBeans, new TreppeEditor.TeilementComparator("nummer"));
            for (CidsBean cidsBean : cidsBeans) {
                this.addLeitelementPanel(cidsBean);
            }
        }
    }

    private void addLeitelementPanel(final CidsBean cidsBean) {
        this.jPanel1.remove(this.filler1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.cidsBeans.size();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        new SwingWorker<JPanel, Void>(){

            @Override
            protected JPanel doInBackground() throws Exception {
                TreppeLeitelementPanel panel = new TreppeLeitelementPanel(TreppeLeitelementePanel.this.editable);
                panel.setCidsBean(cidsBean);
                panel.setParent(TreppeLeitelementePanel.this);
                return panel;
            }

            @Override
            protected void done() {
                try {
                    JPanel panel = (JPanel)this.get();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.gridy = TreppeLeitelementePanel.this.cidsBeans.indexOf(cidsBean);
                    gridBagConstraints.insets = new Insets(0, 0, 5, 0);
                    TreppeLeitelementePanel.this.jPanel1.add((Component)panel, gridBagConstraints);
                    TreppeLeitelementePanel.this.jPanel1.repaint();
                }
                catch (Exception ex) {
                    String message = "Fehler beim Hinzuf\u00fcgen des Leitelements.";
                    LOG.error((Object)"Fehler beim Hinzuf\u00fcgen des Leitelements.", (Throwable)ex);
                    ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Hinzuf\u00fcgen des Leitelements.", ex, TreppeLeitelementePanel.this);
                }
            }
        }.execute();
    }

    public void removeLeitelementPanel(TreppeLeitelementPanel panel) {
        if (panel != null) {
            this.cidsBeans.remove(panel.getCidsBean());
            this.jPanel1.remove(panel);
            this.jPanel1.repaint();
        }
    }

    public List<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    private void btnAddArt1ActionPerformed(ActionEvent evt) {
        try {
            CidsBean cidsBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"TREPPE_ABSTURZSICHERUNG", (ConnectionContext)this.getConnectionContext());
            cidsBean.setProperty("zustand", (Object)CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"TREPPE_ZUSTAND", (ConnectionContext)this.getConnectionContext()));
            this.addLeitelementPanel(cidsBean);
            this.cidsBeans.add(cidsBean);
        }
        catch (Exception ex) {
            String message = "Fehler beim Erzeugen des Leitelements.";
            LOG.error((Object)"Fehler beim Erzeugen des Leitelements.", (Throwable)ex);
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Erzeugen des Leitelements.", ex, this);
        }
    }

    public void dispose() {
        for (Component comp : this.jPanel1.getComponents()) {
            if (!(comp instanceof TreppeLeitelementPanel)) continue;
            TreppeLeitelementPanel panel = (TreppeLeitelementPanel)comp;
            panel.dispose();
            this.jPanel1.remove(panel);
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == TreppeLeitelementePanel.this.btnAddArt1) {
                TreppeLeitelementePanel.this.btnAddArt1ActionPerformed(evt);
            }
        }
    }
}

