/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.converter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.collections.TypeSafeCollections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.beansbinding.Converter;

public class CollectionToStringConverter
extends Converter<List<CidsBean>, String> {
    private static final Pattern REGEX = Pattern.compile("\\$\\{(.*?)\\}");
    private final Set<String> foundPropertyNames;
    private final String inputExpression;
    private final String separator;
    private final String prefix;
    private final String postfix;

    public CollectionToStringConverter(String propName) {
        this(propName, ", ", "", "");
    }

    public CollectionToStringConverter(String propName, String separator) {
        this(propName, separator, "", "");
    }

    public CollectionToStringConverter(String propName, String separator, String prefix, String postfix) {
        if (propName == null || separator == null || prefix == null || postfix == null) {
            throw new IllegalArgumentException();
        }
        this.foundPropertyNames = TypeSafeCollections.newHashSet();
        this.inputExpression = propName;
        this.separator = separator;
        this.prefix = prefix;
        this.postfix = postfix;
        this.parseStringForReplaceToken();
    }

    public static final CollectionToStringConverter getHtmlTaggingCollectionConverter(String property, String separator) {
        return new CollectionToStringConverter(property, separator, "<html>", "</html>");
    }

    private void parseStringForReplaceToken() {
        Matcher matcher = REGEX.matcher(this.inputExpression);
        while (matcher.find()) {
            String toAdd = matcher.group(matcher.groupCount());
            this.foundPropertyNames.add(toAdd);
        }
    }

    private String insertValuesIntoPatternString(CidsBean bean) {
        if (!this.foundPropertyNames.isEmpty()) {
            String workingCopy = this.inputExpression;
            for (String propertyName : this.foundPropertyNames) {
                StringBuilder variableToReplace = new StringBuilder("${").append(propertyName).append("}");
                Object content = bean.getProperty(propertyName);
                String contentString = content != null ? content.toString() : "";
                workingCopy = workingCopy.replace(variableToReplace, contentString);
            }
            return workingCopy;
        }
        return String.valueOf(bean.getProperty(this.inputExpression));
    }

    public String convertForward(List<CidsBean> list) {
        if (list != null && !list.isEmpty()) {
            StringBuffer sb = new StringBuffer(this.prefix);
            for (CidsBean bean : list) {
                if (this.inputExpression == null) continue;
                sb.append(this.insertValuesIntoPatternString(bean)).append(this.separator);
            }
            if (sb.length() > 1 + this.prefix.length()) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(this.postfix);
            return sb.toString();
        }
        return null;
    }

    public List<CidsBean> convertReverse(String arg0) {
        throw new UnsupportedOperationException();
    }
}

