/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.converter;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdesktop.beansbinding.Converter;

public class SQLTimestampToStringConverter
extends Converter<Timestamp, String> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy hh:mm:sss");
    private final DateFormat dateFormat;

    public SQLTimestampToStringConverter() {
        this(DATE_FORMAT);
    }

    public SQLTimestampToStringConverter(String simpleDateFormatString) {
        this(new SimpleDateFormat(simpleDateFormatString));
    }

    public SQLTimestampToStringConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String convertForward(Timestamp date) {
        if (date == null) {
            return "";
        }
        return this.dateFormat.format(date);
    }

    public Timestamp convertReverse(String dateString) {
        Date uDate;
        try {
            uDate = this.dateFormat.parse(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
        return new Timestamp(uDate.getTime());
    }
}

