/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import de.cismet.cids.dynamics.CidsBean;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;

public class BillingCalculations {
    public static BigDecimal calculateBruttoSumFromBillings(Collection<CidsBean> billingBeans) {
        HashMap<BigDecimal, BigDecimal> mwstSatz_nettoSum = new HashMap<BigDecimal, BigDecimal>();
        for (CidsBean billing : billingBeans) {
            Double netto_summe_bean = (Double)billing.getProperty("netto_summe");
            BigDecimal netto_summe = netto_summe_bean != null ? BigDecimal.valueOf(netto_summe_bean) : new BigDecimal("0");
            Double mwst_satz_bean = (Double)billing.getProperty("mwst_satz");
            BigDecimal mwst_satz = mwst_satz_bean != null ? new BigDecimal(mwst_satz_bean.toString()) : new BigDecimal("0");
            if (mwstSatz_nettoSum.containsKey(mwst_satz)) {
                BigDecimal subtotal = (BigDecimal)mwstSatz_nettoSum.get(mwst_satz);
                BigDecimal newSubtotal = subtotal.add(netto_summe);
                mwstSatz_nettoSum.put(mwst_satz, newSubtotal);
                continue;
            }
            mwstSatz_nettoSum.put(mwst_satz, netto_summe);
        }
        BigDecimal totalSum = new BigDecimal("0");
        for (BigDecimal mwst_satz : mwstSatz_nettoSum.keySet()) {
            BigDecimal nettoSum = (BigDecimal)mwstSatz_nettoSum.get(mwst_satz);
            BigDecimal percent = mwst_satz.divide(new BigDecimal("100"));
            BigDecimal mwstValue = nettoSum.multiply(percent);
            mwstValue = mwstValue.setScale(2, 4);
            BigDecimal bruttoSum = nettoSum.add(mwstValue);
            bruttoSum = bruttoSum.setScale(2, 4);
            totalSum = totalSum.add(bruttoSum);
        }
        return totalSum;
    }
}

