/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Paint;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DefaultPreviewMapPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(DefaultPreviewMapPanel.class);
    final StyledFeature previewGeometry = new DefaultStyledFeature();
    private final MappingComponent previewMap;

    public DefaultPreviewMapPanel() {
        this.initComponents();
        this.previewMap = new MappingComponent();
        this.add((Component)this.previewMap, "Center");
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
    }

    public void initMap(final CidsBean cidsBean, String geometryAttributeName, double geoBuffer, final String mapURL) {
        Object geoObj;
        boolean showMap = false;
        if (cidsBean != null && (geoObj = cidsBean.getProperty(geometryAttributeName)) instanceof Geometry) {
            showMap = true;
            final Geometry pureGeom = CrsTransformer.transformToGivenCrs((Geometry)((Geometry)geoObj), (String)ClientAlkisConf.getInstance().getSrsService());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ClientAlkisConf.getInstance().GeoBUffer: " + ClientAlkisConf.getInstance().getGeoBuffer()));
            }
            XBoundingBox box = new XBoundingBox(pureGeom.getEnvelope().buffer(geoBuffer));
            double diagonalLength = Math.sqrt(box.getWidth() * box.getWidth() + box.getHeight() * box.getHeight());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Buffer for map: " + diagonalLength));
            }
            final XBoundingBox bufferedBox = new XBoundingBox(box.getGeometry().buffer(diagonalLength));
            Runnable mapRunnable = new Runnable(){

                @Override
                public void run() {
                    ActiveLayerModel mappingModel = new ActiveLayerModel();
                    mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                    mappingModel.addHome(new XBoundingBox(bufferedBox.getX1(), bufferedBox.getY1(), bufferedBox.getX2(), bufferedBox.getY2(), ClientAlkisConf.getInstance().getSrsService(), true));
                    SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(mapURL));
                    swms.setName(cidsBean.getClass().getSimpleName());
                    DefaultPreviewMapPanel.this.previewGeometry.setGeometry(pureGeom);
                    DefaultPreviewMapPanel.this.previewGeometry.setFillingPaint((Paint)new Color(1.0f, 0.0f, 0.0f, 0.5f));
                    DefaultPreviewMapPanel.this.previewGeometry.setLineWidth(3);
                    DefaultPreviewMapPanel.this.previewGeometry.setLinePaint((Paint)new Color(1.0f, 0.0f, 0.0f, 1.0f));
                    mappingModel.addLayer((RetrievalServiceLayer)swms);
                    DefaultPreviewMapPanel.this.previewMap.setMappingModel((MappingModel)mappingModel);
                    int duration = DefaultPreviewMapPanel.this.previewMap.getAnimationDuration();
                    DefaultPreviewMapPanel.this.previewMap.setAnimationDuration(0);
                    DefaultPreviewMapPanel.this.previewMap.gotoInitialBoundingBox();
                    DefaultPreviewMapPanel.this.previewMap.setInteractionMode("ZOOM");
                    DefaultPreviewMapPanel.this.previewMap.unlock();
                    DefaultPreviewMapPanel.this.previewMap.addCustomInputListener("MUTE", new PBasicInputEventHandler(){

                        public void mouseClicked(PInputEvent evt) {
                            if (evt.getClickCount() > 1) {
                                CidsBean bean = cidsBean;
                                ObjectRendererUtils.switchToCismapMap();
                                ObjectRendererUtils.addBeanGeomAsFeatureToCismapMap(bean, false);
                            }
                        }
                    });
                    DefaultPreviewMapPanel.this.previewMap.setInteractionMode("MUTE");
                    if (DefaultPreviewMapPanel.this.previewMap.getFeatureCollection().contains((Feature)DefaultPreviewMapPanel.this.previewGeometry)) {
                        DefaultPreviewMapPanel.this.previewMap.getFeatureCollection().removeFeature((Feature)DefaultPreviewMapPanel.this.previewGeometry);
                    }
                    DefaultPreviewMapPanel.this.previewMap.getFeatureCollection().addFeature((Feature)DefaultPreviewMapPanel.this.previewGeometry);
                    DefaultPreviewMapPanel.this.previewMap.setAnimationDuration(duration);
                }
            };
            if (EventQueue.isDispatchThread()) {
                mapRunnable.run();
            } else {
                EventQueue.invokeLater(mapRunnable);
            }
        }
        this.showMap(showMap);
    }

    public void dispose() {
        this.previewMap.dispose();
    }

    public void initMap(CidsBean cidsBean, String geometryAttributeName, double geoBuffer) {
        this.initMap(cidsBean, geometryAttributeName, geoBuffer, ClientAlkisConf.getInstance().getMapCallString());
    }

    public void initMap(CidsBean cidsBean, String geometryAttributeName) {
        this.initMap(cidsBean, geometryAttributeName, ClientAlkisConf.getInstance().getGeoBuffer(), ClientAlkisConf.getInstance().getMapCallString());
    }

    private void showMap(boolean showMap) {
        this.previewMap.setVisible(showMap);
    }
}

