/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import de.cismet.tools.collections.TypeSafeCollections;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;

public final class SortedListModel
extends AbstractListModel {
    private static final Comparator LIST_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String str1 = String.valueOf(o1);
            String str2 = String.valueOf(o2);
            return Collator.getInstance().compare(str1, str2);
        }
    };
    private final TreeSet model = TypeSafeCollections.newTreeSet((Comparator)LIST_COMPARATOR);

    @Override
    public int getSize() {
        return this.model.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.model.toArray()[index];
    }

    public void addElement(Object element) {
        if (this.model.add(element)) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public void addAll(Object[] elements) {
        List<Object> c = Arrays.asList(elements);
        this.model.addAll(c);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void clear() {
        this.model.clear();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public boolean contains(Object element) {
        return this.model.contains(element);
    }

    public Object firstElement() {
        return this.model.first();
    }

    public Iterator iterator() {
        return this.model.iterator();
    }

    public Object lastElement() {
        return this.model.last();
    }

    public boolean removeElement(Object element) {
        boolean removed = this.model.remove(element);
        if (removed) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
        return removed;
    }
}

