/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.wunda_blau.search.server.VeraenderungsartLightweightSearch;
import de.cismet.cids.custom.wunda_blau.search.server.VermessungFlurstueckKickerLightweightSearch;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class VermessungFlurstueckFinder {
    private static final Logger LOG = Logger.getLogger(VermessungFlurstueckFinder.class);
    public static final String FLURSTUECK_KICKER_TABLE_NAME = "vermessung_flurstueck_kicker";
    public static final String FLURSTUECK_GEMARKUNG = "gemarkung";
    public static final String FLURSTUECK_FLUR = "flur";
    public static final String FLURSTUECK_ZAEHLER = "zaehler";
    public static final String FLURSTUECK_NENNER = "nenner";
    public static final String GEMARKUNG_TABLE_NAME = "gemarkung";
    public static final String GEMARKUNG_ID = "gemarkungsnummer";
    public static final String GEMARKUNG_NAME = "name";
    public static final String VERMESSUNG_FLURSTUECKSVERMESSUNG_TABLE_NAME = "vermessung_flurstuecksvermessung";
    public static final String VERMESSUNG_FLURSTUECKSVERMESSUNG_FLURSTUECK = "flurstueck";
    public static final String VERMESSUNG_FLURSTUECKSVERMESSUNG_VERMESSUNGSART = "veraenderungsart";
    public static final String VERMESSUNG_GEMARKUNG_TABLE_NAME = "vermessung_gemarkung";
    public static final String VERMESSUNG_GEMARKUNG_ID = "id";
    public static final String VERMESSUNG_GEMARKUNG_NAME = "name";
    public static final String VERMESSUNG_VERAENDERUNGSART_TABLE_NAME = "vermessung_art";
    public static final String VERMESSUNG_VERAENDERUNGSART_ID = "id";
    public static final String VERMESSUNG_VERAENDERUNGSART_CODE = "code";
    public static final String VERMESSUNG_VERAENDERUNGSART_NAME = "name";
    public static final String SEP = " - ";
    private static final Comparator<MetaObject> ZAEHLER_NENNER_COMPARATOR = new Comparator<MetaObject>(){

        @Override
        public final int compare(MetaObject o1, MetaObject o2) {
            LightweightMetaObject lwmo1 = (LightweightMetaObject)o1;
            LightweightMetaObject lwmo2 = (LightweightMetaObject)o2;
            int result = AlphanumComparator.getInstance().compare(lwmo1.getLWAttribute(VermessungFlurstueckFinder.FLURSTUECK_NENNER), lwmo2.getLWAttribute(VermessungFlurstueckFinder.FLURSTUECK_NENNER));
            if (result == 0) {
                result = AlphanumComparator.getInstance().compare(lwmo1.getLWAttribute(VermessungFlurstueckFinder.FLURSTUECK_ZAEHLER), lwmo2.getLWAttribute(VermessungFlurstueckFinder.FLURSTUECK_ZAEHLER));
            }
            return result;
        }
    };

    public static final MetaObject[] getLWLandparcels(ConnectionContext connectionContext) {
        try {
            VermessungFlurstueckKickerLightweightSearch search = new VermessungFlurstueckKickerLightweightSearch();
            search.setSearchFor(VermessungFlurstueckKickerLightweightSearch.SearchFor.ALLE_FLUSTUECKE);
            search.setRepresentationFields(new String[]{"gemarkung", FLURSTUECK_FLUR, FLURSTUECK_ZAEHLER, FLURSTUECK_NENNER});
            Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, connectionContext);
            for (LightweightMetaObject lwmo : lwmos) {
                lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                    public String getRepresentation() {
                        StringBuilder result = new StringBuilder(30);
                        result.append(this.getAttribute("gemarkung")).append("-");
                        result.append(this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_FLUR)).append("-");
                        result.append(this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_ZAEHLER));
                        Object nenner = this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_NENNER);
                        if (nenner != null) {
                            result.append("/").append(nenner);
                        }
                        return result.toString();
                    }
                });
            }
            return lwmos.toArray(new MetaObject[0]);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static final MetaObject[] getLWGemarkungen(ConnectionContext connectionContext) {
        try {
            VermessungFlurstueckKickerLightweightSearch search = new VermessungFlurstueckKickerLightweightSearch();
            search.setSearchFor(VermessungFlurstueckKickerLightweightSearch.SearchFor.ALLE_GEMARKUNGEN);
            search.setRepresentationFields(new String[]{"id", "gemarkung", "name"});
            Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, connectionContext);
            for (LightweightMetaObject lwmo : lwmos) {
                lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                    public String getRepresentation() {
                        return String.valueOf(this.getAttribute("gemarkung"));
                    }
                });
            }
            return lwmos.toArray(new MetaObject[0]);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static final MetaObject getLWGemarkung(int gemarkung, ConnectionContext connectionContext) {
        try {
            VermessungFlurstueckKickerLightweightSearch search = new VermessungFlurstueckKickerLightweightSearch();
            search.setSearchFor(VermessungFlurstueckKickerLightweightSearch.SearchFor.GEMARKUNG);
            search.setGemarkungsnummer(Integer.toString(gemarkung));
            search.setRepresentationFields(new String[]{"id", "name"});
            Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, connectionContext);
            for (LightweightMetaObject lwmo : lwmos) {
                lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                    public String getRepresentation() {
                        return String.valueOf(this.getAttribute("name"));
                    }
                });
            }
            return lwmos.toArray(new MetaObject[0])[0];
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static final MetaObject[] getLWFlure(String gemarkungsnummer, ConnectionContext connectionContext) {
        try {
            VermessungFlurstueckKickerLightweightSearch search = new VermessungFlurstueckKickerLightweightSearch();
            search.setSearchFor(VermessungFlurstueckKickerLightweightSearch.SearchFor.FLURE);
            search.setGemarkungsnummer(gemarkungsnummer);
            search.setRepresentationFields(new String[]{"id", FLURSTUECK_FLUR});
            Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, connectionContext);
            for (LightweightMetaObject lwmo : lwmos) {
                lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                    public String getRepresentation() {
                        return String.valueOf(this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_FLUR));
                    }
                });
            }
            return lwmos.toArray(new MetaObject[0]);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static MetaObject[] getVeraenderungsarten(ConnectionContext connectionContext) {
        try {
            VeraenderungsartLightweightSearch search = new VeraenderungsartLightweightSearch();
            search.setRepresentationFields(new String[]{"id", VERMESSUNG_VERAENDERUNGSART_CODE, "name"});
            Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, connectionContext);
            for (LightweightMetaObject lwmo : lwmos) {
                lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                    public String getRepresentation() {
                        StringBuilder result = new StringBuilder();
                        result.append(this.getAttribute(VermessungFlurstueckFinder.VERMESSUNG_VERAENDERUNGSART_CODE));
                        result.append(" (");
                        result.append(this.getAttribute("name"));
                        result.append(')');
                        return result.toString();
                    }
                });
            }
            return lwmos.toArray(new MetaObject[0]);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static final MetaObject[] getLWFurstuecksZaehlerNenner(String gemarkungsnummer, String flur, ConnectionContext connectionContext) {
        try {
            VermessungFlurstueckKickerLightweightSearch search = new VermessungFlurstueckKickerLightweightSearch();
            search.setSearchFor(VermessungFlurstueckKickerLightweightSearch.SearchFor.ZAEHLER_NENNER);
            search.setGemarkungsnummer(gemarkungsnummer);
            search.setFlur(flur);
            search.setRepresentationFields(new String[]{"id", FLURSTUECK_ZAEHLER, FLURSTUECK_NENNER});
            Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, connectionContext);
            for (LightweightMetaObject lwmo : lwmos) {
                lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                    public String getRepresentation() {
                        StringBuilder result = new StringBuilder();
                        result.append(this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_ZAEHLER));
                        Object nenner = this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_NENNER);
                        if (nenner != null) {
                            result.append("/").append(nenner);
                        }
                        return result.toString();
                    }
                });
            }
            MetaObject[] result = lwmos.toArray(new MetaObject[0]);
            Arrays.sort(result, ZAEHLER_NENNER_COMPARATOR);
            return result;
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static final MetaObject[] getLWLandparcel(String gemarkungsnummer, String flur, String zaehler, String nenner, ConnectionContext connectionContext) {
        try {
            VermessungFlurstueckKickerLightweightSearch search = new VermessungFlurstueckKickerLightweightSearch();
            search.setSearchFor(VermessungFlurstueckKickerLightweightSearch.SearchFor.FLURSTUECKE);
            search.setGemarkungsnummer(gemarkungsnummer);
            search.setFlur(flur);
            search.setZaehler(zaehler);
            search.setNenner(nenner);
            search.setRepresentationFields(new String[]{"id", "gemarkung", FLURSTUECK_FLUR, FLURSTUECK_ZAEHLER, FLURSTUECK_NENNER});
            Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, connectionContext);
            for (LightweightMetaObject lwmo : lwmos) {
                lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                    public String getRepresentation() {
                        StringBuilder result = new StringBuilder(30);
                        result.append(this.getAttribute("gemarkung")).append("-");
                        result.append(this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_FLUR)).append("-");
                        result.append(this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_ZAEHLER));
                        Object nenner = this.getAttribute(VermessungFlurstueckFinder.FLURSTUECK_NENNER);
                        if (nenner != null) {
                            result.append("/").append(nenner);
                        }
                        return result.toString();
                    }
                });
            }
            MetaObject[] result = lwmos.toArray(new MetaObject[0]);
            Arrays.sort(result, ZAEHLER_NENNER_COMPARATOR);
            return result;
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }
}

