/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.wunda_blau.search.actions.VermessungPictureServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import org.apache.log4j.Logger;

public class VermessungPictureFinderClientUtils {
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final Logger LOG = Logger.getLogger(VermessungPictureFinderClientUtils.class);
    private static final ConnectionContext CONNECTION_CONTEXT = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)VermessungPictureFinderClientUtils.class.getSimpleName());

    public static String findVermessungsrissPicture(String riss, Integer gemarkung, String flur, String blatt) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.FIND_VERMESSUNGSRISS, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)riss), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.FLUR.toString(), (Object)flur), new ServerActionParameter(VermessungPictureServerAction.Param.BLATT.toString(), (Object)blatt)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String findGrenzniederschriftPicture(String riss, Integer gemarkung, String flur, String blatt) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.FIND_GRENZNIEDERSCHRIFT, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)riss), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.FLUR.toString(), (Object)flur), new ServerActionParameter(VermessungPictureServerAction.Param.BLATT.toString(), (Object)blatt)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String findBuchwerkPicture(String schluessel, Integer gemarkung, Integer steuerbezirk, String bezeichner, boolean historisch) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.FIND_BUCHWERK, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)schluessel), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.STEUERBEZIRK.toString(), (Object)steuerbezirk), new ServerActionParameter(VermessungPictureServerAction.Param.BEZEICHNER.toString(), (Object)bezeichner), new ServerActionParameter(VermessungPictureServerAction.Param.HISTORISCH.toString(), (Object)historisch)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String findInselkartenPicture(String schluessel, Integer gemarkung, Integer flur, Integer blatt, String version) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.FIND_INSELKARTE, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)schluessel), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.FLUR.toString(), (Object)Integer.toString(flur)), new ServerActionParameter(VermessungPictureServerAction.Param.BLATT.toString(), (Object)Integer.toString(blatt)), new ServerActionParameter(VermessungPictureServerAction.Param.VERSION.toString(), (Object)version)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String findGewannePicture(Integer gemarkungOrKmquadrat, boolean liste) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.FIND_GEWANNE, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(liste ? VermessungPictureServerAction.Param.GEMARKUNG.toString() : VermessungPictureServerAction.Param.KMQUADRAT.toString(), (Object)gemarkungOrKmquadrat)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String findGebaeudebeschreibungPicture(String ordner, Integer nummer) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.FIND_GEBAEUDEBESCHREIBUNG, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.ORDNER.toString(), (Object)ordner), new ServerActionParameter(VermessungPictureServerAction.Param.NUMMER.toString(), (Object)nummer)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getInselkartenPictureFilename(String schluessel, Integer gemarkung, Integer flur, Integer blatt, String version) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_INSELKARTE_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)schluessel), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.FLUR.toString(), (Object)Integer.toString(flur)), new ServerActionParameter(VermessungPictureServerAction.Param.BLATT.toString(), (Object)Integer.toString(blatt)), new ServerActionParameter(VermessungPictureServerAction.Param.VERSION.toString(), (Object)version)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getGewannePictureFilename(Integer gemarkungOrKmquadrat, boolean liste) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_GEWANNE_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(liste ? VermessungPictureServerAction.Param.GEMARKUNG.toString() : VermessungPictureServerAction.Param.KMQUADRAT.toString(), (Object)gemarkungOrKmquadrat)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getGebauedebschreibungPictureFilename(String ordner, Integer nummer) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_GEBAEUDEBESCHREIBUNG_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.ORDNER.toString(), (Object)ordner), new ServerActionParameter(VermessungPictureServerAction.Param.NUMMER.toString(), (Object)nummer)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getVermessungsrissPictureFilename(String riss, Integer gemarkung, String flur, String blatt) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_VERMESSUNGSRISS_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)riss), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.FLUR.toString(), (Object)flur), new ServerActionParameter(VermessungPictureServerAction.Param.BLATT.toString(), (Object)blatt)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getGrenzniederschriftPictureFilename(String riss, Integer gemarkung, String flur, String blatt) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_GRENZNIEDERSCHRIFT_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)riss), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.FLUR.toString(), (Object)flur), new ServerActionParameter(VermessungPictureServerAction.Param.BLATT.toString(), (Object)blatt)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getBuchwerkPictureFilename(String schluessel, Integer gemarkung, Integer steuerbezirk, String bezeichner, boolean historisch) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_BUCHWERK_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.SCHLUESSEL.toString(), (Object)schluessel), new ServerActionParameter(VermessungPictureServerAction.Param.GEMARKUNG.toString(), (Object)gemarkung), new ServerActionParameter(VermessungPictureServerAction.Param.STEUERBEZIRK.toString(), (Object)steuerbezirk), new ServerActionParameter(VermessungPictureServerAction.Param.BEZEICHNER.toString(), (Object)bezeichner), new ServerActionParameter(VermessungPictureServerAction.Param.HISTORISCH.toString(), (Object)historisch)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getVermessungsrissLinkFilename(String link) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_VERMESSUNGSRISS_LINK_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.LINK.toString(), (Object)link)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String getGrenzniederschriftLinkFilename(String link) {
        try {
            return (String)SessionManager.getProxy().executeTask(VermessungPictureServerAction.TASK_NAME, DOMAIN, (Object)VermessungPictureServerAction.Body.GET_GRENZNIEDERSCHRIFT_LINK_FILENAME, CONNECTION_CONTEXT, new ServerActionParameter[]{new ServerActionParameter(VermessungPictureServerAction.Param.LINK.toString(), (Object)link)});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }
}

