/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;

public final class VzkatProperties
extends Properties {
    private final String webdavUploadUrl;
    private final String webdavUploadUsername;
    private final String webdavUploadPassword;
    private final String ovOverviewUrl;

    private VzkatProperties(Properties properties) {
        super(properties);
        this.webdavUploadUrl = properties.getProperty("WEBDAV_UPLOAD_URL");
        this.webdavUploadUsername = properties.getProperty("WEBDAV_UPLOAD_USERNAME");
        this.webdavUploadPassword = properties.getProperty("WEBDAV_UPLOAD_PASSWORD");
        this.ovOverviewUrl = properties.getProperty("OV_OVERVIEW_URL");
    }

    public static VzkatProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public String getWebdavUploadUrl() {
        return this.webdavUploadUrl;
    }

    public String getWebdavUploadUsername() {
        return this.webdavUploadUsername;
    }

    public String getWebdavUploadPassword() {
        return this.webdavUploadPassword;
    }

    public String getOvOverviewUrl() {
        return this.ovOverviewUrl;
    }

    private static final class LazyInitialiser {
        private static final VzkatProperties INSTANCE = new VzkatProperties(LazyInitialiser.loadProperties());

        private LazyInitialiser() {
        }

        private static Properties loadProperties() {
            Properties properties = new Properties();
            try {
                ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)ClientAlkisConf.class.getSimpleName());
                Object ret = SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.VZKAT_PROPERTIES.getValue(), connectionContext, new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                properties.load(new StringReader((String)ret));
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing VzkatProperties", ex);
            }
            return properties;
        }
    }
}

