/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import de.cismet.cids.dynamics.CidsBean;
import java.awt.Font;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPropertyParser {
    private static final Logger log = Logger.getLogger(XMLPropertyParser.class);
    private Document document;
    private List<String> properties;
    private List<String> description;
    private List<String> font;
    private List<Integer> size;
    private List<Boolean> bg;
    private List<Boolean> it;
    private final Map<Class<?>, Converter<?, ?>> converters;

    public XMLPropertyParser(InputStream is) {
        if (is == null) {
            throw new NullPointerException();
        }
        this.converters = new HashMap();
        this.properties = new ArrayList<String>();
        this.description = new ArrayList<String>();
        this.font = new ArrayList<String>();
        this.size = new ArrayList<Integer>();
        this.bg = new ArrayList<Boolean>();
        this.it = new ArrayList<Boolean>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(is);
            NodeList nl = this.document.getElementsByTagName("property");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node cur = nl.item(i);
                this.properties.add(cur.getFirstChild().getNodeValue());
                NamedNodeMap attr = cur.getAttributes();
                Node a = attr.getNamedItem("bg");
                if (a != null) {
                    this.bg.add("true".equalsIgnoreCase(a.getNodeValue()));
                } else {
                    this.bg.add(false);
                }
                a = attr.getNamedItem("it");
                if (a != null) {
                    this.it.add("true".equalsIgnoreCase(a.getNodeValue()));
                } else {
                    this.it.add(false);
                }
                a = attr.getNamedItem("size");
                if (a != null) {
                    this.size.add(Integer.parseInt(a.getNodeValue()));
                } else {
                    this.size.add(11);
                }
                a = attr.getNamedItem("font");
                if (a != null) {
                    this.font.add(a.getNodeValue());
                } else {
                    this.font.add("Tahoma");
                }
                a = attr.getNamedItem("description");
                if (a != null) {
                    this.description.add(a.getNodeValue());
                    continue;
                }
                this.description.add("");
            }
        }
        catch (Throwable ex) {
            log.error((Object)ex, ex);
        }
    }

    private <T> Object convertProperty(Object o) {
        if (o != null) {
            try {
                Converter<?, ?> conv = this.converters.get(o.getClass());
                if (conv != null) {
                    return conv.convertForward(o);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }
        return o;
    }

    public <T> void addConverterForClass(Class<T> clazz, Converter<T, ?> con) {
        if (clazz != null && con != null) {
            this.converters.put(clazz, con);
        }
    }

    public void removeConverter(Class<?> clazz) {
        this.converters.remove(clazz);
    }

    public Set<Class<?>> getConvertedClasses() {
        return this.converters.keySet();
    }

    public List<JLabel> getLabels(CidsBean bean) {
        ArrayList<JLabel> ret = new ArrayList<JLabel>();
        for (int i = 0; i < this.properties.size(); ++i) {
            try {
                JLabel item = new JLabel();
                Object prop = bean.getProperty(this.properties.get(i));
                prop = this.convertProperty(prop);
                item.setText(this.description.get(i) + prop);
                int style = 0;
                if (this.bg.get(i).booleanValue()) {
                    ++style;
                }
                if (this.it.get(i).booleanValue()) {
                    style += 2;
                }
                Font f = new Font(this.font.get(i), style, this.size.get(i));
                item.setFont(f);
                ret.add(item);
                continue;
            }
            catch (Exception ex) {
                log.warn((Object)ex, (Throwable)ex);
            }
        }
        return ret;
    }
}

