/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils.alkis;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.DescriptionPane;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.wunda_blau.BaulastenReportDownloadHelper;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisKarteDownloadInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisProductServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.awt.Component;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class AlkisProductDownloadHelper {
    private static final Logger LOG = Logger.getLogger(AlkisProductDownloadHelper.class);

    public static void downloadBuchungsblattnachweisStichtagProduct(BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo, ConnectionContext connectionContext) {
        DescriptionPane parent = ComponentRegistry.getRegistry().getDescriptionPane();
        String product = downloadInfo.getAlkisProdukt();
        String actionTag = ClientAlkisProducts.getInstance().getActionTag(product);
        String downloadTitle = ClientAlkisProducts.getInstance().getProductName(product);
        Date stichtag = downloadInfo.getDate();
        LinkedList<Download> downloads = new LinkedList<Download>();
        for (String buchungsblattCode : downloadInfo.getAlkisCodes()) {
            Download d = AlkisProductDownloadHelper.createBuchungsblattStichtagProductDownload(stichtag, downloadTitle, product, actionTag, buchungsblattCode, (Component)parent, connectionContext);
            downloads.add(d);
        }
        if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)parent)) {
            return;
        }
        String jobname = DownloadManagerDialog.getInstance().getJobName();
        if (downloads.size() > 1) {
            DownloadManager.instance().add((Download)new MultipleDownload(downloads, jobname));
        } else if (downloads.size() == 1) {
            DownloadManager.instance().add((Download)downloads.get(0));
        }
    }

    public static void downloadBuchungsblattnachweisProduct(BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo, ConnectionContext connectionContext) {
        DescriptionPane parent = ComponentRegistry.getRegistry().getDescriptionPane();
        String product = downloadInfo.getAlkisProdukt();
        String actionTag = ClientAlkisProducts.getInstance().getActionTag(product);
        String downloadTitle = ClientAlkisProducts.getInstance().getProductName(product);
        if (!ObjectRendererUtils.checkActionTag(actionTag, connectionContext)) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning((Component)parent);
        }
        String extension = ".pdf";
        if (ClientAlkisProducts.getInstance().get(AlkisProducts.Type.GRUNDSTUECKSNACHWEIS_NRW_HTML).equals(product) || ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_KOMMUNAL_HTML).equals(product) || ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_HTML).equals(product) || ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_NRW_HTML).equals(product)) {
            extension = ".html";
        }
        if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)parent)) {
            return;
        }
        String directory = DownloadManagerDialog.getInstance().getJobName();
        LinkedList<ByteArrayActionDownload> downloads = new LinkedList<ByteArrayActionDownload>();
        for (String buchungsblattCode : downloadInfo.getAlkisCodes()) {
            if (buchungsblattCode == null || buchungsblattCode.trim().length() <= 0) continue;
            String queryID = AlkisProducts.escapeHtmlSpaces((String)buchungsblattCode);
            try {
                String fertigungsVermerk = AlkisUtils.getFertigungsVermerk("WV ein", connectionContext);
                String filename = product + "." + buchungsblattCode.replace("/", "--").trim().replaceAll(" +", "_");
                ByteArrayActionDownload download = new ByteArrayActionDownload("alkisProduct", (Object)AlkisProductServerAction.Body.EINZELNACHWEIS, new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)product), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)queryID), new ServerActionParameter(AlkisProductServerAction.Parameter.FERTIGUNGSVERMERK.toString(), (Object)fertigungsVermerk)}, downloadTitle, directory, filename, extension, connectionContext);
                downloads.add(download);
            }
            catch (Exception ex) {
                ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Aufruf des Produkts: " + product, ex, (Component)parent);
                LOG.error((Object)("The URL to download product '" + product + "' (actionTag: " + actionTag + ") could not be constructed."), (Throwable)ex);
            }
        }
        if (downloads.size() > 1) {
            DownloadManager.instance().add((Download)new MultipleDownload(downloads, directory));
        } else if (downloads.size() == 1) {
            DownloadManager.instance().add((Download)downloads.get(0));
        }
    }

    public static Download createBuchungsblattStichtagProductDownload(Date stichtag, String downloadTitle, String product, String actionTag, String completeBuchungsblattCode, Component parent, ConnectionContext connectionContext) {
        if (!ObjectRendererUtils.checkActionTag(actionTag, connectionContext)) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning(parent);
            return null;
        }
        try {
            if (completeBuchungsblattCode.length() > 0) {
                String alkisCode = AlkisProducts.escapeHtmlSpaces((String)completeBuchungsblattCode);
                String fertigungsVermerk = AlkisUtils.getFertigungsVermerk("WV ein", connectionContext);
                String directory = DownloadManagerDialog.getInstance().getJobName();
                String filename = product + "." + completeBuchungsblattCode.replace("/", "--").trim().replaceAll(" +", "_");
                String extension = ".pdf";
                ByteArrayActionDownload download = new ByteArrayActionDownload("alkisProduct", (Object)AlkisProductServerAction.Body.EINZELNACHWEIS_STICHTAG, new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)product), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)alkisCode), new ServerActionParameter(AlkisProductServerAction.Parameter.STICHTAG.toString(), (Object)stichtag), new ServerActionParameter(AlkisProductServerAction.Parameter.FERTIGUNGSVERMERK.toString(), (Object)fertigungsVermerk)}, downloadTitle, directory, filename, ".pdf", connectionContext);
                return download;
            }
        }
        catch (Exception ex) {
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Aufruf des Produkts: " + product, ex, parent);
            LOG.error((Object)ex);
        }
        return null;
    }

    public static void downloadEinzelnachweisProduct(BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo, ConnectionContext connectionContext) {
        DescriptionPane parent = ComponentRegistry.getRegistry().getDescriptionPane();
        String product = downloadInfo.getAlkisProdukt();
        String actionTag = ClientAlkisProducts.getInstance().getActionTag(product);
        String downloadTitle = ClientAlkisProducts.getInstance().getProductName(product);
        if (!ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(product), connectionContext)) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning((Component)parent);
            return;
        }
        if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)parent)) {
            return;
        }
        String directory = DownloadManagerDialog.getInstance().getJobName();
        String extension = ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKSNACHWEIS_HTML).equals(product) || ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML).equals(product) || ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML).equals(product) || ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML).equals(product) ? ".html" : ".pdf";
        LinkedList<ByteArrayActionDownload> downloads = new LinkedList<ByteArrayActionDownload>();
        for (String alkisCode : downloadInfo.getAlkisCodes()) {
            if (alkisCode == null || alkisCode.length() <= 0) continue;
            try {
                String fertigungsVermerk = AlkisUtils.getFertigungsVermerk("WV ein", connectionContext);
                String filename = product + "." + alkisCode.replace("/", "--");
                ByteArrayActionDownload download = new ByteArrayActionDownload("alkisProduct", (Object)AlkisProductServerAction.Body.EINZELNACHWEIS, new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)product), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)alkisCode), new ServerActionParameter(AlkisProductServerAction.Parameter.FERTIGUNGSVERMERK.toString(), (Object)fertigungsVermerk)}, downloadTitle, directory, filename, extension, connectionContext);
                downloads.add(download);
            }
            catch (Exception ex) {
                ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Aufruf des Produkts: " + product, ex, (Component)parent);
                LOG.error((Object)("The URL to download product '" + product + "' (actionTag: " + actionTag + ") could not be constructed."), (Throwable)ex);
            }
        }
        if (downloads.size() > 1) {
            DownloadManager.instance().add((Download)new MultipleDownload(downloads, directory));
        } else if (downloads.size() == 1) {
            DownloadManager.instance().add((Download)downloads.get(0));
        }
    }

    public static void downloadKarteProduct(BerechtigungspruefungAlkisKarteDownloadInfo downloadInfo, ConnectionContext connectionContext) {
        DescriptionPane parent = ComponentRegistry.getRegistry().getDescriptionPane();
        String downloadTitle = "Karte";
        if (!ObjectRendererUtils.checkActionTag("custom.alkis.product.karte@WUNDA_BLAU", connectionContext)) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning((Component)parent);
            return;
        }
        if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)parent)) {
            return;
        }
        String directory = DownloadManagerDialog.getInstance().getJobName();
        LinkedList<ByteArrayActionDownload> downloads = new LinkedList<ByteArrayActionDownload>();
        for (String alkisCode : downloadInfo.getAlkisCodes()) {
            if (alkisCode.length() <= 0) continue;
            try {
                String filename = "LK.GDBNRW.A.F." + alkisCode.replace("/", "--");
                String extension = ".pdf";
                String fertigungsVermerk = AlkisUtils.getFertigungsVermerk("WV ein", connectionContext);
                ByteArrayActionDownload download = new ByteArrayActionDownload("alkisProduct", (Object)AlkisProductServerAction.Body.KARTE, new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)alkisCode), new ServerActionParameter(AlkisProductServerAction.Parameter.FERTIGUNGSVERMERK.toString(), (Object)fertigungsVermerk)}, "Karte", directory, filename, ".pdf", connectionContext);
                downloads.add(download);
            }
            catch (Exception ex) {
                ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Aufruf des Produkts: Kartenprodukt", ex, (Component)parent);
                LOG.error((Object)ex);
            }
        }
        if (downloads.size() > 1) {
            DownloadManager.instance().add((Download)new MultipleDownload(downloads, directory));
        } else if (downloads.size() == 1) {
            DownloadManager.instance().add((Download)downloads.get(0));
        }
    }

    public static void downloadBaulastbescheinigung(BerechtigungspruefungBescheinigungDownloadInfo downloadInfo, String anfrageSchluessel, ConnectionContext connectionContext) {
        try {
            Download download = BaulastenReportDownloadHelper.createFullBescheinigungDownload(downloadInfo, anfrageSchluessel, connectionContext);
            if (download != null) {
                DownloadManager.instance().add(download);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while generating download", (Throwable)ex);
        }
    }

    public static void download(String schluessel, String produkttyp, String downloadInfo, ConnectionContext connectionContext) throws Exception {
        if (BerechtigungspruefungBescheinigungDownloadInfo.PRODUKT_TYP.equals(produkttyp)) {
            BerechtigungspruefungBescheinigungDownloadInfo bescheinigungDownloadInfo = (BerechtigungspruefungBescheinigungDownloadInfo)new ObjectMapper().readValue(downloadInfo, BerechtigungspruefungBescheinigungDownloadInfo.class);
            AlkisProductDownloadHelper.downloadBaulastbescheinigung(bescheinigungDownloadInfo, schluessel, connectionContext);
        } else if (BerechtigungspruefungAlkisDownloadInfo.PRODUKT_TYP.equals(produkttyp)) {
            BerechtigungspruefungAlkisDownloadInfo alkisDownloadInfo = (BerechtigungspruefungAlkisDownloadInfo)new ObjectMapper().readValue(downloadInfo, BerechtigungspruefungAlkisDownloadInfo.class);
            switch (alkisDownloadInfo.getAlkisDownloadTyp()) {
                case EINZELNACHWEIS: {
                    BerechtigungspruefungAlkisEinzelnachweisDownloadInfo einzelnachweisDownloadInfo = (BerechtigungspruefungAlkisEinzelnachweisDownloadInfo)new ObjectMapper().readValue(downloadInfo, BerechtigungspruefungAlkisEinzelnachweisDownloadInfo.class);
                    switch (einzelnachweisDownloadInfo.getAlkisObjectTyp()) {
                        case FLURSTUECKE: {
                            AlkisProductDownloadHelper.downloadEinzelnachweisProduct(einzelnachweisDownloadInfo, connectionContext);
                            break;
                        }
                        case BUCHUNGSBLAETTER: {
                            if (ClientAlkisProducts.getInstance().get(AlkisProducts.Type.BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF).equals(einzelnachweisDownloadInfo.getAlkisProdukt())) {
                                AlkisProductDownloadHelper.downloadBuchungsblattnachweisStichtagProduct(einzelnachweisDownloadInfo, connectionContext);
                                break;
                            }
                            AlkisProductDownloadHelper.downloadBuchungsblattnachweisProduct(einzelnachweisDownloadInfo, connectionContext);
                        }
                    }
                    break;
                }
                case KARTE: {
                    BerechtigungspruefungAlkisKarteDownloadInfo karteDownloadInfo = (BerechtigungspruefungAlkisKarteDownloadInfo)new ObjectMapper().readValue(downloadInfo, BerechtigungspruefungAlkisKarteDownloadInfo.class);
                    switch (karteDownloadInfo.getAlkisObjectTyp()) {
                        case FLURSTUECKE: {
                            AlkisProductDownloadHelper.downloadKarteProduct(karteDownloadInfo, connectionContext);
                        }
                    }
                }
            }
        }
    }

    public static void showNoProductPermissionWarning(Component parent) {
        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)parent), "Sie besitzen keine Berechtigung zur Erzeugung dieses Produkts!");
    }

    public static boolean checkBerechtigungspruefung(String downloadType, ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "berechtigungspruefung_" + downloadType, connectionContext);
        }
        catch (Exception ex) {
            LOG.info((Object)"could now check Berechtigungspruefung confattr", (Throwable)ex);
            return false;
        }
    }

    public static void downloadKarteCustomProduct(final AlkisKarteDownloadInfo info, String jobName, boolean moreFlurstueckeSuffix, ConnectionContext connectionContext) {
        AlkisKarteDownloadInfoCreator creator = new AlkisKarteDownloadInfoCreator(){

            @Override
            public AlkisKarteDownloadInfo createInfo() {
                return info;
            }
        };
        AlkisProductDownloadHelper.downloadKarteCustomProduct(creator, jobName, moreFlurstueckeSuffix, connectionContext);
    }

    public static void downloadKarteCustomProduct(AlkisKarteDownloadInfoCreator infoCreator, String jobName, boolean moreFlurstueckeSuffix, ConnectionContext connectionContext) {
        DownloadManager.instance().add((Download)new AlkisKarteDownload(moreFlurstueckeSuffix, infoCreator, connectionContext));
    }

    public static void downloadKarteCustomProduct(AlkisKarteDownloadInfoCreator infoCreator, String jobName, boolean moreFlurstueckeSuffix, String title, ConnectionContext connectionContext) {
        DownloadManager.instance().add((Download)new AlkisKarteDownload(moreFlurstueckeSuffix, infoCreator, title, connectionContext));
    }

    public static boolean validateUserHasAlkisPrintAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "navigator.alkis.print@WUNDA_BLAU", connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis Print Dialog!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasAlkisProductAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://alkisProduct@WUNDA_BLAU", connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis Products!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasEigentuemerAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "custom.alkis.buchungsblatt@WUNDA_BLAU", connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis Buchungsblatt!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasAlkisHTMLProductAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "custom.alkis.products.html.enabled", connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis HTML Products!", (Throwable)ex);
            return false;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class AlkisKarteDownloadInfo {
        @JsonProperty
        private final String product;
        @JsonProperty
        private final String landparcelCode;
        @JsonProperty
        private final String auftragsnummer;
        @JsonProperty
        private final String fertigungsvermerk;
        @JsonProperty
        private final String zusatz;
        @JsonProperty
        private final String massstab;
        @JsonProperty
        private final String massstabMin;
        @JsonProperty
        private final String massstabMax;
        @JsonProperty
        private final int winkel;
        @JsonProperty
        private final int x;
        @JsonProperty
        private final int y;

        public AlkisKarteDownloadInfo(@JsonProperty(value="product") String product, @JsonProperty(value="landparcelCode") String landparcelCode, @JsonProperty(value="auftragsnummer") String auftragsnummer, @JsonProperty(value="fertigungsvermerk") String fertigungsvermerk, @JsonProperty(value="zusatz") String zusatz, @JsonProperty(value="massstab") String massstab, @JsonProperty(value="massstabMin") String massstabMin, @JsonProperty(value="massstabMax") String massstabMax, @JsonProperty(value="winkel") int winkel, @JsonProperty(value="x") int x, @JsonProperty(value="y") int y) {
            this.product = product;
            this.landparcelCode = landparcelCode;
            this.auftragsnummer = auftragsnummer;
            this.fertigungsvermerk = fertigungsvermerk;
            this.zusatz = zusatz;
            this.massstab = massstab;
            this.massstabMin = massstabMin;
            this.massstabMax = massstabMax;
            this.winkel = winkel;
            this.x = x;
            this.y = y;
        }

        public String getProduct() {
            return this.product;
        }

        public String getLandparcelCode() {
            return this.landparcelCode;
        }

        public String getAuftragsnummer() {
            return this.auftragsnummer;
        }

        public String getFertigungsvermerk() {
            return this.fertigungsvermerk;
        }

        public String getZusatz() {
            return this.zusatz;
        }

        public String getMassstab() {
            return this.massstab;
        }

        public String getMassstabMin() {
            return this.massstabMin;
        }

        public String getMassstabMax() {
            return this.massstabMax;
        }

        public int getWinkel() {
            return this.winkel;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class AlkisKarteDownload
    extends ByteArrayActionDownload {
        private final AlkisKarteDownloadInfoCreator infoCreator;
        private final boolean moreFlurstueckeSuffix;
        private boolean titleSet = false;

        public AlkisKarteDownload(boolean moreFlurstueckeSuffix, AlkisKarteDownloadInfoCreator infoCreator, ConnectionContext connectionContext) {
            super("WUNDA_BLAU", connectionContext);
            this.moreFlurstueckeSuffix = moreFlurstueckeSuffix;
            this.infoCreator = infoCreator;
        }

        public AlkisKarteDownload(boolean moreFlurstueckeSuffix, AlkisKarteDownloadInfoCreator infoCreator, String title, ConnectionContext connectionContext) {
            super("WUNDA_BLAU", connectionContext);
            this.moreFlurstueckeSuffix = moreFlurstueckeSuffix;
            this.infoCreator = infoCreator;
            this.title = title;
            this.titleSet = true;
        }

        @Override
        protected Object execAction() throws Exception {
            if (!this.titleSet) {
                this.title = "ALKIS-Druck";
            }
            this.directory = DownloadManagerDialog.getInstance().getJobName();
            AlkisKarteDownloadInfo info = this.infoCreator.createInfo();
            if (this.status == Download.State.ABORTED) {
                return null;
            }
            String filename = info.getProduct() + (info.getLandparcelCode() != null ? "." + info.getLandparcelCode().replace("/", "--") + (this.moreFlurstueckeSuffix ? ".ua" : "") : "");
            this.determineDestinationFile(filename, ".pdf");
            this.taskname = "alkisProduct";
            this.body = AlkisProductServerAction.Body.KARTE_CUSTOM;
            this.params = new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)info.getProduct()), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)info.getLandparcelCode()), new ServerActionParameter(AlkisProductServerAction.Parameter.WINKEL.toString(), (Object)info.getWinkel()), new ServerActionParameter(AlkisProductServerAction.Parameter.X.toString(), (Object)info.getX()), new ServerActionParameter(AlkisProductServerAction.Parameter.Y.toString(), (Object)info.getY()), new ServerActionParameter(AlkisProductServerAction.Parameter.MASSSTAB.toString(), (Object)info.getMassstab()), new ServerActionParameter(AlkisProductServerAction.Parameter.MASSSTAB_MIN.toString(), (Object)info.getMassstabMin()), new ServerActionParameter(AlkisProductServerAction.Parameter.MASSSTAB_MAX.toString(), (Object)info.getMassstabMax()), new ServerActionParameter(AlkisProductServerAction.Parameter.ZUSATZ.toString(), (Object)info.getZusatz()), new ServerActionParameter(AlkisProductServerAction.Parameter.AUFTRAGSNUMMER.toString(), (Object)info.getAuftragsnummer()), new ServerActionParameter(AlkisProductServerAction.Parameter.FERTIGUNGSVERMERK.toString(), (Object)info.getFertigungsvermerk())};
            this.titleChanged();
            this.stateChanged();
            return super.execAction();
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Objects.hashCode(this.infoCreator);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AlkisKarteDownload other = (AlkisKarteDownload)((Object)obj);
            return Objects.equals(this.infoCreator, other.infoCreator);
        }
    }

    public static abstract class AlkisKarteDownloadInfoCreator {
        public abstract AlkisKarteDownloadInfo createInfo() throws Exception;
    }
}

