/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils.alkis;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.utils.billing.ClientBillingUtils;
import de.cismet.cids.custom.objectrenderer.wunda_blau.AlkisBuchungsblattRenderer;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import org.apache.log4j.Logger;

public class AlkisUtils {
    private static final Logger LOG = Logger.getLogger(AlkisUtils.class);
    public static final String LINK_SEPARATOR_TOKEN = "::";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_NRW = "custom.alkis.product.bestandsnachweis_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_KOM = "custom.alkis.product.bestandsnachweis_kom@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_KOM_INTERN = "custom.alkis.product.bestandsnachweis_kom_intern@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_STICHSTAGSBEZOGEN_NRW = "custom.alkis.product.bestandsnachweis_stichtagsbezogen_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_GRUNDSTUECKSNACHWEIS_NRW = "custom.alkis.product.grundstuecksnachweis_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKSNACHWEIS = "custom.alkis.product.flurstuecksnachweis@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_NRW = "custom.alkis.product.flurstuecks_eigentumsnachweis_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_KOM = "custom.alkis.product.flurstuecks_eigentumsnachweis_kom@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_KOM_INTERN = "custom.alkis.product.flurstuecks_eigentumsnachweis_kom_intern@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_KARTE = "custom.alkis.product.karte@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_ENABLED = "baulast.report.bescheinigung_enabled@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_DISABLED = "baulast.report.bescheinigung_disabled@WUNDA_BLAU";
    public static final String ALKIS_HTML_PRODUCTS_ENABLED = "custom.alkis.products.html.enabled";
    public static final String ALKIS_EIGENTUEMER = "custom.alkis.buchungsblatt@WUNDA_BLAU";
    static final AlkisBuchungsblattRenderer.Buchungsblattbezirke BUCHUNGSBLATTBEZIRKE;

    public static String generateLinkFromCidsBean(CidsBean bean, String description) {
        if (bean != null && description != null) {
            int objectID = bean.getMetaObject().getId();
            StringBuilder result = new StringBuilder("<a href=\"");
            result.append(bean.getMetaObject().getMetaClass().getID()).append(LINK_SEPARATOR_TOKEN).append(objectID);
            result.append("\">");
            result.append(description);
            result.append("</a>");
            return result.toString();
        }
        return "";
    }

    public static String getBuchungsblattbezirkFromBuchungsblattnummer(String buchungsblattnummer) {
        try {
            String bezirksNr = buchungsblattnummer.substring(0, buchungsblattnummer.indexOf("-"));
            String bezirksname = BUCHUNGSBLATTBEZIRKE.getDistrictNamesMap().get(bezirksNr);
            StringBuffer b = new StringBuffer(bezirksname).append(" (").append(bezirksNr).append(')');
            return b.toString();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in getBuchungsblattbezirkFromBuchungsblattnummer(" + buchungsblattnummer + ")"), (Throwable)e);
            return null;
        }
    }

    public static String getFertigungsVermerk(String usageKey, ConnectionContext connectionContext) throws ConnectionException {
        String currentUsageKey = BillingPopup.getInstance().getCurrentUsage() != null ? BillingPopup.getInstance().getCurrentUsage().getKey() : null;
        String fertigungsVermerk = usageKey == null || usageKey.equals(currentUsageKey) ? SessionManager.getConnection().getConfigAttr(SessionManager.getSession().getUser(), "custom.alkis.fertigungsVermerk@WUNDA_BLAU", connectionContext) : null;
        return fertigungsVermerk;
    }

    public static String getLandparcelCodeFromParcelBeanObject(Object landParcel) {
        CidsBean cidsBean;
        Object parcelCodeObj;
        if (landParcel instanceof CidsBean && (parcelCodeObj = (cidsBean = (CidsBean)landParcel).getProperty("alkis_id")) != null) {
            return parcelCodeObj.toString();
        }
        return "";
    }

    public static String generateLandparcelCode(int land, int gemarkung, int flur, int zaehler, int nenner) {
        String withoutNenner = AlkisUtils.generateLandparcelCode(land, gemarkung, flur, zaehler);
        StringBuilder sb = new StringBuilder(withoutNenner);
        sb.append(String.format("/%04d", nenner));
        return sb.toString();
    }

    public static String generateLandparcelCode(int land, int gemarkung, int flur, int zaehler) {
        return String.format("%02d%04d-%03d-%05d", land, gemarkung, flur, zaehler);
    }

    public static String arrayToSeparatedString(String[] strings, String separator) {
        if (strings != null) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < strings.length; ++i) {
                result.append(strings[i]);
                if (i + 1 >= strings.length) continue;
                result.append(separator);
            }
            return result.toString();
        }
        return "";
    }

    public static boolean validateUserHasAlkisPrintAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "navigator.alkis.print@WUNDA_BLAU", connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis Print Dialog!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasAlkisProductAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://alkisProduct@WUNDA_BLAU", connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis Products!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasEigentuemerAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), ALKIS_EIGENTUEMER, connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis Buchungsblatt!", (Throwable)ex);
            return false;
        }
    }

    public static boolean validateUserHasAlkisHTMLProductAccess(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), ALKIS_HTML_PRODUCTS_ENABLED, connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis HTML Products!", (Throwable)ex);
            return false;
        }
    }

    public static String createBaulastenFertigungsVermerk(User user, ConnectionContext connectionContext) throws Exception {
        CidsBean billingKunde;
        String fertigungsVermerk = SessionManager.getConnection().getConfigAttr(user, "custom.baulasten.fertigungsVermerk@WUNDA_BLAU", connectionContext);
        if (fertigungsVermerk != null) {
            return fertigungsVermerk;
        }
        CidsBean billingLogin = ClientBillingUtils.getInstance().getExternalUser(user, connectionContext);
        if (billingLogin != null && (billingKunde = (CidsBean)billingLogin.getProperty("kunde")) != null) {
            return (String)billingKunde.getProperty("name");
        }
        return null;
    }

    static {
        ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)AlkisUtils.class.getSimpleName());
        AlkisBuchungsblattRenderer.Buchungsblattbezirke buchungsblattbezirke = null;
        try {
            Object ret = SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.ALKIS_BUCHUNTSBLATTBEZIRKE_JSON.getValue(), connectionContext, new ServerActionParameter[0]);
            if (ret instanceof Exception) {
                throw (Exception)ret;
            }
            ObjectMapper mapper = new ObjectMapper();
            buchungsblattbezirke = (AlkisBuchungsblattRenderer.Buchungsblattbezirke)mapper.readValue((String)ret, AlkisBuchungsblattRenderer.Buchungsblattbezirke.class);
        }
        catch (Exception ex) {
            LOG.error((Object)"Problem while reading the Buchungsblattbezirke.", (Throwable)ex);
            buchungsblattbezirke = new AlkisBuchungsblattRenderer.Buchungsblattbezirke();
        }
        BUCHUNGSBLATTBEZIRKE = buchungsblattbezirke;
    }
}

