/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils.alkis.print;

import com.vividsolutions.jts.algorithm.MinimumDiameter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.print.AlkisPrintingSettingsWidget;
import de.cismet.cids.custom.objectrenderer.utils.alkis.print.AlkisPrintingToolTip;
import de.cismet.cids.custom.utils.alkis.AlkisProductDescription;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.FeatureMoveListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.tools.collections.TypeSafeCollections;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class AlkisPrintListener
extends FeatureMoveListener {
    private static final Logger log = Logger.getLogger(AlkisPrintListener.class);
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs((String)ClientAlkisConf.getInstance().getSrsService()));
    private static final AlkisPrintingToolTip PRINTING_TOOLTIP = new AlkisPrintingToolTip();
    public static final String WIDTH = "WIDTH";
    public static final String HEIGHT = "HEIGHT";
    public static final Color BORDER_COLOR = new Color(0, 0, 255, 75);
    private final PropertyChangeListener mapInteractionModeListener;
    private final MappingComponent mappingComponent;
    private final Collection<Feature> printFeatureCollection = TypeSafeCollections.newArrayList((int)1);
    private final List<Feature> backupFeature;
    private final List<Feature> backupHoldFeature;
    private final AlkisPrintingSettingsWidget printWidget;
    private double diagonal = 0.0;
    private boolean cleared = true;
    private String oldInteractionMode;
    private StyledFeature printTemplateStyledFeature;
    private boolean oldOverlappingCheck = true;

    public AlkisPrintListener(MappingComponent mappingComponent, AlkisPrintingSettingsWidget printWidget) {
        super(mappingComponent);
        this.mappingComponent = mappingComponent;
        this.printWidget = printWidget;
        this.backupFeature = TypeSafeCollections.newArrayList();
        this.backupHoldFeature = TypeSafeCollections.newArrayList();
        this.oldInteractionMode = "PAN";
        this.mapInteractionModeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt != null && "INTERACTION_MODE".equals(evt.getPropertyName()) && "ALKIS_PRINT".equals(evt.getOldValue())) {
                    AlkisPrintListener.this.cleanUpAndRestoreFeatures();
                }
            }
        };
    }

    public void init() {
        this.mappingComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.mappingComponent.setPointerAnnotation((PNode)PRINTING_TOOLTIP);
        this.mappingComponent.setPointerAnnotationVisibility(true);
        String currentInteractionMode = this.mappingComponent.getInteractionMode();
        if (!"ALKIS_PRINT".equals(currentInteractionMode)) {
            this.oldInteractionMode = currentInteractionMode;
            this.mappingComponent.addPropertyChangeListener(this.mapInteractionModeListener);
        }
        this.mappingComponent.setInteractionMode("ALKIS_PRINT");
        this.cleared = false;
        this.mappingComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.mappingComponent.setPointerAnnotation((PNode)PRINTING_TOOLTIP);
        this.mappingComponent.setPointerAnnotationVisibility(true);
    }

    public void refreshPreviewGeometry(AlkisProductDescription product, Geometry geom, boolean findOptimalRotation) {
        if (geom != null) {
            Geometry serviceConformGeometry = CrsTransformer.transformToGivenCrs((Geometry)geom, (String)ClientAlkisConf.getInstance().getSrsService());
            double massstab = Double.parseDouble(product.getMassstab());
            double realWorldWidth = (double)product.getWidth() / 1000.0 * massstab;
            double realWorldHeight = (double)product.getHeight() / 1000.0 * massstab;
            if (massstab != 0.0 && !this.mappingComponent.isFixedMapScale()) {
                this.mappingComponent.queryServices();
            }
            this.initMapTemplate(product, serviceConformGeometry, findOptimalRotation, realWorldWidth, realWorldHeight);
        }
    }

    private void initMapTemplate(AlkisProductDescription product, Geometry geom, boolean findOptimalRotation, double realWorldWidth, double realWorldHeight) {
        DefaultFeatureCollection mapFeatureCol = (DefaultFeatureCollection)this.mappingComponent.getFeatureCollection();
        Point centroid = geom.getEnvelope().getCentroid();
        double centerX = centroid.getX();
        double centerY = centroid.getY();
        double halfRealWorldWidth = realWorldWidth / 2.0;
        double halfRealWorldHeigth = realWorldHeight / 2.0;
        Coordinate[] outerCoords = new Coordinate[]{new Coordinate(-halfRealWorldWidth, -halfRealWorldHeigth), new Coordinate(halfRealWorldWidth, -halfRealWorldHeigth), new Coordinate(halfRealWorldWidth, halfRealWorldHeigth), new Coordinate(-halfRealWorldWidth, halfRealWorldHeigth), new Coordinate(-halfRealWorldWidth, -halfRealWorldHeigth)};
        LinearRing outerRing = GEOMETRY_FACTORY.createLinearRing(outerCoords);
        LinearRing[] innerRings = null;
        AffineTransformation translateToDestination = AffineTransformation.translationInstance((double)centerX, (double)centerY);
        outerRing = (LinearRing)translateToDestination.transform((Geometry)outerRing);
        if (product.getStempelfeldInfo() != null) {
            double fromX = product.getStempelfeldInfo().getFromX();
            double fromY = product.getStempelfeldInfo().getFromY();
            double toX = product.getStempelfeldInfo().getToX();
            double toY = product.getStempelfeldInfo().getToY();
            double stempelfeldWidth = realWorldWidth * (toX - fromX);
            double stempelfeldHeight = realWorldHeight * (toY - fromY);
            Coordinate base = new Coordinate(outerCoords[0].x + fromX * realWorldWidth, outerCoords[0].y + fromY * realWorldHeight);
            Coordinate[] innerCoords = new Coordinate[]{base, new Coordinate(base.x, base.y + stempelfeldHeight), new Coordinate(base.x + stempelfeldWidth, base.y + stempelfeldHeight), new Coordinate(base.x + stempelfeldWidth, base.y), base};
            LinearRing innerRing = GEOMETRY_FACTORY.createLinearRing(innerCoords);
            innerRings = new LinearRing[]{innerRing = (LinearRing)translateToDestination.transform((Geometry)innerRing)};
        }
        BoundingBox polygonBB = new BoundingBox((Geometry)outerRing);
        AffineTransformation rotation = null;
        if (findOptimalRotation) {
            LineString minimumDiameter = new MinimumDiameter(geom).getDiameter();
            Point start = minimumDiameter.getStartPoint();
            Point end = minimumDiameter.getEndPoint();
            if (start.getX() > end.getX()) {
                Point temp = start;
                start = end;
                end = temp;
            }
            double oppositeLeg = end.getY() - start.getY();
            double adjacentLeg = end.getX() - start.getX();
            double tangens = oppositeLeg / adjacentLeg;
            if (polygonBB.getWidth() > polygonBB.getHeight()) {
                tangens = -1.0 / tangens;
            }
            double angle = Math.atan(tangens);
            rotation = AffineTransformation.rotationInstance((double)angle, (double)centerX, (double)centerY);
            outerRing = (LinearRing)rotation.transform((Geometry)outerRing);
            if (innerRings != null) {
                innerRings[0] = (LinearRing)rotation.transform((Geometry)innerRings[0]);
            }
        }
        Polygon polygon = GEOMETRY_FACTORY.createPolygon(outerRing, innerRings);
        StyledFeature oldPrintFeature = this.printTemplateStyledFeature;
        this.printTemplateStyledFeature = new PrintFeature();
        this.printTemplateStyledFeature.setFillingPaint((Paint)BORDER_COLOR);
        this.printTemplateStyledFeature.setCanBeSelected(true);
        this.printTemplateStyledFeature.setEditable(true);
        this.printTemplateStyledFeature.setGeometry((Geometry)polygon);
        this.printFeatureCollection.clear();
        this.printFeatureCollection.add((Feature)this.printTemplateStyledFeature);
        this.diagonal = Math.sqrt(polygonBB.getWidth() * polygonBB.getWidth() + polygonBB.getHeight() * polygonBB.getHeight());
        if (oldPrintFeature != null) {
            mapFeatureCol.unholdFeature((Feature)oldPrintFeature);
            mapFeatureCol.removeFeature((Feature)oldPrintFeature);
        } else {
            this.oldOverlappingCheck = CismapBroker.getInstance().isCheckForOverlappingGeometriesAfterFeatureRotation();
            CismapBroker.getInstance().setCheckForOverlappingGeometriesAfterFeatureRotation(false);
        }
        mapFeatureCol.holdFeature((Feature)this.printTemplateStyledFeature);
        mapFeatureCol.addFeature((Feature)this.printTemplateStyledFeature);
        PFeature printPFeature = (PFeature)this.mappingComponent.getPFeatureHM().get(this.printTemplateStyledFeature);
        this.gotoPrintAreaWithBuffer();
        mapFeatureCol.select((Feature)this.printTemplateStyledFeature);
        this.mappingComponent.setHandleInteractionMode("ROTATE_POLYGON");
    }

    public boolean isFeatureInCollection() {
        return this.printFeatureCollection.contains(this.printTemplateStyledFeature);
    }

    private void gotoPrintAreaWithBuffer() {
        Point center = this.printTemplateStyledFeature.getGeometry().getCentroid();
        double halfDiagonal = this.diagonal / 2.0;
        XBoundingBox gotoBB = new XBoundingBox(center.getX() - halfDiagonal, center.getY() - halfDiagonal, center.getX() + halfDiagonal, center.getY() + halfDiagonal, ClientAlkisConf.getInstance().getSrsService(), true);
        this.mappingComponent.gotoBoundingBoxWithHistory((BoundingBox)gotoBB);
    }

    private void ensureSelection(PInputEvent e) {
        PNode o = PFeatureTools.getFirstValidObjectUnderPointer((PInputEvent)e, (Class[])new Class[]{PFeature.class});
        if (o instanceof PFeature) {
            PFeature pFeature = (PFeature)o;
            Feature feature = pFeature.getFeature();
            DefaultFeatureCollection mapFeatureCol = (DefaultFeatureCollection)this.mappingComponent.getFeatureCollection();
            if (!mapFeatureCol.isSelected(feature)) {
                mapFeatureCol.select(feature);
            }
        }
    }

    public void mouseClicked(PInputEvent event) {
        super.mouseClicked(event);
        if (event.getClickCount() > 1 && event.isLeftMouseButton()) {
            double rotationAngle = this.calculateRotationAngle();
            this.printWidget.downloadProduct(this.printTemplateStyledFeature.getGeometry(), rotationAngle);
        }
    }

    public void mouseReleased(PInputEvent e) {
        super.mouseReleased(e);
        this.gotoPrintAreaWithBuffer();
    }

    public void cleanUpAndRestoreFeatures() {
        if (!this.cleared) {
            this.mappingComponent.removePropertyChangeListener(this.mapInteractionModeListener);
            if (this.printTemplateStyledFeature != null) {
                FeatureCollection mapFeatureCollection = this.mappingComponent.getFeatureCollection();
                mapFeatureCollection.unholdFeature((Feature)this.printTemplateStyledFeature);
                mapFeatureCollection.removeFeature((Feature)this.printTemplateStyledFeature);
                this.printTemplateStyledFeature = null;
            }
            if ("ALKIS_PRINT".equals(this.mappingComponent.getInteractionMode())) {
                this.mappingComponent.setInteractionMode(this.oldInteractionMode);
            }
        }
        this.cleared = true;
        CismapBroker.getInstance().setCheckForOverlappingGeometriesAfterFeatureRotation(this.oldOverlappingCheck);
    }

    private double calculateRotationAngle() {
        Geometry geom = this.printTemplateStyledFeature.getGeometry();
        Coordinate[] corrds = geom.getCoordinates();
        Coordinate point00 = corrds[0];
        Coordinate pointX0 = corrds[1];
        double oppositeLeg = pointX0.y - point00.y;
        double adjacentLeg = pointX0.x - point00.x;
        double tangens = oppositeLeg / adjacentLeg;
        double result = adjacentLeg > 0.0 ? 0.0 : 180.0;
        result = oppositeLeg > 0.0 ? -result : result;
        return result -= Math.toDegrees(Math.atan(tangens));
    }

    public static final class PrintFeature
    extends DefaultStyledFeature {
        public String toString() {
            return "Druckbereich";
        }
    }
}

