/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils.alkis.print;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.butler.Butler2Dialog;
import de.cismet.cids.custom.butler.ButlerGeometryComboBox;
import de.cismet.cids.custom.butler.CoordWrapper;
import de.cismet.cids.custom.nas.NasFeeCalculator;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.utils.alkis.print.AlkisPrintListener;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.alkis.AlkisProductDescription;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.wunda_blau.search.server.CidsAlkisSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class AlkisPrintingSettingsWidget
extends JDialog
implements CidsBeanDropListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlkisPrintingSettingsWidget.class);
    private static final String ALKIS_LANDPARCEL_TABLE = "ALKIS_LANDPARCEL";
    private static final String ALKIS_BUCHUNGSBLATT_TABLE = "ALKIS_BUCHUNGSBLATT";
    private static final String X_POS = "X_POS";
    private static final String Y_POS = "Y_POS";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static HashMap<String, CoordWrapper> gkRahmenKartenMap = new HashMap();
    private static HashMap<String, CoordWrapper> etrsRahmenKartenMap = new HashMap();
    private static Integer X;
    private static Integer Y;
    boolean coodChangedFlag = false;
    boolean updateGeomRunning = false;
    private final MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
    private final DefaultListModel cidsObjectListModel = new DefaultListModel();
    private AlkisPrintListener mapPrintListener;
    private final ActionListener updatePrintingGeometryAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlkisPrintingSettingsWidget.this.mapPrintListener.refreshPreviewGeometry(AlkisPrintingSettingsWidget.this.getSelectedProduct(), AlkisPrintingSettingsWidget.this.getCurrentGeometry(), AlkisPrintingSettingsWidget.this.chkRotation.isSelected());
        }
    };
    private AlkisProductDescription defaultProduct = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final DecimalFormat coordFormatter = new DecimalFormat("#.###");
    private JButton btnRemove;
    private JComboBox cbClazz;
    private JComboBox cbFormat;
    private JComboBox cbGeoms;
    private JComboBox cbProduct;
    private JComboBox cbScales;
    private JCheckBox chkRotation;
    private JButton cmdCancel;
    private JButton cmdOk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTabbedPane jTabbedPane1;
    private JLabel lblPointGeoms;
    private JLabel lblRahmenkartenNr;
    private JList lstFlurstuecke;
    private JPanel panDesc;
    private JPanel panSettings;
    private JScrollPane scpAdditionalText;
    private JScrollPane scpFlurstuecke;
    private JTextArea taAdditionalText;
    private JTextField tfE;
    private JTextField tfN;
    private JTextField tfRahmenkartenNr;
    private JTextField txtAuftragsnummer;
    private BindingGroup bindingGroup;

    public AlkisPrintingSettingsWidget() {
        super(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), false);
    }

    private Geometry getCurrentGeometry() {
        Geometry geom;
        if (this.jPanel2.equals(this.jTabbedPane1.getSelectedComponent())) {
            return this.unionAllObjectsGeometries();
        }
        Geometry geometry = geom = this.cbGeoms.getSelectedItem() instanceof Geometry ? (Geometry)this.cbGeoms.getSelectedItem() : null;
        if (geom != null) {
            return geom;
        }
        try {
            int currentSrid = CrsTransformer.extractSridFromCrs((String)this.mappingComponent.getMappingModel().getSrs().getCode());
            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), currentSrid);
            return geometryFactory.createPoint(new Coordinate(Double.parseDouble(this.tfE.getText()), Double.parseDouble(this.tfN.getText())));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void featureChanged(Collection<Feature> features) {
        if (this.cbGeoms != null && features != null && !features.isEmpty() && !(features.iterator().next() instanceof AlkisPrintListener.PrintFeature)) {
            ((ButlerGeometryComboBox)this.cbGeoms).refresh();
        }
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.mappingComponent.getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
                AlkisPrintingSettingsWidget.this.featureChanged(fce.getEventFeatures());
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                AlkisPrintingSettingsWidget.this.featureChanged(fce.getEventFeatures());
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
                AlkisPrintingSettingsWidget.this.featureChanged(fce.getEventFeatures());
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
                AlkisPrintingSettingsWidget.this.featureChanged(fce.getEventFeatures());
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator('.');
        this.coordFormatter.setDecimalFormatSymbols(formatSymbols);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.cmdOk);
        this.cbClazz.setModel(this.getProductClassModel());
        if (this.defaultProduct != null) {
            this.cbClazz.setSelectedItem(this.defaultProduct.getClazz());
            this.cbProduct.setSelectedItem(this.defaultProduct.getType());
        } else {
            this.cbClazz.setSelectedIndex(this.cbClazz.getModel().getSize() - 1);
            this.cbProduct.setSelectedIndex(this.cbProduct.getModel().getSize() - 1);
        }
        this.panDesc.setBackground(new Color(216, 228, 248));
        new CidsBeanDropTarget((Component)this);
        this.mapPrintListener = new AlkisPrintListener(this.mappingComponent, this);
        this.mappingComponent.addInputListener("ALKIS_PRINT", (PBasicInputEventHandler)this.mapPrintListener);
        this.lstFlurstuecke.setCellRenderer(new ListCellRenderer(){
            DefaultListCellRenderer dlcr = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component defaultC = this.dlcr.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof CidsBean) {
                    ImageIcon icon = new ImageIcon(((CidsBean)value).getMetaObject().getMetaClass().getObjectIcon().getImageData());
                    if (defaultC instanceof JLabel) {
                        ((JLabel)defaultC).setIcon(icon);
                    }
                }
                return defaultC;
            }
        });
        this.tfRahmenkartenNr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.updateForRahmenKartenNr();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.updateForRahmenKartenNr();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.updateForRahmenKartenNr();
            }
        });
        this.tfE.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.coordinatesChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.coordinatesChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.coordinatesChanged();
            }
        });
        this.tfN.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.coordinatesChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.coordinatesChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AlkisPrintingSettingsWidget.this.coordinatesChanged();
            }
        });
    }

    private void coordinatesChanged() {
        if (!this.coodChangedFlag) {
            try {
                this.coodChangedFlag = true;
                if (this.coordFormatter.parse(this.tfE.getText()) != null && this.coordFormatter.parse(this.tfN.getText()) != null) {
                    this.updateFormatProposal();
                }
            }
            catch (ParseException parseException) {
            }
            finally {
                this.coodChangedFlag = false;
            }
        }
    }

    private static void loadPropertiesIntoMap(Properties prop, Map map) {
        Enumeration<?> keys = prop.propertyNames();
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            keyList.add(key);
        }
        for (String key : keyList) {
            String[] splittedVal = prop.getProperty(key).split(";");
            double middleE = Double.parseDouble(splittedVal[0]);
            double middleN = Double.parseDouble(splittedVal[1]);
            CoordWrapper coord = new CoordWrapper(middleE, middleN);
            map.put(key, coord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateForRahmenKartenNr() {
        boolean inputError = false;
        boolean possibleEtrsNumber = false;
        CoordWrapper coord = null;
        String enteredRahmenKartenNr = this.tfRahmenkartenNr.getText();
        if (enteredRahmenKartenNr.length() == 5) {
            coord = gkRahmenKartenMap.get(enteredRahmenKartenNr);
            if (coord != null) {
                this.tfE.setText("" + coord.getMiddleE());
                this.tfN.setText("" + coord.getMiddleN());
            } else {
                inputError = true;
                for (int i = 1; i <= 9; ++i) {
                    String etrsRahmenNumber = enteredRahmenKartenNr + "" + i;
                    if (etrsRahmenKartenMap.get(etrsRahmenNumber) == null) continue;
                    possibleEtrsNumber = true;
                    break;
                }
            }
        } else if (enteredRahmenKartenNr.length() == 6) {
            coord = etrsRahmenKartenMap.get(enteredRahmenKartenNr);
            if (coord != null) {
                this.cbGeoms.setSelectedIndex(-1);
                this.tfE.setText("" + coord.getMiddleE());
                this.tfN.setText("" + coord.getMiddleN());
            } else {
                inputError = true;
            }
        } else if (enteredRahmenKartenNr.length() > 6) {
            inputError = true;
        }
        if (inputError && !possibleEtrsNumber) {
            this.setAlwaysOnTop(false);
            try {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.RahmenkartenNrCheck.JOptionPane.message"), NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.RahmenkartenNrCheck.JOptionPane.title"), 0);
            }
            finally {
                this.setAlwaysOnTop(true);
            }
        } else if (!inputError && coord != null) {
            this.updateFormatProposal();
        }
    }

    @Override
    public void setVisible(boolean b) {
        int dialogResult;
        this.cidsObjectListModel.clear();
        this.tfE.setText("");
        this.tfN.setText("");
        this.tfRahmenkartenNr.setText("");
        this.cbGeoms.setSelectedItem(null);
        Collection<CidsBean> beansToPrint = this.getObjectBeansInMap();
        if (beansToPrint.isEmpty()) {
            beansToPrint = this.getBeansFromTreeSelection();
        } else if (beansToPrint.size() > 1 && 1 == (dialogResult = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Sollen alle ALKIS-Objekte der Karte gedruckt werden?", "ALKIS-Objekte in Druckauswahl \u00fcbernehmen", 0))) {
            beansToPrint.clear();
        }
        for (CidsBean currentBean : beansToPrint) {
            this.cidsObjectListModel.addElement(currentBean);
        }
        super.setVisible(b);
        this.updateFormatProposal();
        this.mapPrintListener.init();
        this.mapPrintListener.refreshPreviewGeometry(this.getSelectedProduct(), this.getCurrentGeometry(), this.chkRotation.isSelected());
    }

    private ComboBoxModel getProductClassModel() {
        HashSet<String> classes = new HashSet<String>();
        for (AlkisProductDescription product : ClientAlkisProducts.getInstance().getAlkisMapProducts()) {
            classes.add(product.getClazz());
            if (!product.isDefaultProduct()) continue;
            this.defaultProduct = product;
        }
        return new DefaultComboBoxModel<Object>(classes.toArray());
    }

    private ComboBoxModel getProductTypeModel() {
        String clazz = String.valueOf(this.cbClazz.getSelectedItem());
        HashSet<String> prodSet = new HashSet<String>();
        ArrayList<String> typesOrdered = new ArrayList<String>();
        for (AlkisProductDescription product : ClientAlkisProducts.getInstance().getAlkisMapProducts()) {
            if (!clazz.equals(product.getClazz()) || !prodSet.add(product.getType())) continue;
            typesOrdered.add(product.getType());
        }
        return new DefaultComboBoxModel<Object>(typesOrdered.toArray());
    }

    public static Dimension getPreferredPositionOnScreen() {
        int y;
        int x;
        if (X != null && Y != null) {
            x = X;
            y = Y;
        } else {
            x = -1;
            y = -1;
        }
        return new Dimension(x, y);
    }

    public void storePreferredPositionOnScreen() {
        X = this.getX();
        Y = this.getY();
    }

    private ComboBoxModel[] getProductDetailModels() {
        String clazz = String.valueOf(this.cbClazz.getSelectedItem());
        String type = String.valueOf(this.cbProduct.getSelectedItem());
        ComboBoxModel[] result = new ComboBoxModel[2];
        TreeSet<String> prodScale = new TreeSet<String>(AlphanumComparator.getInstance());
        HashSet<String> prodLayout = new HashSet<String>();
        ArrayList<LayoutMetaInfo> prodLayoutOrdered = new ArrayList<LayoutMetaInfo>();
        for (AlkisProductDescription product : ClientAlkisProducts.getInstance().getAlkisMapProducts()) {
            if (!clazz.equals(product.getClazz()) || !type.equals(product.getType())) continue;
            prodScale.add(product.getMassstab());
            if (!prodLayout.add(product.getDinFormat())) continue;
            prodLayoutOrdered.add(new LayoutMetaInfo(product.getDinFormat(), product.getWidth(), product.getHeight()));
        }
        result[0] = new DefaultComboBoxModel<Object>(prodLayoutOrdered.toArray());
        result[1] = new DefaultComboBoxModel<Object>(prodScale.toArray());
        return result;
    }

    private AlkisProductDescription getSelectedProduct() {
        String clazz = String.valueOf(this.cbClazz.getSelectedItem());
        String type = String.valueOf(this.cbProduct.getSelectedItem());
        String scale = String.valueOf(this.cbScales.getSelectedItem());
        String layout = String.valueOf(this.cbFormat.getSelectedItem());
        for (AlkisProductDescription product : ClientAlkisProducts.getInstance().getAlkisMapProducts()) {
            if (!clazz.equals(product.getClazz()) || !type.equals(product.getType()) || !scale.equals(product.getMassstab()) || !layout.equals(product.getDinFormat())) continue;
            return product;
        }
        return null;
    }

    private Collection<CidsBean> getObjectBeansInMap() {
        ArrayList result = TypeSafeCollections.newArrayList();
        for (Feature feature : this.mappingComponent.getPFeatureHM().keySet()) {
            CidsFeature cidsFeature;
            if (!(feature instanceof CidsFeature) || (cidsFeature = (CidsFeature)feature).getGeometry() == null) continue;
            result.add(cidsFeature.getMetaObject().getBean());
        }
        return result;
    }

    private Collection<CidsBean> getBeansFromTreeSelection() {
        ArrayList result = TypeSafeCollections.newArrayList();
        Collection nodes = ComponentRegistry.getRegistry().getActiveCatalogue().getSelectedNodes();
        if (nodes != null) {
            for (Object nodeObj : nodes) {
                if (!(nodeObj instanceof ObjectTreeNode)) continue;
                try {
                    ObjectTreeNode metaTreeNode = (ObjectTreeNode)nodeObj;
                    CidsFeature cidsFeature = new CidsFeature(metaTreeNode.getMetaObject());
                    if (cidsFeature.getGeometry() == null) continue;
                    result.add(metaTreeNode.getMetaObject().getBean());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        if (!result.isEmpty()) {
            this.jTabbedPane1.setSelectedComponent(this.jPanel2);
        }
        return result;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panDesc = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.panSettings = new JPanel();
        this.jLabel6 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.scpAdditionalText = new JScrollPane();
        this.taAdditionalText = new JTextArea();
        this.jLabel10 = new JLabel();
        this.cbScales = new JComboBox();
        this.cbFormat = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel7 = new JLabel();
        this.chkRotation = new JCheckBox();
        this.cbProduct = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jLabel12 = new JLabel();
        this.cbClazz = new JComboBox();
        this.jLabel4 = new JLabel();
        this.txtAuftragsnummer = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.scpFlurstuecke = new JScrollPane();
        this.lstFlurstuecke = new JList();
        this.btnRemove = new JButton();
        this.jPanel3 = new JPanel();
        this.lblRahmenkartenNr = new JLabel();
        this.tfRahmenkartenNr = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jPanel4 = new JPanel();
        this.tfE = new JTextField();
        this.tfN = new JTextField();
        this.jLabel14 = new JLabel();
        this.lblPointGeoms = new JLabel();
        this.cbGeoms = new ButlerGeometryComboBox(null);
        this.jLabel11 = new JLabel();
        this.jPanel1 = new JPanel();
        this.cmdCancel = new JButton();
        this.cmdOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(750, 600));
        this.getContentPane().setLayout(new GridBagLayout());
        this.panDesc.setBackground(SystemColor.inactiveCaptionText);
        this.panDesc.setMaximumSize(new Dimension(150, 150));
        this.panDesc.setMinimumSize(new Dimension(150, 150));
        this.panDesc.setPreferredSize(new Dimension(150, 150));
        this.panDesc.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Schritte");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 10, 0, 0);
        this.panDesc.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 319;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panDesc.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabel2.setText("1. Einstellungen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.panDesc.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("2. Druckbereich");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.panDesc.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/frameprint.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = -8;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 3, 7);
        this.panDesc.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 339;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panDesc.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 127;
        gridBagConstraints.ipady = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panDesc, gridBagConstraints);
        this.panSettings.setMaximumSize(new Dimension(425, 300));
        this.panSettings.setMinimumSize(new Dimension(425, 300));
        this.panSettings.setPreferredSize(new Dimension(425, 300));
        this.panSettings.setLayout(new GridBagLayout());
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("1. Einstellungen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 10, 0, 0);
        this.panSettings.add((Component)this.jLabel6, gridBagConstraints);
        this.jSeparator1.setMaximumSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 411;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 5, 0, 5);
        this.panSettings.add((Component)this.jSeparator1, gridBagConstraints);
        this.jSeparator4.setMaximumSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 421;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panSettings.add((Component)this.jSeparator4, gridBagConstraints);
        this.scpAdditionalText.setMinimumSize(new Dimension(250, 110));
        this.scpAdditionalText.setPreferredSize(new Dimension(250, 110));
        this.taAdditionalText.setColumns(20);
        this.taAdditionalText.setRows(5);
        this.scpAdditionalText.setViewportView(this.taAdditionalText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.scpAdditionalText, gridBagConstraints);
        this.jLabel10.setText("Zus\u00e4tzlicher Text:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panSettings.add((Component)this.jLabel10, gridBagConstraints);
        this.cbScales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.cbScalesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.cbScales, gridBagConstraints);
        this.cbFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.cbFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.cbFormat, gridBagConstraints);
        this.jLabel8.setText("Ma\u00dfstab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel7.setText("Format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.jLabel7, gridBagConstraints);
        this.chkRotation.setText("Drehwinkel vorschlagen:");
        this.chkRotation.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.chkRotation, gridBagConstraints);
        this.cbProduct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.cbProductActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.cbProduct, gridBagConstraints);
        this.jLabel9.setText("Produkt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel12.setText("Produktklasse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.jLabel12, gridBagConstraints);
        this.cbClazz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.cbClazzActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.cbClazz, gridBagConstraints);
        this.jLabel4.setText("Auftragsnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.txtAuftragsnummer, gridBagConstraints);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AlkisPrintingSettingsWidget.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.scpFlurstuecke.setMinimumSize(new Dimension(250, 110));
        this.scpFlurstuecke.setPreferredSize(new Dimension(250, 110));
        this.lstFlurstuecke.setModel(this.cidsObjectListModel);
        this.scpFlurstuecke.setViewportView(this.lstFlurstuecke);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.scpFlurstuecke, gridBagConstraints);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/editors/edit_remove_mini.png")));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnRemove, gridBagConstraints);
        this.jTabbedPane1.addTab("Objekte", this.jPanel2);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblRahmenkartenNr.setText("Rahmenkarten-Nr.:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.lblRahmenkartenNr, gridBagConstraints);
        this.tfRahmenkartenNr.setMinimumSize(new Dimension(70, 27));
        this.tfRahmenkartenNr.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.tfRahmenkartenNr, gridBagConstraints);
        this.jLabel13.setText("<html>Beispiel f\u00fcr g\u00fcltige Rahmenkartennummern:<table cellpadding=0 cellspacing=0><tr><td>&nbsp;GK-System:</td><td>&nbsp;83826</td></tr><tr><td>&nbsp;ETRS89 System:</td><td>&nbsp;374815</td></tr>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel15.setText("Eingabe ohne Punkt, Komma oder Leerstelle !");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel15, gridBagConstraints);
        this.jTabbedPane1.addTab("Rahmenkarte", this.jPanel3);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        this.tfE.setMinimumSize(new Dimension(70, 27));
        this.tfE.setPreferredSize(new Dimension(90, 27));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${geomSelected}"), (Object)this.tfE, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.tfE, gridBagConstraints);
        this.tfN.setMinimumSize(new Dimension(70, 27));
        this.tfN.setPreferredSize(new Dimension(90, 27));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${geomSelected}"), (Object)this.tfN, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.tfN, gridBagConstraints);
        this.jLabel14.setText("Mittelpunkt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel14, gridBagConstraints);
        this.lblPointGeoms.setText("Kartengeometrie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblPointGeoms, gridBagConstraints);
        this.cbGeoms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.cbGeomsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.cbGeoms, gridBagConstraints);
        this.jTabbedPane1.addTab("Manuell", this.jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSettings.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jLabel11.setText("Position \u00fcber:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panSettings.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panSettings, gridBagConstraints);
        this.cmdCancel.setMnemonic('A');
        this.cmdCancel.setText("Abbrechen");
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cmdCancel);
        this.cmdOk.setMnemonic('O');
        this.cmdOk.setText("Ok");
        this.cmdOk.setEnabled(false);
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPrintingSettingsWidget.this.cmdOkActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cmdOk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        super.dispose();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.mapPrintListener.cleanUpAndRestoreFeatures();
        this.storePreferredPositionOnScreen();
        super.dispose();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int[] sel = this.lstFlurstuecke.getSelectedIndices();
        int i = sel.length;
        while (--i >= 0) {
            this.cidsObjectListModel.removeElementAt(sel[i]);
        }
        this.updateFormatProposal();
    }

    private void cbClazzActionPerformed(ActionEvent evt) {
        this.cbProduct.setModel(this.getProductTypeModel());
        this.cbProductActionPerformed(null);
        this.updateFormatProposal();
    }

    private void cbProductActionPerformed(ActionEvent evt) {
        ComboBoxModel[] models = this.getProductDetailModels();
        this.cbFormat.setModel(models[0]);
        this.cbScales.setModel(models[1]);
        this.updateFormatProposal();
    }

    private void cbScalesActionPerformed(ActionEvent evt) {
    }

    private void cbFormatActionPerformed(ActionEvent evt) {
    }

    private void cbGeomsActionPerformed(ActionEvent evt) {
        this.updateFormatProposal();
        this.tfE.setEnabled(this.cbGeoms.getSelectedItem() == null);
        this.tfN.setEnabled(this.cbGeoms.getSelectedItem() == null);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jPanel3.equals(this.jTabbedPane1.getSelectedComponent())) {
            this.updateForRahmenKartenNr();
        } else {
            this.updateFormatProposal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGeomForCenter(Geometry geom) {
        if (geom != null) {
            try {
                String formatHint;
                this.cbFormat.removeActionListener(this.updatePrintingGeometryAction);
                this.cbScales.removeActionListener(this.updatePrintingGeometryAction);
                this.chkRotation.removeActionListener(this.updatePrintingGeometryAction);
                this.cbScales.setSelectedIndex(this.cbScales.getModel().getSize() - 1);
                if (!this.coodChangedFlag) {
                    Point centroid = geom.getEnvelope().getCentroid();
                    this.tfE.setText("" + this.coordFormatter.format(centroid.getX()));
                    this.tfN.setText("" + this.coordFormatter.format(centroid.getY()));
                }
                BoundingBox allGeomBB = new BoundingBox(geom);
                Integer productDefaultScale = null;
                if (this.getSelectedProduct() != null) {
                    productDefaultScale = this.getSelectedProduct().getProductDefaultScale();
                }
                boolean hit = this.checkAndSet(productDefaultScale, allGeomBB);
                this.updatePrintingGeometryAction.actionPerformed(null);
                if (hit) {
                    return;
                }
                this.chkRotation.setSelected(true);
                if (allGeomBB.getWidth() >= allGeomBB.getHeight()) {
                    formatHint = "Hoch";
                    this.cbFormat.setSelectedIndex(this.cbFormat.getModel().getSize() - 1);
                } else {
                    this.cbFormat.setSelectedIndex(this.cbFormat.getModel().getSize() - 2);
                    formatHint = "Quer";
                }
                int i = this.cbFormat.getModel().getSize();
                while (--i >= 0) {
                    if (!String.valueOf(this.cbFormat.getItemAt(i)).equals(formatHint)) continue;
                    this.cbFormat.setSelectedIndex(i);
                }
            }
            finally {
                if (this.isVisible()) {
                    this.cbFormat.addActionListener(this.updatePrintingGeometryAction);
                    this.cbScales.addActionListener(this.updatePrintingGeometryAction);
                    this.chkRotation.addActionListener(this.updatePrintingGeometryAction);
                } else {
                    this.cbFormat.removeActionListener(this.updatePrintingGeometryAction);
                    this.cbScales.removeActionListener(this.updatePrintingGeometryAction);
                    this.chkRotation.removeActionListener(this.updatePrintingGeometryAction);
                }
            }
        } else {
            this.chkRotation.setSelected(false);
            this.cbFormat.setSelectedIndex(this.cbFormat.getModel().getSize() - 1);
            this.cbScales.setSelectedIndex(this.cbScales.getModel().getSize() - 1);
        }
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        if (beans != null) {
            for (CidsBean bean : beans) {
                if (this.cidsObjectListModel.contains(bean)) continue;
                this.cidsObjectListModel.addElement(bean);
            }
            this.jTabbedPane1.setSelectedComponent(this.jPanel2);
            this.updateFormatProposal();
        }
    }

    private boolean checkAndSet(Integer defaultScale, BoundingBox allGeomBB) {
        int preferredScaleIndex;
        boolean hit = false;
        if (defaultScale != null && (preferredScaleIndex = ((DefaultComboBoxModel)this.cbScales.getModel()).getIndexOf(defaultScale.toString())) > -1 && (hit = this.formatCheckAndSet(preferredScaleIndex, allGeomBB))) {
            return true;
        }
        for (int j = 0; j < this.cbScales.getModel().getSize(); ++j) {
            hit = this.formatCheckAndSet(j, allGeomBB);
            if (!hit) continue;
            return true;
        }
        return false;
    }

    private boolean formatCheckAndSet(int scaleIndex, BoundingBox allGeomBB) {
        for (int i = 0; i < this.cbFormat.getModel().getSize(); ++i) {
            LayoutMetaInfo currentLayout = (LayoutMetaInfo)this.cbFormat.getItemAt(i);
            Integer currentMassstab = Integer.parseInt(String.valueOf(this.cbScales.getItemAt(scaleIndex)));
            if (!this.doesBoundingBoxFitIntoLayout(allGeomBB, currentLayout.width, currentLayout.heigth, currentMassstab.intValue())) continue;
            this.cbFormat.setSelectedIndex(i);
            this.cbScales.setSelectedIndex(scaleIndex);
            this.chkRotation.setSelected(false);
            return true;
        }
        return false;
    }

    private void updateFormatProposal() {
        if (!this.updateGeomRunning) {
            this.updateGeomRunning = true;
            try {
                this.setGeomForCenter(this.getCurrentGeometry());
                this.syncOkButtonWithListStatus();
            }
            finally {
                this.updateGeomRunning = false;
            }
        }
    }

    public void downloadProduct(final Geometry geom, final double rotationAngle) {
        if (!this.mapPrintListener.isFeatureInCollection()) {
            return;
        }
        final AlkisProductDescription selectedProduct = this.getSelectedProduct();
        boolean isObjekte = this.jPanel2.equals(this.jTabbedPane1.getSelectedComponent());
        final String auftragsnummer = this.txtAuftragsnummer.getText();
        final String additionalText = this.taAdditionalText.getText();
        String landParcelCode = null;
        for (int i = 0; i < this.cidsObjectListModel.size(); ++i) {
            Object o = this.cidsObjectListModel.get(i);
            if (!isObjekte || !(o instanceof CidsBean)) continue;
            if (((CidsBean)o).getMetaObject().getMetaClass().getTableName().equalsIgnoreCase(ALKIS_LANDPARCEL_TABLE)) {
                landParcelCode = AlkisProducts.getLandparcelCodeFromParcelBeanObject(o);
                break;
            }
            if (!((CidsBean)o).getMetaObject().getMetaClass().getTableName().equals(ALKIS_BUCHUNGSBLATT_TABLE)) continue;
            landParcelCode = String.valueOf(((CidsBean)o).getProperty("landparcels[0].landparcelcode"));
            break;
        }
        final Point center = geom.getEnvelope().getCentroid();
        final String objectLandparcel = landParcelCode;
        try {
            CidsAlkisSearchStatement search = new CidsAlkisSearchStatement(CidsAlkisSearchStatement.Resulttyp.FLURSTUECK, CidsAlkisSearchStatement.SucheUeber.FLURSTUECKSNUMMER, "%", (Geometry)center);
            Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, this.getConnectionContext());
            if (mons != null && !mons.isEmpty()) {
                MetaObjectNode mon = (MetaObjectNode)mons.iterator().next();
                if (!mon.objectSet()) {
                    MetaObject mo = SessionManager.getProxy().getMetaObject(SessionManager.getSession().getUser(), mon.getObjectId(), mon.getClassId(), mon.getDomain(), this.connectionContext);
                    mon.setObject(mo);
                }
                String landparcelCode = AlkisProducts.getLandparcelCodeFromParcelBeanObject((Object)mon.getObject().getBean());
                if (objectLandparcel != null && !landparcelCode.equals(objectLandparcel)) {
                    JOptionPane.showMessageDialog((Component)this.mappingComponent, NbBundle.getMessage(AlkisPrintingSettingsWidget.class, (String)"AlkisPrintingSettingsWidget.downloadProduct.other.message", (Object)objectLandparcel, (Object)landparcelCode), NbBundle.getMessage(AlkisPrintingSettingsWidget.class, (String)"AlkisPrintingSettingsWidget.downloadProduct.other.title"), 2);
                } else {
                    JOptionPane.showMessageDialog((Component)this.mappingComponent, NbBundle.getMessage(AlkisPrintingSettingsWidget.class, (String)"AlkisPrintingSettingsWidget.downloadProduct.none.message", (Object)landparcelCode), NbBundle.getMessage(AlkisPrintingSettingsWidget.class, (String)"AlkisPrintingSettingsWidget.downloadProduct.none.title"), 1);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error during flurstueck search", (Throwable)e);
        }
        AlkisProductDownloadHelper.AlkisKarteDownloadInfoCreator creator = new AlkisProductDownloadHelper.AlkisKarteDownloadInfoCreator(){

            @Override
            public AlkisProductDownloadHelper.AlkisKarteDownloadInfo createInfo() throws Exception {
                block142: {
                    String landParcelCode;
                    if (objectLandparcel != null) {
                        landParcelCode = objectLandparcel;
                    } else {
                        CidsAlkisSearchStatement search = new CidsAlkisSearchStatement(CidsAlkisSearchStatement.Resulttyp.FLURSTUECK, CidsAlkisSearchStatement.SucheUeber.FLURSTUECKSNUMMER, "%", (Geometry)center);
                        Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, AlkisPrintingSettingsWidget.this.getConnectionContext());
                        if (mons != null && !mons.isEmpty()) {
                            MetaObjectNode mon = (MetaObjectNode)mons.iterator().next();
                            landParcelCode = mon.toString();
                        } else {
                            landParcelCode = null;
                        }
                    }
                    try {
                        AlkisProductDownloadHelper.AlkisKarteDownloadInfo info = new AlkisProductDownloadHelper.AlkisKarteDownloadInfo(selectedProduct.getCode(), landParcelCode, auftragsnummer.replaceAll("\\?", ""), null, additionalText, selectedProduct.getMassstab(), selectedProduct.getMassstabMin(), selectedProduct.getMassstabMax(), AlkisPrintingSettingsWidget.toInt(rotationAngle), AlkisPrintingSettingsWidget.toInt(center.getX()), AlkisPrintingSettingsWidget.toInt(center.getY()));
                        AlkisProductDownloadHelper.AlkisKarteDownloadInfo infoVermerk = new AlkisProductDownloadHelper.AlkisKarteDownloadInfo(info.getProduct(), info.getLandparcelCode(), info.getAuftragsnummer(), AlkisUtils.getFertigungsVermerk(null, AlkisPrintingSettingsWidget.this.getConnectionContext()), info.getZusatz(), info.getMassstab(), info.getMassstabMin(), info.getMassstabMax(), AlkisPrintingSettingsWidget.toInt(info.getWinkel()), info.getX(), info.getY());
                        HashMap<String, String> requestPerUsage = new HashMap<String, String>();
                        requestPerUsage.put("WV ein", MAPPER.writeValueAsString((Object)infoVermerk));
                        try {
                            BillingProductGroupAmount[] groupAmounts;
                            String product;
                            String dinFormat = selectedProduct.getDinFormat();
                            boolean isDinA4 = dinFormat.equals("DINA4 Hochformat") || dinFormat.equals("DINA4 Querformat");
                            boolean isDinA3 = dinFormat.equals("DINA3 Hochformat") || dinFormat.equals("DINA3 Querformat");
                            boolean isDinA2 = dinFormat.equals("DINA2 Hochformat") || dinFormat.equals("DINA2 Querformat");
                            boolean isDinA1 = dinFormat.equals("DINA1 Hochformat") || dinFormat.equals("DINA1 Querformat");
                            boolean isDinA0 = dinFormat.equals("DINA0 Hochformat") || dinFormat.equals("DINA0 Querformat");
                            String clazz = selectedProduct.getClazz();
                            boolean isGdbNrwAmtlich = clazz.equals("Gdb-NRW-Amtlich");
                            boolean isNrwKommunal = clazz.equals("NRW-Kommunal");
                            boolean isWupKommunal = clazz.equals("WUP-Kommunal");
                            String type = selectedProduct.getType();
                            boolean isFeldvergleichsKarte = type.equals("Feldvergleichskarte, farbig") || type.equals("Feldvergleichskarte, schwarzwei\u00df");
                            boolean isLiegenschaftsKarte = type.equals("Liegenschaftskarte, farbig") || type.equals("Liegenschaftskarte, grau");
                            boolean isStadtgrundkarteMKO = type.equals("Stadtgrundkarte m. kom. Erg., farbig") || type.equals("Stadtgrundkarte m. kom. Erg., schwarz-wei\u00df");
                            boolean isSchaetzungskarte = type.equals("Sch\u00e4tzungskarte, farbig") || type.equals("Sch\u00e4tzungskarte, grau");
                            boolean isAmtlicheBasiskarte = type.equals("Amtliche Basiskarte (farbig)") || type.equals("Amtliche Basiskarte, grau");
                            boolean isStadtgrundkarte = type.equals("Stadtgrundkarte, farbig") || type.equals("Stadtgrundkarte, grau");
                            boolean isDgk = type.equals("DGK");
                            boolean isOrthofoto = type.equals("Orthofoto");
                            boolean isNivPUebersicht = type.equals("NivP-\u00dcbersicht");
                            boolean isApUebersicht = type.equals("AP-\u00dcbersicht");
                            boolean isPunktnummerierungsuebersicht = type.equals("Punktnumerierungs\u00fcbersicht");
                            boolean isDgkMitHoehenlinien = type.equals("ABK mit H\u00f6henlinien");
                            boolean isStadtgrundkarteMitHoehenlinien = type.equals("Stadtgrundkarte mit H\u00f6henlinien");
                            boolean isOrthofotoMitKatasterdarstellung = type.equals("Orthofoto mit Katasterdarstellung");
                            if (isGdbNrwAmtlich && isLiegenschaftsKarte && isDinA4) {
                                product = "fknw4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isGdbNrwAmtlich && isLiegenschaftsKarte && isDinA3) {
                                product = "fknw3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isGdbNrwAmtlich && isLiegenschaftsKarte && isDinA2) {
                                product = "fknw2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isLiegenschaftsKarte && isDinA1) {
                                product = "fknw1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isLiegenschaftsKarte && isDinA0) {
                                product = "fknw0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarteMKO && isDinA4) {
                                product = "skmekom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarteMKO && isDinA3) {
                                product = "skmekom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarteMKO && isDinA2) {
                                product = "skmekom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarteMKO && isDinA1) {
                                product = "skmekom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarteMKO && isDinA0) {
                                product = "skmekom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isSchaetzungskarte && isDinA4) {
                                product = "schknw4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isGdbNrwAmtlich && isSchaetzungskarte && isDinA3) {
                                product = "schknw3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isGdbNrwAmtlich && isSchaetzungskarte && isDinA2) {
                                product = "schknw2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isSchaetzungskarte && isDinA1) {
                                product = "schknw1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isSchaetzungskarte && isDinA0) {
                                product = "schknw0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isAmtlicheBasiskarte && isDinA4) {
                                product = "abknw4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isGdbNrwAmtlich && isAmtlicheBasiskarte && isDinA3) {
                                product = "abknw3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isGdbNrwAmtlich && isAmtlicheBasiskarte && isDinA2) {
                                product = "abknw2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isAmtlicheBasiskarte && isDinA1) {
                                product = "abknw1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isGdbNrwAmtlich && isAmtlicheBasiskarte && isDinA0) {
                                product = "abknw0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarte && isDinA4) {
                                product = "skkom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarte && isDinA3) {
                                product = "skkom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarte && isDinA2) {
                                product = "skkom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarte && isDinA1) {
                                product = "skkom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isNrwKommunal && isStadtgrundkarte && isDinA0) {
                                product = "skkom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isDgk && isDinA4) {
                                product = "dgkkom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isDgk && isDinA3) {
                                product = "dgkkom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isDgk && isDinA2) {
                                product = "dgkkom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isDgk && isDinA1) {
                                product = "dgkkom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isDgk && isDinA0) {
                                product = "dgkkom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isOrthofoto && isDinA4) {
                                product = "ofkom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isOrthofoto && isDinA3) {
                                product = "ofkom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isOrthofoto && isDinA2) {
                                product = "ofkom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isOrthofoto && isDinA1) {
                                product = "ofkom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isOrthofoto && isDinA0) {
                                product = "ofkom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isNivPUebersicht && isDinA4) {
                                product = "nivp\u00fckom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isNivPUebersicht && isDinA3) {
                                product = "nivp\u00fckom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isNivPUebersicht && isDinA2) {
                                product = "nivp\u00fckom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isNivPUebersicht && isDinA1) {
                                product = "nivp\u00fckom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isNivPUebersicht && isDinA0) {
                                product = "nivp\u00fckom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isApUebersicht && isDinA4) {
                                product = "ap\u00fckom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isApUebersicht && isDinA3) {
                                product = "ap\u00fckom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isApUebersicht && isDinA2) {
                                product = "ap\u00fckom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isApUebersicht && isDinA1) {
                                product = "ap\u00fckom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isApUebersicht && isDinA0) {
                                product = "ap\u00fckom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isPunktnummerierungsuebersicht && isDinA4) {
                                product = "pn\u00fckom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isPunktnummerierungsuebersicht && isDinA3) {
                                product = "pn\u00fckom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isPunktnummerierungsuebersicht && isDinA2) {
                                product = "pn\u00fckom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isPunktnummerierungsuebersicht && isDinA1) {
                                product = "pn\u00fckom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isPunktnummerierungsuebersicht && isDinA0) {
                                product = "pn\u00fckom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isDgkMitHoehenlinien && isDinA4) {
                                product = "abkhkom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isDgkMitHoehenlinien && isDinA3) {
                                product = "abkhkom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isDgkMitHoehenlinien && isDinA2) {
                                product = "abkhkom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isDgkMitHoehenlinien && isDinA1) {
                                product = "abkhkom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isDgkMitHoehenlinien && isDinA0) {
                                product = "abkhkom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isStadtgrundkarteMitHoehenlinien && isDinA4) {
                                product = "skhkom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isStadtgrundkarteMitHoehenlinien && isDinA3) {
                                product = "skhkom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isStadtgrundkarteMitHoehenlinien && isDinA2) {
                                product = "skhkom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isStadtgrundkarteMitHoehenlinien && isDinA1) {
                                product = "skhkom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isStadtgrundkarteMitHoehenlinien && isDinA0) {
                                product = "skhkom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isOrthofotoMitKatasterdarstellung && isDinA4) {
                                product = "ofkkom4";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isOrthofotoMitKatasterdarstellung && isDinA3) {
                                product = "ofkkom3";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a3", 1)};
                            } else if (isWupKommunal && isOrthofotoMitKatasterdarstellung && isDinA2) {
                                product = "ofkkom2";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isOrthofotoMitKatasterdarstellung && isDinA1) {
                                product = "ofkkom1";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isWupKommunal && isOrthofotoMitKatasterdarstellung && isDinA0) {
                                product = "ofkkom0";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eakarte_a2-a0", 1)};
                            } else if (isFeldvergleichsKarte) {
                                product = "skmekomtiff";
                                groupAmounts = new BillingProductGroupAmount[]{new BillingProductGroupAmount("eaflst_1000", NasFeeCalculator.getFlurstueckAmount(geom, AlkisPrintingSettingsWidget.this.getConnectionContext())), new BillingProductGroupAmount("eageb_1000", NasFeeCalculator.getGebaeudeAmount(geom, AlkisPrintingSettingsWidget.this.getConnectionContext()))};
                            } else {
                                product = null;
                                groupAmounts = null;
                            }
                            if (product != null) {
                                if (BillingPopup.doBilling(product, MAPPER.writeValueAsString((Object)info), requestPerUsage, (Geometry)null, AlkisPrintingSettingsWidget.this.getConnectionContext(), groupAmounts)) {
                                    return (AlkisProductDownloadHelper.AlkisKarteDownloadInfo)MAPPER.readValue(BillingPopup.getInstance().getCurrentRequest(), AlkisProductDownloadHelper.AlkisKarteDownloadInfo.class);
                                }
                                break block142;
                            }
                            LOG.info((Object)"no product or productgroup is matching");
                            return info;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Aufruf des Produkts: " + selectedProduct, e, AlkisPrintingSettingsWidget.this);
                        LOG.error((Object)e);
                    }
                }
                return null;
            }
        };
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
            AlkisProductDownloadHelper.downloadKarteCustomProduct(creator, DownloadManagerDialog.getInstance().getJobName(), this.cidsObjectListModel.size() > 1, selectedProduct.getType(), this.getConnectionContext());
            this.dispose();
            this.mapPrintListener.cleanUpAndRestoreFeatures();
        }
    }

    private static int toInt(double input) {
        return Double.valueOf(input).intValue();
    }

    private Geometry unionAllObjectsGeometries() {
        Geometry allGeomUnion = null;
        int i = this.cidsObjectListModel.size();
        while (--i >= 0) {
            CidsBean currentObjectBean;
            CidsFeature cf;
            Geometry currentGeom;
            Object currentObj = this.cidsObjectListModel.get(i);
            if (!(currentObj instanceof CidsBean) || (currentGeom = (cf = new CidsFeature((currentObjectBean = (CidsBean)currentObj).getMetaObject())).getGeometry()) == null) continue;
            if (allGeomUnion == null) {
                allGeomUnion = currentGeom;
                continue;
            }
            allGeomUnion = currentGeom.union(allGeomUnion);
        }
        return allGeomUnion;
    }

    private boolean doesBoundingBoxFitIntoLayout(BoundingBox box, int width, int height, double scale) {
        double realWorldLayoutWidth = (double)width / 1000.0 * scale;
        double realWorldLayoutHeigth = (double)height / 1000.0 * scale;
        return realWorldLayoutWidth >= box.getWidth() && realWorldLayoutHeigth >= box.getHeight();
    }

    private void syncOkButtonWithListStatus() {
        this.cmdOk.setEnabled(this.mapPrintListener != null && this.mapPrintListener.isFeatureInCollection());
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        Properties gkRahmenProp = new Properties();
        Properties etrsRahmenProp = new Properties();
        try {
            gkRahmenProp.load(Butler2Dialog.class.getResourceAsStream("rahmenkarten_gk.properties"));
            AlkisPrintingSettingsWidget.loadPropertiesIntoMap(gkRahmenProp, gkRahmenKartenMap);
            etrsRahmenProp.load(Butler2Dialog.class.getResourceAsStream("rahmenkarten_etrs.properties"));
            AlkisPrintingSettingsWidget.loadPropertiesIntoMap(etrsRahmenProp, etrsRahmenKartenMap);
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not read property file with defined boxes for butler 1", (Throwable)ex);
        }
        X = null;
        Y = null;
    }

    static final class LayoutMetaInfo {
        String layoutDesc;
        String layoutCode;
        int width;
        int heigth;

        public LayoutMetaInfo(String layoutDesc, int width, int heigth) {
            this.layoutDesc = layoutDesc;
            this.width = width;
            this.heigth = heigth;
        }

        public String toString() {
            return this.layoutDesc;
        }
    }
}

