/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils.billing;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.BerechtigungspruefungKonfiguration;
import de.cismet.cids.custom.objectrenderer.utils.billing.ClientBillingUtils;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingInfo;
import de.cismet.cids.custom.utils.billing.BillingInfoHandler;
import de.cismet.cids.custom.utils.billing.BillingModus;
import de.cismet.cids.custom.utils.billing.BillingPrice;
import de.cismet.cids.custom.utils.billing.BillingProduct;
import de.cismet.cids.custom.utils.billing.BillingProductGroup;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.billing.BillingUsage;
import de.cismet.cids.custom.wunda_blau.search.actions.BerechtigungspruefungAnfrageServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class BillingPopup
extends JDialog {
    private static final Collection<String> ALLOWED_EXTENSIONS = Arrays.asList("pdf", "bmp", "tiff", "tif", "png", "jpg", "jpeg", "jpg", "gif");
    public static final String MODE_CONFIG_ATTR = "billing.mode@WUNDA_BLAU";
    public static final String ALLOWED_USAGE_CONFIG_ATTR = "billing.allowed.usage@WUNDA_BLAU";
    public static final String RESTRICTED_USAGE_CONFIG_ATTR = "billing.restricted.usage@WUNDA_BLAU";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final transient Logger LOG = Logger.getLogger(BillingPopup.class);
    BillingProduct currentProduct = null;
    BillingModus currentMode = null;
    BillingUsage currentUsage = null;
    String defaultRequest = null;
    Map<String, String> requestPerUsage;
    Geometry geom = null;
    CidsBean logEntry = null;
    String berechnungPrefix = "";
    private final BillingInfoHandler infoHandler;
    private final ImageIcon money = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/billing/money--exclamation.png"));
    private double rawPrice = 0.0;
    private BillingPrice price;
    private boolean shouldGoOn = false;
    private BerechtigungspruefungBillingDownloadInfo downloadInfo = null;
    private File file = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JComboBox cboUsage;
    private JButton cmdCancel;
    private JButton cmdOk;
    private JButton jButton3;
    private JComboBox<String> jComboBox1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JTextArea jTextArea1;
    private JTextPane jTextPane1;
    private JLabel lblGebTitle;
    private JLabel lblGebuehr;
    private JLabel lblMoneyWarn;
    private JLabel lblMwst;
    private JLabel lblMwstTitle;
    private JPanel panControls;
    private JTextPane txtBerechnung;
    private JTextField txtGBuchNr;
    private JTextArea txtProjektbez;

    private BillingPopup() {
        super((Frame)ComponentRegistry.getRegistry().getMainWindow(), true);
        BillingInfo billingInfoTmp;
        this.initComponents();
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 2);
        StyleConstants.setFontSize(attribs, 10);
        this.txtBerechnung.setParagraphAttributes(attribs, true);
        try {
            Object ret = SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.BILLING_JSON.getValue(), this.getConnectionContext(), new ServerActionParameter[0]);
            if (ret instanceof Exception) {
                throw (Exception)ret;
            }
            billingInfoTmp = (BillingInfo)MAPPER.readValue((String)ret, BillingInfo.class);
        }
        catch (Exception exception) {
            LOG.error((Object)"Error when trying to read the billingInfo.json", (Throwable)exception);
            billingInfoTmp = null;
        }
        this.infoHandler = billingInfoTmp != null ? new BillingInfoHandler(billingInfoTmp) : null;
    }

    @Deprecated
    public static boolean doBilling(String product, String request, Geometry geom, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, request, geom, ConnectionContext.createDeprecated(), amounts);
    }

    public static boolean doBilling(String product, String request, Geometry geom, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, request, (Map<String, String>)null, geom, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String request, Geometry geom, BerechtigungspruefungBillingDownloadInfo downloadInfo, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, request, (Map<String, String>)null, geom, downloadInfo, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String defaultRequest, Map<String, String> requestPerUsage, Geometry geom, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, defaultRequest, requestPerUsage, geom, null, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String defaultRequest, Map<String, String> requestPerUsage, Geometry geom, BerechtigungspruefungBillingDownloadInfo downloadInfo, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        BillingPopup instance = BillingPopup.getInstance();
        User user = SessionManager.getSession().getUser();
        if (SessionManager.getConnection().hasConfigAttr(user, MODE_CONFIG_ATTR, connectionContext)) {
            instance.initialize(product, defaultRequest, requestPerUsage, geom, downloadInfo, amounts);
            return instance.shouldGoOn;
        }
        instance.defaultRequest = defaultRequest;
        return true;
    }

    public static boolean doBilling(String product, String request, String gBuchNr, Geometry geom, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, request, gBuchNr, null, geom, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String request, String gBuchNr, String projektbez, Geometry geom, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, request, null, gBuchNr, projektbez, geom, null, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String request, String gBuchNr, String projektbez, Geometry geom, BerechtigungspruefungBillingDownloadInfo downloadInfo, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, request, null, gBuchNr, projektbez, geom, downloadInfo, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String defaultRequest, Map<String, String> requestPerUsage, String gBuchNr, Geometry geom, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, defaultRequest, requestPerUsage, gBuchNr, null, geom, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String defaultRequest, Map<String, String> requestPerUsage, String gBuchNr, String projektbez, Geometry geom, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        return BillingPopup.doBilling(product, defaultRequest, requestPerUsage, gBuchNr, projektbez, geom, null, connectionContext, amounts);
    }

    public static boolean doBilling(String product, String defaultRequest, Map<String, String> requestPerUsage, String gBuchNr, String projektbez, Geometry geom, BerechtigungspruefungBillingDownloadInfo downloadInfo, ConnectionContext connectionContext, BillingProductGroupAmount ... amounts) throws Exception {
        BillingPopup instance = BillingPopup.getInstance();
        instance.txtGBuchNr.setText(gBuchNr);
        instance.txtProjektbez.setText(projektbez);
        if (BillingPopup.hasUserBillingMode(connectionContext)) {
            instance.initialize(product, defaultRequest, requestPerUsage, geom, downloadInfo, amounts);
            return instance.shouldGoOn;
        }
        instance.defaultRequest = defaultRequest;
        return true;
    }

    public static boolean hasUserBillingMode(ConnectionContext connectionContext) throws Exception {
        return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), MODE_CONFIG_ATTR, connectionContext);
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.lblMoneyWarn = new JLabel();
        this.jFileChooser1 = new JFileChooser();
        this.jSeparator1 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.panControls = new JPanel();
        this.cmdCancel = new JButton();
        this.cmdOk = new JButton();
        this.jLabel1 = new JLabel();
        this.txtGBuchNr = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txtProjektbez = new JTextArea();
        this.jLabel3 = new JLabel();
        this.cboUsage = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblGebuehr = new JLabel();
        this.lblGebTitle = new JLabel();
        this.lblMwstTitle = new JLabel();
        this.lblMwst = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.txtBerechnung = new JTextPane();
        this.jLabel7 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel9 = new JLabel();
        this.jScrollPane3.setViewportView(this.jTextPane1);
        this.lblMoneyWarn.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/billing/money--exclamation.png")));
        this.lblMoneyWarn.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.lblMoneyWarn.text"));
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.setFileFilter(new FileNameExtensionFilter("PDF und Bild-Dateien", ALLOWED_EXTENSIONS.toArray(new String[0])));
        this.setTitle(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.title"));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 600));
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.panControls.setLayout(new FlowLayout(2));
        this.cmdCancel.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.cmdCancel.text"));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingPopup.this.cmdCancelActionPerformed(evt);
            }
        });
        this.panControls.add(this.cmdCancel);
        this.cmdOk.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingPopup.this.cmdOkActionPerformed(evt);
            }
        });
        this.panControls.add(this.cmdOk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.panControls, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.txtGBuchNr.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.txtGBuchNr.text"));
        this.txtGBuchNr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingPopup.this.txtGBuchNrActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        this.getContentPane().add((Component)this.txtGBuchNr, gridBagConstraints);
        this.jLabel2.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(222, 77));
        this.txtProjektbez.setColumns(20);
        this.txtProjektbez.setRows(5);
        this.txtProjektbez.setMinimumSize(new Dimension(0, 40));
        this.jScrollPane2.setViewportView(this.txtProjektbez);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel3.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(1, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.cboUsage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingPopup.this.cboUsageActionPerformed(evt);
            }
        });
        this.cboUsage.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BillingPopup.this.cboUsagePropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 5, 5);
        this.getContentPane().add((Component)this.cboUsage, gridBagConstraints);
        this.jLabel5.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(101, 35));
        this.jPanel1.setPreferredSize(new Dimension(101, 35));
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblGebuehr.setHorizontalAlignment(4);
        this.lblGebuehr.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.lblGebuehr.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.jPanel1.add((Component)this.lblGebuehr, gridBagConstraints);
        this.lblGebTitle.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.lblGebTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.jPanel1.add((Component)this.lblGebTitle, gridBagConstraints);
        this.lblMwstTitle.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.lblMwstTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.jPanel1.add((Component)this.lblMwstTitle, gridBagConstraints);
        this.lblMwst.setHorizontalAlignment(4);
        this.lblMwst.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.lblMwst.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.jPanel1.add((Component)this.lblMwst, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.txtBerechnung.setEditable(false);
        this.txtBerechnung.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        this.txtBerechnung.setMinimumSize(new Dimension(0, 200));
        this.jScrollPane4.setViewportView(this.txtBerechnung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        this.getContentPane().add((Component)this.jScrollPane4, gridBagConstraints);
        this.jLabel7.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        this.getContentPane().add(this.jComboBox1, gridBagConstraints);
        this.jLabel6.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(1, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(222, 77));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setMinimumSize(new Dimension(0, 40));
        this.jScrollPane5.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollPane5, gridBagConstraints);
        this.jLabel4.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel8.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel8.text"));
        this.jLabel8.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.jButton3.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jButton3.text"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingPopup.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.jButton3, gridBagConstraints);
        this.jLabel9.setText(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.jLabel9.text"));
        this.jLabel9.setPreferredSize(new Dimension(450, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.setSize(new Dimension(468, 678));
        this.setLocationRelativeTo(null);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int status = this.jFileChooser1.showOpenDialog(StaticSwingTools.getParentFrame((Component)this));
        if (status == 0) {
            String extension = this.jFileChooser1.getSelectedFile().getName().substring(this.jFileChooser1.getSelectedFile().getName().lastIndexOf(".") + 1);
            if (ALLOWED_EXTENSIONS.contains(extension)) {
                this.file = this.jFileChooser1.getSelectedFile();
            } else {
                this.file = null;
                JOptionPane.showMessageDialog(this, "Diese Datei-Endung ist nicht erlaubt.\n\nFolgende Datei-Endungen werden akzeptiert:\n" + BillingPopup.implode(",", ALLOWED_EXTENSIONS.toArray(new String[0])), "Unerlaubte Datei-Endung", 0);
            }
        } else {
            this.file = null;
        }
        this.updateFileLabel();
    }

    private void updateFileLabel() {
        this.jLabel8.setText(this.file == null ? "<html><i>keine Datei ausgew\u00e4hlt" : this.file.getName());
    }

    private void txtGBuchNrActionPerformed(ActionEvent evt) {
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        if (this.downloadInfo == null && this.txtGBuchNr.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Sie m\u00fcssen eine Gesch\u00e4ftsbuchnummer eingeben, damit der Vorgang bearbeitet werden kann.", "Fehlende Eingabe", 2);
            return;
        }
        try {
            if (this.downloadInfo != null) {
                this.downloadInfo.setProduktbezeichnung(this.txtProjektbez.getText());
                new SwingWorker<String, Void>(){

                    @Override
                    protected String doInBackground() throws Exception {
                        String fileName = BillingPopup.this.file != null ? BillingPopup.this.file.getName() : null;
                        byte[] fileData = BillingPopup.this.file != null ? FileUtils.readFileToByteArray((File)BillingPopup.this.file) : null;
                        String anfrageSchluessel = BillingPopup.requestPruefung(fileData, fileName, BillingPopup.this.jComboBox1.getSelectedItem().toString(), BillingPopup.this.jTextArea1.getText(), (BerechtigungspruefungDownloadInfo)BillingPopup.this.downloadInfo, BillingPopup.this.txtBerechnung.getText().trim(), BillingPopup.this.currentMode, BillingPopup.this.currentUsage, BillingPopup.this.currentProduct, BillingPopup.this.price, BillingPopup.this.getConnectionContext());
                        return anfrageSchluessel;
                    }

                    @Override
                    protected void done() {
                        try {
                            String anfrageSchluessel = (String)this.get();
                            JOptionPane.showMessageDialog(BillingPopup.this, "<html>Ihre Anfrage wird unter dem Schl\u00fcssel \"" + anfrageSchluessel + "\" bearbeitet.<br/>Sie werden benachrichtigt, sobald sie bearbeitet wurde.", "Ihre Anfrage wird bearbeitet", 1);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                            String title = "Unerwarteter Fehler";
                            String message = "Beim Anfrage der Berechtigungspr\u00fcfung ist es zu unerwartetem einem Fehler gekommen.";
                            LOG.error((Object)"Beim Anfrage der Berechtigungspr\u00fcfung ist es zu unerwartetem einem Fehler gekommen.", (Throwable)ex);
                            ErrorInfo info = new ErrorInfo("Unerwarteter Fehler", "Beim Anfrage der Berechtigungspr\u00fcfung ist es zu unerwartetem einem Fehler gekommen.", null, null, (Throwable)ex, Level.SEVERE, null);
                            JXErrorPane.showDialog((Component)ComponentRegistry.getRegistry().getMainWindow(), (ErrorInfo)info);
                        }
                    }
                }.execute();
                this.shouldGoOn = false;
            } else {
                CidsBean billingBean = ClientBillingUtils.getInstance().createBilling(this.txtBerechnung.getText().trim(), this.txtGBuchNr.getText(), this.getCurrentRequest(), this.txtBerechnung.getText().trim(), this.currentMode, this.currentUsage, this.currentProduct, this.price, SessionManager.getSession().getUser(), null, this.connectionContext);
                billingBean.persist(this.connectionContext);
                this.shouldGoOn = true;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error during the persitence of the billing log.", (Throwable)ex);
            String title = "Unerwarteter Fehler";
            String message = "Beim Erzeugen der Buchung ist es zu unerwartetem einem Fehler gekommen.";
            LOG.error((Object)"Beim Erzeugen der Buchung ist es zu unerwartetem einem Fehler gekommen.", (Throwable)ex);
            ErrorInfo info = new ErrorInfo("Unerwarteter Fehler", "Beim Erzeugen der Buchung ist es zu unerwartetem einem Fehler gekommen.", null, null, (Throwable)ex, Level.SEVERE, null);
            JXErrorPane.showDialog((Component)ComponentRegistry.getRegistry().getMainWindow(), (ErrorInfo)info);
            this.shouldGoOn = false;
        }
        this.setVisible(false);
    }

    public String getCurrentRequest() {
        String usageKey;
        String string = usageKey = this.currentUsage != null ? this.currentUsage.getKey() : null;
        if (this.requestPerUsage != null && this.requestPerUsage.containsKey(usageKey)) {
            return this.requestPerUsage.get(usageKey);
        }
        return this.defaultRequest;
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.shouldGoOn = false;
        this.setVisible(false);
    }

    private void cboUsageActionPerformed(ActionEvent evt) {
        this.calculatePrice();
    }

    private void cboUsagePropertyChange(PropertyChangeEvent evt) {
    }

    private void calculatePrice() {
        Object sel = this.cboUsage.getSelectedItem();
        if (sel instanceof BillingUsage) {
            this.currentUsage = (BillingUsage)sel;
            String berechungUsageDependent = "";
            this.price = new BillingPrice(this.rawPrice, this.currentUsage.getKey(), this.currentProduct);
            berechungUsageDependent = "zweckabh\u00e4ngiger Rabatt (" + this.price.getDiscountPercentage() + "%) : -" + NumberFormat.getCurrencyInstance().format(this.price.getDiscountAbsolute()) + " \n";
            berechungUsageDependent = berechungUsageDependent + "---------\n";
            berechungUsageDependent = berechungUsageDependent + NumberFormat.getCurrencyInstance().format(this.price.getNetto()) + " \n";
            this.txtBerechnung.setText(this.berechnungPrefix + "\n" + berechungUsageDependent);
            DecimalFormat df = new DecimalFormat("0.#");
            this.lblMwstTitle.setText("zzgl. MwSt. (" + df.format(this.currentProduct.getMwst()) + "%):");
            this.lblMwst.setText(NumberFormat.getCurrencyInstance().format(this.price.getMwst()));
            this.lblGebuehr.setText(NumberFormat.getCurrencyInstance().format(this.price.getBrutto()));
            if (this.price.getBrutto() > 0.0) {
                this.lblGebTitle.setIcon(this.money);
            } else {
                this.lblGebTitle.setIcon(null);
            }
        } else {
            this.currentUsage = null;
        }
    }

    public BillingUsage getCurrentUsage() {
        return this.currentUsage;
    }

    public static boolean isBillingAllowed(String product, ConnectionContext connectionContext) {
        try {
            User user = SessionManager.getSession().getUser();
            return !SessionManager.getConnection().hasConfigAttr(user, MODE_CONFIG_ATTR, connectionContext) || SessionManager.getConnection().hasConfigAttr(user, MODE_CONFIG_ATTR, connectionContext) && BillingPopup.getAllowedUsages(user, product, connectionContext).length > 0;
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"error while checking configAttr", (Throwable)ex);
            return false;
        }
    }

    public static String[] getAllowedUsages(User user, String product, ConnectionContext connectionContext) throws ConnectionException {
        String rawRestrcitedUsageLines;
        LinkedHashSet<String> allowedUsages = new LinkedHashSet<String>();
        String rawAllowedUsageLines = SessionManager.getConnection().getConfigAttr(user, ALLOWED_USAGE_CONFIG_ATTR, connectionContext);
        if (rawAllowedUsageLines != null) {
            for (String rawAllowedUsageLine : rawAllowedUsageLines.split("\n")) {
                String allowedProduct;
                int indexOfAllowed = rawAllowedUsageLine.indexOf(":");
                String string = allowedProduct = indexOfAllowed > -1 ? rawAllowedUsageLine.substring(0, indexOfAllowed) : null;
                if (allowedProduct != null && !allowedProduct.equals(product)) continue;
                allowedUsages.addAll(Arrays.asList(rawAllowedUsageLine.substring(indexOfAllowed + 1).split(",")));
            }
        }
        if (!allowedUsages.isEmpty() && (rawRestrcitedUsageLines = SessionManager.getConnection().getConfigAttr(user, RESTRICTED_USAGE_CONFIG_ATTR, connectionContext)) != null) {
            for (String rawRestrcitedUsageLine : rawRestrcitedUsageLines.split("\n")) {
                String restrictedProduct;
                int indexOfRestricted = rawRestrcitedUsageLine.indexOf(":");
                String string = restrictedProduct = indexOfRestricted > -1 ? rawRestrcitedUsageLine.substring(0, indexOfRestricted) : null;
                if (restrictedProduct != null && !restrictedProduct.equals(product)) continue;
                allowedUsages.removeAll(Arrays.asList(rawRestrcitedUsageLine.substring(indexOfRestricted + 1).split(",")));
            }
        }
        return allowedUsages.toArray(new String[0]);
    }

    public String getBerechnungsProtokoll() {
        return this.txtBerechnung.getText();
    }

    private void initialize(String product, String defaultRequest, Map<String, String> requestPerUsage, Geometry geom, BerechtigungspruefungBillingDownloadInfo downloadInfo, BillingProductGroupAmount ... amounts) throws Exception {
        User user = SessionManager.getSession().getUser();
        String modus = SessionManager.getConnection().getConfigAttr(user, MODE_CONFIG_ATTR, this.getConnectionContext());
        this.currentMode = (BillingModus)this.infoHandler.getModi().get(modus);
        if (this.currentMode == null) {
            LOG.info((Object)("mode " + modus + " not found in billing.json. will hide billing popup. reports for free ;-)"));
            this.setVisible(false);
            return;
        }
        this.txtBerechnung.setText(null);
        this.berechnungPrefix = "";
        this.currentProduct = (BillingProduct)this.infoHandler.getProducts().get(product);
        this.berechnungPrefix = "\nProdukt: " + this.currentProduct.getName() + "\n\n";
        if (this.currentProduct == null) {
            throw new IllegalArgumentException("Product " + product + " not in the configured productlist.");
        }
        for (BillingProductGroupAmount billingProductGroupAmount : amounts) {
            if (this.currentProduct.getPrices().get(billingProductGroupAmount.getGroup()) == null || this.infoHandler.getProductGroups().get(billingProductGroupAmount.getGroup()) == null) {
                throw new IllegalArgumentException("Productgroup " + billingProductGroupAmount.getGroup() + " not in the configured productgroups.");
            }
            this.berechnungPrefix = this.berechnungPrefix + billingProductGroupAmount.getAmount() + " " + ((BillingProductGroup)this.infoHandler.getProductGroups().get(billingProductGroupAmount.getGroup())).getDescription() + " (a " + NumberFormat.getCurrencyInstance().format(this.currentProduct.getPrices().get(billingProductGroupAmount.getGroup())) + ")\n";
        }
        this.berechnungPrefix = this.berechnungPrefix + "---------\n";
        this.rawPrice = BillingInfoHandler.calculateRawPrice((BillingProduct)this.currentProduct, (BillingProductGroupAmount[])amounts);
        this.berechnungPrefix = this.berechnungPrefix + NumberFormat.getCurrencyInstance().format(this.rawPrice) + " \n";
        this.berechnungPrefix = this.berechnungPrefix + "\n";
        String[] validUsages = BillingPopup.getAllowedUsages(user, this.currentProduct.getId(), this.getConnectionContext());
        BillingUsage[] comboUsages = new BillingUsage[validUsages.length];
        int i = 0;
        for (String usage : validUsages) {
            if (this.currentProduct.getDiscounts().get(usage) == null || this.infoHandler.getUsages().get(usage) == null) {
                throw new IllegalArgumentException("Usage " + usage + " not in the configured discounts for product " + this.currentProduct.getId());
            }
            comboUsages[i++] = (BillingUsage)this.infoHandler.getUsages().get(usage);
        }
        this.cboUsage.setModel(new DefaultComboBoxModel<BillingUsage>(comboUsages));
        this.setTitle(NbBundle.getMessage(BillingPopup.class, (String)"BillingPopup.title") + " (" + user + ")");
        this.calculatePrice();
        this.defaultRequest = defaultRequest;
        this.requestPerUsage = requestPerUsage;
        this.downloadInfo = downloadInfo;
        this.txtGBuchNr.setEnabled(downloadInfo == null);
        boolean bl = downloadInfo != null;
        this.jComboBox1.setVisible(bl);
        this.jScrollPane5.setVisible(bl);
        this.jButton3.setVisible(bl);
        this.jLabel4.setVisible(bl);
        this.jLabel6.setVisible(bl);
        this.jLabel7.setVisible(bl);
        this.jLabel8.setVisible(bl);
        this.jLabel9.setVisible(bl);
        this.jSeparator3.setVisible(bl);
        if (downloadInfo != null) {
            this.txtGBuchNr.setText("");
            this.setProdukt(downloadInfo.getProduktTyp());
        }
        this.pack();
        this.setVisible(true);
    }

    public static HashMap<String, BillingProduct> getProducts() {
        return BillingPopup.getInstance().infoHandler.getProducts();
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.initSessionManagerFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"buggalo");
        boolean t = BillingPopup.doBilling("fsnw", "request", null, ConnectionContext.createDummy(), new BillingProductGroupAmount("ea", 2), new BillingProductGroupAmount("ea", 1), new BillingProductGroupAmount("ea", 1), new BillingProductGroupAmount("ea", 1));
        System.out.println("schluss " + t);
        System.exit(0);
    }

    public static BillingPopup getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public void setProdukt(String produktbezeichnung) {
        ((DefaultComboBoxModel)this.jComboBox1.getModel()).removeAllElements();
        for (BerechtigungspruefungKonfiguration.ProduktTyp produkt : BerechtigungspruefungKonfiguration.INSTANCE.getProdukte()) {
            if (!produktbezeichnung.equals(produkt.getProduktbezeichnung())) continue;
            ((DefaultComboBoxModel)this.jComboBox1.getModel()).addElement("<html><i>kein Berechtigungsgrund ausgew\u00e4hlt");
            for (String berechtigungsgrund : produkt.getBerechtigungsgruende()) {
                ((DefaultComboBoxModel)this.jComboBox1.getModel()).addElement(berechtigungsgrund);
            }
        }
        this.jTextArea1.setText("");
        this.file = null;
        this.updateFileLabel();
    }

    public static String implode(String delimiter, String ... strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strings[0]);
        for (int index = 1; index < strings.length; ++index) {
            sb.append(delimiter);
            sb.append(strings[index]);
        }
        return sb.toString();
    }

    private static String requestPruefung(byte[] fileData, String fileName, String berechtigungsgrund, String begruendung, BerechtigungspruefungDownloadInfo downloadInfo, String billingBerechnung, BillingModus billingModus, BillingUsage billingUsage, BillingProduct billingProduct, BillingPrice billingPrice, ConnectionContext connectionContext) throws Exception {
        ArrayList<ServerActionParameter> params = new ArrayList<ServerActionParameter>();
        ObjectMapper mapper = new ObjectMapper();
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.DATEINAME.toString(), (Object)fileName));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.BERECHTIGUNGSGRUND.toString(), (Object)berechtigungsgrund));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.BEGRUENDUNG.toString(), (Object)begruendung));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.DOWNLOADINFO_JSON.toString(), (Object)mapper.writeValueAsString((Object)downloadInfo)));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.BILLING_BERECHNUNG.toString(), (Object)billingBerechnung));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.BILLING_MODUS.toString(), (Object)billingModus));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.BILLING_USAGE.toString(), (Object)billingUsage));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.BILLING_PRODUCT.toString(), (Object)billingProduct));
        params.add(new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.BILLING_PRICE.toString(), (Object)billingPrice));
        Object ret = SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "berechtigungspruefungAnfrage", SessionManager.getSession().getUser().getDomain(), (Object)fileData, connectionContext, params.toArray(new ServerActionParameter[0]));
        if (ret instanceof Exception) {
            throw (Exception)ret;
        }
        return (String)ret;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private static final class LazyInitialiser {
        private static final BillingPopup INSTANCE = new BillingPopup();

        private LazyInitialiser() {
        }
    }
}

