/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils.billing;

import de.cismet.cids.custom.objectrenderer.utils.billing.FilterSettingChangedTrigger;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TimeFilterPanel
extends JPanel
implements FilterSettingChangedTrigger {
    private static final Logger LOG = Logger.getLogger(TimeFilterPanel.class);
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private Action filterAction;
    private ButtonGroup btngTimeFilters;
    private JComboBox cboMonth;
    private JComboBox cboQuarter;
    private JComboBox cboYear_Month;
    private JComboBox cboYear_Quarter;
    private JXDatePicker dpFrom;
    private JXDatePicker dpTill;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel pnlDateRange;
    private JPanel pnlIgnore;
    private JPanel pnlMonth;
    private JPanel pnlQuarter;
    private JPanel pnlTimeFilterCards;
    private JPanel pnlTimeFilters;
    private JPanel pnlToday;
    private JToggleButton tbtnDateRange;
    private JToggleButton tbtnIgnore;
    private JToggleButton tbtnMonth;
    private JToggleButton tbtnQuarter;
    private JToggleButton tbtnToday;

    public TimeFilterPanel() {
        this.initComponents();
        this.setTimeRelatedModels();
        this.selectCurrentDates();
        this.dpFrom.getMonthView().setZoomable(true);
        this.dpTill.getMonthView().setZoomable(true);
    }

    private void initComponents() {
        this.btngTimeFilters = new ButtonGroup();
        this.pnlTimeFilters = new JPanel();
        this.pnlTimeFilterCards = new JPanel();
        this.pnlIgnore = new JPanel();
        this.jLabel13 = new JLabel();
        this.filler5 = new Box.Filler(new Dimension(1, 0), new Dimension(1, 0), new Dimension(1, Short.MAX_VALUE));
        this.pnlToday = new JPanel();
        this.jLabel9 = new JLabel();
        this.filler2 = new Box.Filler(new Dimension(1, 0), new Dimension(1, 0), new Dimension(1, Short.MAX_VALUE));
        this.pnlMonth = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel10 = new JLabel();
        this.cboMonth = new JComboBox();
        this.cboYear_Month = new JComboBox();
        this.filler1 = new Box.Filler(new Dimension(1, 0), new Dimension(1, 0), new Dimension(1, Short.MAX_VALUE));
        this.pnlQuarter = new JPanel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.cboQuarter = new JComboBox();
        this.cboYear_Quarter = new JComboBox();
        this.filler4 = new Box.Filler(new Dimension(1, 0), new Dimension(1, 0), new Dimension(1, Short.MAX_VALUE));
        this.pnlDateRange = new JPanel();
        this.dpTill = new JXDatePicker();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.dpFrom = new JXDatePicker();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.tbtnToday = new JToggleButton();
        this.tbtnIgnore = new JToggleButton();
        this.tbtnMonth = new JToggleButton();
        this.tbtnDateRange = new JToggleButton();
        this.tbtnQuarter = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.pnlTimeFilters.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.pnlTimeFilters.setLayout(new GridBagLayout());
        this.pnlTimeFilterCards.setBorder(BorderFactory.createTitledBorder(""));
        this.pnlTimeFilterCards.setLayout(new CardLayout());
        this.pnlIgnore.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel13.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.pnlIgnore.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlIgnore.add((Component)this.filler5, gridBagConstraints);
        this.pnlTimeFilterCards.add((Component)this.pnlIgnore, "pnlIgnore");
        this.pnlToday.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.pnlToday.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlToday.add((Component)this.filler2, gridBagConstraints);
        this.pnlTimeFilterCards.add((Component)this.pnlToday, "pnlToday");
        this.pnlMonth.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 6, 3, 3);
        this.pnlMonth.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(4, 6, 10, 3);
        this.pnlMonth.add((Component)this.jLabel10, gridBagConstraints);
        this.cboMonth.setModel(new DefaultComboBoxModel<String>(new String[]{"Januar", "Februar", "M\u00e4rz"}));
        this.cboMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.cboMonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(10, 2, 3, 0);
        this.pnlMonth.add((Component)this.cboMonth, gridBagConstraints);
        this.cboYear_Month.setModel(new DefaultComboBoxModel<String>(new String[]{"2013"}));
        this.cboYear_Month.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.cboYear_MonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 2, 10, 0);
        this.pnlMonth.add((Component)this.cboYear_Month, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlMonth.add((Component)this.filler1, gridBagConstraints);
        this.pnlTimeFilterCards.add((Component)this.pnlMonth, "pnlMonth");
        this.pnlQuarter.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 6, 4, 3);
        this.pnlQuarter.add((Component)this.jLabel11, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 6, 10, 3);
        this.pnlQuarter.add((Component)this.jLabel12, gridBagConstraints);
        this.cboQuarter.setModel(new DefaultComboBoxModel<String>(new String[]{"Januar - M\u00e4rz", "April - Juni", "Juli - September", "Oktober - Dezember"}));
        this.cboQuarter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.cboQuarterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(10, 3, 4, 0);
        this.pnlQuarter.add((Component)this.cboQuarter, gridBagConstraints);
        this.cboYear_Quarter.setModel(new DefaultComboBoxModel<String>(new String[]{"2013"}));
        this.cboYear_Quarter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.cboYear_QuarterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 10, 0);
        this.pnlQuarter.add((Component)this.cboYear_Quarter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlQuarter.add((Component)this.filler4, gridBagConstraints);
        this.pnlTimeFilterCards.add((Component)this.pnlQuarter, "pnlQuarter");
        this.pnlDateRange.setLayout(new GridBagLayout());
        this.dpTill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.dpTillActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 10, 0);
        this.pnlDateRange.add((Component)this.dpTill, gridBagConstraints);
        this.dpTill.setFormats(new DateFormat[]{DATE_FORMAT});
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 6, 4, 3);
        this.pnlDateRange.add((Component)this.jLabel7, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 6, 10, 3);
        this.pnlDateRange.add((Component)this.jLabel8, gridBagConstraints);
        this.dpFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.dpFromActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(10, 3, 4, 0);
        this.pnlDateRange.add((Component)this.dpFrom, gridBagConstraints);
        this.dpFrom.setFormats(new DateFormat[]{DATE_FORMAT});
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlDateRange.add((Component)this.filler3, gridBagConstraints);
        this.pnlTimeFilterCards.add((Component)this.pnlDateRange, "pnlDateRange");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.pnlTimeFilters.add((Component)this.pnlTimeFilterCards, gridBagConstraints);
        this.btngTimeFilters.add(this.tbtnToday);
        Mnemonics.setLocalizedText((AbstractButton)this.tbtnToday, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.tbtnToday.text"));
        this.tbtnToday.setMaximumSize(new Dimension(500, 25));
        this.tbtnToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.tbtnTodayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.pnlTimeFilters.add((Component)this.tbtnToday, gridBagConstraints);
        this.btngTimeFilters.add(this.tbtnIgnore);
        this.tbtnIgnore.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbtnIgnore, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.tbtnIgnore.text"));
        this.tbtnIgnore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.tbtnIgnoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.pnlTimeFilters.add((Component)this.tbtnIgnore, gridBagConstraints);
        this.btngTimeFilters.add(this.tbtnMonth);
        Mnemonics.setLocalizedText((AbstractButton)this.tbtnMonth, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.tbtnMonth.text"));
        this.tbtnMonth.setMaximumSize(new Dimension(500, 25));
        this.tbtnMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.tbtnMonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.pnlTimeFilters.add((Component)this.tbtnMonth, gridBagConstraints);
        this.btngTimeFilters.add(this.tbtnDateRange);
        Mnemonics.setLocalizedText((AbstractButton)this.tbtnDateRange, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.tbtnDateRange.text"));
        this.tbtnDateRange.setMaximumSize(new Dimension(500, 25));
        this.tbtnDateRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.tbtnDateRangeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        this.pnlTimeFilters.add((Component)this.tbtnDateRange, gridBagConstraints);
        this.btngTimeFilters.add(this.tbtnQuarter);
        Mnemonics.setLocalizedText((AbstractButton)this.tbtnQuarter, (String)NbBundle.getMessage(TimeFilterPanel.class, (String)"TimeFilterPanel.tbtnQuarter.text"));
        this.tbtnQuarter.setMaximumSize(new Dimension(500, 25));
        this.tbtnQuarter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFilterPanel.this.tbtnQuarterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.pnlTimeFilters.add((Component)this.tbtnQuarter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTimeFilters, gridBagConstraints);
    }

    private void cboMonthActionPerformed(ActionEvent evt) {
        this.filterSettingChanged();
    }

    private void cboYear_MonthActionPerformed(ActionEvent evt) {
        this.filterSettingChanged();
    }

    private void cboQuarterActionPerformed(ActionEvent evt) {
        this.filterSettingChanged();
    }

    private void cboYear_QuarterActionPerformed(ActionEvent evt) {
        this.filterSettingChanged();
    }

    private void dpTillActionPerformed(ActionEvent evt) {
        this.checkDateRange();
    }

    private void dpFromActionPerformed(ActionEvent evt) {
        this.checkDateRange();
    }

    private void tbtnTodayActionPerformed(ActionEvent evt) {
        this.changeVisibleTimeFilterPanel();
        this.filterSettingChanged();
    }

    private void tbtnMonthActionPerformed(ActionEvent evt) {
        this.changeVisibleTimeFilterPanel();
        this.filterSettingChanged();
    }

    private void tbtnDateRangeActionPerformed(ActionEvent evt) {
        this.changeVisibleTimeFilterPanel();
    }

    private void tbtnQuarterActionPerformed(ActionEvent evt) {
        this.changeVisibleTimeFilterPanel();
        this.filterSettingChanged();
    }

    private void tbtnIgnoreActionPerformed(ActionEvent evt) {
        this.changeVisibleTimeFilterPanel();
        this.filterSettingChanged();
    }

    private void changeVisibleTimeFilterPanel() {
        CardLayout cardLayout = (CardLayout)this.pnlTimeFilterCards.getLayout();
        if (this.tbtnIgnore.isSelected()) {
            cardLayout.show(this.pnlTimeFilterCards, "pnlIgnore");
        } else if (this.tbtnToday.isSelected()) {
            cardLayout.show(this.pnlTimeFilterCards, "pnlToday");
        } else if (this.tbtnMonth.isSelected()) {
            cardLayout.show(this.pnlTimeFilterCards, "pnlMonth");
        } else if (this.tbtnQuarter.isSelected()) {
            cardLayout.show(this.pnlTimeFilterCards, "pnlQuarter");
        } else if (this.tbtnDateRange.isSelected()) {
            cardLayout.show(this.pnlTimeFilterCards, "pnlDateRange");
        } else {
            LOG.warn((Object)"No toggle button, to show a time filter, is selected. This should never happen.");
        }
    }

    private void checkDateRange() {
        Date from = this.dpFrom.getDate();
        Date till = this.dpTill.getDate();
        if (from != null && till != null && from.before(till) || from.equals(till)) {
            this.filterAction.actionPerformed(null);
        }
    }

    @Override
    public Action getFilterSettingChangedAction() {
        return this.filterAction;
    }

    @Override
    public void setFilterSettingChangedAction(Action filterAction) {
        this.filterAction = filterAction;
    }

    private void setTimeRelatedModels() {
        String[] months = TimeFilterPanel.getMonthStrings();
        this.cboMonth.setModel(new DefaultComboBoxModel<String>(months));
        int currentYear = Calendar.getInstance().get(1);
        Integer[] years = new Integer[100];
        for (int i = 0; i < 100; ++i) {
            years[i] = new Integer(currentYear - i);
        }
        this.cboYear_Month.setModel(new DefaultComboBoxModel<Integer>(years));
        this.cboYear_Quarter.setModel(new DefaultComboBoxModel<Integer>(years));
    }

    private void selectCurrentDates() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int month = cal.get(2);
        this.cboMonth.setSelectedIndex(month);
        int quarter = month / 3;
        this.cboQuarter.setSelectedIndex(quarter);
    }

    private static String[] getMonthStrings() {
        int lastIndex;
        String[] months = new DateFormatSymbols().getMonths();
        if (months[lastIndex = months.length - 1] == null || months[lastIndex].length() <= 0) {
            String[] monthStrings = new String[lastIndex];
            System.arraycopy(months, 0, monthStrings, 0, lastIndex);
            return monthStrings;
        }
        return months;
    }

    public Date[] chooseDates() {
        Date from;
        Date[] fromDate_tillDate = new Date[]{null, null};
        if (this.tbtnToday.isSelected()) {
            fromDate_tillDate[0] = new Date();
        } else if (this.tbtnMonth.isSelected()) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(2, this.cboMonth.getSelectedIndex());
            calendar.set(1, (Integer)this.cboYear_Month.getSelectedItem());
            fromDate_tillDate[0] = calendar.getTime();
            calendar.add(2, 1);
            calendar.add(5, -1);
            fromDate_tillDate[1] = calendar.getTime();
        } else if (this.tbtnQuarter.isSelected()) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(2, this.cboQuarter.getSelectedIndex() * 3);
            calendar.set(1, (Integer)this.cboYear_Quarter.getSelectedItem());
            fromDate_tillDate[0] = calendar.getTime();
            calendar.add(2, 3);
            calendar.add(5, -1);
            fromDate_tillDate[1] = calendar.getTime();
        } else if (this.tbtnDateRange.isSelected() && (from = this.dpFrom.getDate()) != null) {
            fromDate_tillDate[0] = from;
            fromDate_tillDate[1] = this.dpTill.getDate();
        }
        return fromDate_tillDate;
    }

    public void filterSettingChanged() {
        if (this.filterAction != null) {
            this.filterAction.actionPerformed(null);
        }
    }
}

