/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils.billing;

import Sirius.navigator.connection.SessionManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.utils.billing.FilterSettingChangedTrigger;
import de.cismet.cids.custom.utils.billing.BillingInfo;
import de.cismet.cids.custom.utils.billing.BillingUsage;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class VerwendungszweckPanel
extends JPanel
implements FilterSettingChangedTrigger,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(VerwendungszweckPanel.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final HashMap<String, BillingUsage> USAGES = new HashMap();
    private final HashMap<JCheckBox, BillingUsage> mappingJCheckboxToUsages = new HashMap();
    private Action filterAction;
    private JPanel pnlVerwendungszweckCheckBoxes;
    private final ConnectionContext connectionContext;

    public VerwendungszweckPanel() {
        this(ConnectionContext.createDeprecated());
    }

    public VerwendungszweckPanel(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
    }

    public void initVerwendungszweckCheckBoxes(boolean filterUsages) {
        this.mappingJCheckboxToUsages.clear();
        this.pnlVerwendungszweckCheckBoxes.removeAll();
        HashSet<Object> allowedUsages = null;
        if (filterUsages) {
            try {
                allowedUsages = new HashSet<String>(Arrays.asList(BillingPopup.getAllowedUsages(SessionManager.getSession().getUser(), null, this.getConnectionContext())));
            }
            catch (Exception ex) {
                allowedUsages = new HashSet();
            }
        }
        ArrayList<JCheckBox> checkboxes = new ArrayList<JCheckBox>(USAGES.values().size());
        for (BillingUsage usage : USAGES.values()) {
            if (allowedUsages != null && !allowedUsages.contains(usage.getKey())) continue;
            JCheckBox checkBox = new JCheckBox();
            checkBox.setSelected(true);
            checkBox.setText(usage.getName());
            checkBox.setToolTipText(usage.getKey());
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean noneSelected = true;
                    for (JCheckBox cb : VerwendungszweckPanel.this.mappingJCheckboxToUsages.keySet()) {
                        if (!cb.isSelected()) continue;
                        noneSelected = false;
                        break;
                    }
                    if (noneSelected) {
                        ((JCheckBox)e.getSource()).setSelected(true);
                        String title = NbBundle.getMessage(VerwendungszweckPanel.class, (String)"VerwendungszweckPanel.initVerwendungszweckCheckBoxes().actionPerformed().dialog.title");
                        String message = NbBundle.getMessage(VerwendungszweckPanel.class, (String)"VerwendungszweckPanel.initVerwendungszweckCheckBoxes().actionPerformed().dialog.message");
                        JOptionPane.showMessageDialog(VerwendungszweckPanel.this.getTopLevelAncestor(), message, title, 1);
                    } else if (VerwendungszweckPanel.this.filterAction != null) {
                        VerwendungszweckPanel.this.filterAction.actionPerformed(null);
                    }
                }
            });
            this.mappingJCheckboxToUsages.put(checkBox, usage);
            checkboxes.add(checkBox);
        }
        final Collator deCollator = Collator.getInstance(Locale.GERMANY);
        Collections.sort(checkboxes, new Comparator<JCheckBox>(){

            @Override
            public int compare(JCheckBox o1, JCheckBox o2) {
                return deCollator.compare(o1.getText(), o2.getText());
            }
        });
        List leftCol = checkboxes.subList(0, (int)Math.ceil((float)checkboxes.size() / 2.0f));
        List rightCol = checkboxes.subList((int)Math.ceil((float)checkboxes.size() / 2.0f), checkboxes.size());
        Iterator itLeft = leftCol.iterator();
        Iterator itRight = rightCol.iterator();
        while (itLeft.hasNext()) {
            this.pnlVerwendungszweckCheckBoxes.add((Component)itLeft.next());
            if (!itRight.hasNext()) continue;
            this.pnlVerwendungszweckCheckBoxes.add((Component)itRight.next());
        }
    }

    private void initComponents() {
        this.pnlVerwendungszweckCheckBoxes = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VerwendungszweckPanel.class, (String)"VerwendungszweckPanel.border.title")));
        this.setLayout(new GridBagLayout());
        this.pnlVerwendungszweckCheckBoxes.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 3));
        this.pnlVerwendungszweckCheckBoxes.setLayout(new GridLayout(0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlVerwendungszweckCheckBoxes, gridBagConstraints);
    }

    @Override
    public Action getFilterSettingChangedAction() {
        return this.filterAction;
    }

    @Override
    public void setFilterSettingChangedAction(Action filterAction) {
        this.filterAction = filterAction;
    }

    public ArrayList<String> createSelectedVerwendungszweckKeysStringArray() {
        ArrayList<String> ret = new ArrayList<String>();
        for (JCheckBox jCheckBox : this.mappingJCheckboxToUsages.keySet()) {
            if (!jCheckBox.isSelected()) continue;
            BillingUsage usage = this.mappingJCheckboxToUsages.get(jCheckBox);
            ret.add(usage.getKey());
        }
        return ret;
    }

    public static HashMap<String, BillingUsage> getUsages() {
        return USAGES;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        try {
            BillingInfo billingInfo = (BillingInfo)MAPPER.readValue(BillingInfo.class.getResourceAsStream("/de/cismet/cids/custom/billing/billing.json"), BillingInfo.class);
            ArrayList lu = billingInfo.getUsages();
            for (BillingUsage u : lu) {
                USAGES.put(u.getKey(), u);
            }
        }
        catch (IOException ioException) {
            LOG.error((Object)"Error when trying to read the billingInfo.json", (Throwable)ioException);
        }
    }
}

