/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.ComponentRegistry;
import de.aedsicad.aaaweb.rest.model.Buchungsblatt;
import de.aedsicad.aaaweb.rest.model.Buchungsstelle;
import de.aedsicad.aaaweb.rest.model.Owner;
import de.cismet.cids.custom.clientutils.AlkisClientUtils;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.StyleListCellRenderer;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisRestUtils;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.AlkisSOAPWorkerService;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.collections.TypeSafeCollections;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AlkisEigentuemerPanel
extends JPanel
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlkisEigentuemerPanel.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final Map<String, CidsBean> gotoBeanMap;
    private RetrieveBuchungsblaetterWorker retrieveBuchungsblaetterWorker;
    private final Map<CidsBean, Buchungsblatt> buchungsblaetter;
    private boolean continueInBackground = false;
    private final boolean demoMode = StaticDebuggingTools.checkHomeForFile((String)"demoMode");
    private Map<CidsBean, Collection<CidsBean>> buchungsblaetterToFlurstuecke = new HashMap<CidsBean, Collection<CidsBean>>();
    private Listener listener;
    private JEditorPane epInhaltBuchungsblatt;
    private JLabel lblBuchungsblaetter;
    private JLabel lblEnthalteneFlurstuecke;
    private JLabel lblInhalt;
    private JList lstBuchungsblaetter;
    private JList lstBuchungsblattFlurstuecke;
    private JPanel panInhaltBuchungsblatt;
    private JScrollPane scpBuchungsblaetter;
    private JScrollPane scpBuchungsblattFlurstuecke;
    private JScrollPane scpInhaltBuchungsblatt;

    public AlkisEigentuemerPanel() {
        this.buchungsblaetter = TypeSafeCollections.newConcurrentHashMap();
        this.gotoBeanMap = TypeSafeCollections.newHashMap();
    }

    private void initComponents() {
        this.scpBuchungsblaetter = new JScrollPane();
        this.lstBuchungsblaetter = new JList();
        this.scpBuchungsblattFlurstuecke = new JScrollPane();
        this.lstBuchungsblattFlurstuecke = new JList();
        this.lblBuchungsblaetter = new JLabel();
        this.lblInhalt = new JLabel();
        this.lblEnthalteneFlurstuecke = new JLabel();
        this.panInhaltBuchungsblatt = new JPanel();
        this.scpInhaltBuchungsblatt = new JScrollPane();
        this.epInhaltBuchungsblatt = new JEditorPane();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.scpBuchungsblaetter.setMaximumSize(new Dimension(140, 200));
        this.scpBuchungsblaetter.setMinimumSize(new Dimension(140, 200));
        this.scpBuchungsblaetter.setOpaque(false);
        this.scpBuchungsblaetter.setPreferredSize(new Dimension(140, 200));
        this.lstBuchungsblaetter.setOpaque(false);
        this.lstBuchungsblaetter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlkisEigentuemerPanel.this.lstBuchungsblaetterMouseClicked(evt);
            }
        });
        this.lstBuchungsblaetter.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AlkisEigentuemerPanel.this.lstBuchungsblaetterValueChanged(evt);
            }
        });
        this.scpBuchungsblaetter.setViewportView(this.lstBuchungsblaetter);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.add((Component)this.scpBuchungsblaetter, gridBagConstraints);
        this.scpBuchungsblattFlurstuecke.setMaximumSize(new Dimension(200, 200));
        this.scpBuchungsblattFlurstuecke.setMinimumSize(new Dimension(200, 200));
        this.scpBuchungsblattFlurstuecke.setOpaque(false);
        this.scpBuchungsblattFlurstuecke.setPreferredSize(new Dimension(200, 200));
        this.lstBuchungsblattFlurstuecke.setSelectionMode(0);
        this.lstBuchungsblattFlurstuecke.setOpaque(false);
        this.scpBuchungsblattFlurstuecke.setViewportView(this.lstBuchungsblattFlurstuecke);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.add((Component)this.scpBuchungsblattFlurstuecke, gridBagConstraints);
        this.lblBuchungsblaetter.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.lblBuchungsblaetter, (String)NbBundle.getMessage(AlkisEigentuemerPanel.class, (String)"AlkisEigentuemerPanel.lblBuchungsblaetter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.lblBuchungsblaetter, gridBagConstraints);
        this.lblInhalt.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.lblInhalt, (String)NbBundle.getMessage(AlkisEigentuemerPanel.class, (String)"AlkisEigentuemerPanel.lblInhalt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.lblInhalt, gridBagConstraints);
        this.lblEnthalteneFlurstuecke.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.lblEnthalteneFlurstuecke, (String)NbBundle.getMessage(AlkisEigentuemerPanel.class, (String)"AlkisEigentuemerPanel.lblEnthalteneFlurstuecke.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.lblEnthalteneFlurstuecke, gridBagConstraints);
        this.panInhaltBuchungsblatt.setOpaque(false);
        this.panInhaltBuchungsblatt.setLayout(new BorderLayout());
        this.scpInhaltBuchungsblatt.setBorder(null);
        this.scpInhaltBuchungsblatt.setMaximumSize(new Dimension(250, 200));
        this.scpInhaltBuchungsblatt.setMinimumSize(new Dimension(250, 200));
        this.scpInhaltBuchungsblatt.setOpaque(false);
        this.scpInhaltBuchungsblatt.setPreferredSize(new Dimension(250, 200));
        this.epInhaltBuchungsblatt.setEditable(false);
        this.epInhaltBuchungsblatt.setBorder(null);
        this.epInhaltBuchungsblatt.setContentType("text/html");
        this.epInhaltBuchungsblatt.setText(NbBundle.getMessage(AlkisEigentuemerPanel.class, (String)"AlkisEigentuemerPanel.epInhaltBuchungsblatt.text"));
        this.epInhaltBuchungsblatt.setMaximumSize(new Dimension(250, 200));
        this.epInhaltBuchungsblatt.setMinimumSize(new Dimension(250, 200));
        this.epInhaltBuchungsblatt.setOpaque(false);
        this.epInhaltBuchungsblatt.setPreferredSize(new Dimension(250, 200));
        this.scpInhaltBuchungsblatt.setViewportView(this.epInhaltBuchungsblatt);
        this.panInhaltBuchungsblatt.add((Component)this.scpInhaltBuchungsblatt, "Center");
        this.scpInhaltBuchungsblatt.getViewport().setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 10, 15);
        this.add((Component)this.panInhaltBuchungsblatt, gridBagConstraints);
    }

    private void lstBuchungsblaetterMouseClicked(MouseEvent evt) {
        Object selObject;
        if (evt.getClickCount() > 1 && (selObject = this.lstBuchungsblaetter.getSelectedValue()) instanceof CidsBean) {
            CidsBean selBean = (CidsBean)selObject;
            ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(selBean.getMetaObject(), "");
        }
    }

    private void lstBuchungsblaetterValueChanged(ListSelectionEvent evt) {
        Object[] selectedObjs;
        if (!evt.getValueIsAdjusting() && (selectedObjs = this.lstBuchungsblaetter.getSelectedValues()) != null && selectedObjs.length > 0) {
            ArrayList buchungsblatter = TypeSafeCollections.newArrayList((int)selectedObjs.length);
            for (Object buchungsblatt : selectedObjs) {
                if (!(buchungsblatt instanceof CidsBean)) continue;
                buchungsblatter.add((CidsBean)buchungsblatt);
            }
            RetrieveBuchungsblaetterWorker oldWorker = this.retrieveBuchungsblaetterWorker;
            if (oldWorker != null) {
                AlkisSOAPWorkerService.cancel((Runnable)oldWorker);
            }
            this.retrieveBuchungsblaetterWorker = new RetrieveBuchungsblaetterWorker(buchungsblatter);
            AlkisSOAPWorkerService.execute((Runnable)this.retrieveBuchungsblaetterWorker);
            DefaultListModel<CidsBean> model = new DefaultListModel<CidsBean>();
            for (Object buchungsblatt : buchungsblatter) {
                for (CidsBean flurstueck : buchungsblatt.getBeanCollectionProperty("landparcels")) {
                    model.addElement(flurstueck);
                }
            }
            this.lstBuchungsblattFlurstuecke.setModel(model);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.lstBuchungsblaetter.setCellRenderer(new StyleListCellRenderer());
        this.lstBuchungsblattFlurstuecke.setCellRenderer(new StyleListCellRenderer());
        this.epInhaltBuchungsblatt.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    CidsBean blatt = (CidsBean)AlkisEigentuemerPanel.this.gotoBeanMap.get(e.getDescription());
                    if (blatt != null) {
                        AlkisEigentuemerPanel.this.continueInBackground = true;
                        ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(blatt.getMetaObject(), "");
                    } else {
                        LOG.warn((Object)"Could not find buchungsblatt bean in gotoMap");
                    }
                }
            }
        });
        StyleSheet css = ((HTMLEditorKit)this.epInhaltBuchungsblatt.getEditorKit()).getStyleSheet();
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        String tableRule = "td { padding-right : 15px; }";
        String tableHeadRule = "th { padding-right : 15px; }";
        css.addRule(bodyRule);
        css.addRule("td { padding-right : 15px; }");
        css.addRule("th { padding-right : 15px; }");
        Caret caret = this.epInhaltBuchungsblatt.getCaret();
        if (caret instanceof DefaultCaret) {
            DefaultCaret dCaret = (DefaultCaret)caret;
            dCaret.setUpdatePolicy(1);
        }
    }

    public boolean isContinueInBackground() {
        return this.continueInBackground;
    }

    public void setContinueInBackground(boolean continueInBackground) {
        this.continueInBackground = continueInBackground;
    }

    private void initGotoBeanMap(Collection<CidsBean> flurstuecke) {
        this.gotoBeanMap.clear();
        if (flurstuecke != null) {
            for (CidsBean flurstueck : flurstuecke) {
                Object buchungsblaetterCollectionObj = flurstueck.getProperty("buchungsblaetter");
                if (buchungsblaetterCollectionObj instanceof List) {
                    List blaetterList = (List)buchungsblaetterCollectionObj;
                    for (CidsBean blatt : blaetterList) {
                        this.gotoBeanMap.put(blatt.getMetaObject().getMetaClass().getID() + "::" + blatt.getMetaObject().getID(), blatt);
                    }
                } else {
                    LOG.error((Object)("Fehler bei initGotoMap. buchungsbaetter = " + buchungsblaetterCollectionObj));
                }
                Object adressenCollectionObj = flurstueck.getProperty("adressen");
                if (adressenCollectionObj instanceof List) {
                    List adressenList = (List)adressenCollectionObj;
                    for (CidsBean adresse : adressenList) {
                        this.gotoBeanMap.put(adresse.getMetaObject().getMetaClass().getID() + "::" + adresse.getMetaObject().getID(), adresse);
                    }
                    continue;
                }
                LOG.error((Object)("Fehler bei initGotoMap. adressen = " + buchungsblaetterCollectionObj));
            }
        }
    }

    public void cancelWorker() {
        AlkisSOAPWorkerService.cancel((Runnable)this.retrieveBuchungsblaetterWorker);
    }

    public Map<String, CidsBean> getGotoBeanMap() {
        return this.gotoBeanMap;
    }

    public void setFlurstuecke(Collection<CidsBean> flurstuecke) {
        this.setFlurstuecke(flurstuecke, null);
    }

    public void setFlurstuecke(Collection<CidsBean> flurstuecke, Listener listener) {
        this.listener = listener;
        this.initGotoBeanMap(flurstuecke);
        this.buchungsblaetterToFlurstuecke.clear();
        ArrayList<CidsBean> buchungsblaetter = new ArrayList<CidsBean>();
        if (flurstuecke != null) {
            for (CidsBean cidsBean : flurstuecke) {
                for (CidsBean buchungsblatt : cidsBean.getBeanCollectionProperty("buchungsblaetter")) {
                    ArrayList<CidsBean> flurstueckeBB = this.buchungsblaetterToFlurstuecke.containsKey(buchungsblatt) ? this.buchungsblaetterToFlurstuecke.get(buchungsblatt) : new ArrayList<CidsBean>();
                    this.buchungsblaetterToFlurstuecke.put(buchungsblatt, flurstueckeBB);
                    flurstueckeBB.add(cidsBean);
                }
            }
        }
        buchungsblaetter.addAll(this.buchungsblaetterToFlurstuecke.keySet());
        Collections.sort(buchungsblaetter, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean t, CidsBean t1) {
                return t.toString().compareTo(t1.toString());
            }
        });
        DefaultListModel<CidsBean> listModel = new DefaultListModel<CidsBean>();
        for (CidsBean buchungsblatt : buchungsblaetter) {
            listModel.addElement(buchungsblatt);
        }
        this.lstBuchungsblaetter.setModel(listModel);
        int n = this.lstBuchungsblaetter.getModel().getSize();
        if (n < 5) {
            this.lblBuchungsblaetter.setVisible(false);
            this.scpBuchungsblaetter.setVisible(false);
            this.lblEnthalteneFlurstuecke.setVisible(false);
            this.scpBuchungsblattFlurstuecke.setVisible(false);
            this.lblInhalt.setVisible(false);
            int[] selection = new int[n];
            for (int i = 0; i < selection.length; ++i) {
                selection[i] = i;
            }
            this.lstBuchungsblaetter.setSelectedIndices(selection);
        }
    }

    private Buchungsblatt getBuchungsblatt(CidsBean buchungsblattBean) throws Exception {
        String buchungsblattcode;
        Buchungsblatt buchungsblatt = null;
        if (buchungsblattBean != null && (buchungsblatt = this.buchungsblaetter.get(buchungsblattBean)) == null && (buchungsblattcode = String.valueOf(buchungsblattBean.getProperty("buchungsblattcode"))) != null && buchungsblattcode.length() > 5) {
            if (!this.demoMode) {
                buchungsblatt = ClientAlkisRestUtils.getBuchungsblatt(AlkisClientUtils.fixBuchungslattCode(buchungsblattcode), this.getConnectionContext());
            } else {
                Owner o = new Owner();
                o.setForeName("***");
                o.setSurName("***");
                buchungsblatt = new Buchungsblatt();
                buchungsblatt.setBlattart("****");
                buchungsblatt.setBlattartCode("****");
                buchungsblatt.setBuchungsblattCode("****");
                buchungsblatt.setBuchungsstellen(new ArrayList());
                buchungsblatt.setDescriptionOfRechtsgemeinschaft(Arrays.asList("****"));
                buchungsblatt.setId("****");
                buchungsblatt.setOffices(null);
                buchungsblatt.setOwners(Arrays.asList(o));
                buchungsblatt.setBuchungsblattCode(buchungsblattcode);
            }
            this.buchungsblaetter.put(buchungsblattBean, buchungsblatt);
        }
        return buchungsblatt;
    }

    final class RetrieveBuchungsblaetterWorker
    extends SwingWorker<String, String> {
        private static final String LOAD_TEXT = "Weitere werden geladen...";
        private final Collection<CidsBean> buchungsblaetterBeans;
        private final StringBuilder currentInfoText;
        private int current;

        public RetrieveBuchungsblaetterWorker(Collection<CidsBean> buchungsblatterBeans) {
            this.buchungsblaetterBeans = buchungsblatterBeans;
            this.currentInfoText = new StringBuilder();
            if (AlkisEigentuemerPanel.this.listener != null) {
                AlkisEigentuemerPanel.this.listener.loadingStarted();
            }
            AlkisEigentuemerPanel.this.epInhaltBuchungsblatt.setText("Wird geladen... (" + buchungsblatterBeans.size() + ")");
            this.current = 1;
        }

        @Override
        protected String doInBackground() throws Exception {
            for (CidsBean buchungsblattBean : this.buchungsblaetterBeans) {
                if (buchungsblattBean == null) continue;
                Buchungsblatt buchungsblatt = AlkisEigentuemerPanel.this.getBuchungsblatt(buchungsblattBean);
                if (buchungsblatt.getBuchungsstellen() != null) {
                    for (Buchungsstelle stelle : buchungsblatt.getBuchungsstellen()) {
                        stelle.getFraction();
                    }
                }
                this.currentInfoText.append(AlkisProducts.buchungsblattToHtml((CidsBean)((CidsBean)((Collection)AlkisEigentuemerPanel.this.buchungsblaetterToFlurstuecke.get(buchungsblattBean)).iterator().next()), (Buchungsblatt)buchungsblatt, (CidsBean)buchungsblattBean));
                if (this.isCancelled()) {
                    return this.currentInfoText.toString();
                }
                this.publish(this.currentInfoText.toString());
            }
            return this.currentInfoText.toString();
        }

        @Override
        protected void process(List<String> chunks) {
            if (!this.isCancelled()) {
                StringBuilder infos = new StringBuilder(chunks.get(chunks.size() - 1));
                infos.append(LOAD_TEXT).append(" (").append(this.current += chunks.size()).append(" / ").append(this.buchungsblaetterBeans.size()).append(")");
                AlkisEigentuemerPanel.this.epInhaltBuchungsblatt.setText("<table>" + infos.toString() + "</table>");
            }
        }

        public String toString() {
            return super.toString() + " " + this.buchungsblaetterBeans;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    if (AlkisEigentuemerPanel.this.listener != null) {
                        AlkisEigentuemerPanel.this.listener.loadingDone();
                    }
                    AlkisEigentuemerPanel.this.epInhaltBuchungsblatt.setText((String)this.get());
                }
                catch (InterruptedException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)ex, (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    AlkisEigentuemerPanel.this.epInhaltBuchungsblatt.setText("Fehler beim Empfangen.");
                    if (!AlkisEigentuemerPanel.this.demoMode) {
                        ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Empfangen", ex, AlkisEigentuemerPanel.this);
                    }
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    public static interface Listener {
        public void loadingStarted();

        public void loadingDone();
    }
}

