/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.clientutils.CachedInfoBaulastRetriever;
import de.cismet.cids.custom.clientutils.ClientBaulastBescheinigungHelper;
import de.cismet.cids.custom.objectrenderer.utils.WebAccessBaulastenPictureFinder;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisUtils;
import de.cismet.cids.custom.utils.alkis.BaulastenReportGenerator;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungBaulastInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungFlurstueckInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungGruppeInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.BaulastBescheinigungReportServerAction;
import de.cismet.cids.custom.wunda_blau.search.actions.BaulastenReportServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.BackgroundTaskMultipleDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BaulastenReportDownloadHelper {
    private static final Logger LOG = Logger.getLogger(BaulastenReportDownloadHelper.class);

    public static Download createBescheinigungReportDownload(BerechtigungspruefungBescheinigungGruppeInfo bescheinigungsGruppeInfo, String jobName, String auftragsNummer, String projectName, String fertigungsVermerk, Date fabricationdate, int number, int max, ConnectionContext connectionContext) throws Exception {
        List fls = bescheinigungsGruppeInfo.getFlurstuecke();
        boolean ua = fls.size() > 1;
        String title = "Bescheinigung " + ((BerechtigungspruefungBescheinigungFlurstueckInfo)fls.iterator().next()).getAlkisId() + (ua ? " (ua)" : "") + " " + number + "/" + max;
        String fileName = "bescheinigung_" + ((BerechtigungspruefungBescheinigungFlurstueckInfo)fls.iterator().next()).getAlkisId().replace("/", "--") + (ua ? ".ua" : "") + "_" + number;
        ServerActionParameter[] saps = new ServerActionParameter[]{new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.BESCHEINIGUNGGRUPPE_INFO.toString(), (Object)new ObjectMapper().writeValueAsString((Object)bescheinigungsGruppeInfo)), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.FABRICATION_DATE.toString(), (Object)fabricationdate.getTime()), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.FERTIGUNGS_VERMERK.toString(), (Object)fertigungsVermerk), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.JOB_NUMBER.toString(), (Object)auftragsNummer), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.PROJECT_NAME.toString(), (Object)projectName)};
        return new ByteArrayActionDownload("baulastBescheinigungReport", null, saps, title, jobName, fileName, ".pdf", connectionContext);
    }

    public static Collection<? extends Download> createAdditionalFilesDownloads(String jobname, Collection<CidsBean> baulasten, String projectname, ConnectionContext connectionContext) throws Exception {
        ArrayList<HttpDownload> downloads = new ArrayList<HttpDownload>();
        for (URL url : WebAccessBaulastenPictureFinder.getInstance().findAdditionalFiles(baulasten)) {
            String file = url.getFile().substring(url.getFile().lastIndexOf(47) + 1);
            String filename = file.substring(0, file.lastIndexOf(46));
            String extension = file.substring(file.lastIndexOf(46));
            String title = jobname;
            downloads.add(new HttpDownload(url, null, title, file, filename, extension));
        }
        return downloads;
    }

    private static Collection<Download> createTextblattPlanRasterDownloads(Collection<CidsBean> selectedBaulasten, String jobname, String jobnumber, String projectname, ConnectionContext connectionContext) throws Exception {
        ArrayList<Download> downloads = new ArrayList<Download>();
        downloads.add(BaulastenReportDownloadHelper.createReportDownload(BaulastenReportGenerator.Type.TEXTBLATT_PLAN_RASTER, selectedBaulasten, jobname, jobnumber, projectname, "Bericht aus dem Baulastenverzeichnis", connectionContext));
        downloads.addAll(BaulastenReportDownloadHelper.createAdditionalFilesDownloads(jobname, selectedBaulasten, projectname, connectionContext));
        return downloads;
    }

    public static Download createDownload(BaulastenReportGenerator.Type type, final Collection<CidsBean> selectedBaulasten, final String jobnumber, final String projectname, final ConnectionContext connectionContext) throws Exception {
        final String jobname = DownloadManagerDialog.getJobname();
        if (BaulastenReportGenerator.Type.TEXTBLATT_PLAN_RASTER.equals((Object)type)) {
            BackgroundTaskMultipleDownload.FetchDownloadsTask fetchDownloadsTask = new BackgroundTaskMultipleDownload.FetchDownloadsTask(){

                public Collection<? extends Download> fetchDownloads() throws Exception {
                    return BaulastenReportDownloadHelper.createTextblattPlanRasterDownloads(selectedBaulasten, jobname, jobnumber, projectname, connectionContext);
                }
            };
            return new BackgroundTaskMultipleDownload(null, jobname, fetchDownloadsTask);
        }
        String title = projectname;
        return BaulastenReportDownloadHelper.createReportDownload(type, selectedBaulasten, jobname, jobnumber, projectname, title, connectionContext);
    }

    public static Download createReportDownload(BaulastenReportGenerator.Type type, Collection<CidsBean> selectedBaulasten, String jobName, String jobNumber, String projectName, String title, ConnectionContext connectionContext) throws Exception {
        ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
        for (CidsBean baulastBean : selectedBaulasten) {
            mons.add(new MetaObjectNode(baulastBean));
        }
        ServerActionParameter[] saps = new ServerActionParameter[]{new ServerActionParameter(BaulastenReportServerAction.Parameter.BAULASTEN_MONS.toString(), mons), new ServerActionParameter(BaulastenReportServerAction.Parameter.FERTIGUNGS_VERMERK.toString(), (Object)AlkisUtils.createBaulastenFertigungsVermerk(SessionManager.getSession().getUser(), connectionContext)), new ServerActionParameter(BaulastenReportServerAction.Parameter.JOB_NUMBER.toString(), (Object)jobNumber), new ServerActionParameter(BaulastenReportServerAction.Parameter.PROJECT_NAME.toString(), (Object)projectName), new ServerActionParameter(BaulastenReportServerAction.Parameter.TYPE.toString(), (Object)type)};
        return new ByteArrayActionDownload("baulastenReport", null, saps, title, jobName, "baulasten", ".pdf", connectionContext);
    }

    public static Download createBescheinigungsProtokollDownload(String protocol, String jobName) {
        return new TxtDownload(protocol, jobName, "Baulastbescheinigung-Protokoll", "baulastbescheinigung_protokoll", ".txt");
    }

    public static Download createFullBescheinigungDownload(final BerechtigungspruefungBescheinigungDownloadInfo downloadInfo, String anfrageSchluessel, final ConnectionContext connectionContext) throws Exception {
        if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            return null;
        }
        final String jobname = DownloadManagerDialog.getInstance().getJobName();
        BackgroundTaskMultipleDownload.FetchDownloadsTask fetchDownloadsTask = new BackgroundTaskMultipleDownload.FetchDownloadsTask(){

            public Collection<? extends Download> fetchDownloads() throws Exception {
                ArrayList<Download> downloads = new ArrayList<Download>();
                try {
                    downloads.add(BaulastenReportDownloadHelper.createBescheinigungsProtokollDownload(downloadInfo.getProtokoll(), jobname));
                    if (downloadInfo.getBescheinigungsInfo() != null) {
                        HashSet<CidsBean> allBaulasten = new HashSet<CidsBean>();
                        int number = 0;
                        int max = downloadInfo.getBescheinigungsInfo().getBescheinigungsgruppen().size();
                        for (BerechtigungspruefungBescheinigungGruppeInfo bescheinigungsGruppe : ClientBaulastBescheinigungHelper.getSortedBescheinigungsGruppen((Collection)downloadInfo.getBescheinigungsInfo().getBescheinigungsgruppen())) {
                            downloads.add(BaulastenReportDownloadHelper.createBescheinigungReportDownload(bescheinigungsGruppe, jobname != null ? jobname : downloadInfo.getAuftragsnummer(), downloadInfo.getAuftragsnummer(), downloadInfo.getProduktbezeichnung(), downloadInfo.getFertigungsVermerk(), downloadInfo.getBescheinigungsInfo().getDatum(), ++number, max, connectionContext));
                            for (BerechtigungspruefungBescheinigungBaulastInfo baulastInfo : bescheinigungsGruppe.getBaulastenBelastet()) {
                                allBaulasten.add(CachedInfoBaulastRetriever.getInstance().loadBaulast(baulastInfo, connectionContext));
                            }
                            for (BerechtigungspruefungBescheinigungBaulastInfo baulastInfo : bescheinigungsGruppe.getBaulastenBeguenstigt()) {
                                allBaulasten.add(CachedInfoBaulastRetriever.getInstance().loadBaulast(baulastInfo, connectionContext));
                            }
                        }
                        if (!allBaulasten.isEmpty()) {
                            downloads.addAll(BaulastenReportDownloadHelper.createTextblattPlanRasterDownloads(allBaulasten, jobname, downloadInfo.getAuftragsnummer(), downloadInfo.getProduktbezeichnung(), connectionContext));
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.fatal((Object)ex, (Throwable)ex);
                }
                return downloads;
            }
        };
        return new BackgroundTaskMultipleDownload(null, jobname, fetchDownloadsTask);
    }

    private static class TxtDownload
    extends AbstractDownload {
        private final String content;

        public TxtDownload(String content, String directory, String title, String filename, String extension) {
            this.content = content;
            this.directory = directory;
            this.title = title;
            this.status = Download.State.WAITING;
            this.determineDestinationFile(filename, extension);
        }

        public void run() {
            if (this.status != Download.State.WAITING) {
                return;
            }
            this.status = Download.State.RUNNING;
            this.stateChanged();
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(this.fileToSaveTo, false));
                writer.write(this.content);
            }
            catch (Exception ex) {
                this.error(ex);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception occured while closing file.", (Throwable)e);
                    }
                }
            }
            if (this.status == Download.State.RUNNING) {
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
        }
    }
}

