/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objectrenderer.utils.BillingCalculations;
import de.cismet.cids.custom.objectrenderer.utils.BillingRestrictedReportJButton;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.billing.TimeFilterPanel;
import de.cismet.cids.custom.objectrenderer.utils.billing.VerwendungszweckPanel;
import de.cismet.cids.custom.objectrenderer.wunda_blau.BillingKundeRenderer;
import de.cismet.cids.custom.reports.wunda_blau.PrintBillingReportForCustomer;
import de.cismet.cids.custom.reports.wunda_blau.PrintStatisticsReport;
import de.cismet.cids.custom.wunda_blau.search.server.CidsBillingSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.TitleComponentProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BillingKundeAggregationRenderer
extends JPanel
implements RequestsFullSizeComponent,
CidsBeanAggregationRenderer,
TitleComponentProvider,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BillingKundeAggregationRenderer.class);
    private static final String[] AGR_COMLUMN_NAMES = new String[]{"Auswahl f\u00fcr Berichte", "Kundenname", "aggregierter Preis (brutto)", "kostenpflichtige Downloads"};
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private SwingWorker<List<CidsBean>, Integer> worker;
    private Collection<CidsBean> cidsBeans = null;
    private Collection<Object[]> tableData;
    private List<CidsBean> filteredBillingBeans;
    private Date[] fromDate_tillDate;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JXBusyLabel blblBusy;
    private JButton btnBuchungsbeleg;
    private JButton btnGeschaeftsstatistik;
    private JButton btnRechnungsanlage;
    private JButton btnShowResults;
    private JCheckBox cboAbgerechnet;
    private JCheckBox cboHideFreeDownloadsBuchungsbeleg;
    private JCheckBox cboHideFreeDownloadsRechnungsanlage;
    private JCheckBox cboKostenfrei;
    private JCheckBox cboKostenpflichtig;
    private JCheckBox cboNichtAbgerechnet;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JLabel lblAgrTitle;
    private JLabel lblFilterResult;
    private JLabel lblResultHeader;
    private JPanel panTitle;
    private JPanel panTitleString;
    private JPanel pnlBusyLable;
    private JPanel pnlFilterResults;
    private JPanel pnlFilters;
    private JPanel pnlTable;
    private TimeFilterPanel pnlTimeFilters;
    private VerwendungszweckPanel pnlVerwendungszweck;
    private SemiRoundedPanel smiplFilter;
    private SemiRoundedPanel smiplTable;
    private JTable tblCustomers;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.setFilterActionInExternalPanels();
        AggregatedBillingTableModel tableModel = new AggregatedBillingTableModel((Object[][])new Object[0][], AGR_COMLUMN_NAMES);
        this.tblCustomers.setModel(tableModel);
        if (!ObjectRendererUtils.checkActionTag("custom.billing.reports@WUNDA_BLAU", this.getConnectionContext())) {
            this.btnRechnungsanlage.setEnabled(false);
            this.cboHideFreeDownloadsRechnungsanlage.setEnabled(false);
            this.btnGeschaeftsstatistik.setEnabled(false);
            this.cboAbgerechnet.setVisible(false);
        }
    }

    private void initComponents() {
        this.panTitle = new JPanel();
        this.panTitleString = new JPanel();
        this.lblAgrTitle = new JLabel();
        this.smiplFilter = new SemiRoundedPanel();
        this.jLabel2 = new JLabel();
        this.smiplTable = new SemiRoundedPanel();
        this.lblResultHeader = new JLabel();
        this.pnlFilters = new JPanel();
        this.jPanel8 = new JPanel();
        this.btnShowResults = new JButton();
        this.pnlVerwendungszweck = new VerwendungszweckPanel();
        this.jPanel1 = new JPanel();
        this.pnlTimeFilters = new TimeFilterPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.cboAbgerechnet = new JCheckBox();
        this.cboNichtAbgerechnet = new JCheckBox();
        this.cboKostenpflichtig = new JCheckBox();
        this.cboKostenfrei = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.cboHideFreeDownloadsBuchungsbeleg = new JCheckBox();
        this.cboHideFreeDownloadsRechnungsanlage = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.btnRechnungsanlage = new BillingRestrictedReportJButton(this.getConnectionContext());
        this.btnBuchungsbeleg = new JButton();
        this.btnGeschaeftsstatistik = new BillingRestrictedReportJButton(this.getConnectionContext());
        this.jPanel7 = new JPanel();
        this.lblFilterResult = new JLabel();
        this.pnlTable = new JPanel();
        this.pnlFilterResults = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblCustomers = new JTable();
        this.pnlBusyLable = new JPanel();
        this.blblBusy = new JXBusyLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButton1 = new JButton();
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new BorderLayout());
        this.panTitleString.setOpaque(false);
        this.panTitleString.setLayout(new GridBagLayout());
        this.lblAgrTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblAgrTitle.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblAgrTitle, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.lblAgrTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panTitleString.add((Component)this.lblAgrTitle, gridBagConstraints);
        this.panTitle.add((Component)this.panTitleString, "Center");
        this.setLayout(new GridBagLayout());
        this.smiplFilter.setBackground(new Color(51, 51, 51));
        this.smiplFilter.setLayout((LayoutManager)new FlowLayout());
        this.jLabel2.setBackground(new Color(255, 255, 255));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.jLabel2.text"));
        this.smiplFilter.add((Component)this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.smiplFilter, gridBagConstraints);
        this.smiplTable.setBackground(new Color(51, 51, 51));
        this.smiplTable.setLayout((LayoutManager)new FlowLayout());
        this.lblResultHeader.setBackground(new Color(51, 51, 51));
        this.lblResultHeader.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblResultHeader, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.lblResultHeader.text"));
        this.smiplTable.add((Component)this.lblResultHeader);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.smiplTable, gridBagConstraints);
        this.pnlFilters.setLayout(new GridBagLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowResults, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnShowResults.text"));
        this.btnShowResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.btnShowResultsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 2);
        this.jPanel8.add((Component)this.btnShowResults, gridBagConstraints);
        this.pnlVerwendungszweck.initVerwendungszweckCheckBoxes(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel8.add((Component)this.pnlVerwendungszweck, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.pnlTimeFilters, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.jPanel3.border.title")));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridLayout(2, 2));
        this.cboAbgerechnet.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboAbgerechnet, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.cboAbgerechnet.text"));
        this.cboAbgerechnet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.cboAbgerechnetActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cboAbgerechnet);
        this.cboNichtAbgerechnet.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboNichtAbgerechnet, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.cboNichtAbgerechnet.text"));
        this.cboNichtAbgerechnet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.cboNichtAbgerechnetActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cboNichtAbgerechnet);
        this.cboKostenpflichtig.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboKostenpflichtig, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.cboKostenpflichtig.text"));
        this.cboKostenpflichtig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.cboKostenpflichtigActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cboKostenpflichtig);
        this.cboKostenfrei.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboKostenfrei, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.cboKostenfrei.text"));
        this.cboKostenfrei.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.cboKostenfreiActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cboKostenfrei);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 0, 2);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.jPanel3.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel8.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilters.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlFilters, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridLayout(2, 3, 10, 0));
        this.cboHideFreeDownloadsBuchungsbeleg.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboHideFreeDownloadsBuchungsbeleg, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.cboHideFreeDownloadsBuchungsbeleg.text"));
        this.jPanel2.add(this.cboHideFreeDownloadsBuchungsbeleg);
        this.cboHideFreeDownloadsRechnungsanlage.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cboHideFreeDownloadsRechnungsanlage, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.cboHideFreeDownloadsRechnungsanlage.text"));
        this.jPanel2.add(this.cboHideFreeDownloadsRechnungsanlage);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.jLabel1.text"));
        this.jPanel2.add(this.jLabel1);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRechnungsanlage, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnRechnungsanlage.text"));
        this.btnRechnungsanlage.setEnabled(false);
        this.btnRechnungsanlage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.btnRechnungsanlageActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnRechnungsanlage);
        Mnemonics.setLocalizedText((AbstractButton)this.btnBuchungsbeleg, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnBuchungsbeleg.text"));
        this.btnBuchungsbeleg.setEnabled(false);
        this.btnBuchungsbeleg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.btnBuchungsbelegActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnBuchungsbeleg);
        Mnemonics.setLocalizedText((AbstractButton)this.btnGeschaeftsstatistik, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnGeschaeftsstatistik.text"));
        this.btnGeschaeftsstatistik.setEnabled(false);
        this.btnGeschaeftsstatistik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.btnGeschaeftsstatistikActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnGeschaeftsstatistik);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblFilterResult, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.lblFilterResult.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 7, 5, 7);
        this.jPanel7.add((Component)this.lblFilterResult, gridBagConstraints);
        this.pnlTable.setLayout(new CardLayout());
        this.pnlFilterResults.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(453, 275));
        this.tblCustomers.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblCustomers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BillingKundeAggregationRenderer.this.tblCustomersMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BillingKundeAggregationRenderer.this.tblCustomersMouseExited(evt);
            }
        });
        this.tblCustomers.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                BillingKundeAggregationRenderer.this.tblCustomersMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblCustomers);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlFilterResults.add((Component)this.jScrollPane1, gridBagConstraints);
        this.pnlTable.add((Component)this.pnlFilterResults, "table");
        this.pnlBusyLable.setLayout(new GridBagLayout());
        this.blblBusy.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.blblBusy, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.blblBusy.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlBusyLable.add((Component)this.blblBusy, gridBagConstraints);
        this.jProgressBar1.setString(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.jProgressBar1.string"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlBusyLable.add((Component)this.jProgressBar1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BillingKundeAggregationRenderer.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.pnlBusyLable.add((Component)this.jButton1, gridBagConstraints);
        this.pnlTable.add((Component)this.pnlBusyLable, "busy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 7, 5, 7);
        this.jPanel7.add((Component)this.pnlTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel7, gridBagConstraints);
    }

    private void tblCustomersMouseClicked(MouseEvent evt) {
    }

    private void tblCustomersMouseExited(MouseEvent evt) {
    }

    private void tblCustomersMouseMoved(MouseEvent evt) {
    }

    private void btnShowResultsActionPerformed(ActionEvent evt) {
        this.btnBuchungsbeleg.setEnabled(true);
        this.btnRechnungsanlage.setEnabled(true);
        this.btnGeschaeftsstatistik.setEnabled(true);
        this.filterBuchungen();
    }

    private void btnBuchungsbelegActionPerformed(ActionEvent evt) {
        HashMap<CidsBean, Collection<CidsBean>> billingsOfCustomers = this.createBillingsOfCostumersForReports(evt);
        Set<CidsBean> customers = billingsOfCustomers.keySet();
        if (customers.isEmpty()) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnBuchungsbelegActionPerformed().dialog.message"), NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnBuchungsbelegActionPerformed().dialog.title"), 0);
        } else {
            for (CidsBean kundeBean : customers) {
                new PrintBillingReportForCustomer(kundeBean, this.getSortedBillingBeans(billingsOfCustomers.get(kundeBean)), this.fromDate_tillDate, false, this, this.retrieveShowBillingWithoutCostInReport(evt), new PrintBillingReportForCustomer.BillingDoneListener(){

                    @Override
                    public void billingDone(boolean isDone) {
                        BillingKundeAggregationRenderer.this.filterBuchungen();
                    }
                }, this.getConnectionContext()).print();
            }
        }
    }

    private List<CidsBean> getSortedBillingBeans(Collection<CidsBean> billingBeans) {
        ArrayList<CidsBean> sortedFilteredBuchungen = new ArrayList<CidsBean>(billingBeans);
        Collections.sort(sortedFilteredBuchungen, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                Date d1 = (Date)o1.getProperty("ts");
                Date d2 = (Date)o2.getProperty("ts");
                if (d1 != null && d2 != null) {
                    return d1.compareTo(d2);
                }
                if (d1 == null && d2 != null) {
                    return -1;
                }
                if (d2 == null && d1 != null) {
                    return 1;
                }
                return 0;
            }
        });
        return sortedFilteredBuchungen;
    }

    private void btnRechnungsanlageActionPerformed(ActionEvent evt) {
        HashMap<CidsBean, Collection<CidsBean>> billingsOfCustomers = this.createBillingsOfCostumersForReports(evt);
        Set<CidsBean> customers = billingsOfCustomers.keySet();
        if (customers.isEmpty()) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnBuchungsbelegActionPerformed().dialog.message"), NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnBuchungsbelegActionPerformed().dialog.title"), 0);
        } else {
            for (CidsBean kundeBean : customers) {
                PrintBillingReportForCustomer printBillingReportForCustomer = new PrintBillingReportForCustomer(kundeBean, this.getSortedBillingBeans(billingsOfCustomers.get(kundeBean)), this.fromDate_tillDate, true, this, this.retrieveShowBillingWithoutCostInReport(evt), null, this.getConnectionContext());
                printBillingReportForCustomer.setDownloadFinishedObserver(new PrintBillingReportForCustomer.DownloadFinishedObserver(printBillingReportForCustomer){

                    @Override
                    public void additionalFunctionalityIfDownloadCompleted() {
                        BillingKundeAggregationRenderer.this.filterBuchungen();
                    }
                });
                printBillingReportForCustomer.print();
            }
        }
    }

    private void btnGeschaeftsstatistikActionPerformed(ActionEvent evt) {
        Collection<CidsBean> billings = this.createBillingsForStatisticsReport();
        if (billings.isEmpty()) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnGeschaeftsstatistikActionPerformed().dialog.message"), NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.btnGeschaeftsstatistikActionPerformed().dialog.title"), 0);
        } else {
            new PrintStatisticsReport(this.fromDate_tillDate, billings, this.getConnectionContext()).print();
        }
    }

    private void cboKostenfreiActionPerformed(ActionEvent evt) {
        if (!this.cboKostenfrei.isSelected() && !this.cboKostenpflichtig.isSelected()) {
            this.cboKostenpflichtig.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void cboAbgerechnetActionPerformed(ActionEvent evt) {
        if (!this.cboAbgerechnet.isSelected() && !this.cboNichtAbgerechnet.isSelected()) {
            this.cboAbgerechnet.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void cboNichtAbgerechnetActionPerformed(ActionEvent evt) {
        if (!this.cboAbgerechnet.isSelected() && !this.cboNichtAbgerechnet.isSelected()) {
            this.cboAbgerechnet.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void cboKostenpflichtigActionPerformed(ActionEvent evt) {
        if (!this.cboKostenfrei.isSelected() && !this.cboKostenpflichtig.isSelected()) {
            this.cboKostenfrei.setSelected(true);
        }
        this.filterSettingsChanged();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
    }

    private void setFilterActionInExternalPanels() {
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillingKundeAggregationRenderer.this.filterSettingsChanged();
            }
        };
        this.pnlTimeFilters.setFilterSettingChangedAction(filterAction);
        this.pnlVerwendungszweck.setFilterSettingChangedAction(filterAction);
    }

    private void filterSettingsChanged() {
        Mnemonics.setLocalizedText((JLabel)this.lblResultHeader, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.lblResultHeader.text.filterSettingsChanged"));
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public void setCidsBeans(Collection<CidsBean> cidsBeans) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.cidsBeans = cidsBeans;
        this.setTitle(null);
    }

    private void filterBuchungen() {
        Mnemonics.setLocalizedText((JLabel)this.lblResultHeader, (String)NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.lblResultHeader.text.updated"));
        ArrayList<MetaObject> kundenMetaObjects = new ArrayList<MetaObject>();
        for (CidsBean kundeBean : this.cidsBeans) {
            kundenMetaObjects.add(kundeBean.getMetaObject());
        }
        final CidsBillingSearchStatement cidsBillingSearchStatement = new CidsBillingSearchStatement(kundenMetaObjects);
        cidsBillingSearchStatement.setVerwendungszweckKeys(this.pnlVerwendungszweck.createSelectedVerwendungszweckKeysStringArray());
        this.fromDate_tillDate = this.pnlTimeFilters.chooseDates();
        cidsBillingSearchStatement.setFrom(this.fromDate_tillDate[0]);
        cidsBillingSearchStatement.setTill(this.fromDate_tillDate[1]);
        if (this.cboKostenfrei.isSelected() && this.cboKostenpflichtig.isSelected()) {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.IGNORIEREN);
        } else if (this.cboKostenfrei.isSelected()) {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.KOSTENFREI);
        } else if (this.cboKostenpflichtig.isSelected()) {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.KOSTENPFLICHTIG);
        } else {
            cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.IGNORIEREN);
        }
        if (this.cboAbgerechnet.isSelected() && this.cboNichtAbgerechnet.isSelected()) {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(null);
        } else if (this.cboAbgerechnet.isSelected()) {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(Boolean.valueOf(true));
        } else if (this.cboNichtAbgerechnet.isSelected()) {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(Boolean.valueOf(false));
        } else {
            cidsBillingSearchStatement.setShowAbgerechneteBillings(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Query to get the billings: " + cidsBillingSearchStatement.generateQuery()));
        }
        this.blblBusy.setBusy(true);
        ((CardLayout)this.pnlTable.getLayout()).show(this.pnlTable, "busy");
        this.btnBuchungsbeleg.setEnabled(false);
        this.btnRechnungsanlage.setEnabled(false);
        this.btnShowResults.setEnabled(false);
        this.btnGeschaeftsstatistik.setEnabled(false);
        this.jProgressBar1.setString(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.jProgressBar1.string"));
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setStringPainted(true);
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<List<CidsBean>, Integer>(){

            @Override
            protected List<CidsBean> doInBackground() throws Exception {
                ArrayList<CidsBean> beans;
                Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)cidsBillingSearchStatement, BillingKundeAggregationRenderer.this.getConnectionContext());
                this.publish(mons.size());
                if (mons != null) {
                    beans = new ArrayList<CidsBean>(mons.size());
                    for (MetaObjectNode mon : mons) {
                        if (!this.isCancelled()) {
                            if (mon == null) continue;
                            this.publish(beans.size() + 1);
                            MetaObject mo = SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain(), BillingKundeAggregationRenderer.this.getConnectionContext());
                            CidsBean bean = mo != null ? mo.getBean() : null;
                            beans.add(bean);
                            continue;
                        }
                        break;
                    }
                } else {
                    beans = null;
                }
                return beans;
            }

            @Override
            protected void process(List<Integer> chunks) {
                for (Integer chunk : chunks) {
                    if (BillingKundeAggregationRenderer.this.jProgressBar1.isIndeterminate()) {
                        BillingKundeAggregationRenderer.this.jProgressBar1.setIndeterminate(false);
                        BillingKundeAggregationRenderer.this.jProgressBar1.setMaximum(chunk);
                        BillingKundeAggregationRenderer.this.jProgressBar1.setValue(0);
                        continue;
                    }
                    String string = "Lade Buchung " + chunk + " von " + BillingKundeAggregationRenderer.this.jProgressBar1.getMaximum();
                    BillingKundeAggregationRenderer.this.jProgressBar1.setValue(chunk);
                    BillingKundeAggregationRenderer.this.jProgressBar1.setString(string);
                }
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        List billingBeans = (List)this.get();
                        if (billingBeans == null) {
                            LOG.error((Object)"Billing metaobjects was null.");
                        } else if (billingBeans.isEmpty()) {
                            LOG.info((Object)"No Billing metaobjects found.");
                            BillingKundeAggregationRenderer.this.filteredBillingBeans = new ArrayList();
                            BillingKundeAggregationRenderer.this.fillCustomerTable(BillingKundeAggregationRenderer.this.filteredBillingBeans);
                            BillingKundeAggregationRenderer.this.lblFilterResult.setText(BillingKundeAggregationRenderer.this.generateFilterResultText(new ArrayList()));
                        } else {
                            BillingKundeAggregationRenderer.this.fillCustomerTable(billingBeans);
                            BillingKundeAggregationRenderer.this.filteredBillingBeans = billingBeans;
                            BillingKundeAggregationRenderer.this.lblFilterResult.setText(BillingKundeAggregationRenderer.this.generateFilterResultText(billingBeans));
                        }
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Error while filtering the billings.", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)"Error while filtering the billings.", (Throwable)ex);
                }
                finally {
                    ((CardLayout)BillingKundeAggregationRenderer.this.pnlTable.getLayout()).show(BillingKundeAggregationRenderer.this.pnlTable, "table");
                    BillingKundeAggregationRenderer.this.btnBuchungsbeleg.setEnabled(true);
                    BillingKundeAggregationRenderer.this.btnRechnungsanlage.setEnabled(true);
                    BillingKundeAggregationRenderer.this.btnShowResults.setEnabled(true);
                    BillingKundeAggregationRenderer.this.btnGeschaeftsstatistik.setEnabled(true);
                    BillingKundeAggregationRenderer.this.blblBusy.setBusy(false);
                    BillingKundeAggregationRenderer.this.jProgressBar1.setMaximum(0);
                    BillingKundeAggregationRenderer.this.jProgressBar1.setValue(0);
                    BillingKundeAggregationRenderer.this.jProgressBar1.setStringPainted(false);
                    BillingKundeAggregationRenderer.this.jProgressBar1.setIndeterminate(false);
                }
            }
        };
        this.worker.execute();
    }

    private String generateFilterResultText(Collection<CidsBean> billingBeans) {
        StringBuilder text = new StringBuilder();
        if (billingBeans.isEmpty()) {
            text.append(NbBundle.getMessage(BillingKundeRenderer.class, (String)"BillingKundeRenderer.generateFilterResultText().noBillings"));
        } else {
            this.fromDate_tillDate = this.pnlTimeFilters.chooseDates();
            Date from = this.fromDate_tillDate[0];
            Date till = this.fromDate_tillDate[1];
            text.append(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.generateFilterResultText().billings1"));
            if (from == null) {
                text.append(".");
            } else if (till == null || from.equals(till)) {
                text.append(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.generateFilterResultText().billings2.oneDate"));
                text.append(DATE_FORMAT.format(from));
                text.append(".");
            } else {
                text.append(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.generateFilterResultText().billings2.twoDates1"));
                text.append(DATE_FORMAT.format(from));
                text.append(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.generateFilterResultText().billings2.twoDates2"));
                text.append(DATE_FORMAT.format(till));
                text.append(".");
            }
        }
        if (this.cboNichtAbgerechnet.isSelected()) {
            text.append(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.generateFilterResultText().suffix.hideAbgerechnteAndStornierte"));
        } else {
            text.append(NbBundle.getMessage(BillingKundeAggregationRenderer.class, (String)"BillingKundeAggregationRenderer.generateFilterResultText().suffix.hideStornierte"));
        }
        return text.toString();
    }

    private void fillCustomerTable(Collection<CidsBean> billingBeans) {
        HashMap<CidsBean, Object[]> aggregatedData = this.aggregateData(billingBeans);
        this.tableData = aggregatedData.values();
        AggregatedBillingTableModel tableModel = new AggregatedBillingTableModel((Object[][])this.tableData.toArray((T[])new Object[this.tableData.size()][]), AGR_COMLUMN_NAMES);
        this.tblCustomers.setModel(tableModel);
        this.tblCustomers.getColumnModel().getColumn(2).setCellRenderer(new EuroFormatterRenderer());
        if (!this.tableData.isEmpty()) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tblCustomers.getModel());
            this.tblCustomers.setRowSorter(sorter);
        } else {
            this.tblCustomers.setRowSorter(null);
        }
    }

    private HashMap<CidsBean, Object[]> aggregateData(Collection<CidsBean> billingBeans) {
        HashMap<CidsBean, Object[]> aggregatedData = new HashMap<CidsBean, Object[]>();
        HashMap billingsOfCustomers = new HashMap();
        for (CidsBean billingBean : billingBeans) {
            int amountOfBillingsWithCosts;
            CidsBean kundeBean = (CidsBean)billingBean.getProperty("angelegt_durch.kunde");
            double netto_sum = (Double)billingBean.getProperty("netto_summe");
            if (aggregatedData.containsKey(kundeBean)) {
                Object[] dataForCustomer = aggregatedData.get(kundeBean);
                if (netto_sum > 0.0) {
                    amountOfBillingsWithCosts = (Integer)dataForCustomer[3];
                    dataForCustomer[3] = amountOfBillingsWithCosts + 1;
                }
            } else {
                Boolean useInReports = Boolean.TRUE;
                amountOfBillingsWithCosts = 0;
                if (netto_sum > 0.0) {
                    amountOfBillingsWithCosts = 1;
                }
                Object[] dataForCustomer = new Object[]{useInReports, kundeBean, null, amountOfBillingsWithCosts};
                aggregatedData.put(kundeBean, dataForCustomer);
            }
            if (billingsOfCustomers.containsKey(kundeBean)) {
                ((Collection)billingsOfCustomers.get(kundeBean)).add(billingBean);
                continue;
            }
            ArrayList<CidsBean> list = new ArrayList<CidsBean>();
            list.add(billingBean);
            billingsOfCustomers.put(kundeBean, list);
        }
        for (CidsBean kundeBean : billingsOfCustomers.keySet()) {
            BigDecimal brutto_sum = BillingCalculations.calculateBruttoSumFromBillings((Collection)billingsOfCustomers.get(kundeBean));
            Object[] dataForCustomer = aggregatedData.get(kundeBean);
            dataForCustomer[2] = brutto_sum;
        }
        return aggregatedData;
    }

    private HashMap<CidsBean, Collection<CidsBean>> createBillingsOfCostumersForReports(ActionEvent evt) {
        HashMap<CidsBean, Collection<CidsBean>> billingsOfCustomers = new HashMap<CidsBean, Collection<CidsBean>>();
        for (CidsBean billingBean : this.filteredBillingBeans) {
            CidsBean kundeBean = (CidsBean)billingBean.getProperty("angelegt_durch.kunde");
            if (!this.isCustomerSelectedToBeIncludedIntoReport(kundeBean)) continue;
            if (billingsOfCustomers.containsKey(kundeBean)) {
                billingsOfCustomers.get(kundeBean).add(billingBean);
                continue;
            }
            ArrayList<CidsBean> billings = new ArrayList<CidsBean>();
            billings.add(billingBean);
            billingsOfCustomers.put(kundeBean, billings);
        }
        return billingsOfCustomers;
    }

    private boolean retrieveShowBillingWithoutCostInReport(ActionEvent evt) {
        JButton source = (JButton)evt.getSource();
        if (source.equals(this.btnBuchungsbeleg)) {
            return !this.cboHideFreeDownloadsBuchungsbeleg.isSelected();
        }
        if (source.equals(this.btnRechnungsanlage)) {
            return !this.cboHideFreeDownloadsRechnungsanlage.isSelected();
        }
        return false;
    }

    private Collection<CidsBean> createBillingsForStatisticsReport() {
        ArrayList<CidsBean> billlings = new ArrayList<CidsBean>();
        for (CidsBean billingBean : this.filteredBillingBeans) {
            CidsBean kundeBean = (CidsBean)billingBean.getProperty("angelegt_durch.kunde");
            if (!this.isCustomerSelectedToBeIncludedIntoReport(kundeBean)) continue;
            billlings.add(billingBean);
        }
        return billlings;
    }

    private boolean isCustomerSelectedToBeIncludedIntoReport(CidsBean kundeBean) {
        AggregatedBillingTableModel model = (AggregatedBillingTableModel)this.tblCustomers.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            CidsBean kundeFromTable = (CidsBean)model.getValueAt(i, 1);
            if (!kundeFromTable.equals((Object)kundeBean)) continue;
            return (Boolean)model.getValueAt(i, 0);
        }
        return false;
    }

    public void dispose() {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
    }

    public String getTitle() {
        return this.lblAgrTitle.getText();
    }

    public void setTitle(String title) {
        String desc = "Kundenaggregationsrenderer: ";
        Collection<CidsBean> beans = this.cidsBeans;
        if (beans != null && beans.size() > 0) {
            desc = desc + beans.size() + " Kunden ausgew\u00e4hlt";
        }
        this.lblAgrTitle.setText(desc);
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JLabel getTitleLabel() {
        return this.lblAgrTitle;
    }

    public static void main(String[] args) {
        try {
            CidsBean[] beans = DevelopmentTools.createCidsBeansFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"kif", (String)"billing_kunde", (int)60);
            DevelopmentTools.createAggregationRendererInFrameFromRMIConnectionOnLocalhost(Arrays.asList(beans), (String)"Ausgew\u00e4hlte Kunden", (int)1024, (int)800);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private class EuroFormatterRenderer
    extends DefaultTableCellRenderer {
        private NumberFormat euroFormatter = NumberFormat.getCurrencyInstance(Locale.GERMANY);

        public EuroFormatterRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            if (value == null || !(value instanceof Number)) {
                this.setText(ObjectRendererUtils.propertyPrettyPrint(value));
            } else {
                this.setText(this.euroFormatter.format(value));
            }
        }
    }

    static final class AggregatedBillingTableModel
    extends DefaultTableModel {
        public AggregatedBillingTableModel(Object[][] data, String[] labels) {
            super(data, labels);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public Class getColumnClass(int column) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object o = this.getValueAt(row, column);
                if (o == null) continue;
                return o.getClass();
            }
            return Object.class;
        }
    }
}

