/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class FilenameToIconConverter
extends Converter<String, Icon> {
    private static final Logger log = Logger.getLogger(FilenameToIconConverter.class);
    private final String prefix;
    private final String postfix;

    public FilenameToIconConverter() {
        this.postfix = "";
        this.prefix = "";
    }

    public FilenameToIconConverter(String prefix, String postfix) {
        this.prefix = prefix;
        this.postfix = postfix;
    }

    public Icon convertForward(String in) {
        in = this.prefix + in + this.postfix;
        log.fatal((Object)("converting: " + in));
        try {
            URL symbolURL = Object.class.getResource(in);
            if (symbolURL == null) {
                symbolURL = new URL(in);
            }
            if (symbolURL != null) {
                log.fatal((Object)("returning: " + new ImageIcon(symbolURL)));
                return new ImageIcon(symbolURL);
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
        return null;
    }

    public String convertReverse(Icon value) {
        return "";
    }
}

