/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.localserver.attribute.MemberAttributeInfo;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.wunda_blau.MauerObjectsPermissionsProviderDialog;
import de.cismet.cids.custom.reports.wunda_blau.MauernReportGenerator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.search.CidsBeansTableActionPanel;
import de.cismet.cids.search.QuerySearchResultsAction;
import de.cismet.cids.server.actions.CsvExportServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MauerAggregationRenderer
extends JPanel
implements CidsBeanAggregationRenderer,
RequestsFullSizeComponent,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(MauerAggregationRenderer.class);
    private static final int COLUMNS = 4;
    private static final Color[] COLORS = new Color[]{new Color(247, 150, 70, 192), new Color(155, 187, 89, 192), new Color(128, 100, 162, 192), new Color(75, 172, 198, 192), new Color(192, 80, 77, 192)};
    private Collection<CidsBean> cidsBeans;
    private List<CidsBeanWrapper> cidsBeanWrappers;
    private CidsBeanWrapper selectedCidsBeanWrapper;
    private MauerTableModel tableModel;
    private MappingComponent map;
    private final Collection<Feature> pointFeatures = new LinkedList<Feature>();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final QuerySearchResultsAction csvAction = new QuerySearchResultsAction(){

        public String getName() {
            return "nach CSV exportieren";
        }

        public void doAction() {
            String title = MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getMetaClass().getName();
            if (DownloadManagerDialog.showAskingForUserTitle((Frame)StaticSwingTools.getParentFrame((Component)MauerAggregationRenderer.this))) {
                ArrayList columnNames = new ArrayList(MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getAttributeNames().size());
                ArrayList<String> fields = new ArrayList<String>(MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getAttributeNames().size());
                List keys = MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getKeys();
                if (keys != null) {
                    for (Object attrKey : keys) {
                        MemberAttributeInfo mai = (MemberAttributeInfo)MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getMetaClass().getMemberAttributeInfos().get(attrKey);
                        columnNames.add(MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getAttributeNames().get(attrKey));
                        fields.add(mai.getFieldName());
                    }
                }
                ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
                for (CidsBean cidsBean : MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getCidsBeans()) {
                    mons.add(new MetaObjectNode(cidsBean));
                }
                ServerActionParameter[] params = new ServerActionParameter[]{new ServerActionParameter(CsvExportServerAction.ParameterType.COLUMN_NAMES.toString(), columnNames), new ServerActionParameter(CsvExportServerAction.ParameterType.FIELDS.toString(), fields), new ServerActionParameter(CsvExportServerAction.ParameterType.MONS.toString(), mons), new ServerActionParameter(CsvExportServerAction.ParameterType.DATE_FORMAT.toString(), (Object)"dd.MM.yy"), new ServerActionParameter(CsvExportServerAction.ParameterType.BOOLEAN_YES.toString(), (Object)"ja"), new ServerActionParameter(CsvExportServerAction.ParameterType.BOOLEAN_NO.toString(), (Object)"nein"), new ServerActionParameter(CsvExportServerAction.ParameterType.DISTINCT_ON.toString(), (Object)"id"), new ServerActionParameter(CsvExportServerAction.ParameterType.CHARSET.toString(), (Object)"LATIN9"), new ServerActionParameter(CsvExportServerAction.ParameterType.ESCAPE_STRINGS.toString(), (Object)Boolean.TRUE), new ServerActionParameter(CsvExportServerAction.ParameterType.LOCALE.toString(), (Object)Locale.GERMAN.toLanguageTag())};
                DownloadManager.instance().add((Download)new ByteArrayActionDownload("WUNDA_BLAU", "CsvExport", (Object)MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getMetaClass().getTableName(), params, title, DownloadManagerDialog.getInstance().getJobName(), title, ".csv", ConnectionContext.createDeprecated()));
                DownloadManagerDialog downloadManagerDialog = DownloadManagerDialog.getInstance();
                StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)MauerAggregationRenderer.this), (JDialog)downloadManagerDialog, (boolean)true);
            }
        }
    };
    private CidsBeansTableActionPanel cidsBeansTableActionPanel1;
    private JDialog jDialog1;
    private JLabel jLabel1;
    private JLayeredPane jLayeredPane1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JXHyperlink jxlHauptinfo;
    private JXHyperlink jxlKatasterblatt;
    private JXHyperlink jxlKatasterblatt1;
    private JLabel lblHeaderMauern;
    private JLabel lblheaderProdutke;
    private JLabel lblheaderProdutke1;
    private SemiRoundedPanel pnlHeaderMauern;
    private SemiRoundedPanel pnlHeaderProducts;
    private SemiRoundedPanel pnlHeaderProducts1;
    private JPanel pnlMap;
    private RoundedPanel pnlMauern;
    private RoundedPanel pnlProducts;
    private RoundedPanel pnlProducts1;
    private JScrollPane scpMauern;
    private JTable tblMauern;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.tableModel = new MauerTableModel();
        this.initComponents();
        this.map = new MappingComponent();
        this.pnlMap.setLayout(new BorderLayout());
        this.pnlMap.add((Component)this.map, "Center");
        this.tblMauern.setDefaultRenderer(Color.class, new ColorRenderer());
        this.tblMauern.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    MauerAggregationRenderer.this.selectedCidsBeanWrapper = null;
                } else {
                    MauerAggregationRenderer.this.selectedCidsBeanWrapper = MauerAggregationRenderer.this.tableModel.get(lsm.getLeadSelectionIndex());
                }
                MauerAggregationRenderer.this.changeMap();
            }
        });
        boolean rechteManagement = false;
        try {
            rechteManagement = SessionManager.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "mauerObjektRechteManagement", this.getConnectionContext());
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.pnlHeaderProducts1.setVisible(rechteManagement);
        this.jDialog1.pack();
        try {
            this.cidsBeansTableActionPanel1.setMetaClass(CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"VIEW_MAUER_EXPORT", (ConnectionContext)this.getConnectionContext()));
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
        }
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.jPanel1 = new JPanel();
        this.cidsBeansTableActionPanel1 = new CidsBeansTableActionPanel(Arrays.asList(this.csvAction), true);
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.pnlMap = new JPanel();
        this.pnlMauern = new RoundedPanel();
        this.pnlHeaderMauern = new SemiRoundedPanel();
        this.lblHeaderMauern = new JLabel();
        this.scpMauern = new JScrollPane();
        this.tblMauern = new JTable();
        this.jLayeredPane1 = new JLayeredPane();
        this.pnlProducts = new RoundedPanel();
        this.pnlHeaderProducts = new SemiRoundedPanel();
        this.lblheaderProdutke = new JLabel();
        this.jxlKatasterblatt = new JXHyperlink();
        this.jxlHauptinfo = new JXHyperlink();
        this.pnlProducts1 = new RoundedPanel();
        this.pnlHeaderProducts1 = new SemiRoundedPanel();
        this.lblheaderProdutke1 = new JLabel();
        this.jxlKatasterblatt1 = new JXHyperlink();
        this.jDialog1.setTitle(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.jDialog1.title"));
        this.jDialog1.setModal(true);
        this.jDialog1.getContentPane().setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.cidsBeansTableActionPanel1.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel1.add((Component)this.cidsBeansTableActionPanel1, gridBagConstraints);
        this.jDialog1.getContentPane().add((Component)this.jPanel1, "exporter");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.jLabel1.text"));
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints());
        this.jDialog1.getContentPane().add((Component)this.jPanel2, "loader");
        this.setLayout(new GridBagLayout());
        this.pnlMap.setBorder(BorderFactory.createEtchedBorder());
        this.pnlMap.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.pnlMap, gridBagConstraints);
        this.pnlMauern.setPreferredSize(new Dimension(470, 439));
        this.pnlMauern.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderMauern.setBackground(Color.darkGray);
        this.lblHeaderMauern.setForeground(new Color(255, 255, 255));
        this.lblHeaderMauern.setText(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.lblHeaderMauern.text"));
        GroupLayout pnlHeaderMauernLayout = new GroupLayout((Container)this.pnlHeaderMauern);
        this.pnlHeaderMauern.setLayout((LayoutManager)pnlHeaderMauernLayout);
        pnlHeaderMauernLayout.setHorizontalGroup(pnlHeaderMauernLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 168, Short.MAX_VALUE).addGroup(pnlHeaderMauernLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHeaderMauernLayout.createSequentialGroup().addGap(0, 23, Short.MAX_VALUE).addComponent(this.lblHeaderMauern).addGap(0, 23, Short.MAX_VALUE))));
        pnlHeaderMauernLayout.setVerticalGroup(pnlHeaderMauernLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 17, Short.MAX_VALUE).addGroup(pnlHeaderMauernLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHeaderMauernLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lblHeaderMauern).addGap(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.pnlMauern.add((Component)this.pnlHeaderMauern, (Object)gridBagConstraints);
        this.scpMauern.setPreferredSize(new Dimension(250, 402));
        this.tblMauern.setModel(this.tableModel);
        this.tblMauern.setShowVerticalLines(false);
        this.tblMauern.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MauerAggregationRenderer.this.tblMauernFocusLost(evt);
            }
        });
        this.scpMauern.setViewportView(this.tblMauern);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.35;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlMauern.add((Component)this.scpMauern, (Object)gridBagConstraints);
        this.pnlMauern.add((Component)this.jLayeredPane1, (Object)new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.pnlMauern, gridBagConstraints);
        this.pnlProducts.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderProducts.setBackground(Color.darkGray);
        this.lblheaderProdutke.setForeground(new Color(255, 255, 255));
        this.lblheaderProdutke.setText(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.lblheaderProdutke.text"));
        GroupLayout pnlHeaderProductsLayout = new GroupLayout((Container)this.pnlHeaderProducts);
        this.pnlHeaderProducts.setLayout((LayoutManager)pnlHeaderProductsLayout);
        pnlHeaderProductsLayout.setHorizontalGroup(pnlHeaderProductsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 169, Short.MAX_VALUE).addGroup(pnlHeaderProductsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHeaderProductsLayout.createSequentialGroup().addGap(0, 56, Short.MAX_VALUE).addComponent(this.lblheaderProdutke).addGap(0, 56, Short.MAX_VALUE))));
        pnlHeaderProductsLayout.setVerticalGroup(pnlHeaderProductsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 17, Short.MAX_VALUE).addGroup(pnlHeaderProductsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHeaderProductsLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lblheaderProdutke).addGap(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlProducts.add((Component)this.pnlHeaderProducts, (Object)gridBagConstraints);
        this.jxlKatasterblatt.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlKatasterblatt.setText(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.jxlKatasterblatt.text"));
        this.jxlKatasterblatt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerAggregationRenderer.this.jxlKatasterblattActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 10, 10);
        this.pnlProducts.add((Component)this.jxlKatasterblatt, (Object)gridBagConstraints);
        this.jxlHauptinfo.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/page_white_excel.png")));
        this.jxlHauptinfo.setText(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.jxlHauptinfo.text"));
        this.jxlHauptinfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerAggregationRenderer.this.jxlHauptinfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 10, 10);
        this.pnlProducts.add((Component)this.jxlHauptinfo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.pnlProducts, gridBagConstraints);
        this.pnlProducts1.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderProducts1.setBackground(Color.darkGray);
        this.lblheaderProdutke1.setForeground(new Color(255, 255, 255));
        this.lblheaderProdutke1.setText(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.lblheaderProdutke1.text"));
        GroupLayout pnlHeaderProducts1Layout = new GroupLayout((Container)this.pnlHeaderProducts1);
        this.pnlHeaderProducts1.setLayout((LayoutManager)pnlHeaderProducts1Layout);
        pnlHeaderProducts1Layout.setHorizontalGroup(pnlHeaderProducts1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 169, Short.MAX_VALUE).addGroup(pnlHeaderProducts1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHeaderProducts1Layout.createSequentialGroup().addGap(0, 62, Short.MAX_VALUE).addComponent(this.lblheaderProdutke1).addGap(0, 62, Short.MAX_VALUE))));
        pnlHeaderProducts1Layout.setVerticalGroup(pnlHeaderProducts1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE).addGroup(pnlHeaderProducts1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHeaderProducts1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lblheaderProdutke1).addGap(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlProducts1.add((Component)this.pnlHeaderProducts1, (Object)gridBagConstraints);
        this.jxlKatasterblatt1.setText(NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.jxlKatasterblatt1.text"));
        this.jxlKatasterblatt1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerAggregationRenderer.this.jxlKatasterblatt1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 10, 10);
        this.pnlProducts1.add((Component)this.jxlKatasterblatt1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.pnlProducts1, gridBagConstraints);
    }

    private void jxlKatasterblattActionPerformed(ActionEvent evt) {
        LinkedList<CidsBean> reportBeans = new LinkedList<CidsBean>();
        for (CidsBeanWrapper beanWrapper : this.cidsBeanWrappers) {
            if (!beanWrapper.isSelected()) continue;
            reportBeans.add(beanWrapper.cidsBean);
        }
        MauernReportGenerator.generateKatasterBlatt(reportBeans, this, this.getConnectionContext());
    }

    private Collection<CidsBean> getSelectedBeans() {
        LinkedList<CidsBean> reportBeans = new LinkedList<CidsBean>();
        for (CidsBeanWrapper beanWrapper : this.cidsBeanWrappers) {
            if (!beanWrapper.isSelected()) continue;
            reportBeans.add(beanWrapper.cidsBean);
        }
        return reportBeans;
    }

    private void jxlHauptinfoActionPerformed(ActionEvent evt) {
        if (this.cidsBeans != null) {
            ((CardLayout)this.jDialog1.getContentPane().getLayout()).show(this.jDialog1.getContentPane(), "loader");
            final Collection<CidsBean> selectedBeans = this.getSelectedBeans();
            new SwingWorker<List<CidsBean>, Void>(){

                @Override
                protected List<CidsBean> doInBackground() throws Exception {
                    ArrayList<CidsBean> viewBeans = new ArrayList<CidsBean>();
                    for (CidsBean cidsBean : selectedBeans) {
                        if (cidsBean == null) continue;
                        MetaObject mo = cidsBean.getMetaObject();
                        MetaObject viewMo = SessionManager.getConnection().getMetaObject(SessionManager.getSession().getUser(), mo.getId(), MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getMetaClass().getId(), MauerAggregationRenderer.this.cidsBeansTableActionPanel1.getMetaClass().getDomain(), MauerAggregationRenderer.this.getConnectionContext());
                        if (viewMo == null) continue;
                        viewBeans.add(viewMo.getBean());
                    }
                    return viewBeans;
                }

                @Override
                protected void done() {
                    try {
                        MauerAggregationRenderer.this.cidsBeansTableActionPanel1.setCidsBeans((List)this.get());
                        ((CardLayout)MauerAggregationRenderer.this.jDialog1.getContentPane().getLayout()).show(MauerAggregationRenderer.this.jDialog1.getContentPane(), "exporter");
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }.execute();
            StaticSwingTools.showDialog((Component)this, (JDialog)this.jDialog1, (boolean)true);
        }
    }

    private void tblMauernFocusLost(FocusEvent evt) {
        this.map.gotoInitialBoundingBox();
        this.map.getFeatureCollection().addFeatures(this.pointFeatures);
        this.tblMauern.clearSelection();
    }

    private void jxlKatasterblatt1ActionPerformed(ActionEvent evt) {
        MauerObjectsPermissionsProviderDialog.getInstance().setCidsBeans(this.getCidsBeans());
        StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)this), (JDialog)MauerObjectsPermissionsProviderDialog.getInstance(), (boolean)true);
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    private void changeMap() {
        Runnable mapChangeRunnable = new Runnable(){

            @Override
            public void run() {
                if (MauerAggregationRenderer.this.selectedCidsBeanWrapper == null) {
                    return;
                }
                Geometry g = MauerAggregationRenderer.this.selectedCidsBeanWrapper.getGeometry();
                if (g == null) {
                    LOG.info((Object)"No Geoemtry available for the selected Mauer Geometry. Can not change Map");
                    return;
                }
                XBoundingBox boxToGoto = new XBoundingBox(g.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()), ClientAlkisConf.getInstance().getSrsService(), true);
                boxToGoto.setX1(boxToGoto.getX1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                boxToGoto.setX2(boxToGoto.getX2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                boxToGoto.setY1(boxToGoto.getY1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                boxToGoto.setY2(boxToGoto.getY2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                MauerAggregationRenderer.this.map.getFeatureCollection().removeFeatures(MauerAggregationRenderer.this.pointFeatures);
                MauerAggregationRenderer.this.map.gotoBoundingBox((BoundingBox)boxToGoto, false, true, 500);
            }
        };
        if (EventQueue.isDispatchThread()) {
            mapChangeRunnable.run();
        } else {
            EventQueue.invokeLater(mapChangeRunnable);
        }
    }

    public void setCidsBeans(Collection<CidsBean> cidsBeans) {
        this.cidsBeans = cidsBeans;
        if (cidsBeans != null) {
            this.cidsBeanWrappers = new LinkedList<CidsBeanWrapper>();
            for (CidsBean cidsBean : cidsBeans) {
                this.cidsBeanWrappers.add(new CidsBeanWrapper(cidsBean, true));
            }
            int colorIndex = 0;
            Collections.sort(this.cidsBeanWrappers);
            for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
                cidsBeanWrapper.setColor(COLORS[colorIndex]);
                colorIndex = (colorIndex + 1) % COLORS.length;
            }
            this.tableModel.setCidsBeans(this.cidsBeanWrappers);
            if (this.tblMauern != null && this.tblMauern.getColumnModel() != null) {
                TableColumn tableColumn;
                TableColumn tableColumn2 = this.tblMauern.getColumnModel().getColumn(0);
                if (tableColumn2 != null) {
                    tableColumn2.setPreferredWidth(20);
                }
                if ((tableColumn = this.tblMauern.getColumnModel().getColumn(3)) != null) {
                    tableColumn.setPreferredWidth(15);
                }
            }
            this.initMap();
            this.changeButtonAvailability(this.cidsBeanWrappers.size() > 0);
        }
    }

    public void dispose() {
    }

    public String getTitle() {
        return NbBundle.getMessage(MauerAggregationRenderer.class, (String)"MauerAggregationRenderer.title", (Object)(this.cidsBeanWrappers != null ? Integer.valueOf(this.cidsBeanWrappers.size()) : "0"));
    }

    public void setTitle(String title) {
    }

    private void changeButtonAvailability(boolean enable) {
        this.jxlHauptinfo.setEnabled(enable);
        this.jxlKatasterblatt.setEnabled(enable);
    }

    public static void main(String[] args) {
        try {
            CidsBean[] beans = DevelopmentTools.createCidsBeansFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"kif", (String)"mauer", (int)6);
            DevelopmentTools.createAggregationRendererInFrameFromRMIConnectionOnLocalhost(Arrays.asList(beans), (String)"Ausgew\u00e4hlte Mauern", (int)1024, (int)800);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initMap() {
        if (this.cidsBeanWrappers != null) {
            Runnable mapRunnable = new Runnable(){

                @Override
                public void run() {
                    ActiveLayerModel mappingModel = new ActiveLayerModel();
                    mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                    mappingModel.addHome(this.getBoundingBox());
                    SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
                    swms.setName("Mauer");
                    mappingModel.addLayer((RetrievalServiceLayer)swms);
                    MauerAggregationRenderer.this.map.setMappingModel((MappingModel)mappingModel);
                    int duration = MauerAggregationRenderer.this.map.getAnimationDuration();
                    MauerAggregationRenderer.this.map.setAnimationDuration(0);
                    MauerAggregationRenderer.this.map.gotoInitialBoundingBox();
                    MauerAggregationRenderer.this.map.setInteractionMode("ZOOM");
                    MauerAggregationRenderer.this.map.unlock();
                    MauerAggregationRenderer.this.map.setInteractionMode("MUTE");
                    for (CidsBeanWrapper cidsBeanWrapper : MauerAggregationRenderer.this.cidsBeanWrappers) {
                        StyledFeature mauerGeomFeature = cidsBeanWrapper.getFeature();
                        StyledFeature mauerPointFeature = cidsBeanWrapper.getPointFeature();
                        if (mauerGeomFeature != null) {
                            MauerAggregationRenderer.this.map.getFeatureCollection().addFeature((Feature)mauerGeomFeature);
                        }
                        if (mauerGeomFeature == null) continue;
                        MauerAggregationRenderer.this.pointFeatures.add(mauerPointFeature);
                        MauerAggregationRenderer.this.map.getFeatureCollection().addFeature((Feature)mauerPointFeature);
                    }
                    MauerAggregationRenderer.this.map.setAnimationDuration(duration);
                }

                private XBoundingBox getBoundingBox() {
                    XBoundingBox result = null;
                    for (CidsBeanWrapper cidsBeanWrapper : MauerAggregationRenderer.this.cidsBeanWrappers) {
                        Geometry g = cidsBeanWrapper.getGeometry();
                        if (g == null) continue;
                        Geometry geometry = CrsTransformer.transformToGivenCrs((Geometry)g, (String)ClientAlkisConf.getInstance().getSrsService());
                        if (result == null) {
                            result = new XBoundingBox(geometry.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()), ClientAlkisConf.getInstance().getSrsService(), true);
                            result.setSrs(ClientAlkisConf.getInstance().getSrsService());
                            result.setMetric(true);
                            continue;
                        }
                        XBoundingBox temp = new XBoundingBox(geometry.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()), ClientAlkisConf.getInstance().getSrsService(), true);
                        temp.setSrs(ClientAlkisConf.getInstance().getSrsService());
                        temp.setMetric(true);
                        if (temp.getX1() < result.getX1()) {
                            result.setX1(temp.getX1());
                        }
                        if (temp.getY1() < result.getY1()) {
                            result.setY1(temp.getY1());
                        }
                        if (temp.getX2() > result.getX2()) {
                            result.setX2(temp.getX2());
                        }
                        if (!(temp.getY2() > result.getY2())) continue;
                        result.setY2(temp.getY2());
                    }
                    return result;
                }
            };
            if (EventQueue.isDispatchThread()) {
                mapRunnable.run();
            } else {
                EventQueue.invokeLater(mapRunnable);
            }
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            return this;
        }
    }

    private class CidsBeanWrapper
    implements Comparable<CidsBeanWrapper> {
        private CidsBean cidsBean;
        private boolean selected;
        private Color color;
        private String lagebezeichnung;
        private String stuetzmauertyp;
        private Geometry geometry;
        private StyledFeature feature;
        private StyledFeature pointFeature;

        public CidsBeanWrapper(CidsBean cidsBean, boolean selected) {
            this.cidsBean = cidsBean;
            this.selected = selected;
            Object lagebezObj = cidsBean.getProperty("lagebezeichnung");
            this.lagebezeichnung = lagebezObj == null ? "n.a." : lagebezObj.toString();
            Object stuetzTypObj = cidsBean.getProperty("stuetzmauertyp.name");
            this.stuetzmauertyp = stuetzTypObj == null ? "n.a." : stuetzTypObj.toString();
            if (cidsBean.getProperty("georeferenz.geo_field") != null && cidsBean.getProperty("georeferenz.geo_field") instanceof Geometry) {
                this.geometry = CrsTransformer.transformToGivenCrs((Geometry)((Geometry)cidsBean.getProperty("georeferenz.geo_field")), (String)ClientAlkisConf.getInstance().getSrsService());
            }
            if (this.geometry != null) {
                FeatureAnnotationSymbol result;
                DefaultStyledFeature dsf = new DefaultStyledFeature();
                dsf.setLineWidth(3);
                dsf.setGeometry(this.geometry);
                dsf.setTransparency(0.9f);
                this.feature = dsf;
                DefaultStyledFeature pointDsf = new DefaultStyledFeature();
                pointDsf.setGeometry((Geometry)this.geometry.getEnvelope().getCentroid());
                URL urlToIcon = null;
                urlToIcon = this.getClass().getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_mauer_silver.png");
                Color pointColor = new Color(192, 192, 192);
                ImageIcon pointIcon = null;
                if (urlToIcon != null) {
                    pointIcon = new ImageIcon(urlToIcon);
                }
                if (pointIcon != null) {
                    result = new FeatureAnnotationSymbol(pointIcon.getImage());
                    result.setSweetSpotX(0.5);
                    result.setSweetSpotY(0.9);
                } else {
                    int fallbackSymbolSize = 8;
                    BufferedImage bufferedImage = new BufferedImage(8, 8, 2);
                    Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
                    graphics.setColor(pointColor);
                    graphics.fillOval(0, 0, 8, 8);
                    result = new FeatureAnnotationSymbol((Image)bufferedImage);
                    result.setSweetSpotX(0.5);
                    result.setSweetSpotY(0.5);
                }
                pointDsf.setPointAnnotationSymbol(result);
                this.pointFeature = pointDsf;
            }
        }

        public CidsBean getCidsBean() {
            return this.cidsBean;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            if (this.feature != null) {
                this.feature.setFillingPaint((Paint)this.color);
                this.feature.setLinePaint((Paint)this.color);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getGemarkung() {
            return this.lagebezeichnung;
        }

        public String getBezeichnung() {
            return this.stuetzmauertyp;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public StyledFeature getFeature() {
            return this.feature;
        }

        public StyledFeature getPointFeature() {
            return this.pointFeature;
        }

        @Override
        public int compareTo(CidsBeanWrapper o) {
            CidsBean cidsBean1 = this.cidsBean;
            CidsBean cidsBean2 = o.cidsBean;
            if (cidsBean1 == null && cidsBean2 == null) {
                return 0;
            }
            if (cidsBean1 == null) {
                return -1;
            }
            if (cidsBean2 == null) {
                return 1;
            }
            int districtComparison = cidsBean1.getProperty("lagebezeichnung").toString().compareTo(cidsBean2.getProperty("lagebezeichnung").toString());
            if (districtComparison != 0) {
                return districtComparison;
            }
            return cidsBean1.getProperty("id").toString().compareTo(cidsBean2.getProperty("id").toString());
        }
    }

    private class MauerTableModel
    extends AbstractTableModel {
        private int selectedCidsBeans = 0;

        private MauerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (MauerAggregationRenderer.this.cidsBeanWrappers == null) {
                return 0;
            }
            return MauerAggregationRenderer.this.cidsBeanWrappers.size();
        }

        @Override
        public int getColumnCount() {
            if (MauerAggregationRenderer.this.cidsBeanWrappers == null) {
                return 0;
            }
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (MauerAggregationRenderer.this.cidsBeanWrappers == null) {
                return null;
            }
            CidsBeanWrapper bean = (CidsBeanWrapper)MauerAggregationRenderer.this.cidsBeanWrappers.get(rowIndex);
            if (columnIndex == 0) {
                return bean.isSelected();
            }
            if (columnIndex == 1) {
                return bean.lagebezeichnung;
            }
            if (columnIndex == 2) {
                return bean.stuetzmauertyp;
            }
            return bean.color;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            CidsBeanWrapper cidsBeanWrapper;
            if (column != 0) {
                return;
            }
            cidsBeanWrapper.setSelected(!(cidsBeanWrapper = (CidsBeanWrapper)MauerAggregationRenderer.this.cidsBeanWrappers.get(row)).isSelected());
            this.selectedCidsBeans = cidsBeanWrapper.isSelected() ? ++this.selectedCidsBeans : --this.selectedCidsBeans;
            this.fireTableRowsUpdated(row, row);
            MauerAggregationRenderer.this.changeMap();
            MauerAggregationRenderer.this.changeButtonAvailability(this.selectedCidsBeans > 0);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 3) {
                return Color.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return NbBundle.getMessage(MauerAggregationRenderer.class, (String)("MauerAggregationRenderer.MauerTableModel.getColumnName(" + column + ")"));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void setCidsBeans(List<CidsBeanWrapper> cidsBeans) {
            if (cidsBeans != null) {
                this.selectedCidsBeans = MauerAggregationRenderer.this.cidsBeanWrappers.size();
                this.fireTableStructureChanged();
            }
        }

        public CidsBeanWrapper get(int index) {
            return (CidsBeanWrapper)MauerAggregationRenderer.this.cidsBeanWrappers.get(index);
        }
    }
}

