/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.TableModelIndexConvertingToViewIndexComparator;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.wunda_blau.search.actions.NivPReportServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class NivellementPunktAggregationRenderer
extends JPanel
implements CidsBeanAggregationRenderer,
RequestsFullSizeComponent,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(NivellementPunktAggregationRenderer.class);
    private static final double BUFFER = 0.005;
    private static final String[] AGR_COMLUMN_NAMES = new String[]{"Auswahl", "DGK-Blattnr.", "Lfd. Nr.", "Jahr", "Festlegungsart", "Lagebezeichnung"};
    private static final String[] AGR_PROPERTY_NAMES = new String[]{"dgk_blattnummer", "laufende_nummer", "messungsjahr", "festlegungsart", "lagebezeichnung"};
    private static final int[] AGR_COMLUMN_WIDTH = new int[]{40, 70, 40, 30, 80, 200};
    private List<CidsBean> cidsBeans;
    private String title = "";
    private PointTableModel tableModel;
    private Map<CidsBean, CidsFeature> features;
    private Comparator<Integer> tableComparator;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnGenerateReport;
    private Box.Filler flrGap;
    private JLabel lblJobnumber;
    private JLabel lblProjectname;
    private MappingComponent mappingComponent;
    private JPanel panMap;
    private JPanel pnlReport;
    private JScrollPane scpPunkte;
    private JTable tblPunkte;
    private JTextField txtJobnumber;
    private JTextField txtProjectname;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.scpPunkte.getViewport().setOpaque(false);
        this.tblPunkte.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.tableComparator = new TableModelIndexConvertingToViewIndexComparator(this.tblPunkte);
        boolean billingAllowed = BillingPopup.isBillingAllowed("nivppdf", this.getConnectionContext());
        this.btnGenerateReport.setEnabled(billingAllowed);
    }

    public void animateToOverview() {
        this.mappingComponent.gotoInitialBoundingBox();
        Rectangle2D viewBounds = this.mappingComponent.getCamera().getViewBounds().getBounds2D();
        double scale = this.mappingComponent.getScaleDenominator();
        double newX = (viewBounds.getX() / scale - 0.005) * scale;
        double newY = (viewBounds.getY() / scale - 0.005) * scale;
        double newWidth = (viewBounds.getWidth() / scale + 0.01) * scale;
        double newHeight = (viewBounds.getHeight() / scale + 0.01) * scale;
        viewBounds.setRect(newX, newY, newWidth, newHeight);
        this.mappingComponent.getCamera().animateViewToCenterBounds(viewBounds, true, (long)this.mappingComponent.getAnimationDuration());
    }

    private void initComponents() {
        this.scpPunkte = new JScrollPane();
        this.tblPunkte = new JTable();
        this.panMap = new JPanel();
        this.mappingComponent = new MappingComponent();
        this.pnlReport = new JPanel();
        this.flrGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblProjectname = new JLabel();
        this.txtProjectname = new JTextField();
        this.lblJobnumber = new JLabel();
        this.txtJobnumber = new JTextField();
        this.btnGenerateReport = new JButton();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                NivellementPunktAggregationRenderer.this.formAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.setLayout(new GridBagLayout());
        this.tblPunkte.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tblPunkte.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NivellementPunktAggregationRenderer.this.tblPunkteFocusLost(evt);
            }
        });
        this.scpPunkte.setViewportView(this.tblPunkte);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.scpPunkte, gridBagConstraints);
        this.panMap.setMaximumSize(new Dimension(300, 450));
        this.panMap.setMinimumSize(new Dimension(300, 450));
        this.panMap.setOpaque(false);
        this.panMap.setPreferredSize(new Dimension(300, 450));
        this.panMap.setLayout(new GridBagLayout());
        this.mappingComponent.setBorder(BorderFactory.createEtchedBorder());
        this.mappingComponent.setMaximumSize(new Dimension(100, 100));
        this.mappingComponent.setMinimumSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panMap.add((Component)this.mappingComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.panMap, gridBagConstraints);
        this.pnlReport.setOpaque(false);
        this.pnlReport.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.pnlReport.add((Component)this.flrGap, gridBagConstraints);
        this.lblProjectname.setText(NbBundle.getMessage(NivellementPunktAggregationRenderer.class, (String)"NivellementPunktAggregationRenderer.lblProjectname.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlReport.add((Component)this.lblProjectname, gridBagConstraints);
        this.txtProjectname.setText(NbBundle.getMessage(NivellementPunktAggregationRenderer.class, (String)"NivellementPunktAggregationRenderer.txtProjectname.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlReport.add((Component)this.txtProjectname, gridBagConstraints);
        this.lblJobnumber.setText(NbBundle.getMessage(NivellementPunktAggregationRenderer.class, (String)"NivellementPunktAggregationRenderer.lblJobnumber.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.pnlReport.add((Component)this.lblJobnumber, gridBagConstraints);
        this.txtJobnumber.setText(NbBundle.getMessage(NivellementPunktAggregationRenderer.class, (String)"NivellementPunktAggregationRenderer.txtJobnumber.text"));
        this.txtJobnumber.setMaximumSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.pnlReport.add((Component)this.txtJobnumber, gridBagConstraints);
        this.btnGenerateReport.setText(NbBundle.getMessage(NivellementPunktAggregationRenderer.class, (String)"NivellementPunktAggregationRenderer.btnGenerateReport.text"));
        this.btnGenerateReport.setFocusPainted(false);
        this.btnGenerateReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NivellementPunktAggregationRenderer.this.btnGenerateReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.pnlReport.add((Component)this.btnGenerateReport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.pnlReport, gridBagConstraints);
    }

    private void tblPunkteFocusLost(FocusEvent evt) {
        this.tblPunkte.clearSelection();
        this.animateToOverview();
    }

    private void btnGenerateReportActionPerformed(ActionEvent evt) {
        Collection<CidsBean> selectedNivellementPunkte = this.getSelectedNivellementPunkte();
        if (selectedNivellementPunkte.isEmpty()) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(NivellementPunktAggregationRenderer.class, (String)"NivellementPunktAggregationRenderer.btnGenerateReportActionPerformed(ActionEvent).emptySelection.message"), NbBundle.getMessage(NivellementPunktAggregationRenderer.class, (String)"NivellementPunktAggregationRenderer.btnGenerateReportActionPerformed(ActionEvent).emptySelection.title"), 1);
            return;
        }
        try {
            if (BillingPopup.doBilling("nivppdf", "no.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", selectedNivellementPunkte.size()))) {
                NivellementPunktAggregationRenderer.downloadReport(selectedNivellementPunkte, this.txtJobnumber.getText(), this.txtProjectname.getText(), this.getConnectionContext());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    public static void downloadReport(Collection<CidsBean> nivPoints, String jobnumber, String projectname, ConnectionContext connectionContext) {
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getDescriptionPane())) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            ArrayList<MetaObjectNode> nivPMons = new ArrayList<MetaObjectNode>();
            for (CidsBean nivPoint : nivPoints) {
                nivPMons.add(new MetaObjectNode(nivPoint));
            }
            ServerActionParameter sapMons = new ServerActionParameter(NivPReportServerAction.Parameter.POINT_MONS.toString(), nivPMons);
            ServerActionParameter sapJobnumber = new ServerActionParameter(NivPReportServerAction.Parameter.JOBNUMBER.toString(), (Object)jobnumber);
            ServerActionParameter sapProjectName = new ServerActionParameter(NivPReportServerAction.Parameter.PROJECTNAME.toString(), (Object)projectname);
            DownloadManager.instance().add((Download)new ByteArrayActionDownload("nivPReport", null, new ServerActionParameter[]{sapMons, sapJobnumber, sapProjectName}, projectname == null || projectname.trim().length() == 0 ? (nivPoints.size() == 1 ? "Nivellement-Punkt" : "Nivellement-Punkte") : projectname, jobname, "nivp", ".pdf", connectionContext));
        }
    }

    private void formAncestorAdded(AncestorEvent evt) {
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Sleeping to wait for zooming to added features was interrupted.", (Throwable)ex);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NivellementPunktAggregationRenderer.this.animateToOverview();
                    }
                });
            }
        });
    }

    protected Collection<CidsBean> getSelectedNivellementPunkte() {
        LinkedList<CidsBean> result = new LinkedList<CidsBean>();
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        TableModel tableModel = this.tblPunkte.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object includedObj = tableModel.getValueAt(i, 0);
            if (!(includedObj instanceof Boolean) || !((Boolean)includedObj).booleanValue()) continue;
            selectedIndexes.add(i);
        }
        Collections.sort(selectedIndexes, this.tableComparator);
        for (Integer selectedIndex : selectedIndexes) {
            result.add(this.cidsBeans.get(selectedIndex));
        }
        return result;
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public void setCidsBeans(Collection<CidsBean> beans) {
        if (beans instanceof List) {
            this.cidsBeans = (List)beans;
            this.features = new HashMap<CidsBean, CidsFeature>(beans.size());
            this.initMap();
            ArrayList tableData = TypeSafeCollections.newArrayList();
            for (CidsBean punktBean : this.cidsBeans) {
                tableData.add(this.cidsBean2Row(punktBean));
            }
            this.tableModel = new PointTableModel((Object[][])tableData.toArray((T[])new Object[tableData.size()][]), AGR_COMLUMN_NAMES);
            this.tblPunkte.setModel(this.tableModel);
            TableColumnModel cModel = this.tblPunkte.getColumnModel();
            for (int i = 0; i < cModel.getColumnCount(); ++i) {
                cModel.getColumn(i).setPreferredWidth(AGR_COMLUMN_WIDTH[i]);
            }
            ObjectRendererUtils.decorateTableWithSorter(this.tblPunkte);
        }
        this.setTitle(null);
    }

    public void dispose() {
        this.mappingComponent.dispose();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String desc = "Punktliste";
        List<CidsBean> beans = this.cidsBeans;
        if (beans != null && beans.size() > 0) {
            desc = desc + " - " + beans.size() + " Nivellement-Punkte ausgew\u00e4hlt";
        }
        this.title = desc;
    }

    protected void initMap() {
        try {
            ActiveLayerModel mappingModel = new ActiveLayerModel();
            mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
            XBoundingBox box = this.boundingBoxFromPointList(this.cidsBeans);
            mappingModel.addHome(new XBoundingBox(box.getX1(), box.getY1(), box.getX2(), box.getY2(), ClientAlkisConf.getInstance().getSrsService(), true));
            SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
            swms.setName("Nivellement_Punkte");
            mappingModel.addLayer((RetrievalServiceLayer)swms);
            this.mappingComponent.setMappingModel((MappingModel)mappingModel);
            this.mappingComponent.setAnimationDuration(0);
            this.mappingComponent.gotoInitialBoundingBox();
            this.mappingComponent.setInteractionMode("ZOOM");
            this.mappingComponent.unlock();
            for (CidsBean cidsBean : this.cidsBeans) {
                CidsFeature feature = new CidsFeature(cidsBean.getMetaObject());
                this.features.put(cidsBean, feature);
            }
            this.mappingComponent.getFeatureCollection().addFeatures(this.features.values());
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
        }
    }

    protected XBoundingBox boundingBoxFromPointList(Collection<CidsBean> nivellementPunkte) {
        ArrayList geometries = TypeSafeCollections.newArrayList();
        for (CidsBean nivellementPunkt : nivellementPunkte) {
            try {
                geometries.add((Geometry)nivellementPunkt.getProperty("geometrie.geo_field"));
            }
            catch (Exception ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
        GeometryCollection geoCollection = new GeometryCollection(geometries.toArray(new Geometry[geometries.size()]), new GeometryFactory());
        return new XBoundingBox(geoCollection.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
    }

    protected Object[] cidsBean2Row(CidsBean nivellementPunkt) {
        if (nivellementPunkt != null) {
            Object[] result = new Object[AGR_COMLUMN_NAMES.length];
            result[0] = Boolean.TRUE;
            for (int i = 0; i < AGR_PROPERTY_NAMES.length; ++i) {
                Object property = nivellementPunkt.getProperty(AGR_PROPERTY_NAMES[i]);
                String propertyString = ObjectRendererUtils.propertyPrettyPrint(property);
                result[i + 1] = propertyString;
            }
            return result;
        }
        return new Object[0];
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    class PointTableModel
    extends DefaultTableModel {
        public PointTableModel(Object[][] data, String[] labels) {
            super(data, labels);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] indexes;
            if (!e.getValueIsAdjusting() && NivellementPunktAggregationRenderer.this.cidsBeans != null && (indexes = NivellementPunktAggregationRenderer.this.tblPunkte.getSelectedRows()) != null && indexes.length > 0) {
                for (int viewIdx : indexes) {
                    int modelIdx = NivellementPunktAggregationRenderer.this.tblPunkte.getRowSorter().convertRowIndexToModel(viewIdx);
                    if (modelIdx <= -1 || modelIdx >= NivellementPunktAggregationRenderer.this.cidsBeans.size()) continue;
                    CidsBean selectedBean = (CidsBean)NivellementPunktAggregationRenderer.this.cidsBeans.get(modelIdx);
                    XBoundingBox boxToGoto = new XBoundingBox(((CidsFeature)NivellementPunktAggregationRenderer.this.features.get(selectedBean)).getGeometry().getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                    boxToGoto.setX1(boxToGoto.getX1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                    boxToGoto.setX2(boxToGoto.getX2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                    boxToGoto.setY1(boxToGoto.getY1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                    boxToGoto.setY2(boxToGoto.getY2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                    NivellementPunktAggregationRenderer.this.mappingComponent.gotoBoundingBox((BoundingBox)boxToGoto, false, true, 500);
                    break;
                }
            }
        }
    }
}

