/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.guigarage.jgrid.JGrid;
import com.guigarage.jgrid.renderer.GridCellRenderer;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.clientutils.TifferDownload;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_SingleStadtbildJGrid;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieAggregationRendererInfoPanel;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridObject;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridObjectListener;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridRenderer;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Sb_stadtbildserieAggregationRenderer
extends JPanel
implements RequestsFullSizeComponent,
CidsBeanAggregationRenderer,
FooterComponentProvider,
TitleComponentProvider,
ListDataListener,
Sb_stadtbildserieGridObjectListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(Sb_stadtbildserieGridRenderer.class);
    private static final Icon BIN_EMPTY = new ImageIcon(Sb_stadtbildserieAggregationRenderer.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bin_empty.png"));
    private static final Icon BIN_FULL = new ImageIcon(Sb_stadtbildserieAggregationRenderer.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bin.png"));
    private static final Icon BIN_RECYCLE = new ImageIcon(Sb_stadtbildserieAggregationRenderer.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bin_recycle.png"));
    private static final String REPORT_STADTBILDSERIE_URL = "/de/cismet/cids/custom/reports/wunda_blau/Stadtbildbericht.jasper";
    private static final String REPORT_STADTBILDVORSCHAU_URL = "/de/cismet/cids/custom/reports/wunda_blau/Stadtbildvorschaubericht.jasper";
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final ExecutorService highResAvailableThreadPool = CismetExecutors.newFixedThreadPool((int)20);
    private final Action vorauswahlReportAction;
    private final Action vorauswahlDownloadAction;
    private final Action warenkorbReportAction;
    private final Action warenkorbDownloadAction;
    private boolean wasInfoPanelVisibleBeforeSwitch = true;
    private Collection<CidsBean> cidsBeans = null;
    private HashSet<String> highResStadtbilder = new HashSet();
    private HashSet<String> selectedStadtbilder = new HashSet();
    private HashSet<String> vorschauStadtbilder = new HashSet();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnBin;
    private JButton btnBinRecycle;
    private JButton btnDownloadHighResImage;
    private JButton btnMoveSerienToWarenkorb;
    private JButton btnRemoveWarenkorb;
    private JButton btnReport;
    private Box.Filler filler1;
    private JGrid grdBin;
    private JGrid grdStadtbildserien;
    private JGrid grdWarenkorb;
    private Sb_stadtbildserieAggregationRendererInfoPanel infoNotAvailable;
    private Sb_stadtbildserieAggregationRendererInfoPanel infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblMiddle;
    private JLabel lblSubtitle;
    private JLabel lblSwitchToBin;
    private JLabel lblSwitchToSerie;
    private JLabel lblTitle;
    private JPanel panButtons;
    private JPanel panFooter;
    private JPanel panTitle;
    private JPanel panTitleString;
    private JPanel pnlInfoPanels;
    private JPanel pnlLeuchtkasten;
    private JPanel pnlSlider;
    private RoundedPanel roundedPanel1;
    private JSlider sldSize;
    private JToggleButton tbtnSlide;

    public Sb_stadtbildserieAggregationRenderer() {
        this.vorauswahlReportAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/vorauswahlReport.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sb_stadtbildserieAggregationRenderer.this.reportVorauswahl();
            }
        };
        this.vorauswahlDownloadAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/vorauswahlDownload.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sb_stadtbildserieAggregationRenderer.this.downladVorauswahl();
            }
        };
        this.warenkorbReportAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/warenkorbReport.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sb_stadtbildserieAggregationRenderer.this.reportWarenkorb();
            }
        };
        this.warenkorbDownloadAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/warenkorbDownload.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sb_stadtbildserieAggregationRenderer.this.downladWarenkorb();
            }
        };
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.vorauswahlReportAction.putValue("ShortDescription", NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.actionVorauswahlReport.toolTipText"));
        this.vorauswahlReportAction.setEnabled(true);
        this.warenkorbReportAction.putValue("ShortDescription", NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.actionWarenkorbReport.toolTipText"));
        this.warenkorbReportAction.setEnabled(false);
        this.initComponents();
        this.refreshVorauswahlDownloadAction();
        this.refreshWarenkorbDownloadAction();
        this.btnDownloadHighResImage.setAction(this.vorauswahlDownloadAction);
        this.btnReport.setAction(this.vorauswahlReportAction);
        this.infoNotAvailable.previewImageNotAvailable();
        this.infoNotAvailable.setEnableTable(false);
        ((PictureSelectionJGrid)this.grdStadtbildserien).updateInfoPanel();
        this.sldSize.setValue(this.grdStadtbildserien.getFixedCellDimension());
        this.switchToSerie();
    }

    private void initComponents() {
        this.panFooter = new JPanel();
        this.panButtons = new JPanel();
        this.lblSwitchToSerie = new JLabel();
        this.lblMiddle = new JLabel();
        this.lblSwitchToBin = new JLabel();
        this.panTitle = new JPanel();
        this.panTitleString = new JPanel();
        this.lblTitle = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnDownloadHighResImage = new JButton();
        this.btnReport = new JButton();
        this.tbtnSlide = new JToggleButton();
        this.roundedPanel1 = new RoundedPanel();
        this.btnBin = new JButton();
        this.btnRemoveWarenkorb = new JButton();
        this.btnBinRecycle = new JButton();
        this.pnlLeuchtkasten = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.grdWarenkorb = new Sb_SingleStadtbildJGrid(this.getConnectionContext());
        this.jScrollPane2 = new JScrollPane();
        this.grdBin = new PictureSelectionJGrid();
        this.jScrollPane1 = new JScrollPane();
        this.grdStadtbildserien = new PictureSelectionJGrid();
        this.pnlSlider = new JPanel();
        this.jLabel1 = new JLabel();
        this.sldSize = new JSlider();
        this.jLabel2 = new JLabel();
        this.btnMoveSerienToWarenkorb = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.pnlInfoPanels = new JPanel();
        this.infoPanel = new Sb_stadtbildserieAggregationRendererInfoPanel(this.getConnectionContext());
        this.infoNotAvailable = new Sb_stadtbildserieAggregationRendererInfoPanel(this.getConnectionContext());
        this.lblSubtitle = new JLabel();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.panButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.panButtons.setOpaque(false);
        this.panButtons.setLayout(new GridBagLayout());
        this.lblSwitchToSerie.setFont(new Font("Tahoma", 1, 14));
        this.lblSwitchToSerie.setForeground(new Color(255, 255, 255));
        this.lblSwitchToSerie.setHorizontalAlignment(11);
        this.lblSwitchToSerie.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/magnifier.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblSwitchToSerie, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.lblSwitchToSerie.text"));
        this.lblSwitchToSerie.setEnabled(false);
        this.lblSwitchToSerie.setPreferredSize(new Dimension(186, 17));
        this.lblSwitchToSerie.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.lblSwitchToSerieMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.panButtons.add((Component)this.lblSwitchToSerie, gridBagConstraints);
        this.lblMiddle.setFont(new Font("Tahoma", 1, 14));
        this.lblMiddle.setForeground(new Color(255, 255, 255));
        this.lblMiddle.setHorizontalAlignment(0);
        this.lblMiddle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/basket_shopping.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblMiddle, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.lblMiddle.text"));
        this.lblMiddle.setPreferredSize(new Dimension(212, 24));
        this.lblMiddle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.lblMiddleMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.panButtons.add((Component)this.lblMiddle, gridBagConstraints);
        this.lblSwitchToBin.setFont(new Font("Tahoma", 1, 14));
        this.lblSwitchToBin.setForeground(new Color(255, 255, 255));
        this.lblSwitchToBin.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bin_empty.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblSwitchToBin, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.lblSwitchToBin.text"));
        this.lblSwitchToBin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.lblSwitchToBinMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panButtons.add((Component)this.lblSwitchToBin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panFooter.add((Component)this.panButtons, gridBagConstraints);
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new BorderLayout());
        this.panTitleString.setOpaque(false);
        this.panTitleString.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.lblTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTitleString.add((Component)this.lblTitle, gridBagConstraints);
        this.panTitle.add((Component)this.panTitleString, "Center");
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnDownloadHighResImage.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/download.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDownloadHighResImage, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnDownloadHighResImage.text"));
        this.btnDownloadHighResImage.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnDownloadHighResImage.toolTipText"));
        this.btnDownloadHighResImage.setBorder(null);
        this.btnDownloadHighResImage.setBorderPainted(false);
        this.btnDownloadHighResImage.setContentAreaFilled(false);
        this.btnDownloadHighResImage.setEnabled(false);
        this.btnDownloadHighResImage.setFocusPainted(false);
        this.btnDownloadHighResImage.setMaximumSize(new Dimension(30, 30));
        this.btnDownloadHighResImage.setMinimumSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.btnDownloadHighResImage, gridBagConstraints);
        this.btnReport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/printer.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReport, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnReport.text"));
        this.btnReport.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnReport.toolTipText"));
        this.btnReport.setBorderPainted(false);
        this.btnReport.setContentAreaFilled(false);
        this.btnReport.setEnabled(false);
        this.btnReport.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.btnReport, gridBagConstraints);
        this.tbtnSlide.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.tbtnSlide, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.tbtnSlide.text"));
        this.tbtnSlide.setBorderPainted(false);
        this.tbtnSlide.setContentAreaFilled(false);
        this.tbtnSlide.setFocusPainted(false);
        this.tbtnSlide.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/arrow-180.png")));
        this.tbtnSlide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.tbtnSlideActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.tbtnSlide, new GridBagConstraints());
        this.panTitle.add((Component)this.jPanel1, "East");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.roundedPanel1.setMinimumSize(new Dimension(300, 200));
        this.roundedPanel1.setPreferredSize(new Dimension(300, 200));
        this.roundedPanel1.setLayout((LayoutManager)new GridBagLayout());
        this.btnBin.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bin_empty.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBin, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnBin.text"));
        this.btnBin.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnBin.toolTipText"));
        this.btnBin.setBorderPainted(false);
        this.btnBin.setContentAreaFilled(false);
        this.btnBin.setFocusPainted(false);
        this.btnBin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.btnBinActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.roundedPanel1.add((Component)this.btnBin, (Object)gridBagConstraints);
        this.btnRemoveWarenkorb.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/basket_shopping-minus.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveWarenkorb, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnRemoveWarenkorb.text"));
        this.btnRemoveWarenkorb.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnRemoveWarenkorb.toolTipText"));
        this.btnRemoveWarenkorb.setBorderPainted(false);
        this.btnRemoveWarenkorb.setContentAreaFilled(false);
        this.btnRemoveWarenkorb.setFocusPainted(false);
        this.btnRemoveWarenkorb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.btnRemoveWarenkorbActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.roundedPanel1.add((Component)this.btnRemoveWarenkorb, (Object)gridBagConstraints);
        this.btnRemoveWarenkorb.setVisible(false);
        this.btnBinRecycle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bin_recycle.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBinRecycle, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnBinRecycle.text"));
        this.btnBinRecycle.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnBinRecycle.toolTipText"));
        this.btnBinRecycle.setBorderPainted(false);
        this.btnBinRecycle.setContentAreaFilled(false);
        this.btnBinRecycle.setFocusPainted(false);
        this.btnBinRecycle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.btnBinRecycleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.roundedPanel1.add((Component)this.btnBinRecycle, (Object)gridBagConstraints);
        this.btnBinRecycle.setVisible(false);
        this.pnlLeuchtkasten.setOpaque(false);
        this.pnlLeuchtkasten.setLayout(new CardLayout());
        this.jScrollPane3.setBorder(null);
        this.jScrollPane3.setOpaque(false);
        this.grdWarenkorb.setOpaque(false);
        this.jScrollPane3.setViewportView((Component)this.grdWarenkorb);
        this.pnlLeuchtkasten.add((Component)this.jScrollPane3, "WARENKORB");
        this.jScrollPane3.getViewport().setOpaque(false);
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setOpaque(false);
        this.grdBin.setOpaque(false);
        this.jScrollPane2.setViewportView((Component)this.grdBin);
        this.pnlLeuchtkasten.add((Component)this.jScrollPane2, "BIN");
        this.jScrollPane2.getViewport().setOpaque(false);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setOpaque(false);
        this.grdStadtbildserien.setOpaque(false);
        this.jScrollPane1.setViewportView((Component)this.grdStadtbildserien);
        this.grdStadtbildserien.getModel().addListDataListener(this);
        this.pnlLeuchtkasten.add((Component)this.jScrollPane1, "SERIEN");
        this.jScrollPane1.getViewport().setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel1.add((Component)this.pnlLeuchtkasten, (Object)gridBagConstraints);
        this.pnlSlider.setOpaque(false);
        this.pnlSlider.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/image_small.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlSlider.add((Component)this.jLabel1, gridBagConstraints);
        this.sldSize.setMaximum(512);
        this.sldSize.setMinimum(64);
        this.sldSize.setMinimumSize(new Dimension(200, 16));
        this.sldSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.sldSizeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.pnlSlider.add((Component)this.sldSize, gridBagConstraints);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/image_big.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlSlider.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel1.add((Component)this.pnlSlider, (Object)gridBagConstraints);
        this.btnMoveSerienToWarenkorb.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/basket_shopping.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMoveSerienToWarenkorb, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnMoveSerienToWarenkorb.text"));
        this.btnMoveSerienToWarenkorb.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.btnMoveSerienToWarenkorb.toolTipText"));
        this.btnMoveSerienToWarenkorb.setBorderPainted(false);
        this.btnMoveSerienToWarenkorb.setContentAreaFilled(false);
        this.btnMoveSerienToWarenkorb.setFocusPainted(false);
        this.btnMoveSerienToWarenkorb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRenderer.this.btnMoveSerienToWarenkorbActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.roundedPanel1.add((Component)this.btnMoveSerienToWarenkorb, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.roundedPanel1.add((Component)this.filler1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.roundedPanel1, gridBagConstraints);
        this.pnlInfoPanels.setOpaque(false);
        this.pnlInfoPanels.setLayout(new CardLayout());
        this.infoPanel.setMinimumSize(new Dimension(350, 0));
        this.infoPanel.setPreferredSize(new Dimension(350, 0));
        this.pnlInfoPanels.add((Component)this.infoPanel, "INFO");
        this.infoNotAvailable.setMinimumSize(new Dimension(350, 0));
        this.infoNotAvailable.setPreferredSize(new Dimension(350, 0));
        this.pnlInfoPanels.add((Component)this.infoNotAvailable, "NO_INFO");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlInfoPanels, gridBagConstraints);
        this.lblSubtitle.setFont(new Font("Dialog", 1, 18));
        Mnemonics.setLocalizedText((JLabel)this.lblSubtitle, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRenderer.class, (String)"Sb_stadtbildserieAggregationRenderer.lblSubtitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.add((Component)this.lblSubtitle, gridBagConstraints);
    }

    private void btnBinActionPerformed(ActionEvent evt) {
        this.moveSelectedStadtbildserienToOtherGrid(this.grdStadtbildserien, this.grdBin);
    }

    private void btnBinRecycleActionPerformed(ActionEvent evt) {
        this.moveSelectedStadtbildserienToOtherGrid(this.grdBin, this.grdStadtbildserien);
    }

    private void sldSizeStateChanged(ChangeEvent evt) {
        this.grdStadtbildserien.setFixedCellDimension(this.sldSize.getValue());
        this.grdStadtbildserien.ensureIndexIsVisible(this.grdStadtbildserien.getSelectedIndex());
        this.grdBin.setFixedCellDimension(this.sldSize.getValue());
        this.grdBin.ensureIndexIsVisible(this.grdBin.getSelectedIndex());
        this.grdWarenkorb.setFixedCellDimension(this.sldSize.getValue());
        this.grdWarenkorb.ensureIndexIsVisible(this.grdWarenkorb.getSelectedIndex());
    }

    private void tbtnSlideActionPerformed(ActionEvent evt) {
        this.showInfoPanel(!this.pnlInfoPanels.isVisible());
        this.wasInfoPanelVisibleBeforeSwitch = this.pnlInfoPanels.isVisible();
    }

    private void showInfoPanel(boolean show) {
        if (show == this.pnlInfoPanels.isVisible()) {
            return;
        }
        this.grdStadtbildserien.setVisible(false);
        this.grdBin.setVisible(false);
        this.grdWarenkorb.setVisible(false);
        this.pnlInfoPanels.setVisible(show);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Sb_stadtbildserieAggregationRenderer.this.grdStadtbildserien.setVisible(true);
                Sb_stadtbildserieAggregationRenderer.this.grdBin.setVisible(true);
                Sb_stadtbildserieAggregationRenderer.this.grdWarenkorb.setVisible(true);
                Sb_stadtbildserieAggregationRenderer.this.grdStadtbildserien.ensureIndexIsVisible(Sb_stadtbildserieAggregationRenderer.this.grdStadtbildserien.getSelectedIndex());
                Sb_stadtbildserieAggregationRenderer.this.grdBin.ensureIndexIsVisible(Sb_stadtbildserieAggregationRenderer.this.grdBin.getSelectedIndex());
            }
        });
    }

    private void reportVorauswahl() {
        JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

            public JRDataSource generateDataSource() {
                ArrayList<StadtbildReportBean> stadtbilderReportBeans = new ArrayList<StadtbildReportBean>();
                Enumeration e = ((DefaultListModel)Sb_stadtbildserieAggregationRenderer.this.grdStadtbildserien.getModel()).elements();
                while (e.hasMoreElements()) {
                    BufferedImage image;
                    Sb_stadtbildserieGridObject gridObject = (Sb_stadtbildserieGridObject)e.nextElement();
                    CidsBean stadtbildserie = gridObject.getCidsBean();
                    CidsBean stadtbild = (CidsBean)stadtbildserie.getProperty("vorschaubild");
                    boolean previewAllowed = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(stadtbildserie, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext()).isPreviewAllowed();
                    StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(stadtbildserie, stadtbild);
                    if (!previewAllowed) continue;
                    try {
                        image = StadtbilderUtils.downloadImageForBildnummer(stadtbildInfo);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Image could not be fetched.", (Throwable)ex);
                        image = StadtbilderUtils.ERROR_IMAGE;
                    }
                    stadtbilderReportBeans.add(new StadtbildReportBean(stadtbildserie, (CidsBean)stadtbildserie.getProperty("vorschaubild"), image));
                }
                JRBeanCollectionDataSource beanArray = new JRBeanCollectionDataSource(stadtbilderReportBeans);
                return beanArray;
            }
        };
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            String filename = "Stadtbilder_Serienauszug";
            String downloadTitle = "Stadtbilder Serienauszug";
            String resourceName = REPORT_STADTBILDVORSCHAU_URL;
            JasperReportDownload download = new JasperReportDownload(REPORT_STADTBILDVORSCHAU_URL, dataSourceGenerator, jobname, "Stadtbilder Serienauszug", "Stadtbilder_Serienauszug");
            DownloadManager.instance().add((Download)download);
        }
    }

    private void reportWarenkorb() {
        if (this.getSelectedStadtbilderAmount() <= 0) {
            JOptionPane.showMessageDialog(this, "<html>Der Bericht kann nicht erstellt werden, wenn keine Stadtbilder ausgew\u00e4hlt wurden.</html>", "Keine Stadtbilder ausgew\u00e4hlt", 1);
            return;
        }
        JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

            public JRDataSource generateDataSource() {
                ArrayList<StadtbildReportBean> stadtbilderReportBeans = new ArrayList<StadtbildReportBean>();
                Enumeration e = ((DefaultListModel)Sb_stadtbildserieAggregationRenderer.this.grdStadtbildserien.getModel()).elements();
                while (e.hasMoreElements()) {
                    Sb_stadtbildserieGridObject gridObject = (Sb_stadtbildserieGridObject)e.nextElement();
                    CidsBean stadtbildserie = gridObject.getCidsBean();
                    Set<CidsBean> stadtbilder = gridObject.getSelectedBildnummernOfSerie();
                    boolean previewAllowed = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(stadtbildserie, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext()).isPreviewAllowed();
                    for (CidsBean stadtbild : stadtbilder) {
                        BufferedImage image;
                        StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(stadtbildserie, stadtbild);
                        if (previewAllowed) {
                            try {
                                image = StadtbilderUtils.downloadImageForBildnummer(stadtbildInfo);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Image could not be fetched.", (Throwable)ex);
                                image = StadtbilderUtils.ERROR_IMAGE;
                            }
                        } else {
                            image = StadtbilderUtils.ERROR_IMAGE;
                        }
                        stadtbilderReportBeans.add(new StadtbildReportBean(stadtbildserie, stadtbild, image));
                    }
                }
                JRBeanCollectionDataSource beanArray = new JRBeanCollectionDataSource(stadtbilderReportBeans);
                return beanArray;
            }
        };
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            String filename = "Stadtbilder_Einzelbilderauszug";
            String downloadTitle = "Stadtbilder Einzelbilderauszug";
            String resourceName = REPORT_STADTBILDSERIE_URL;
            JasperReportDownload download = new JasperReportDownload(REPORT_STADTBILDSERIE_URL, dataSourceGenerator, jobname, "Stadtbilder Einzelbilderauszug", "Stadtbilder_Einzelbilderauszug");
            DownloadManager.instance().add((Download)download);
        }
    }

    private void lblSwitchToSerieMouseClicked(MouseEvent evt) {
        this.switchToSerie();
    }

    private void lblSwitchToBinMouseClicked(MouseEvent evt) {
        this.switchToBin();
    }

    private void lblMiddleMouseClicked(MouseEvent evt) {
        this.switchToWarenkorb();
    }

    private void btnRemoveWarenkorbActionPerformed(ActionEvent evt) {
        ((Sb_SingleStadtbildJGrid)this.grdWarenkorb).unchoseStadtbilderSelectedInTheGrid();
        this.grdWarenkorb.getSelectionModel().clearSelection();
    }

    private void downladVorauswahl() {
        String jobname = DownloadManagerDialog.getInstance().getJobName();
        Object[] gridObjectArr = new Sb_stadtbildserieGridObject[this.grdStadtbildserien.getModel().getSize()];
        ((DefaultListModel)this.grdStadtbildserien.getModel()).copyInto(gridObjectArr);
        new SwingWorker<Void, Void>((Sb_stadtbildserieGridObject[])gridObjectArr, jobname){
            final ArrayList<Download> downloads = new ArrayList();
            final /* synthetic */ Sb_stadtbildserieGridObject[] val$gridObjectArr;
            final /* synthetic */ String val$jobname;
            {
                this.val$gridObjectArr = sb_stadtbildserieGridObjectArray;
                this.val$jobname = string;
            }

            @Override
            protected Void doInBackground() throws Exception {
                for (Sb_stadtbildserieGridObject gridObject : this.val$gridObjectArr) {
                    CidsBean stadtbildserie = gridObject.getCidsBean();
                    boolean downloadAllowed = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(stadtbildserie, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext()).isDownloadAllowed();
                    if (!downloadAllowed) continue;
                    CidsBean stadtbild = (CidsBean)gridObject.getStadtbildserie().getProperty("vorschaubild");
                    StadtbilderUtils.StadtbildInfo stadtbildInfo = gridObject.getStadtbildInfo();
                    if (StadtbilderUtils.getFormatOfHighResPicture(stadtbildInfo) == null) continue;
                    String imageNumber = stadtbildInfo.getBildnummer();
                    this.downloads.add((Download)new TifferDownload(this.val$jobname, "Stadtbild " + imageNumber, "stadtbild_" + imageNumber, stadtbildInfo, "1", Sb_stadtbildserieAggregationRenderer.this.getConnectionContext()));
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    int amountDownloads = this.downloads.size();
                    if (BillingPopup.doBilling("stb", "not.yet", (Geometry)null, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext(), new BillingProductGroupAmount("ea", amountDownloads)) && DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)Sb_stadtbildserieAggregationRenderer.this)) {
                        if (amountDownloads == 1) {
                            DownloadManager.instance().add(this.downloads.get(0));
                        } else if (amountDownloads > 1) {
                            DownloadManager.instance().add((Download)new MultipleDownload(this.downloads, "Vorschau Stadtbilder"));
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error when trying to download the high res image(s)", (Throwable)ex);
                }
            }
        }.execute();
    }

    private void downladWarenkorb() {
        String jobname = DownloadManagerDialog.getInstance().getJobName();
        Object[] gridObjectArr = new Sb_stadtbildserieGridObject[this.grdStadtbildserien.getModel().getSize()];
        ((DefaultListModel)this.grdStadtbildserien.getModel()).copyInto(gridObjectArr);
        new SwingWorker<Void, Void>((Sb_stadtbildserieGridObject[])gridObjectArr, jobname){
            final ArrayList<Download> downloads = new ArrayList();
            final /* synthetic */ Sb_stadtbildserieGridObject[] val$gridObjectArr;
            final /* synthetic */ String val$jobname;
            {
                this.val$gridObjectArr = sb_stadtbildserieGridObjectArray;
                this.val$jobname = string;
            }

            @Override
            protected Void doInBackground() throws Exception {
                for (Sb_stadtbildserieGridObject gridObject : this.val$gridObjectArr) {
                    CidsBean stadtbildserie = gridObject.getCidsBean();
                    boolean downloadAllowed = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(stadtbildserie, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext()).isDownloadAllowed();
                    if (!downloadAllowed) continue;
                    for (CidsBean stadtbild : gridObject.getSelectedBildnummernOfSerie()) {
                        StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(stadtbildserie, stadtbild);
                        if (StadtbilderUtils.getFormatOfHighResPicture(stadtbildInfo) == null) continue;
                        String imageNumber = (String)stadtbild.getProperty("bildnummer");
                        this.downloads.add((Download)new TifferDownload(this.val$jobname, "Stadtbild " + imageNumber, "stadtbild_" + imageNumber, stadtbildInfo, "1", Sb_stadtbildserieAggregationRenderer.this.getConnectionContext()));
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    int amountDownloads = this.downloads.size();
                    if (BillingPopup.doBilling("stb", "not.yet", (Geometry)null, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext(), new BillingProductGroupAmount("ea", amountDownloads)) && DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)Sb_stadtbildserieAggregationRenderer.this)) {
                        if (amountDownloads == 1) {
                            DownloadManager.instance().add(this.downloads.get(0));
                        } else if (amountDownloads > 1) {
                            DownloadManager.instance().add((Download)new MultipleDownload(this.downloads, "Ausgew\u00e4hlte Stadtbilder"));
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error when trying to download the high res image(s)", (Throwable)ex);
                }
            }
        }.execute();
    }

    private void btnMoveSerienToWarenkorbActionPerformed(ActionEvent evt) {
        List selectedStadtbildserien = this.grdStadtbildserien.getSelectedValuesList();
        for (Sb_stadtbildserieGridObject stadtbildserie : selectedStadtbildserien) {
            stadtbildserie.selecteAllStadtbilder(false);
            ((Sb_SingleStadtbildJGrid)this.grdWarenkorb).addStadtbilder(stadtbildserie.getSelectedBildnummernOfSerie(), stadtbildserie);
        }
        this.updateFooterLabels();
        this.setEnableHighResDownload();
        this.warenkorbReportAction.setEnabled(this.getSelectedStadtbilderAmount() > 0);
    }

    private void switchToSerie() {
        CardLayout cardLayout = (CardLayout)this.pnlLeuchtkasten.getLayout();
        cardLayout.show(this.pnlLeuchtkasten, "SERIEN");
        this.lblSwitchToSerie.setEnabled(false);
        this.lblSwitchToBin.setEnabled(true);
        this.lblMiddle.setEnabled(true);
        ((PictureSelectionJGrid)this.grdStadtbildserien).updateInfoPanel();
        this.btnBin.setVisible(true);
        this.btnBinRecycle.setVisible(false);
        this.btnRemoveWarenkorb.setVisible(false);
        this.tbtnSlide.setEnabled(true);
        this.showInfoPanel(this.wasInfoPanelVisibleBeforeSwitch);
        this.btnMoveSerienToWarenkorb.setVisible(true);
        this.lblSubtitle.setText("Vorauswahl");
        this.btnDownloadHighResImage.setAction(this.vorauswahlDownloadAction);
        this.btnReport.setAction(this.vorauswahlReportAction);
        this.btnReport.setVisible(true);
        this.btnDownloadHighResImage.setVisible(true);
    }

    private void switchToBin() {
        CardLayout cardLayout = (CardLayout)this.pnlLeuchtkasten.getLayout();
        cardLayout.show(this.pnlLeuchtkasten, "BIN");
        this.lblSwitchToSerie.setEnabled(true);
        this.lblSwitchToBin.setEnabled(false);
        this.lblMiddle.setEnabled(true);
        ((PictureSelectionJGrid)this.grdBin).updateInfoPanel();
        this.btnBin.setVisible(false);
        this.btnBinRecycle.setVisible(true);
        this.btnRemoveWarenkorb.setVisible(false);
        this.tbtnSlide.setEnabled(true);
        this.showInfoPanel(this.wasInfoPanelVisibleBeforeSwitch);
        this.btnMoveSerienToWarenkorb.setVisible(false);
        this.lblSubtitle.setText("Papierkorb");
        this.btnReport.setAction(null);
        this.btnDownloadHighResImage.setAction(null);
        this.btnReport.setVisible(false);
        this.btnDownloadHighResImage.setVisible(false);
    }

    private void switchToWarenkorb() {
        CardLayout cardLayout = (CardLayout)this.pnlLeuchtkasten.getLayout();
        cardLayout.show(this.pnlLeuchtkasten, "WARENKORB");
        this.lblSwitchToSerie.setEnabled(true);
        this.lblSwitchToBin.setEnabled(true);
        this.lblMiddle.setEnabled(false);
        ((PictureSelectionJGrid)this.grdBin).updateInfoPanel();
        this.btnBin.setVisible(false);
        this.btnBinRecycle.setVisible(false);
        this.btnRemoveWarenkorb.setVisible(true);
        this.tbtnSlide.setEnabled(false);
        this.wasInfoPanelVisibleBeforeSwitch = this.pnlInfoPanels.isVisible();
        this.showInfoPanel(false);
        this.btnMoveSerienToWarenkorb.setVisible(false);
        this.lblSubtitle.setText("Warenkorb");
        this.btnDownloadHighResImage.setAction(this.warenkorbDownloadAction);
        this.btnReport.setAction(this.warenkorbReportAction);
        this.btnReport.setVisible(true);
        this.btnDownloadHighResImage.setVisible(true);
        this.refreshWarenkorbDownloadAction();
    }

    private void moveSelectedStadtbildserienToOtherGrid(JGrid from, JGrid to) {
        List gridObjectsToRemove = from.getSelectedValuesList();
        boolean movedToBin = to == this.grdBin;
        for (Sb_stadtbildserieGridObject gridObject : gridObjectsToRemove) {
            ((DefaultListModel)from.getModel()).removeElement(gridObject);
            ((DefaultListModel)to.getModel()).addElement(gridObject);
            gridObject.setModel((DefaultListModel)to.getModel());
            gridObject.setIsInBin(movedToBin);
        }
        from.getSelectionModel().clearSelection();
        this.updateFooterLabels();
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public void setCidsBeans(Collection<CidsBean> beans) {
        this.cidsBeans = beans;
        if (beans != null) {
            this.infoPanel.setAggregationRenderer(this);
            DefaultListModel model = (DefaultListModel)this.grdStadtbildserien.getModel();
            for (CidsBean bean : beans) {
                Sb_stadtbildserieGridObject gridObject = new Sb_stadtbildserieGridObject(model, this.getConnectionContext());
                gridObject.setCidsBean(bean);
                gridObject.addStadtbildChosenListener((Sb_stadtbildserieGridObjectListener)this.grdWarenkorb);
                gridObject.addStadtbildChosenListener(this.infoPanel);
                gridObject.addStadtbildChosenListener(this);
                model.addElement(gridObject);
                StadtbilderUtils.cacheImagesForStadtbilder(bean, bean.getBeanCollectionProperty("stadtbilder_arr"), this.getConnectionContext());
            }
            this.updateFooterLabels();
            this.setTitle("");
            this.checkHighResVorschaubilder();
        }
    }

    public void dispose() {
    }

    public String getTitle() {
        return "Leuchtkasten";
    }

    public void setTitle(String title) {
        title = "Leuchtkasten";
        if (this.cidsBeans != null && !this.cidsBeans.isEmpty()) {
            int amountSerien = this.cidsBeans.size();
            int amountBilder = 0;
            for (CidsBean stadtbildserie : this.cidsBeans) {
                amountBilder += stadtbildserie.getBeanCollectionProperty("stadtbilder_arr").size();
            }
            title = title + ": " + amountBilder + " Stadtbilder in " + amountSerien + " Stadtbildserien gefunden";
        }
        this.lblTitle.setText(title);
    }

    public static void main(String[] args) {
        try {
            CidsBean[] beans = DevelopmentTools.createCidsBeansFromRMIConnectionOnLocalhost((String)DOMAIN, (String)"Administratoren", (String)"admin", (String)"kif", (String)"sb_stadtbildserie", (String)" id = 5 or id = 6 or id = 285195 or id = 8 or id = 9 or id = 10 or id = 11 or  id = 285198 or id = 151489 ", (int)10);
            DevelopmentTools.createAggregationRendererInFrameFromRMIConnectionOnLocalhost(Arrays.asList(beans), (String)"Leuchtkasten", (int)1024, (int)800);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    private void updateFooterLabels() {
        String stadtbildserien = "Vorauswahl (" + this.grdStadtbildserien.getModel().getSize() + " Serien)";
        this.lblSwitchToSerie.setText(stadtbildserien);
        String warenkorbText = "Warenkorb (" + this.getSelectedStadtbilderAmount() + " Bilder)";
        this.lblMiddle.setText(warenkorbText);
        int amountSerienInBin = this.grdBin.getModel().getSize();
        String bin = "Papierkorb (" + amountSerienInBin + " Serien)";
        if (amountSerienInBin == 0) {
            this.btnBin.setIcon(BIN_EMPTY);
        } else {
            this.btnBin.setIcon(BIN_FULL);
        }
        this.lblSwitchToBin.setText(bin);
    }

    private int getSelectedStadtbilderAmount() {
        return this.getSelectedStadtbilder().size();
    }

    private Collection<CidsBean> getSelectedStadtbilder() {
        HashSet<CidsBean> selectedStadtbilder = new HashSet<CidsBean>();
        Enumeration e = ((DefaultListModel)this.grdStadtbildserien.getModel()).elements();
        while (e.hasMoreElements()) {
            Sb_stadtbildserieGridObject gridObject = (Sb_stadtbildserieGridObject)e.nextElement();
            Set<CidsBean> set = gridObject.getSelectedBildnummernOfSerie();
            selectedStadtbilder.addAll(set);
        }
        return selectedStadtbilder;
    }

    private void checkHighResVorschaubilder() {
        this.vorschauStadtbilder.clear();
        Enumeration e = ((DefaultListModel)this.grdStadtbildserien.getModel()).elements();
        while (e.hasMoreElements()) {
            Sb_stadtbildserieGridObject gridObject = (Sb_stadtbildserieGridObject)e.nextElement();
            CidsBean stadtbildserie = gridObject.getCidsBean();
            CidsBean vorschauBild = (CidsBean)stadtbildserie.getProperty("vorschaubild");
            this.vorschauStadtbilder.add((String)vorschauBild.getProperty("bildnummer"));
            this.checkHighResDownloadAvailable(vorschauBild);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateFooterLabels();
    }

    @Override
    public void stadtbildChosen(Sb_stadtbildserieGridObject source, CidsBean stadtbild) {
        String imageNumber = (String)stadtbild.getProperty("bildnummer");
        this.selectedStadtbilder.add(imageNumber);
        if (!this.highResStadtbilder.contains(imageNumber)) {
            this.warenkorbDownloadAction.putValue("ShortDescription", Sb_stadtbildserieAggregationRenderer.createAnzahlHighResBilderTooltipText(-1, "dem Warenkorb"));
            this.checkHighResDownloadAvailable(stadtbild);
        }
        this.warenkorbReportAction.setEnabled(this.getSelectedStadtbilderAmount() > 0);
    }

    @Override
    public void stadtbildUnchosen(Sb_stadtbildserieGridObject source, CidsBean stadtbild) {
        String imageNumber = (String)stadtbild.getProperty("bildnummer");
        if (this.selectedStadtbilder.contains(imageNumber)) {
            this.selectedStadtbilder.remove(imageNumber);
        }
        this.refreshWarenkorbDownloadAction();
        this.warenkorbReportAction.setEnabled(this.getSelectedStadtbilderAmount() > 0);
    }

    @Override
    public void sb_stadtbildserieGridObjectMoveToBin(Sb_stadtbildserieGridObject source) {
        this.setEnableHighResDownload();
        this.refreshWarenkorbDownloadAction();
    }

    @Override
    public void sb_stadtbildserieGridObjectRemovedFromBin(Sb_stadtbildserieGridObject source) {
        this.setEnableHighResDownload();
        this.warenkorbReportAction.setEnabled(this.getSelectedStadtbilderAmount() > 0);
    }

    private void checkHighResDownloadAvailable(CidsBean stadtbild, CidsBean stadtbildSerie) {
        highResAvailableThreadPool.submit(new HighResDownloadChecker(stadtbild, stadtbildSerie));
    }

    private void checkHighResDownloadAvailable(CidsBean stadtbild) {
        this.checkHighResDownloadAvailable(stadtbild, null);
    }

    private void setEnableHighResDownload() {
        Object[] gridObjectArr = new Sb_stadtbildserieGridObject[this.grdStadtbildserien.getModel().getSize()];
        ((DefaultListModel)this.grdStadtbildserien.getModel()).copyInto(gridObjectArr);
        this.warenkorbDownloadAction.setEnabled(false);
        for (Object gridObject : gridObjectArr) {
            CidsBean stadtbildserie = ((Sb_stadtbildserieGridObject)gridObject).getCidsBean();
            for (CidsBean stadtbild : ((Sb_stadtbildserieGridObject)gridObject).getSelectedBildnummernOfSerie()) {
                this.checkHighResDownloadAvailable(stadtbild, stadtbildserie);
            }
        }
    }

    private int countAnzahlVorauswahlInHighRes() {
        int count = 0;
        for (String bildnummer : this.vorschauStadtbilder) {
            if (!this.highResStadtbilder.contains(bildnummer)) continue;
            ++count;
        }
        return count;
    }

    private int countAnzahlWarenkorbInHighRes() {
        int count = 0;
        for (CidsBean selectedStadtbild : this.getSelectedStadtbilder()) {
            if (!this.highResStadtbilder.contains((String)selectedStadtbild.getProperty("bildnummer"))) continue;
            ++count;
        }
        return count;
    }

    private void refreshVorauswahlDownloadAction() {
        int countAnzahlVorauswahlInHighRes = this.countAnzahlVorauswahlInHighRes();
        this.vorauswahlDownloadAction.setEnabled(countAnzahlVorauswahlInHighRes > 0);
        this.vorauswahlDownloadAction.putValue("ShortDescription", Sb_stadtbildserieAggregationRenderer.createAnzahlHighResBilderTooltipText(countAnzahlVorauswahlInHighRes, "der Vorauswahl"));
    }

    private void refreshWarenkorbDownloadAction() {
        int countAnzahlWarenkorbInHighRes = this.countAnzahlWarenkorbInHighRes();
        this.warenkorbDownloadAction.setEnabled(countAnzahlWarenkorbInHighRes > 0);
        this.warenkorbDownloadAction.putValue("ShortDescription", Sb_stadtbildserieAggregationRenderer.createAnzahlHighResBilderTooltipText(countAnzahlWarenkorbInHighRes, "dem Warenkorb"));
    }

    private static String createAnzahlHighResBilderTooltipText(int anzahlBilder, String fillText) {
        String tooltipText = anzahlBilder < 0 ? "Verf\u00fcgbare Bilder aus " + fillText + " herunterladen (Anzahl wird ermittelt...)" : (anzahlBilder == 0 ? "Keine verf\u00fcgbaren Bilder in " + fillText : (anzahlBilder == 1 ? "1 verf\u00fcgbares Bild aus " + fillText + " herunterladen" : anzahlBilder + " verf\u00fcgbare Bilder aus " + fillText + " herunterladen"));
        return tooltipText;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static class StadtbildReportBean {
        CidsBean stadtbildserie;
        CidsBean stadtbild;
        Image image;

        public StadtbildReportBean(CidsBean stadtbildserie, CidsBean stadtbild, Image image) {
            this.stadtbildserie = stadtbildserie;
            this.stadtbild = stadtbild;
            this.image = image;
        }

        public CidsBean getStadtbildserie() {
            return this.stadtbildserie;
        }

        public void setStadtbildserie(CidsBean stadtbildserie) {
            this.stadtbildserie = stadtbildserie;
        }

        public CidsBean getStadtbild() {
            return this.stadtbild;
        }

        public void setStadtbild(CidsBean stadtbild) {
            this.stadtbild = stadtbild;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public String getStrasse() {
            return (String)this.stadtbildserie.getProperty("strasse.name");
        }

        public String getHausnummer() {
            return (String)this.stadtbildserie.getProperty("hausnummer");
        }

        public String getAnzahlBilder() {
            return Integer.toString(this.stadtbildserie.getBeanCollectionProperty("stadtbilder_arr").size());
        }

        public String getAnzahlBilderWeitere() {
            int anzBilder = this.stadtbildserie.getBeanCollectionProperty("stadtbilder_arr").size();
            int anzBilderWeitere = anzBilder > 0 ? anzBilder - 1 : 0;
            return Integer.toString(anzBilderWeitere);
        }
    }

    private class PictureSelectionJGrid
    extends JGrid {
        public PictureSelectionJGrid() {
            this.init();
        }

        public PictureSelectionJGrid(ListModel model) throws IllegalArgumentException {
            super(model);
            this.init();
        }

        private void init() {
            DefaultListModel gridModel = new DefaultListModel();
            this.setModel(gridModel);
            this.getCellRendererManager().setDefaultRenderer((GridCellRenderer)new Sb_stadtbildserieGridRenderer());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    List selectedSerien;
                    if (e.getClickCount() >= 2 && (selectedSerien = PictureSelectionJGrid.this.getSelectedValuesList()).size() == 1) {
                        Sb_stadtbildserieGridObject gridObject = (Sb_stadtbildserieGridObject)selectedSerien.get(0);
                        gridObject.selectOrDeselectStadtbild(gridObject.getStadtbildUnderMarker());
                    }
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){
                int hoveredSerieIndex = -1;

                @Override
                public void mouseMoved(MouseEvent e) {
                    int index = PictureSelectionJGrid.this.getCellAt(e.getPoint());
                    if (index >= 0) {
                        this.hoveredSerieIndex = index;
                    } else {
                        Object o;
                        if (this.hoveredSerieIndex >= 0 && (o = PictureSelectionJGrid.this.getModel().getElementAt(this.hoveredSerieIndex)) instanceof Sb_stadtbildserieGridObject) {
                            Sb_stadtbildserieGridObject hoveredSerie = (Sb_stadtbildserieGridObject)o;
                            hoveredSerie.setFraction(0.0f);
                        }
                        this.hoveredSerieIndex = -1;
                    }
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){
                int lastIndex = -1;

                @Override
                public void mouseMoved(MouseEvent e) {
                    Rectangle r;
                    Object o;
                    int index;
                    Rectangle r2;
                    Object o2;
                    if (this.lastIndex >= 0 && this.lastIndex < PictureSelectionJGrid.this.getModel().getSize() && (o2 = PictureSelectionJGrid.this.getModel().getElementAt(this.lastIndex)) instanceof Sb_stadtbildserieGridObject && (r2 = PictureSelectionJGrid.this.getCellBounds(this.lastIndex)) != null && !r2.contains(e.getPoint()) && ((Sb_stadtbildserieGridObject)o2).isMarker()) {
                        ((Sb_stadtbildserieGridObject)o2).setMarker(false);
                        PictureSelectionJGrid.this.repaint(r2);
                    }
                    if ((index = PictureSelectionJGrid.this.getCellAt(e.getPoint())) >= 0 && (o = PictureSelectionJGrid.this.getModel().getElementAt(index)) instanceof Sb_stadtbildserieGridObject && ((Sb_stadtbildserieGridObject)o).getAmountImages() > 1 && (r = PictureSelectionJGrid.this.getCellBounds(index)) != null) {
                        ((Sb_stadtbildserieGridObject)o).setFraction(((float)e.getPoint().x - (float)r.x) / (float)r.width);
                        ((Sb_stadtbildserieGridObject)o).setMarker(true);
                        this.lastIndex = index;
                        PictureSelectionJGrid.this.repaint(r);
                    }
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        PictureSelectionJGrid.this.updateInfoPanel();
                        this.reloadIfImageWithError();
                    }
                }

                private void reloadIfImageWithError() {
                    Sb_stadtbildserieGridObject gridObject;
                    StadtbilderUtils.StadtbildInfo stadtbildInfo;
                    List selectedObject = PictureSelectionJGrid.this.getSelectedValuesList();
                    if (selectedObject.size() == 1 && StadtbilderUtils.isBildnummerInFailedSet(stadtbildInfo = (gridObject = (Sb_stadtbildserieGridObject)selectedObject.get(0)).getStadtbildInfo())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("The image " + stadtbildInfo.getBildnummer() + " could not be loaded the last time because:\n" + StadtbilderUtils.getErrorMessageForFailedImage(stadtbildInfo)));
                        }
                        StadtbilderUtils.removeBildnummerFromFailedSet(stadtbildInfo);
                        gridObject.clearLastShownImage();
                    }
                }
            });
        }

        public void updateInfoPanel() {
            int[] indexes = new int[]{};
            ListSelectionModel sm = this.getSelectionModel();
            int iMin = sm.getMinSelectionIndex();
            int iMax = sm.getMaxSelectionIndex();
            if (iMin >= 0 && iMin == iMax) {
                indexes = new int[]{iMin};
            }
            CardLayout cardLayout = (CardLayout)Sb_stadtbildserieAggregationRenderer.this.pnlInfoPanels.getLayout();
            if (indexes.length == 1) {
                cardLayout.show(Sb_stadtbildserieAggregationRenderer.this.pnlInfoPanels, "INFO");
                Sb_stadtbildserieGridObject gridObject = (Sb_stadtbildserieGridObject)this.getModel().getElementAt(indexes[0]);
                Sb_stadtbildserieAggregationRenderer.this.infoPanel.setGridObject(gridObject);
            } else {
                cardLayout.show(Sb_stadtbildserieAggregationRenderer.this.pnlInfoPanels, "NO_INFO");
            }
        }
    }

    private class HighResDownloadChecker
    extends SwingWorker<Boolean, Void> {
        private CidsBean stadtbild;
        private CidsBean stadtbildSerie;

        public HighResDownloadChecker(CidsBean stadtbild, CidsBean stadtbildSerie) {
            this.stadtbild = stadtbild;
            this.stadtbildSerie = stadtbildSerie;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            boolean downloadAllowed;
            if (this.stadtbildSerie == null) {
                MetaClass mc = ClassCacheMultiple.getMetaClass((String)Sb_stadtbildserieAggregationRenderer.DOMAIN, (String)"sb_serie_bild_array", (ConnectionContext)Sb_stadtbildserieAggregationRenderer.this.getConnectionContext());
                String query = "SELECT " + mc.getID() + ", sb_serie_bild_array." + mc.getPrimaryKey() + " FROM " + mc.getTableName() + " WHERE  stadtbild= " + this.stadtbild.getProperty("id").toString();
                try {
                    MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext());
                    CidsBean array = metaObjects[0].getBean();
                    MetaClass mcSerie = ClassCacheMultiple.getMetaClass((String)Sb_stadtbildserieAggregationRenderer.DOMAIN, (String)"sb_stadtbildserie", (ConnectionContext)Sb_stadtbildserieAggregationRenderer.this.getConnectionContext());
                    query = "SELECT " + mcSerie.getID() + ",sb_stadtbildserie." + mcSerie.getPrimaryKey() + " FROM " + mcSerie.getTableName() + " WHERE  id= " + array.getProperty("sb_stadtbildserie_reference").toString();
                    MetaObject[] serieMetaObjects = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext());
                    this.stadtbildSerie = serieMetaObjects[0].getBean();
                }
                catch (ConnectionException ex) {
                    LOG.error((Object)("Could not determine the Stadtbildserie of Stadtbild " + this.stadtbild.toString()), (Throwable)ex);
                    return false;
                }
            }
            if ((downloadAllowed = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(this.stadtbildSerie, Sb_stadtbildserieAggregationRenderer.this.getConnectionContext()).isDownloadAllowed()) && StadtbilderUtils.getFormatOfHighResPicture(new StadtbilderUtils.StadtbildInfo(this.stadtbildSerie, this.stadtbild)) != null) {
                return true;
            }
            return false;
        }

        @Override
        protected void done() {
            try {
                boolean highResDownloadAvailable = (Boolean)this.get();
                String imageNumber = (String)this.stadtbild.getProperty("bildnummer");
                if (highResDownloadAvailable) {
                    Sb_stadtbildserieAggregationRenderer.this.highResStadtbilder.add(imageNumber);
                } else if (Sb_stadtbildserieAggregationRenderer.this.highResStadtbilder.contains(imageNumber)) {
                    Sb_stadtbildserieAggregationRenderer.this.highResStadtbilder.remove(imageNumber);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (CancellationException ex) {
                return;
            }
            Sb_stadtbildserieAggregationRenderer.this.refreshVorauswahlDownloadAction();
            Sb_stadtbildserieAggregationRenderer.this.refreshWarenkorbDownloadAction();
        }
    }
}

