/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_AbstractPictureGridObject;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridObjectListener;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.swing.DefaultListModel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class Sb_stadtbildserieGridObject
extends Sb_AbstractPictureGridObject
implements CidsBeanStore {
    private static final Logger LOG = Logger.getLogger(Sb_stadtbildserieGridObject.class);
    private static final ExecutorService bulletPointFetcherThreadPool = CismetExecutors.newFixedThreadPool((int)20);
    private CidsBean stadtbildserie;
    private float fraction;
    private int index;
    private int amountImages = 1;
    private boolean marker;
    private DefaultListModel gridModel;
    private List<Sb_stadtbildserieGridObjectListener> stadtbildChosenListeners = new ArrayList<Sb_stadtbildserieGridObjectListener>();
    private final HashSet<CidsBean> selectedBildnummernOfSerie = new HashSet();
    private boolean isInBin = false;
    private List<CidsBean> imagesToShow;
    private Sb_RestrictionLevelUtils.BulletPointSettings bulletPointSettings = null;

    public Sb_stadtbildserieGridObject(DefaultListModel model, ConnectionContext connectionContext) {
        super(connectionContext);
        this.gridModel = model;
    }

    public CidsBean getCidsBean() {
        return this.stadtbildserie;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.stadtbildserie = cidsBean;
        this.imagesToShow = this.stadtbildserie.getBeanCollectionProperty("stadtbilder_arr");
        this.amountImages = !this.imagesToShow.isEmpty() ? this.imagesToShow.size() : 1;
    }

    @Override
    public CidsBean getStadtbildserie() {
        return this.stadtbildserie;
    }

    public CidsBean getStadtbildUnderMarker() {
        CidsBean stadtbild;
        if (!this.imagesToShow.isEmpty() && this.index < this.imagesToShow.size() && this.index != 0) {
            stadtbild = this.imagesToShow.get(this.index);
            if (stadtbild.equals((Object)((CidsBean)this.stadtbildserie.getProperty("vorschaubild")))) {
                stadtbild = this.imagesToShow.get(0);
            }
        } else {
            stadtbild = (CidsBean)this.stadtbildserie.getProperty("vorschaubild");
        }
        return stadtbild;
    }

    public void setMarker(boolean marker) {
        if (marker) {
            StadtbilderUtils.cacheImagesForStadtbilder(this.getStadtbildserie(), this.imagesToShow, this.getConnectionContext());
        }
        this.marker = marker;
    }

    public boolean isMarker() {
        return this.marker;
    }

    public boolean isIsInBin() {
        return this.isInBin;
    }

    public void setIsInBin(boolean isInBin) {
        this.isInBin = isInBin;
        if (isInBin) {
            this.fireMovedToBin();
        } else {
            this.fireRemovedFromBin();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public float getFraction() {
        return this.fraction;
    }

    public void setFraction(float fraction) {
        this.fraction = Math.max(0.0f, Math.min(1.0f, fraction));
        this.index = (int)(this.fraction * (float)this.amountImages);
    }

    public int getAmountImages() {
        return this.amountImages;
    }

    public int getAmountSelectedImages() {
        return this.selectedBildnummernOfSerie.size();
    }

    public Set<CidsBean> getSelectedBildnummernOfSerie() {
        return this.selectedBildnummernOfSerie;
    }

    public void selectAllStadtbilder() {
        this.selecteAllStadtbilder(true);
    }

    public void selecteAllStadtbilder(boolean fireEvents) {
        for (CidsBean stadtbild : this.imagesToShow) {
            this.selectStadtbildOfSerie(stadtbild, fireEvents);
        }
    }

    public void deselectAllStadtbilder() {
        for (CidsBean stadtbild : this.imagesToShow) {
            this.deselectStadtbildOfSerie(stadtbild);
        }
    }

    public void selectStadtbildOfSerie(CidsBean bildnummer) {
        this.selectStadtbildOfSerie(bildnummer, true);
    }

    public void selectStadtbildOfSerie(CidsBean bildnummer, boolean fireEvents) {
        boolean wasAdded;
        if (!this.isInBin && this.imagesToShow.contains(bildnummer) && (wasAdded = this.selectedBildnummernOfSerie.add(bildnummer)) && fireEvents) {
            this.fireStadtbildChosen(bildnummer);
            this.notifyModel();
        }
    }

    public void deselectStadtbildOfSerie(CidsBean bildnummer) {
        boolean wasRemoved;
        if (!this.isInBin && (wasRemoved = this.selectedBildnummernOfSerie.remove(bildnummer))) {
            this.fireStadtbildUnchosen(bildnummer);
            this.notifyModel();
        }
    }

    public boolean isStadtbildSelected(CidsBean bildnummer) {
        return this.selectedBildnummernOfSerie.contains(bildnummer);
    }

    public void selectOrDeselectStadtbild(CidsBean bildnummer) {
        if (this.selectedBildnummernOfSerie.contains(bildnummer)) {
            this.deselectStadtbildOfSerie(bildnummer);
        } else {
            this.selectStadtbildOfSerie(bildnummer);
        }
    }

    @Override
    protected StadtbilderUtils.StadtbildInfo getStadtbildInfo() {
        CidsBean stadtbild;
        if (!this.imagesToShow.isEmpty() && this.index < this.imagesToShow.size() && this.index != 0) {
            stadtbild = this.imagesToShow.get(this.index);
            if (stadtbild.equals(this.stadtbildserie.getProperty("vorschaubild"))) {
                stadtbild = this.imagesToShow.get(0);
            }
        } else {
            stadtbild = (CidsBean)this.stadtbildserie.getProperty("vorschaubild");
        }
        return new StadtbilderUtils.StadtbildInfo(this.stadtbildserie, stadtbild);
    }

    @Override
    protected int getDownloadPrority() {
        int priority = this.marker ? 1 : -1;
        return priority;
    }

    public List<CidsBean> getImagesToShow() {
        return this.imagesToShow;
    }

    public void setImagesToShow(List<CidsBean> imagesToShow) {
        this.imagesToShow = imagesToShow;
    }

    @Override
    protected void notifyModel() {
        this.gridModel.setElementAt(this, this.gridModel.indexOf(this));
    }

    public DefaultListModel getModel() {
        return this.gridModel;
    }

    public void setModel(DefaultListModel model) {
        this.gridModel = model;
    }

    public void sortImagesToShow(List<CidsBean> sortedStatdbilder) {
        if (sortedStatdbilder != null && !sortedStatdbilder.isEmpty()) {
            this.imagesToShow = sortedStatdbilder;
        } else {
            LOG.info((Object)"Sb_stadtbildserieGridObject.sortImagesToShow() got an empty list.");
            this.imagesToShow = this.imagesToShow = this.stadtbildserie.getBeanCollectionProperty("stadtbilder_arr");
        }
    }

    public void addStadtbildChosenListener(Sb_stadtbildserieGridObjectListener listener) {
        this.stadtbildChosenListeners.add(listener);
    }

    public void fireStadtbildChosen(CidsBean stadtbild) {
        for (Sb_stadtbildserieGridObjectListener listener : this.stadtbildChosenListeners) {
            listener.stadtbildChosen(this, stadtbild);
        }
    }

    public void fireStadtbildUnchosen(CidsBean stadtbild) {
        for (Sb_stadtbildserieGridObjectListener listener : this.stadtbildChosenListeners) {
            listener.stadtbildUnchosen(this, stadtbild);
        }
    }

    public void fireMovedToBin() {
        for (Sb_stadtbildserieGridObjectListener listener : this.stadtbildChosenListeners) {
            listener.sb_stadtbildserieGridObjectMoveToBin(this);
        }
    }

    public void fireRemovedFromBin() {
        for (Sb_stadtbildserieGridObjectListener listener : this.stadtbildChosenListeners) {
            listener.sb_stadtbildserieGridObjectRemovedFromBin(this);
        }
    }

    @Override
    protected boolean isPreviewAllowed() {
        return Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(this.stadtbildserie, this.getConnectionContext()).isPreviewAllowed();
    }

    public Sb_RestrictionLevelUtils.BulletPointSettings determineBulletPointColor() {
        if (this.bulletPointSettings != null) {
            return this.bulletPointSettings;
        }
        SwingWorker<Sb_RestrictionLevelUtils.BulletPointSettings, Void> worker = new SwingWorker<Sb_RestrictionLevelUtils.BulletPointSettings, Void>(){

            @Override
            protected Sb_RestrictionLevelUtils.BulletPointSettings doInBackground() throws Exception {
                return Sb_RestrictionLevelUtils.determineBulletPointAndInfoText(Sb_stadtbildserieGridObject.this.getCidsBean(), Sb_stadtbildserieGridObject.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    Sb_stadtbildserieGridObject.this.bulletPointSettings = (Sb_RestrictionLevelUtils.BulletPointSettings)this.get();
                    Sb_stadtbildserieGridObject.this.notifyModel();
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        };
        bulletPointFetcherThreadPool.submit(worker);
        return null;
    }
}

