/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.server.middleware.types.LightweightMetaObject;
import de.cismet.cids.custom.objectrenderer.wunda_blau.PoiTools;
import de.cismet.cids.dynamics.CidsBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class SignaturListCellRenderer
implements ListCellRenderer {
    private static final Logger log = Logger.getLogger(SignaturListCellRenderer.class);
    private static final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Font theFont = null;
        Color theForeground = null;
        ImageIcon theIcon = null;
        String theText = null;
        JLabel renderer = (JLabel)defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof CidsBean) {
            CidsBean bean = (CidsBean)value;
            String filename = String.valueOf(bean.getProperty("filename"));
            theIcon = PoiTools.createPoiIconFromFileName(filename);
        } else if (value instanceof LightweightMetaObject) {
            String filename = String.valueOf(((LightweightMetaObject)value).getLWAttribute("filename"));
            theIcon = PoiTools.createPoiIconFromFileName(filename);
        }
        theFont = list.getFont();
        theForeground = list.getForeground();
        theText = value == null ? "keine Signatur ausgew\u00e4hlt" : String.valueOf(value);
        if (!isSelected) {
            renderer.setForeground(theForeground);
        }
        if (theIcon != null) {
            renderer.setIcon(theIcon);
        }
        renderer.setText(theText);
        renderer.setFont(theFont);
        return renderer;
    }
}

