/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.custom.deprecated.JBreakLabel;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.graphics.ShadowRenderer;

public class WerbetraegerRenderer
extends JPanel
implements CidsBeanRenderer {
    private static final String TITLE = "Werbeanlagen";
    private static final Logger LOG = Logger.getLogger(WerbetraegerRenderer.class);
    private CidsBean cidsBean;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JXHyperlink jhxImage1;
    private JXHyperlink jhxImage2;
    private JLabel lblArt;
    private JLabel lblBez;
    private JLabel lblWerbung;
    private JPanel panContent;
    private DefaultPreviewMapPanel panPreviewMap;
    private BindingGroup bindingGroup;

    public WerbetraegerRenderer() {
        this.initComponents();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            this.panPreviewMap.initMap(cidsBean, "geometrie.geo_field");
            this.bindingGroup.bind();
            this.fetchImages();
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        String bezeichnung = (String)this.cidsBean.getProperty("bezeichnung");
        if (StringUtils.isNotBlank((String)bezeichnung)) {
            return "Werbeanlagen - " + bezeichnung;
        }
        return TITLE;
    }

    public void setTitle(String title) {
    }

    private void fetchImages() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Graphics2D rg;
                BufferedImage result;
                BufferedImage shadow;
                BufferedImage temp;
                ShadowRenderer renderer;
                String bezeichnung = (String)WerbetraegerRenderer.this.cidsBean.getProperty("bezeichnung");
                if (StringUtils.isBlank((String)bezeichnung)) {
                    WerbetraegerRenderer.this.jhxImage1.setVisible(false);
                    WerbetraegerRenderer.this.jhxImage2.setVisible(false);
                    LOG.error((Object)"The Werbetraeger does not have a name. The images can therefore not be loaded.");
                    return;
                }
                String urlA = "http://s10221/cismet/res/werbetafeln/200/t_" + bezeichnung + "a.JPG";
                String urlB = "http://s10221/cismet/res/werbetafeln/200/t_" + bezeichnung + "b.JPG";
                final String fullUrlA = "http://s10221/cismet/res/werbetafeln/" + bezeichnung + "a.JPG";
                final String fullUrlB = "http://s10221/cismet/res/werbetafeln/" + bezeichnung + "b.JPG";
                try {
                    ImageIcon a = new ImageIcon(new URL(urlA));
                    renderer = new ShadowRenderer(3, 0.5f, Color.BLACK);
                    temp = new BufferedImage(a.getIconWidth(), a.getIconHeight(), 6);
                    Graphics2D ag = temp.createGraphics();
                    ag.drawImage(a.getImage(), 0, 0, null);
                    ag.dispose();
                    shadow = renderer.createShadow(temp);
                    result = new BufferedImage(a.getIconWidth() + 6, a.getIconHeight() + 6, 6);
                    rg = result.createGraphics();
                    rg.drawImage((Image)shadow, 0, 0, null);
                    rg.drawImage((Image)temp, 0, 0, null);
                    rg.setColor(new Color(0, 0, 0, 120));
                    rg.drawRect(0, 0, a.getIconWidth(), a.getIconHeight());
                    rg.dispose();
                    shadow.flush();
                    final ImageIcon afinal = new ImageIcon(result);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WerbetraegerRenderer.this.jhxImage1.setIcon((Icon)afinal);
                            WerbetraegerRenderer.this.jhxImage1.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    try {
                                        BrowserLauncher.openURL((String)fullUrlA);
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)("Fehler beim \u00f6ffnen der URL \"" + fullUrlA + "\""), (Throwable)ex);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error((Object)("Konnte Werbetafel-Bild mit URL \"" + urlA + "\" nicht laden."), (Throwable)e);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WerbetraegerRenderer.this.jhxImage1.setVisible(false);
                        }
                    });
                }
                try {
                    ImageIcon b = new ImageIcon(new URL(urlB));
                    renderer = new ShadowRenderer(3, 0.5f, Color.BLACK);
                    temp = new BufferedImage(b.getIconWidth(), b.getIconHeight(), 6);
                    Graphics2D tg = temp.createGraphics();
                    tg.drawImage(b.getImage(), 0, 0, null);
                    tg.dispose();
                    shadow = renderer.createShadow(temp);
                    result = new BufferedImage(b.getIconWidth() + 6, b.getIconHeight() + 6, 6);
                    rg = result.createGraphics();
                    rg.drawImage((Image)shadow, 0, 0, null);
                    rg.drawImage((Image)temp, 0, 0, null);
                    rg.setColor(new Color(0, 0, 0, 120));
                    rg.drawRect(0, 0, b.getIconWidth(), b.getIconHeight());
                    rg.dispose();
                    shadow.flush();
                    final ImageIcon bfinal = new ImageIcon(result);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WerbetraegerRenderer.this.jhxImage2.setIcon((Icon)bfinal);
                            WerbetraegerRenderer.this.jhxImage2.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    try {
                                        BrowserLauncher.openURL((String)fullUrlB);
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)("Fehler beim \u00f6ffnen der URL \"" + fullUrlB + "\""), (Throwable)ex);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error((Object)("Konnte Werbetafel-Bild mit URL \"" + urlB + "\" nicht laden."), (Throwable)e);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WerbetraegerRenderer.this.jhxImage2.setVisible(false);
                        }
                    });
                }
            }
        });
        t.start();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.panContent = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblBez = new JLabel();
        this.lblWerbung = new JBreakLabel();
        this.jLabel3 = new JLabel();
        this.lblArt = new JLabel();
        this.jhxImage1 = new JXHyperlink();
        this.jhxImage2 = new JXHyperlink();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Bezeichnung:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 30);
        this.panContent.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("momentane Werbung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 30);
        this.panContent.add((Component)this.jLabel2, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bezeichnung}"), (Object)this.lblBez, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblBez, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.momentane_werbung}"), (Object)this.lblWerbung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblWerbung, gridBagConstraints);
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Art:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 30);
        this.panContent.add((Component)this.jLabel3, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.art.bezeichnung}"), (Object)this.lblArt, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panContent.add((Component)this.lblArt, gridBagConstraints);
        this.jhxImage1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/res/load.png")));
        this.jhxImage1.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 30);
        this.panContent.add((Component)this.jhxImage1, gridBagConstraints);
        this.jhxImage2.setIcon((Icon)new ImageIcon(this.getClass().getResource("/res/load.png")));
        this.jhxImage2.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        this.panContent.add((Component)this.jhxImage2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 30);
        this.jPanel1.add((Component)this.panContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 0, 10, 5);
        this.jPanel1.add((Component)this.panPreviewMap, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
        this.bindingGroup.bind();
    }
}

