/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.client.tools.ReportLookupButton;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.custom.wunda_blau.search.server.ZaehlungLastYearsSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.TitleComponentProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.Layer;
import org.openide.util.Exceptions;

public class ZaehlungsstandortRenderer
extends JPanel
implements CidsBeanRenderer,
TitleComponentProvider {
    public static final String FIELD__WETTER = "Wetter";
    public static final String FIELD__DATUM = "datum";
    public static final String FIELD__ANZAHL = "anzahl";
    public static final String FIELD__WETTER_WETTER = "wetter.wetter";
    public static final String FIELD__BEZIRK = "bezirk";
    public static final String FIELD__ZAEHLUNGEN = "zaehlungen";
    public static final String FIELD__GEO_FIELD = "georeferenz.geo_field";
    public static final String FIELD__STADTTEIL = "stadtteil.stadtteil";
    public static final String FIELD__STANDORT = "standort";
    public static final String AVG_TEXT = "Durchschnitt \u00d8";
    private static final Logger LOG = Logger.getLogger((String)"de.cismet.cids.objectrenderer.CoolPassantenfrequenzRenderer");
    private static final String SONNE = "sonne";
    private static final String LEICHTER_BEW = "leichter bewoelkt";
    private static final String LEICHT_BEW = "leicht bewoelkt";
    private static final String BEWOELKT = "bewoelkt";
    private static final String STARK_BEW = "stark bewoelkt";
    private static final String REGEN = "regen";
    private static final String GEWITTER = "gewitter";
    private static final String WECHSELHAFT = "wechselhaft";
    private static final String SCHNEE = "schnee";
    private static final String SCHNEE_WECHSEL = "schnee wechselhaft";
    private static final Color COLOR_MO = new Color(255, 255, 0);
    private static final Color COLOR_DI = new Color(255, 150, 0);
    private static final Color COLOR_MI = new Color(200, 0, 0);
    private static final Color COLOR_DO = new Color(180, 50, 180);
    private static final Color COLOR_FR = new Color(0, 0, 230);
    private static final Color COLOR_SA = new Color(0, 170, 0);
    private static final Color COLOR_SO = new Color(50, 50, 50);
    private static final Paint LIGHT_MO = new GradientPaint(0.0f, 0.0f, COLOR_MO, 0.0f, 0.0f, new Color(255, 255, 180));
    private static final Paint LIGHT_DI = new GradientPaint(0.0f, 0.0f, COLOR_DI, 0.0f, 0.0f, new Color(255, 220, 180));
    private static final Paint LIGHT_MI = new GradientPaint(0.0f, 0.0f, COLOR_MI, 0.0f, 0.0f, new Color(240, 175, 150));
    private static final Paint LIGHT_DO = new GradientPaint(0.0f, 0.0f, COLOR_DO, 0.0f, 0.0f, new Color(230, 190, 230));
    private static final Paint LIGHT_FR = new GradientPaint(0.0f, 0.0f, COLOR_FR, 0.0f, 0.0f, new Color(175, 175, 250));
    private static final Paint LIGHT_SA = new GradientPaint(0.0f, 0.0f, COLOR_SA, 0.0f, 0.0f, new Color(150, 210, 150));
    private static final Paint LIGHT_SO = new GradientPaint(0.0f, 0.0f, COLOR_SO, 0.0f, 0.0f, new Color(180, 180, 180));
    private static final String STRING_MO = "Mo";
    private static final String STRING_DI = "Tu";
    private static final String STRING_MI = "We";
    private static final String STRING_DO = "Th";
    private static final String STRING_FR = "Fr";
    private static final String STRING_SA = "Sa";
    private static final String STRING_SO = "Su";
    public static final String TITLE = "Passantenfrequenzz\u00e4hlung";
    private final TreeMap<String, int[]> jahresDurchschnitt = new TreeMap();
    private final ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)ZaehlungsstandortRenderer.class.getSimpleName());
    private CidsBean cidsBean;
    private final ZaehlungLastYearsSearch yearsSearch = new ZaehlungLastYearsSearch();
    private final ImageIcon ICON_SONNE = new ImageIcon(this.getClass().getResource("/res/16/sonne.png"));
    private final ImageIcon ICON_LEICHTER_BEW = new ImageIcon(this.getClass().getResource("/res/16/leichter_bew.png"));
    private final ImageIcon ICON_LEICHT_BEW = new ImageIcon(this.getClass().getResource("/res/16/leicht_bew.png"));
    private final ImageIcon ICON_BEWOELKT = new ImageIcon(this.getClass().getResource("/res/16/bewoelkt.png"));
    private final ImageIcon ICON_STARK_BEW = new ImageIcon(this.getClass().getResource("/res/16/stark_bewoelkt.png"));
    private final ImageIcon ICON_REGEN = new ImageIcon(this.getClass().getResource("/res/16/regen.png"));
    private final ImageIcon ICON_GEWITTER = new ImageIcon(this.getClass().getResource("/res/16/gewitter.png"));
    private final ImageIcon ICON_WECHSELHAFT = new ImageIcon(this.getClass().getResource("/res/16/wechselhaft.png"));
    private final ImageIcon ICON_SCHNEE = new ImageIcon(this.getClass().getResource("/res/16/schnee.png"));
    private final ImageIcon ICON_SCHNEE_WECHSEL = new ImageIcon(this.getClass().getResource("/res/16/schnee_wechsel.png"));
    private final ArrayList<String> colNames = new ArrayList();
    private final ArrayList<String> colNamesJahr = new ArrayList();
    private DefaultCategoryDataset dataset;
    private DefaultCategoryDataset datasetJahr;
    private ButtonGroup buttonGroup1;
    private JButton cmdPrint;
    private Box.Filler filler1;
    private JLabel jLabel10;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel24;
    private JPanel jPanel25;
    private JPanel jPanel26;
    private JPanel jPanel27;
    private JPanel jPanel28;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelDaten;
    private JPanel jPanelDaten1;
    private JPanel jPanelDaten2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    JTabbedPane jTabbedPane;
    private JLabel lblChartAlle;
    private JLabel lblChartJahre;
    private JLabel lblChartLetzte;
    private JLabel lblTitle;
    private JPanel panInhalt;
    private JPanel panInhalt1;
    private JPanel panInhalt2;
    private JPanel panLegend;
    private JPanel panLegend2;
    private DefaultPreviewMapPanel panMapPreview;
    private JPanel panTitle;
    private JPanel pnlCard1;
    private JTable tabFrequenzenAlle;
    private JTable tabFrequenzenJahre;
    private JTable tabFrequenzenLetzte;

    public ZaehlungsstandortRenderer() {
        this.colNamesJahr.add("Jahr");
        this.colNamesJahr.add("Anz/h-Mittel");
        this.colNames.add("Datum");
        this.colNames.add("Anzahl/h");
        this.colNames.add(FIELD__WETTER);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.cmdPrint = new ReportLookupButton("PFZReport");
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.pnlCard1 = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.panInhalt = new JPanel();
        this.jPanelDaten = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tabFrequenzenAlle = new JTable(){

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.panLegend = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jPanel11 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel14 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lblChartAlle = new JLabel();
        this.jPanel3 = new JPanel();
        this.panInhalt1 = new JPanel();
        this.jPanelDaten1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.tabFrequenzenLetzte = new JTable(){

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.jScrollPane4 = new JScrollPane();
        this.lblChartLetzte = new JLabel();
        this.panLegend2 = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jPanel22 = new JPanel();
        this.jPanel23 = new JPanel();
        this.jPanel24 = new JPanel();
        this.jPanel25 = new JPanel();
        this.jPanel26 = new JPanel();
        this.jPanel27 = new JPanel();
        this.jPanel28 = new JPanel();
        this.jPanel4 = new JPanel();
        this.panInhalt2 = new JPanel();
        this.jPanelDaten2 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.tabFrequenzenJahre = new JTable(){

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.jScrollPane6 = new JScrollPane();
        this.lblChartJahre = new JLabel();
        this.jPanel2 = new JPanel();
        this.panMapPreview = new DefaultPreviewMapPanel();
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText(TITLE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 20, 0);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.cmdPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/printer.png")));
        this.cmdPrint.setBorderPainted(false);
        this.cmdPrint.setContentAreaFilled(false);
        this.cmdPrint.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 22);
        this.panTitle.add((Component)this.cmdPrint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panTitle.add((Component)this.filler1, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.pnlCard1.setOpaque(false);
        this.pnlCard1.setLayout(new GridBagLayout());
        this.jTabbedPane.setMinimumSize(new Dimension(849, 520));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.panInhalt.setOpaque(false);
        this.panInhalt.setLayout(new GridBagLayout());
        this.jPanelDaten.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(230, 200));
        this.tabFrequenzenAlle.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Datum", "Anzahl"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tabFrequenzenAlle.setGridColor(new Color(153, 153, 153));
        this.tabFrequenzenAlle.setSelectionBackground(new Color(153, 204, 255));
        this.tabFrequenzenAlle.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tabFrequenzenAlle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.jPanelDaten.add((Component)this.jScrollPane1, gridBagConstraints);
        this.panLegend.setMinimumSize(new Dimension(125, 35));
        this.panLegend.setOpaque(false);
        this.panLegend.setPreferredSize(new Dimension(125, 35));
        this.panLegend.setLayout(new GridBagLayout());
        this.jLabel4.setText(STRING_MO);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Di");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("Mi");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Do");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText(STRING_FR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText(STRING_SA);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("So");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jLabel10, gridBagConstraints);
        this.jPanel8.setBackground(new Color(255, 255, 0));
        this.jPanel8.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel8.setMaximumSize(new Dimension(10, 10));
        this.jPanel8.setMinimumSize(new Dimension(10, 10));
        this.jPanel8.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setBackground(new Color(255, 153, 0));
        this.jPanel9.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel9.setMaximumSize(new Dimension(10, 10));
        this.jPanel9.setMinimumSize(new Dimension(10, 10));
        this.jPanel9.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel10.setBackground(new Color(204, 0, 0));
        this.jPanel10.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel10.setMaximumSize(new Dimension(10, 10));
        this.jPanel10.setMinimumSize(new Dimension(10, 10));
        this.jPanel10.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel11.setBackground(new Color(180, 50, 180));
        this.jPanel11.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel11.setMaximumSize(new Dimension(10, 10));
        this.jPanel11.setMinimumSize(new Dimension(10, 10));
        this.jPanel11.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel12.setBackground(new Color(51, 51, 51));
        this.jPanel12.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel12.setMaximumSize(new Dimension(10, 10));
        this.jPanel12.setMinimumSize(new Dimension(10, 10));
        this.jPanel12.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jPanel12, gridBagConstraints);
        this.jPanel13.setBackground(new Color(0, 170, 0));
        this.jPanel13.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel13.setMaximumSize(new Dimension(10, 10));
        this.jPanel13.setMinimumSize(new Dimension(10, 10));
        this.jPanel13.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jPanel13, gridBagConstraints);
        this.jPanel14.setBackground(new Color(0, 0, 230));
        this.jPanel14.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel14.setMaximumSize(new Dimension(10, 10));
        this.jPanel14.setMinimumSize(new Dimension(10, 10));
        this.jPanel14.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel14Layout = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel14Layout.setVerticalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend.add((Component)this.jPanel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        this.jPanelDaten.add((Component)this.panLegend, gridBagConstraints);
        this.lblChartAlle.setHorizontalAlignment(0);
        this.lblChartAlle.setIcon(new ImageIcon(this.getClass().getResource("/res/load.png")));
        this.lblChartAlle.setPreferredSize(new Dimension(1000, 400));
        this.jScrollPane2.setViewportView(this.lblChartAlle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelDaten.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInhalt.add((Component)this.jPanelDaten, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.jPanel1.add((Component)this.panInhalt, gridBagConstraints);
        this.jTabbedPane.addTab("alle Werte", this.jPanel1);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.panInhalt1.setOpaque(false);
        this.panInhalt1.setLayout(new GridBagLayout());
        this.jPanelDaten1.setLayout(new GridBagLayout());
        this.jScrollPane3.setPreferredSize(new Dimension(230, 200));
        this.tabFrequenzenLetzte.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Datum", "Anzahl"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tabFrequenzenLetzte.setGridColor(new Color(153, 153, 153));
        this.tabFrequenzenLetzte.setSelectionBackground(new Color(153, 204, 255));
        this.tabFrequenzenLetzte.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane3.setViewportView(this.tabFrequenzenLetzte);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.jPanelDaten1.add((Component)this.jScrollPane3, gridBagConstraints);
        this.lblChartLetzte.setHorizontalAlignment(0);
        this.lblChartLetzte.setIcon(new ImageIcon(this.getClass().getResource("/res/load.png")));
        this.lblChartLetzte.setPreferredSize(new Dimension(1000, 400));
        this.jScrollPane4.setViewportView(this.lblChartLetzte);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelDaten1.add((Component)this.jScrollPane4, gridBagConstraints);
        this.panLegend2.setMinimumSize(new Dimension(125, 35));
        this.panLegend2.setOpaque(false);
        this.panLegend2.setPreferredSize(new Dimension(125, 35));
        this.panLegend2.setLayout(new GridBagLayout());
        this.jLabel18.setText(STRING_MO);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel19.setText("Di");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jLabel19, gridBagConstraints);
        this.jLabel20.setText("Mi");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setText("Do");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel22.setText(STRING_FR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setText(STRING_SA);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setText("So");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jLabel24, gridBagConstraints);
        this.jPanel22.setBackground(new Color(255, 255, 0));
        this.jPanel22.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel22.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel22Layout = new GroupLayout(this.jPanel22);
        this.jPanel22.setLayout(jPanel22Layout);
        jPanel22Layout.setHorizontalGroup(jPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel22Layout.setVerticalGroup(jPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jPanel22, gridBagConstraints);
        this.jPanel23.setBackground(new Color(255, 153, 0));
        this.jPanel23.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel23.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel23Layout = new GroupLayout(this.jPanel23);
        this.jPanel23.setLayout(jPanel23Layout);
        jPanel23Layout.setHorizontalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel23Layout.setVerticalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jPanel23, gridBagConstraints);
        this.jPanel24.setBackground(new Color(204, 0, 0));
        this.jPanel24.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel24.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel24Layout = new GroupLayout(this.jPanel24);
        this.jPanel24.setLayout(jPanel24Layout);
        jPanel24Layout.setHorizontalGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel24Layout.setVerticalGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jPanel24, gridBagConstraints);
        this.jPanel25.setBackground(new Color(180, 50, 180));
        this.jPanel25.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel25.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel25Layout = new GroupLayout(this.jPanel25);
        this.jPanel25.setLayout(jPanel25Layout);
        jPanel25Layout.setHorizontalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel25Layout.setVerticalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jPanel25, gridBagConstraints);
        this.jPanel26.setBackground(new Color(51, 51, 51));
        this.jPanel26.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel26.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel26Layout = new GroupLayout(this.jPanel26);
        this.jPanel26.setLayout(jPanel26Layout);
        jPanel26Layout.setHorizontalGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel26Layout.setVerticalGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jPanel26, gridBagConstraints);
        this.jPanel27.setBackground(new Color(0, 170, 0));
        this.jPanel27.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel27.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel27Layout = new GroupLayout(this.jPanel27);
        this.jPanel27.setLayout(jPanel27Layout);
        jPanel27Layout.setHorizontalGroup(jPanel27Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel27Layout.setVerticalGroup(jPanel27Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jPanel27, gridBagConstraints);
        this.jPanel28.setBackground(new Color(0, 0, 230));
        this.jPanel28.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jPanel28.setPreferredSize(new Dimension(10, 10));
        GroupLayout jPanel28Layout = new GroupLayout(this.jPanel28);
        this.jPanel28.setLayout(jPanel28Layout);
        jPanel28Layout.setHorizontalGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel28Layout.setVerticalGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLegend2.add((Component)this.jPanel28, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        this.jPanelDaten1.add((Component)this.panLegend2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInhalt1.add((Component)this.jPanelDaten1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.jPanel3.add((Component)this.panInhalt1, gridBagConstraints);
        this.jTabbedPane.addTab("letzten zwei Jahre", this.jPanel3);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        this.panInhalt2.setOpaque(false);
        this.panInhalt2.setLayout(new GridBagLayout());
        this.jPanelDaten2.setLayout(new GridBagLayout());
        this.jScrollPane5.setPreferredSize(new Dimension(230, 200));
        this.tabFrequenzenJahre.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Datum", "Anzahl"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tabFrequenzenJahre.setGridColor(new Color(153, 153, 153));
        this.tabFrequenzenJahre.setSelectionBackground(new Color(153, 204, 255));
        this.tabFrequenzenJahre.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane5.setViewportView(this.tabFrequenzenJahre);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.jPanelDaten2.add((Component)this.jScrollPane5, gridBagConstraints);
        this.lblChartJahre.setHorizontalAlignment(0);
        this.lblChartJahre.setIcon(new ImageIcon(this.getClass().getResource("/res/load.png")));
        this.lblChartJahre.setPreferredSize(new Dimension(1000, 400));
        this.jScrollPane6.setViewportView(this.lblChartJahre);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(35, 0, 0, 0);
        this.jPanelDaten2.add((Component)this.jScrollPane6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInhalt2.add((Component)this.jPanelDaten2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.jPanel4.add((Component)this.panInhalt2, gridBagConstraints);
        this.jTabbedPane.addTab("Jahresdurchschnitt", this.jPanel4);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel2.add((Component)this.panMapPreview, gridBagConstraints);
        this.jTabbedPane.addTab("Karte", this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlCard1.add((Component)this.jTabbedPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlCard1, gridBagConstraints);
    }

    public void fillTableAndCreateChart(final List<CidsBean> werte, final JLabel chartLabel, final JTable tabelle) {
        if (!werte.isEmpty()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZaehlungsstandortRenderer.this.dataset = new DefaultCategoryDataset();
                        TreeMap<Date, Integer> tmAnzahl = new TreeMap<Date, Integer>();
                        TreeMap<Date, String> tmWetter = new TreeMap<Date, String>();
                        DefaultTableModel model = new DefaultTableModel(ZaehlungsstandortRenderer.this.colNames.toArray(), werte.size() + 1);
                        tabelle.setModel(model);
                        if (tabelle.getColumn(ZaehlungsstandortRenderer.FIELD__WETTER) != null) {
                            tabelle.getColumn(ZaehlungsstandortRenderer.FIELD__WETTER).setCellRenderer(new WetterRenderer());
                        }
                        double avg = 0.0;
                        for (Object zaehlung : werte) {
                            Timestamp datum = (Timestamp)zaehlung.getProperty(ZaehlungsstandortRenderer.FIELD__DATUM);
                            Date key = new Date(datum.getTime());
                            Integer anzahl = (Integer)zaehlung.getProperty(ZaehlungsstandortRenderer.FIELD__ANZAHL);
                            tmAnzahl.put(key, anzahl);
                            String wetter = (String)zaehlung.getProperty(ZaehlungsstandortRenderer.FIELD__WETTER_WETTER);
                            if (wetter == null) continue;
                            tmWetter.put(key, wetter);
                        }
                        int i = 0;
                        for (Date s : tmAnzahl.keySet()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("KEY=" + s));
                                LOG.debug((Object)("ANZAHL=" + tmAnzahl.get(s)));
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("WETTER=" + (String)tmWetter.get(s)));
                            }
                            int wert = (Integer)tmAnzahl.get(s) * 12;
                            avg += (double)wert;
                            model.setValueAt(DateFormat.getDateTimeInstance(3, 3, Locale.GERMANY).format(s), i + 1, 0);
                            model.setValueAt(wert, i + 1, 1);
                            if (tmWetter.get(s) != null) {
                                model.setValueAt(tmWetter.get(s), i + 1, tabelle.getColumn(ZaehlungsstandortRenderer.FIELD__WETTER).getModelIndex());
                            }
                            ZaehlungsstandortRenderer.this.dataset.addValue((double)wert, (Comparable)((Object)"Daten"), (Comparable)((Object)DateFormat.getDateTimeInstance(3, 3, Locale.GERMANY).format(s)));
                            ++i;
                            tabelle.getColumnModel().getColumn(0).setPreferredWidth(150);
                        }
                        model.setValueAt(ZaehlungsstandortRenderer.AVG_TEXT, 0, 0);
                        model.setValueAt(Math.round(avg /= (double)werte.size()), 0, 1);
                        JFreeChart chart = ZaehlungsstandortRenderer.this.createChart((CategoryDataset)ZaehlungsstandortRenderer.this.dataset, avg);
                        chart.setBackgroundPaint((Paint)new Color(200, 200, 200));
                        final BufferedImage icon = chart.createBufferedImage(1000, 400);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                chartLabel.setIcon(new ImageIcon(icon));
                            }
                        });
                    }
                    catch (Exception exception) {
                        LOG.error((Object)"Error while filling the table and creating the chart", (Throwable)exception);
                    }
                }
            });
            t.start();
        }
    }

    public void fillTableAndCreateYearChart(final List<CidsBean> werte) {
        if (!werte.isEmpty()) {
            final ArrayList<Timestamp> datum = new ArrayList<Timestamp>(werte.size());
            final ArrayList<Integer> anzahl = new ArrayList<Integer>(werte.size());
            for (CidsBean wert : werte) {
                datum.add((Timestamp)wert.getProperty(FIELD__DATUM));
                anzahl.add((Integer)wert.getProperty(FIELD__ANZAHL));
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ZaehlungsstandortRenderer.this.datasetJahr = new DefaultCategoryDataset();
                    Integer summe = 0;
                    for (int i = 0; i < datum.size(); ++i) {
                        try {
                            String jahr = DateFormat.getDateInstance(1, Locale.GERMANY).format((Date)datum.get(i));
                            jahr = jahr.substring(jahr.length() - 4);
                            int wert = (Integer)anzahl.get(i) * 12;
                            if (ZaehlungsstandortRenderer.this.jahresDurchschnitt.get(jahr) != null) {
                                int[] tmp = (int[])ZaehlungsstandortRenderer.this.jahresDurchschnitt.get(jahr);
                                tmp[0] = tmp[0] + wert;
                                tmp[1] = tmp[1] + 1;
                                ZaehlungsstandortRenderer.this.jahresDurchschnitt.put(jahr, tmp);
                            } else {
                                int[] newArr = new int[]{wert, 1};
                                ZaehlungsstandortRenderer.this.jahresDurchschnitt.put(jahr, newArr);
                            }
                            summe = summe + wert;
                            continue;
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Error beim Erstellen des FeatureRenderers", (Throwable)ex);
                        }
                    }
                    for (String key : ZaehlungsstandortRenderer.this.jahresDurchschnitt.keySet()) {
                        ZaehlungsstandortRenderer.this.datasetJahr.addValue((double)Math.round(((int[])ZaehlungsstandortRenderer.this.jahresDurchschnitt.get(key))[0] / ((int[])ZaehlungsstandortRenderer.this.jahresDurchschnitt.get(key))[1]), (Comparable)((Object)"Daten"), (Comparable)((Object)key));
                    }
                    DefaultTableModel modelJahr = new DefaultTableModel(ZaehlungsstandortRenderer.this.colNamesJahr.toArray(), ZaehlungsstandortRenderer.this.datasetJahr.getColumnCount() + 1);
                    ZaehlungsstandortRenderer.this.tabFrequenzenJahre.setModel(modelJahr);
                    for (int i = 0; i < ZaehlungsstandortRenderer.this.datasetJahr.getColumnCount(); ++i) {
                        modelJahr.setValueAt(ZaehlungsstandortRenderer.this.datasetJahr.getColumnKey(i), i + 1, 0);
                        modelJahr.setValueAt(ZaehlungsstandortRenderer.this.datasetJahr.getValue(0, i).intValue(), i + 1, 1);
                    }
                    modelJahr.setValueAt(ZaehlungsstandortRenderer.AVG_TEXT, 0, 0);
                    Integer durchschnitt = Math.round(summe / werte.size());
                    modelJahr.setValueAt(durchschnitt, 0, 1);
                    JFreeChart chart = ZaehlungsstandortRenderer.this.createChart((CategoryDataset)ZaehlungsstandortRenderer.this.datasetJahr, durchschnitt.intValue());
                    chart.setBackgroundPaint((Paint)new Color(210, 210, 210));
                    final BufferedImage icon = chart.createBufferedImage(1000, 400);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ZaehlungsstandortRenderer.this.lblChartJahre.setIcon(new ImageIcon(icon));
                        }
                    });
                }
            });
            t.start();
        }
    }

    JFreeChart createChart(CategoryDataset dataset, double average) {
        JFreeChart chart = ChartFactory.createBarChart3D(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        CustomBarRenderer renderer = new CustomBarRenderer();
        plot.setRenderer((CategoryItemRenderer)renderer);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(true);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        ValueMarker markerAvg = new ValueMarker(average, (Paint)new Color(100, 100, 255), (Stroke)new BasicStroke(2.5f));
        plot.addRangeMarker((Marker)markerAvg, Layer.BACKGROUND);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setVisible(true);
        rangeAxis.setAutoRange(true);
        return chart;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            ((ReportLookupButton)this.cmdPrint).setBean(cidsBean);
            List zaehlungen = cidsBean.getBeanCollectionProperty(FIELD__ZAEHLUNGEN);
            this.fillTableAndCreateChart(zaehlungen, this.lblChartAlle, this.tabFrequenzenAlle);
            this.fillTableAndCreateYearChart(zaehlungen);
            this.panMapPreview.initMap(cidsBean, FIELD__GEO_FIELD);
            this.yearsSearch.setStandortId(cidsBean.getPrimaryKeyValue());
            try {
                Collection colMONZaehlung = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)this.yearsSearch, this.getConnectionContext());
                ArrayList<CidsBean> yearBeans = new ArrayList<CidsBean>();
                for (MetaObjectNode mon : colMONZaehlung) {
                    yearBeans.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", this.getConnectionContext()).getBean());
                }
                this.fillTableAndCreateChart(yearBeans, this.lblChartLetzte, this.tabFrequenzenLetzte);
            }
            catch (ConnectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void dispose() {
    }

    public String getTitle() {
        return this.lblTitle.getText();
    }

    public void setTitle(String title) {
    }

    public JComponent getTitleComponent() {
        Integer standort;
        Integer bezirk;
        String stadtteil = (String)this.cidsBean.getProperty(FIELD__STADTTEIL);
        String title = TITLE;
        if (StringUtils.isNotBlank((String)stadtteil)) {
            title = title + " - " + stadtteil;
        }
        if ((bezirk = (Integer)this.cidsBean.getProperty(FIELD__BEZIRK)) != null) {
            title = title + " (Bezirk " + bezirk.toString();
        }
        title = (standort = (Integer)this.cidsBean.getProperty(FIELD__STANDORT)) != null ? title + ", Standort " + standort.toString() + ")" : title + ")";
        this.lblTitle.setText(title);
        return this.panTitle;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    class CustomBarRenderer
    extends BarRenderer {
        private boolean paintLight = false;

        public Paint getItemPaint(int row, int column) {
            try {
                CategoryDataset dataset = this.getPlot().getDataset();
                String key = (String)((Object)dataset.getColumnKey(column));
                Date date = DateFormat.getInstance().parse(key);
                Calendar mittag = Calendar.getInstance();
                mittag.setTime(date);
                mittag.set(11, 12);
                mittag.set(12, 0);
                mittag.set(13, 0);
                this.paintLight = date.before(mittag.getTime());
                if (date.toString().startsWith(ZaehlungsstandortRenderer.STRING_MO)) {
                    if (this.paintLight) {
                        return LIGHT_MO;
                    }
                    return COLOR_MO;
                }
                if (date.toString().startsWith(ZaehlungsstandortRenderer.STRING_DI)) {
                    if (this.paintLight) {
                        return LIGHT_DI;
                    }
                    return COLOR_DI;
                }
                if (date.toString().startsWith(ZaehlungsstandortRenderer.STRING_MI)) {
                    if (this.paintLight) {
                        return LIGHT_MI;
                    }
                    return COLOR_MI;
                }
                if (date.toString().startsWith(ZaehlungsstandortRenderer.STRING_DO)) {
                    if (this.paintLight) {
                        return LIGHT_DO;
                    }
                    return COLOR_DO;
                }
                if (date.toString().startsWith(ZaehlungsstandortRenderer.STRING_FR)) {
                    if (this.paintLight) {
                        return LIGHT_FR;
                    }
                    return COLOR_FR;
                }
                if (date.toString().startsWith(ZaehlungsstandortRenderer.STRING_SA)) {
                    if (this.paintLight) {
                        return LIGHT_SA;
                    }
                    return COLOR_SA;
                }
                if (date.toString().startsWith(ZaehlungsstandortRenderer.STRING_SO)) {
                    if (this.paintLight) {
                        return LIGHT_SO;
                    }
                    return COLOR_SO;
                }
                return Color.BLACK;
            }
            catch (ParseException exception) {
                LOG.error((Object)"FEHLER", (Throwable)exception);
                return Color.BLACK;
            }
        }
    }

    class WetterRenderer
    extends DefaultTableCellRenderer {
        WetterRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                if (value != null) {
                    String wetter;
                    switch (wetter = value.toString().toLowerCase()) {
                        case "sonne": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_SONNE);
                        }
                        case "leichter bewoelkt": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_LEICHTER_BEW);
                        }
                        case "leicht bewoelkt": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_LEICHT_BEW);
                        }
                        case "wechselhaft": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_WECHSELHAFT);
                        }
                        case "bewoelkt": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_BEWOELKT);
                        }
                        case "stark bewoelkt": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_STARK_BEW);
                        }
                        case "regen": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_REGEN);
                        }
                        case "gewitter": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_GEWITTER);
                        }
                        case "schnee": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_SCHNEE);
                        }
                        case "schnee wechselhaft": {
                            return new JLabel(ZaehlungsstandortRenderer.this.ICON_SCHNEE_WECHSEL);
                        }
                    }
                    return new JLabel("");
                }
            }
            catch (Exception exception) {
                LOG.warn((Object)"Wetterrendererfehler", (Throwable)exception);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

