/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.optionspanels.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.clientutils.DmsUrlPathMapper;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.options.NetworkOptionsCategory;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DmsUrlMappingOptionsPanel
extends AbstractOptionsPanel {
    private static final Logger LOG = Logger.getLogger(DmsUrlMappingOptionsPanel.class);
    private static final String CONF_ATTR_ENABLED = "options.dms-url-mapping.enabled";
    final List<MyTableEntry> hm = new ArrayList<MyTableEntry>();
    private boolean networkPathCanceled = false;
    private JButton btnAddVerwaltung;
    private JButton btnRemoveVerwaltung;
    private JButton jButton4;
    private JButton jButton5;
    private JDialog jDialog2;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextField1;

    public DmsUrlMappingOptionsPanel() {
        super(NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)(DmsUrlMappingOptionsPanel.class.getSimpleName() + ".option.name")), NetworkOptionsCategory.class);
        this.initComponents();
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                DmsUrlMappingOptionsPanel.this.jButton5.setEnabled(DmsUrlMappingOptionsPanel.this.jTextField1.getText().matches("\\\\\\\\[\\w\\s\\-.]+(\\\\[\\w\\s\\-.]+)+"));
            }
        });
        this.jDialog2.pack();
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jDialog2 = new JDialog();
        this.jPanel3 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.btnRemoveVerwaltung = new JButton();
        this.btnAddVerwaltung = new JButton();
        this.jFileChooser1.setDialogType(2);
        this.jFileChooser1.setApproveButtonText(NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)"DmsUrlMappingOptionsPanel.jFileChooser1.approveButtonText"));
        this.jFileChooser1.setCurrentDirectory(DmsUrlMappingOptionsPanel.getFileSystemRootDir());
        this.jFileChooser1.setDialogTitle(NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)"DmsUrlMappingOptionsPanel.jFileChooser1.dialogTitle"));
        this.jFileChooser1.setFileSelectionMode(1);
        this.jFileChooser1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DmsUrlMappingOptionsPanel.this.jFileChooser1ActionPerformed(evt);
            }
        });
        DmsUrlMappingOptionsPanel.disableNewFolderButton(this.jFileChooser1);
        this.jDialog2.setTitle(NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)"DmsUrlMappingOptionsPanel.jDialog2.title"));
        this.jDialog2.setModal(true);
        this.jDialog2.getContentPane().setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jTextField1.setText(NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)"DmsUrlMappingOptionsPanel.jTextField1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.jTextField1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)"DmsUrlMappingOptionsPanel.jButton4.text"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DmsUrlMappingOptionsPanel.this.jButton4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.jButton4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)"DmsUrlMappingOptionsPanel.jButton5.text"));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DmsUrlMappingOptionsPanel.this.jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.jButton5, gridBagConstraints);
        this.jDialog2.getRootPane().setDefaultButton(this.jButton5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)"DmsUrlMappingOptionsPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jDialog2.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jTable1.setModel(new MyTableModel());
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DmsUrlMappingOptionsPanel.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnRemoveVerwaltung.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/remove.png")));
        this.btnRemoveVerwaltung.setBorder(null);
        this.btnRemoveVerwaltung.setBorderPainted(false);
        this.btnRemoveVerwaltung.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveVerwaltung.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveVerwaltung.setPreferredSize(new Dimension(25, 25));
        this.btnRemoveVerwaltung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DmsUrlMappingOptionsPanel.this.btnRemoveVerwaltungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.btnRemoveVerwaltung, gridBagConstraints);
        this.btnAddVerwaltung.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/add.png")));
        this.btnAddVerwaltung.setBorder(null);
        this.btnAddVerwaltung.setBorderPainted(false);
        this.btnAddVerwaltung.setMaximumSize(new Dimension(25, 25));
        this.btnAddVerwaltung.setMinimumSize(new Dimension(25, 25));
        this.btnAddVerwaltung.setPreferredSize(new Dimension(25, 25));
        this.btnAddVerwaltung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DmsUrlMappingOptionsPanel.this.btnAddVerwaltungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.btnAddVerwaltung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.jPanel2, gridBagConstraints);
    }

    private void jFileChooser1ActionPerformed(ActionEvent evt) {
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int row = this.jTable1.rowAtPoint(new Point(evt.getX(), evt.getY()));
            int col = this.jTable1.columnAtPoint(new Point(evt.getX(), evt.getY()));
            if (row >= 0 && col >= 0) {
                String newValue;
                String oldValue = (String)this.jTable1.getValueAt(row, col);
                if (col == 0) {
                    String result = this.showNetworkPathChooser(oldValue);
                    newValue = result != null ? result : oldValue;
                } else if (col == 1) {
                    File input = oldValue.isEmpty() ? DmsUrlMappingOptionsPanel.getFileSystemRootDir() : new File(oldValue);
                    File result = this.showLocalPathChooser(input);
                    newValue = result != null ? result.getAbsolutePath() : oldValue;
                } else {
                    return;
                }
                this.jTable1.setValueAt(newValue, row, col);
            }
        }
    }

    private File showLocalPathChooser(File path) {
        this.jFileChooser1.setCurrentDirectory(path);
        int result = this.jFileChooser1.showOpenDialog((Component)((Object)this));
        switch (result) {
            case 0: {
                return this.jFileChooser1.getSelectedFile();
            }
        }
        return null;
    }

    private String showNetworkPathChooser(String path) {
        this.networkPathCanceled = true;
        if (path != null) {
            this.jTextField1.setText(path);
        } else {
            this.jTextField1.setText("");
        }
        StaticSwingTools.showDialog((JDialog)this.jDialog2);
        if (this.networkPathCanceled) {
            return null;
        }
        return this.jTextField1.getText();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.networkPathCanceled = false;
        this.jDialog2.setVisible(false);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.networkPathCanceled = true;
        this.jDialog2.setVisible(false);
    }

    private void btnAddVerwaltungActionPerformed(ActionEvent evt) {
        File localPath;
        String networkPath = this.showNetworkPathChooser(null);
        if (networkPath != null && (localPath = this.showLocalPathChooser(DmsUrlMappingOptionsPanel.getFileSystemRootDir())) != null) {
            try {
                MyTableModel model = (MyTableModel)this.jTable1.getModel();
                model.addRow(networkPath, localPath.toURI().toURL().toString());
                model.fireTableDataChanged();
            }
            catch (MalformedURLException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
    }

    private void btnRemoveVerwaltungActionPerformed(ActionEvent evt) {
        int selRow = this.jTable1.getSelectedRow();
        if (selRow >= 0) {
            MyTableModel model = (MyTableModel)this.jTable1.getModel();
            model.removeRow(selRow);
            model.fireTableDataChanged();
        }
    }

    public boolean isEnabled() {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), CONF_ATTR_ENABLED, ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OPTIONS, (String)((Object)((Object)this)).getClass().getSimpleName()));
        }
        catch (Exception ex) {
            LOG.error((Object)"could not check conf attr options.dms-url-mapping.enabled", (Throwable)ex);
            return false;
        }
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setSize(800, 600);
                frame.add((Component)((Object)new DmsUrlMappingOptionsPanel()));
                frame.setVisible(true);
                frame.setDefaultCloseOperation(3);
            }
        });
    }

    public static void disableNewFolderButton(Container c) {
        int len = c.getComponentCount();
        for (int i = 0; i < len; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof JButton) {
                JButton b = (JButton)comp;
                Icon icon = b.getIcon();
                if (icon == null || icon != UIManager.getIcon("FileChooser.newFolderIcon")) continue;
                b.setEnabled(false);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            DmsUrlMappingOptionsPanel.disableNewFolderButton((Container)comp);
        }
    }

    public static File getFileSystemRootDir() {
        File[] roots = FileSystemView.getFileSystemView().getRoots();
        if (roots == null || roots.length == 0) {
            LOG.warn((Object)"could not get default FileSystemView roo directory!");
            roots = File.listRoots();
        }
        return roots[0];
    }

    public void update() {
        this.hm.clear();
        for (String networkPath : DmsUrlPathMapper.getInstance().getAllNetworkPaths()) {
            String localPath = DmsUrlPathMapper.getInstance().getLocalPath(networkPath);
            this.hm.add(new MyTableEntry(networkPath, localPath));
        }
        ((MyTableModel)this.jTable1.getModel()).fireTableDataChanged();
    }

    public void applyChanges() {
        DmsUrlPathMapper.getInstance().unmapAll();
        for (MyTableEntry entry : this.hm) {
            DmsUrlPathMapper.getInstance().map(entry.getNetworkPath(), entry.getLocalPath());
        }
    }

    public boolean isChanged() {
        Set<String> origNetworkPaths = DmsUrlPathMapper.getInstance().getAllLocalPaths();
        if (origNetworkPaths.size() != this.hm.size()) {
            return true;
        }
        for (MyTableEntry entry : this.hm) {
            String networkPath = entry.getNetworkPath();
            String localPath = entry.getLocalPath();
            if (!origNetworkPaths.contains(networkPath)) {
                return true;
            }
            String origLocalPath = DmsUrlPathMapper.getInstance().getLocalPath(networkPath);
            if (localPath.equals(origLocalPath)) continue;
            return true;
        }
        return false;
    }

    public Element getConfiguration() {
        return DmsUrlPathMapper.getInstance().getConfiguration();
    }

    public void configure(Element parent) {
        DmsUrlPathMapper.getInstance().configure(parent);
        this.update();
    }

    public void masterConfigure(Element parent) {
        DmsUrlPathMapper.getInstance().masterConfigure(parent);
        this.update();
    }

    class MyTableEntry {
        private String networkPath;
        private String localPath;

        public MyTableEntry(String networkPath, String localPath) {
            this.networkPath = networkPath;
            this.localPath = localPath;
        }

        public String getNetworkPath() {
            return this.networkPath;
        }

        public void setNetworkPath(String networkPath) {
            this.networkPath = networkPath;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public void setLocalPath(String localPath) {
            this.localPath = localPath;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)(DmsUrlMappingOptionsPanel.class.getSimpleName() + ".columns.network")), NbBundle.getMessage(DmsUrlMappingOptionsPanel.class, (String)(DmsUrlMappingOptionsPanel.class.getSimpleName() + ".columns.local"))};

        MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return DmsUrlMappingOptionsPanel.this.hm.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && rowIndex < DmsUrlMappingOptionsPanel.this.hm.size()) {
                MyTableEntry entry = DmsUrlMappingOptionsPanel.this.hm.get(rowIndex);
                if (columnIndex == 0) {
                    return entry.getNetworkPath();
                }
                if (columnIndex == 1) {
                    return entry.getLocalPath();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && rowIndex < DmsUrlMappingOptionsPanel.this.hm.size()) {
                MyTableEntry entry = DmsUrlMappingOptionsPanel.this.hm.get(rowIndex);
                if (columnIndex == 0) {
                    entry.setNetworkPath((String)aValue);
                } else if (columnIndex == 1) {
                    entry.setLocalPath((String)aValue);
                }
            }
            super.setValueAt(aValue, rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void removeRow(int row) {
            DmsUrlMappingOptionsPanel.this.hm.remove(row);
        }

        public void addRow(String networkPath, String localPath) {
            DmsUrlMappingOptionsPanel.this.hm.add(new MyTableEntry(networkPath, localPath));
        }
    }
}

