/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.orbit;

import de.cismet.cids.custom.clientutils.ServerResourceProperties;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OrbitviewerProperties
extends Properties {
    private static final transient Logger LOG = Logger.getLogger(OrbitviewerProperties.class);

    private OrbitviewerProperties(Properties properties) throws Exception {
        super(properties);
    }

    public String getOpenChannelsSecret() {
        return this.getProperty("openChannelsSecret");
    }

    public String getOpenChannelTimeout() {
        return this.getProperty("openChannelTimeout");
    }

    public String getSocketBroadcaster() {
        return this.getProperty("socketBroadcaster");
    }

    public String getLauncherUrl() {
        return this.getProperty("launcherUrl");
    }

    public String getArcColorRGBA() {
        return this.getProperty("arcColorRGBA");
    }

    public static OrbitviewerProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private static final class LazyInitialiser {
        private static final OrbitviewerProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            OrbitviewerProperties instance = null;
            try {
                instance = new OrbitviewerProperties(ServerResourceProperties.loadPropertiesFromServerResource(WundaBlauServerResources.ORBIT_SETTINGS_PROPERTIES));
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while initializing OrbitviewerProperties", (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

