/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.tools.MapImageFactory;
import Sirius.server.middleware.types.MetaObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import de.cismet.cids.custom.utils.BaumMapImageFactoryConfiguration;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BaumMapImageFactory
extends MapImageFactory<BaumMapImageFactoryConfiguration>
implements ConnectionContextStore {
    private static Map<String, String> colorMap = new HashMap<String, String>();
    private static final Color DEFAULT_COLOR = new Color(0.5f, 0.5f, 0.5f);
    private static final String FIELD__GEOM = "fk_geom.geo_field";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    protected BaumMapImageFactoryConfiguration extractConfiguration(String confJson) throws Exception {
        return (BaumMapImageFactoryConfiguration)new ObjectMapper().readValue(confJson, BaumMapImageFactoryConfiguration.class);
    }

    private DefaultStyledFeature createPointFeature(Geometry geom, Color color) {
        DefaultStyledFeature dsf = new DefaultStyledFeature();
        Geometry polygon = BufferOp.bufferOp((Geometry)geom, (double)0.1);
        dsf.setGeometry(polygon);
        dsf.setFillingPaint((Paint)color);
        dsf.setLineWidth(3);
        dsf.setLinePaint((Paint)color);
        return dsf;
    }

    private DefaultStyledFeature createRectangleFeature(Geometry geom, Color color) {
        DefaultStyledFeature dsf = new DefaultStyledFeature();
        dsf.setGeometry(geom);
        dsf.setTransparency(0.5f);
        dsf.setFillingPaint((Paint)color);
        return dsf;
    }

    protected BufferedImage generateMap(BaumMapImageFactoryConfiguration config) throws Exception {
        Geometry geom = null;
        ArrayList<DefaultStyledFeature> features = new ArrayList<DefaultStyledFeature>();
        for (BaumMapImageFactoryConfiguration.ObjectIdentifier oi : config.getMons()) {
            MetaObject mo = SessionManager.getProxy().getMetaObject(oi.getObjectId().intValue(), oi.getClassId().intValue(), "WUNDA_BLAU", this.connectionContext);
            CidsBean bean = mo.getBean();
            Geometry baumGeom = (Geometry)bean.getProperty(FIELD__GEOM);
            if (baumGeom == null) continue;
            colorMap = config.getColorMap();
            Color classColor = colorMap.containsKey(mo.getMetaClass().getName()) ? Color.decode(colorMap.get(mo.getMetaClass().getName())) : DEFAULT_COLOR;
            DefaultStyledFeature dsf = baumGeom.getGeometryType().equals("Polygon") ? this.createRectangleFeature(baumGeom, classColor) : this.createPointFeature(baumGeom, classColor);
            features.add(dsf);
            if (geom == null) {
                geom = (Geometry)dsf.getGeometry().buffer(0.0).clone();
                continue;
            }
            geom = geom.union((Geometry)dsf.getGeometry().buffer(0.0).clone());
        }
        int margin = 50;
        if (geom != null) {
            XBoundingBox boundingBox = new XBoundingBox(geom);
            boundingBox.increase(10);
            boundingBox.setX1(boundingBox.getX1() - 50.0);
            boundingBox.setY1(boundingBox.getY1() - 50.0);
            boundingBox.setX2(boundingBox.getX2() + 50.0);
            boundingBox.setY2(boundingBox.getY2() + 50.0);
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            mapProvider.setCenterMapOnResize(true);
            mapProvider.setBoundingBox(boundingBox);
            SimpleWmsGetMapUrl getMapUrl = new SimpleWmsGetMapUrl(config.getMapUrl());
            SimpleWMS simpleWms = new SimpleWMS(getMapUrl);
            mapProvider.addLayer((RetrievalServiceLayer)simpleWms);
            features.forEach(feature -> mapProvider.addFeature(feature));
            return (BufferedImage)mapProvider.getImageAndWait(72, config.getMapDpi().intValue(), (double)config.getWidth().intValue(), (double)config.getHeight().intValue());
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

