/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.reports.wunda_blau.BillingStatisticsReport;
import de.cismet.cids.custom.wunda_blau.search.server.BillingStatisticsReportServerSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class BillingStatisticsDataSourceAccumulation
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(BillingStatisticsDataSourceAccumulation.class);
    protected final Collection<CidsBean> billingBeans;
    private HashMap<String, Collection> searchResults;
    private final ConnectionContext connectionContext;

    public BillingStatisticsDataSourceAccumulation(Collection<CidsBean> billingBeans, ConnectionContext connectionContext) {
        this.billingBeans = billingBeans;
        this.connectionContext = connectionContext;
    }

    public JRDataSource getKundeBranche() {
        return this.getResource("branchenAmounts");
    }

    public JRDataSource getKundenAntraege() {
        return this.getResource("antraegeAmounts");
    }

    public JRDataSource getAnzahlDownloads() {
        return this.getResource("downloadAmounts");
    }

    public JRDataSource getKundenUmsatz() {
        return this.getResource("kundenUmsatz");
    }

    public JRDataSource getProdukteCommonDownloads() {
        return this.getResource("produkteCommonDownloads");
    }

    public JRDataSource getProdukteDownloads() {
        return this.getResource("produkteDownloads");
    }

    public JRDataSource getProdukteEinnahmen() {
        return this.getResource("produkteEinnahmen");
    }

    public JRDataSource getEinnahmen() {
        return this.getResource("einnahmen");
    }

    protected JRDataSource getResource(String key) {
        return new JRBeanCollectionDataSource(this.searchResults.get(key), false);
    }

    protected BillingStatisticsReportServerSearch createServerSearch() {
        String ids = BillingStatisticsReport.joinCidsBeanIds(this.billingBeans, ", ");
        return new BillingStatisticsReportServerSearch(ids);
    }

    public void fetchSearchResults() {
        try {
            BillingStatisticsReportServerSearch search = this.createServerSearch();
            Collection searchResultsCol = SessionManager.getConnection().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, this.getConnectionContext());
            this.searchResults = (HashMap)searchResultsCol.iterator().next();
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not fetch the data for the report.", (Throwable)ex);
            this.searchResults = null;
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

