/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.reports.wunda_blau.ReportBeanWithMapAndTwoUrlImages;
import de.cismet.cids.custom.utils.MauernProperties;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class MauernReportBean
extends ReportBeanWithMapAndTwoUrlImages {
    private static final String DOWNLOAD_TEMPLATE = "<rasterfari:url>?REQUEST=GetMap&SERVICE=WMS&customDocumentInfo=download&LAYERS=<rasterfari:path>/<rasterfari:document>";
    private final MauernProperties properties;

    public MauernReportBean(CidsBean mauer, boolean beanOnly, MauernProperties properties, ConnectionContext connectionContext) {
        super(mauer, beanOnly ? null : properties.getMapUrl(), connectionContext);
        this.properties = properties;
    }

    @Override
    protected List<CidsBean> getImageBeans() {
        if (this.getCidsBean() == null) {
            return null;
        }
        return this.getCidsBean().getBeanCollectionProperty("n_dokumente").stream().filter(b -> b.getProperty("position") != null).filter(b -> "foto".equals(b.getProperty("fk_art.schluessel"))).sorted(Comparator.comparing(b -> b != null ? (Integer)b.getProperty("position") : null, Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
    }

    @Override
    protected URL getUrl(CidsBean cidsBean) throws Exception {
        return new URL(DOWNLOAD_TEMPLATE.replace("<rasterfari:path>", this.properties.getRasterfariPath()).replace("<rasterfari:url>", this.properties.getRasterfariUrl()).replace("<rasterfari:document>", URLEncoder.encode((String)cidsBean.getProperty("filename"))));
    }

    @Override
    protected Geometry getGeometry() {
        return this.getCidsBean() != null ? (Geometry)this.getCidsBean().getProperty("georeferenz.geo_field") : null;
    }

    private MauernProperties getProperties() {
        return this.properties;
    }

    public CidsBean getMauer() {
        return this.getCidsBean();
    }

    private Integer findMax(String svdg) {
        if (this.getMauer() == null) {
            return null;
        }
        ArrayList<Integer> scores = new ArrayList<Integer>();
        scores.add((Integer)this.getMauer().getProperty(String.format("fk_zustand_gelaender.%s", svdg)));
        scores.add((Integer)this.getMauer().getProperty(String.format("fk_zustand_kopf.%s", svdg)));
        scores.add((Integer)this.getMauer().getProperty(String.format("fk_zustand_ansicht.%s", svdg)));
        scores.add((Integer)this.getMauer().getProperty(String.format("fk_zustand_gruendung.%s", svdg)));
        scores.add((Integer)this.getMauer().getProperty(String.format("fk_zustand_verformung.%s", svdg)));
        scores.add((Integer)this.getMauer().getProperty(String.format("fk_zustand_gelaende_oben.%s", svdg)));
        scores.add((Integer)this.getMauer().getProperty(String.format("fk_zustand_gelaende.%s", svdg)));
        return this.maxFrom(scores);
    }

    public Integer getVerkehrssicherheit() {
        return this.findMax("verkehrssicherheit");
    }

    public Integer getStandsicherheit() {
        return this.findMax("standsicherheit");
    }

    public Integer getDauerhaftigkeit() {
        return this.findMax("dauerhaftigkeit");
    }

    public Integer getGesamt() {
        if (this.getMauer() == null) {
            return null;
        }
        ArrayList<Integer> scores = new ArrayList<Integer>();
        scores.add(this.getStandsicherheit());
        scores.add(this.getVerkehrssicherheit());
        scores.add(this.getDauerhaftigkeit());
        return this.maxFrom(scores);
    }

    private Integer maxFrom(Collection<Integer> scores) {
        Integer max = null;
        for (Integer score : scores) {
            if (score == null) continue;
            max = max == null ? score : Integer.max(max, score);
        }
        return max;
    }
}

