/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import de.cismet.cids.custom.clientutils.ServerResourcesLoaderClient;
import de.cismet.cids.custom.reports.wunda_blau.MauernReportBean;
import de.cismet.cids.custom.utils.MauernProperties;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.utils.serverresources.PropertiesServerResource;
import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.cismap.commons.gui.printing.JasperReportExcelDownload;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class MauernReportGenerator {
    private static final Logger LOG = Logger.getLogger(MauernReportGenerator.class);
    private static final MauernProperties PROPERTIES;

    public static void generateKatasterBlatt(final Collection<CidsBean> cidsBeans, Component parent, final ConnectionContext connectionContext) {
        JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

            public JRDataSource generateDataSource() {
                boolean ready;
                LinkedList<MauernReportBean> reportBeans = new LinkedList<MauernReportBean>();
                for (Object b : cidsBeans) {
                    reportBeans.add(new MauernReportBean((CidsBean)b, false, PROPERTIES, connectionContext));
                }
                block1: do {
                    ready = true;
                    for (MauernReportBean m : reportBeans) {
                        if (m.isReadyToProceed()) continue;
                        ready = false;
                        continue block1;
                    }
                } while (!ready);
                JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(reportBeans);
                return dataSource;
            }
        };
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(parent)) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            DownloadManager.instance().add((Download)new JasperReportDownload("/de/cismet/cids/custom/reports/wunda_blau/mauer-katasterblatt.jasper", dataSourceGenerator, jobname, "Mauer Katasterblatt", "mauern_katasterblatt"));
        }
    }

    public static void generateMainInfo(final Collection<CidsBean> cidsBeans, Component parent, final ConnectionContext connectionContext) {
        JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

            public JRDataSource generateDataSource() {
                boolean ready;
                LinkedList<MauernReportBean> reportBeans = new LinkedList<MauernReportBean>();
                for (Object b : cidsBeans) {
                    reportBeans.add(new MauernReportBean((CidsBean)b, true, PROPERTIES, connectionContext));
                }
                block1: do {
                    ready = true;
                    for (MauernReportBean m : reportBeans) {
                        if (m.isReadyToProceed()) continue;
                        ready = false;
                        continue block1;
                    }
                } while (!ready);
                JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(reportBeans);
                return dataSource;
            }
        };
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(parent)) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            DownloadManager.instance().add((Download)new JasperReportExcelDownload("/de/cismet/cids/custom/reports/wunda_blau/mauer-hauptinfo.jasper", dataSourceGenerator, jobname, "Mauer Hauptinfo", "mauern_hauptinfo"));
        }
    }

    static {
        MauernProperties properties = null;
        try {
            properties = (MauernProperties)ServerResourcesLoaderClient.getInstance().get((PropertiesServerResource)WundaBlauServerResources.MAUERN_PROPERTIES.getValue(), true);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        PROPERTIES = properties;
    }
}

