/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.reports.wunda_blau.BillingStatisticsReport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PrintStatisticsReport
implements ConnectionContextProvider {
    protected final HashMap<String, Integer> productInformation = new HashMap();
    protected final Date[] fromDate_tillDate;
    protected final Collection<CidsBean> billingsBeans;
    protected int amountTotalDownloads = 0;
    protected int amountWithCosts = 0;
    protected int amountWithoutCosts = 0;
    protected int amountVUamtlicherLageplan = 0;
    protected int amountVUhoheitlicheVermessung = 0;
    protected int amountVUsonstige = 0;
    protected int amountWithCostsVU = 0;
    protected int amountWithCostsWiederver = 0;
    protected int amountWiederverkaeufe = 0;
    protected double earningsWithCostsVU = 0.0;
    protected double earningsWithCostsWiederver = 0.0;
    protected final Set<String> amountWiederverkaeufeGBs = new HashSet<String>();
    protected final Set<String> amountVUamtlicherLageplanGBs = new HashSet<String>();
    protected final Set<String> amountVUhoheitlicheVermessungGBs = new HashSet<String>();
    protected final Set<String> amountVUsonstigeGBs = new HashSet<String>();
    private final ConnectionContext connectionContext;

    public PrintStatisticsReport(Date[] fromDate_tillDate, Collection<CidsBean> billingsBeans, ConnectionContext connectionContext) {
        this.fromDate_tillDate = fromDate_tillDate;
        this.billingsBeans = billingsBeans;
        this.connectionContext = connectionContext;
        for (CidsBean billingBean : billingsBeans) {
            this.setCountersDependingOnVerwendungszweck(billingBean);
            this.addProductInformation(billingBean);
        }
    }

    public static void main(String[] args) throws Exception {
        CidsBean[] billings = new CidsBean[]{DevelopmentTools.createCidsBeanFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"kif", (String)"billing_billing", (int)6838)};
        ArrayList<CidsBean> list = new ArrayList<CidsBean>(1);
        list.add(billings[0]);
        System.out.println(PrintStatisticsReport.class.getResourceAsStream("/de/cismet/cids/custom/reports/wunda_blau/geschaeftsstatisktik.jasper"));
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        Date start = formatter.parse("01.05.2013");
        Date end = formatter.parse("31.05.2013");
        PrintStatisticsReport printStatisticsReport = new PrintStatisticsReport(new Date[]{start, end}, list, ConnectionContext.createDeprecated());
        BillingStatisticsReport report = printStatisticsReport.createReport();
        Map params = report.generateParamters();
        DevelopmentTools.showReportForBeans((String)"/de/cismet/cids/custom/reports/wunda_blau/geschaeftsstatisktik.jasper", list, (Map)params);
    }

    public void print() {
        if (!this.billingsBeans.isEmpty()) {
            BillingStatisticsReport report = this.createReport();
            report.generateReport();
        }
    }

    protected BillingStatisticsReport createReport() {
        return new BillingStatisticsReport(this.billingsBeans, this.fromDate_tillDate[0], this.fromDate_tillDate[1], this.amountTotalDownloads, this.amountWithCosts, this.amountWithoutCosts, this.amountVUamtlicherLageplan, this.amountVUhoheitlicheVermessung, this.amountVUsonstige, this.amountVUamtlicherLageplanGBs.size(), this.amountVUhoheitlicheVermessungGBs.size(), this.amountVUsonstigeGBs.size(), this.amountWithCostsVU, this.amountWithCostsWiederver, this.amountWiederverkaeufe, this.amountWiederverkaeufeGBs.size(), this.earningsWithCostsVU, this.earningsWithCostsWiederver, this.getConnectionContext());
    }

    private void setCountersDependingOnVerwendungszweck(CidsBean billing) {
        boolean withCosts;
        String verwendungsKey = (String)billing.getProperty("verwendungskey");
        String geschaeftsbuchnummer = (String)billing.getProperty("geschaeftsbuchnummer");
        boolean geschaeftsbuchnummerIsValid = false;
        if (geschaeftsbuchnummer != null && !geschaeftsbuchnummer.trim().equals("")) {
            geschaeftsbuchnummerIsValid = true;
        }
        ++this.amountTotalDownloads;
        Double nettoSum = (Double)billing.getProperty("netto_summe");
        if (nettoSum > 0.0) {
            ++this.amountWithCosts;
            withCosts = true;
        } else {
            ++this.amountWithoutCosts;
            withCosts = false;
        }
        if (verwendungsKey.startsWith("VU") && withCosts) {
            ++this.amountWithCostsVU;
            this.earningsWithCostsVU += nettoSum.doubleValue();
        }
        if (verwendungsKey.startsWith("WV")) {
            ++this.amountWiederverkaeufe;
            if (geschaeftsbuchnummerIsValid) {
                this.amountWiederverkaeufeGBs.add(geschaeftsbuchnummer);
            }
            if (withCosts) {
                ++this.amountWithCostsWiederver;
                this.earningsWithCostsWiederver += nettoSum.doubleValue();
            }
        }
        if (verwendungsKey.equals("VU aL")) {
            ++this.amountVUamtlicherLageplan;
            if (geschaeftsbuchnummerIsValid) {
                this.amountVUamtlicherLageplanGBs.add(geschaeftsbuchnummer);
            }
        } else if (verwendungsKey.equals("VU hV")) {
            ++this.amountVUhoheitlicheVermessung;
            if (geschaeftsbuchnummerIsValid) {
                this.amountVUhoheitlicheVermessungGBs.add(geschaeftsbuchnummer);
            }
        } else if (verwendungsKey.equals("VU s")) {
            ++this.amountVUsonstige;
            if (geschaeftsbuchnummerIsValid) {
                this.amountVUsonstigeGBs.add(geschaeftsbuchnummer);
            }
        }
    }

    private void addProductInformation(CidsBean billingBean) {
        String verwendungszweck = (String)billingBean.getProperty("verwendungszweck");
        if (this.productInformation.containsKey(verwendungszweck)) {
            Integer amount = this.productInformation.get(verwendungszweck);
            amount = amount + 1;
            this.productInformation.put(verwendungszweck, amount);
        } else {
            this.productInformation.put(verwendungszweck, 1);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

