/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import de.cismet.cids.custom.reports.wunda_blau.AbstractReportBeanWithMapAndImages;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.CismetThreadPool;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public abstract class ReportBeanWithMapAndTwoUrlImages
extends AbstractReportBeanWithMapAndImages
implements ConnectionContextProvider {
    private static final transient Logger LOG = Logger.getLogger(ReportBeanWithMapAndTwoUrlImages.class);

    public ReportBeanWithMapAndTwoUrlImages(CidsBean cidsBean, ConnectionContext connectionContext) {
        this(cidsBean, null, connectionContext);
    }

    public ReportBeanWithMapAndTwoUrlImages(CidsBean cidsBean, String mapUrl, ConnectionContext connectionContext) {
        super(cidsBean, mapUrl, connectionContext);
        this.initImgStates();
    }

    protected abstract URL getUrl(CidsBean var1) throws Exception;

    @Override
    protected void initImgStates() {
        List<CidsBean> imageBeans = this.getImageBeans();
        if (imageBeans != null) {
            try {
                this.setImgState0(this.loadImage(imageBeans.size() > 0 ? imageBeans.get(0) : null, true));
            }
            catch (Exception ex) {
                LOG.error((Object)"error while loading url0", (Throwable)ex);
            }
            try {
                this.setImgState1(this.loadImage(imageBeans.size() > 1 ? imageBeans.get(1) : null, false));
            }
            catch (Exception ex) {
                LOG.error((Object)"error while loading url1", (Throwable)ex);
            }
        }
    }

    private AbstractReportBeanWithMapAndImages.ImageState loadImage(final CidsBean imageBean, final boolean oneOrTwo) throws Exception {
        final AbstractReportBeanWithMapAndImages.ImageState imgState = new AbstractReportBeanWithMapAndImages.ImageState();
        if (imageBean != null) {
            CismetThreadPool.execute((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        URL url = ReportBeanWithMapAndTwoUrlImages.this.getUrl(imageBean);
                        if (url == null) {
                            imgState.setError(true);
                            return;
                        }
                        InputStream iStream = WebAccessManager.getInstance().doRequest(url);
                        BufferedImage img = ImageIO.read(iStream);
                        if (img == null) {
                            imgState.setError(true);
                            LOG.warn((Object)"error during image retrieval from Rasterfari");
                        }
                        imgState.setImg(img);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                        imgState.setError(true);
                    }
                    finally {
                        if (oneOrTwo) {
                            ReportBeanWithMapAndTwoUrlImages.this.setImg0Ready(true);
                        } else {
                            ReportBeanWithMapAndTwoUrlImages.this.setImg1Ready(true);
                        }
                    }
                }
            });
        } else if (oneOrTwo) {
            this.setImg0Ready(true);
        } else {
            this.setImg1Ready(true);
        }
        return imgState;
    }
}

