/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objecteditors.wunda_blau.TreppeEditor;
import de.cismet.cids.custom.reports.wunda_blau.ReportBeanWithMapAndTwoWebDavImages;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class TreppenReportBean
extends ReportBeanWithMapAndTwoWebDavImages {
    private static final WebDavTunnelHelper WEBDAV_HELPER;
    private static final String WEBDAV_DIRECTORY;
    private final Collection<StuetzMauerBean> stuetzmauern = new ArrayList<StuetzMauerBean>();
    private final Double zustandStuetzmauern;
    private final Double kostenStuetzmauern;

    public TreppenReportBean(CidsBean treppe, TreppeEditor editor, ConnectionContext connectionContext) {
        super(treppe, ResourceBundle.getBundle("de/cismet/cids/custom/reports/wunda_blau/MauernReport").getString("map_url"), WEBDAV_HELPER, WEBDAV_DIRECTORY, connectionContext);
        this.zustandStuetzmauern = editor.getZustandStuetzmauern();
        this.kostenStuetzmauern = editor.getKostenStuetzmauern();
        for (CidsBean treppeMauerBean : editor.getMauerBeans().keySet()) {
            CidsBean mauerBean = editor.getMauerBeans().get(treppeMauerBean);
            Boolean bauwerk = true;
            String name = (String)mauerBean.getProperty("lagebezeichnung");
            String art = (String)mauerBean.getProperty("materialtyp.name");
            String wo = (String)treppeMauerBean.getProperty("wo");
            StuetzMauerBean stuetzmauer = new StuetzMauerBean(bauwerk, name, art, wo);
            this.stuetzmauern.add(stuetzmauer);
        }
    }

    @Override
    protected String getDavFile(CidsBean cidsBean) {
        return (String)cidsBean.getProperty("url.object_name");
    }

    @Override
    protected List<CidsBean> getImageBeans() {
        return this.getCidsBean() != null ? this.getCidsBean().getBeanCollectionProperty("bilder").stream().filter(b -> b.getProperty("laufende_nummer") != null).sorted(Comparator.comparing(b -> (Integer)b.getProperty("laufende_nummer"), Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList()) : null;
    }

    @Override
    protected Geometry getGeometry() {
        return this.getCidsBean() != null ? (Geometry)this.getCidsBean().getProperty("geometrie.geo_field") : null;
    }

    public CidsBean getTreppe() {
        return this.getCidsBean();
    }

    public Collection<StuetzMauerBean> getStuetzmauern() {
        return this.stuetzmauern;
    }

    public Double getZustandStuetzmauern() {
        return this.zustandStuetzmauern;
    }

    public Double getKostenStuetzmauern() {
        return this.kostenStuetzmauern;
    }

    static {
        ResourceBundle webDavBundle = ResourceBundle.getBundle("WebDav");
        String pass = webDavBundle.getString("password");
        if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
            pass = PasswordEncrypter.decryptString((String)pass);
        }
        String webDavPassword = pass;
        String webDavUser = webDavBundle.getString("user");
        WEBDAV_HELPER = new WebDavTunnelHelper("WUNDA_BLAU", ProxyHandler.getInstance().getProxy(), webDavUser, webDavPassword, Boolean.valueOf(false));
        WEBDAV_DIRECTORY = webDavBundle.getString("url_treppen");
    }

    public class StuetzMauerBean {
        private final Boolean treppenbauwerk;
        private final String name;
        private final String art;
        private final String wo;

        public Boolean getTreppenbauwerk() {
            return this.treppenbauwerk;
        }

        public String getName() {
            return this.name;
        }

        public String getArt() {
            return this.art;
        }

        public String getWo() {
            return this.wo;
        }

        public StuetzMauerBean(Boolean treppenbauwerk, String name, String art, String wo) {
            this.treppenbauwerk = treppenbauwerk;
            this.name = name;
            this.art = art;
            this.wo = wo;
        }
    }
}

