/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.templateinscriber;

import de.cismet.cids.custom.clientutils.ConversionUtils;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.printing.AbstractPrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FileNameChangedEvent;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriberListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class A4HMap1Picture
extends AbstractPrintingInscriber
implements DropTargetListener,
FilenamePrintingInscriber {
    public static final String KEY_HIGHLIGHT = "Ueberschrift";
    public static final String KEY_SIGNATURE = "Unterschrift";
    public static final String KEY_E_NR = "ENr";
    public static final String KEY_LOC_DESC = "Lagebezeichnung";
    public static final String KEY_DATA = "Datenart";
    public static final String KEY_DATASOURCES = "Datenquellen";
    private static final String CBO_DATA_PROPERTIES = "CboData.properties";
    private static final Logger LOG = Logger.getLogger(A4HMap1Picture.class);
    private static final String FILE_PROTOCOL_PREFIX = "file://";
    private static final String IMAGE = "image";
    String cacheFile = "";
    Properties cache = new Properties();
    private final ArrayList<JCheckBox> chkDataSourcesList;
    private final Logger log = Logger.getLogger(this.getClass());
    private DropTarget dropTarget;
    private String lastPath = null;
    private File file = null;
    private List<FilenamePrintingInscriberListener> listeners = new ArrayList<FilenamePrintingInscriberListener>();
    private String oldText = "";
    private JComboBox cboData;
    private JPanel filePanel;
    private JButton jButton1;
    private JScrollPane jScrollPane2;
    private JLabel lblData;
    private JLabel lblData1;
    private JLabel lblDataSources;
    private JLabel lblENr;
    private JLabel lblFile;
    private JLabel lblHighlight;
    private JLabel lblLocationDescription;
    private JLabel lblSignature;
    private JPanel pnlDataSources;
    private JTextField txtENr;
    private JTextField txtHighlight;
    private JTextField txtLocationDescription;
    private JTextField txtSignature;

    public A4HMap1Picture() {
        this.initComponents();
        this.cacheFile = CismapBroker.getInstance().getCismapFolderPath() + System.getProperty("file.separator") + "inscriberCache";
        this.readInscriberCache();
        this.chkDataSourcesList = new ArrayList();
        this.setUpDataSourceChks();
        this.setUpDataCbo();
        this.dropTarget = new DropTarget((Component)((Object)this), this);
        new DropTarget(this.lblFile, this);
        this.oldText = this.txtHighlight.getText();
        this.txtHighlight.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            private void onChange(DocumentEvent e) {
                FileNameChangedEvent event = new FileNameChangedEvent(A4HMap1Picture.this.oldText, A4HMap1Picture.this.txtHighlight.getText());
                for (FilenamePrintingInscriberListener listener : A4HMap1Picture.this.listeners) {
                    listener.fileNameChanged(event);
                }
                A4HMap1Picture.this.oldText = A4HMap1Picture.this.txtHighlight.getText();
            }
        });
    }

    private void setUpDataSourceChks() {
        CismapBroker broker = CismapBroker.getInstance();
        MappingComponent mapComp = broker.getMappingComponent();
        MappingModel mapModel = mapComp.getMappingModel();
        TreeMap rasterServices = mapModel.getRasterServices();
        for (Object v : rasterServices.values()) {
            boolean retrievalServiceLayerCheck;
            boolean serviceLayerCheck = v instanceof ServiceLayer && ((ServiceLayer)v).isEnabled() && ((ServiceLayer)v).getTranslucency() > 0.0f || !(v instanceof ServiceLayer);
            boolean bl = retrievalServiceLayerCheck = v instanceof RetrievalServiceLayer && ((RetrievalServiceLayer)v).getPNode().getVisible() || !(v instanceof MapService);
            if (!serviceLayerCheck || !retrievalServiceLayerCheck) continue;
            JCheckBox chkDataSource = new JCheckBox(v.toString());
            chkDataSource.setSelected(true);
            this.pnlDataSources.add((Component)chkDataSource, 0);
            this.chkDataSourcesList.add(chkDataSource);
        }
        Collections.reverse(this.chkDataSourcesList);
    }

    private void setUpDataCbo() {
        InputStream in = this.getClass().getResourceAsStream(CBO_DATA_PROPERTIES);
        if (in == null) {
            LOG.error((Object)"Can not configuration file 'CboData.properties' in classpath. -> data combo box is empty");
        } else {
            Properties prop = new Properties();
            try {
                prop.load(in);
                TreeMap<Object, Object> propTreeMap = new TreeMap<Object, Object>(prop);
                Iterator<Object> it = propTreeMap.values().iterator();
                while (it.hasNext()) {
                    this.cboData.addItem(it.next());
                }
                this.cboData.setSelectedIndex(0);
            }
            catch (Exception ex) {
                LOG.error((Object)"An error occurred while reading configuration file 'CboData.properties' -> data combo box is empty", (Throwable)ex);
            }
        }
    }

    private String getSelectedDataSourcesString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirstIter = true;
        for (JCheckBox chk : this.chkDataSourcesList) {
            if (!chk.isSelected()) continue;
            if (isFirstIter) {
                isFirstIter = false;
            } else {
                stringBuilder.append('\n');
            }
            stringBuilder.append("- ").append(chk.getText());
        }
        return stringBuilder.toString();
    }

    public HashMap<String, String> getValues() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put(KEY_HIGHLIGHT, this.txtHighlight.getText());
        hm.put(KEY_SIGNATURE, this.txtSignature.getText());
        hm.put(KEY_E_NR, this.txtENr.getText());
        hm.put(KEY_LOC_DESC, this.txtLocationDescription.getText());
        hm.put(KEY_DATA, String.valueOf(this.cboData.getSelectedItem()));
        hm.put(KEY_DATASOURCES, this.getSelectedDataSourcesString());
        try {
            if (this.file != null) {
                BufferedImage image = ImageIO.read(this.file);
                hm.put(IMAGE, ConversionUtils.image2String(image));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read image", (Throwable)e);
        }
        this.cache.setProperty(KEY_HIGHLIGHT, this.txtHighlight.getText());
        this.cache.setProperty(KEY_SIGNATURE, this.txtSignature.getText());
        this.cache.setProperty(KEY_E_NR, this.txtENr.getText());
        this.cache.setProperty(KEY_LOC_DESC, this.txtLocationDescription.getText());
        this.writeInscriberCache();
        return hm;
    }

    private void initComponents() {
        this.lblHighlight = new JLabel();
        this.txtHighlight = new JTextField();
        this.lblSignature = new JLabel();
        this.txtSignature = new JTextField();
        this.lblENr = new JLabel();
        this.txtENr = new JTextField();
        this.lblLocationDescription = new JLabel();
        this.txtLocationDescription = new JTextField();
        this.lblData = new JLabel();
        this.cboData = new JComboBox();
        this.lblDataSources = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.pnlDataSources = new JPanel();
        this.lblData1 = new JLabel();
        this.filePanel = new JPanel();
        this.lblFile = new JLabel();
        this.jButton1 = new JButton();
        this.setPreferredSize(new Dimension(312, 245));
        this.setLayout(new GridBagLayout());
        this.lblHighlight.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblHighlight.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblHighlight, gridBagConstraints);
        this.lblHighlight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblHighlight.AccessibleContext.accessibleName"));
        this.txtHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                A4HMap1Picture.this.txtHighlightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.txtHighlight, gridBagConstraints);
        this.lblSignature.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblSignature.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblSignature, gridBagConstraints);
        this.lblSignature.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblSignature.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.txtSignature, gridBagConstraints);
        this.lblENr.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblENr.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 0);
        this.add(this.lblENr, gridBagConstraints);
        this.lblENr.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblENr.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 10);
        this.add(this.txtENr, gridBagConstraints);
        this.lblLocationDescription.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblLocationDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblLocationDescription, gridBagConstraints);
        this.lblLocationDescription.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblLocationDescription.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.txtLocationDescription, gridBagConstraints);
        this.lblData.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblData.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblData, gridBagConstraints);
        this.lblData.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblData.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.cboData, gridBagConstraints);
        this.lblDataSources.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblDataSources.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add(this.lblDataSources, gridBagConstraints);
        this.lblDataSources.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblDataSources.AccessibleContext.accessibleName"));
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane2.setMinimumSize(new Dimension(125, 56));
        this.jScrollPane2.setOpaque(false);
        this.pnlDataSources.setFocusTraversalPolicyProvider(true);
        this.pnlDataSources.setMinimumSize(new Dimension(123, 20));
        this.pnlDataSources.setLayout(new BoxLayout(this.pnlDataSources, 1));
        this.jScrollPane2.setViewportView(this.pnlDataSources);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add(this.jScrollPane2, gridBagConstraints);
        this.lblData1.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.lblData1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblData1, gridBagConstraints);
        this.filePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.filePanel.add((Component)this.lblFile, gridBagConstraints);
        this.jButton1.setText(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.jButton1.text", (Object[])new Object[0]));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                A4HMap1Picture.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.filePanel.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.filePanel, gridBagConstraints);
    }

    private void txtHighlightActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        File file = StaticSwingTools.chooseFile((String)this.lastPath, (boolean)false, null, (String)"(*)", (Component)((Object)this));
        if (file != null) {
            this.lastPath = file.getParent();
            this.setFile(file);
        }
    }

    private void readInscriberCache() {
        try {
            this.cache.load(new FileInputStream(this.cacheFile));
            String h = this.cache.getProperty(KEY_HIGHLIGHT);
            String s = this.cache.getProperty(KEY_SIGNATURE);
            String l = this.cache.getProperty(KEY_LOC_DESC);
            String e = this.cache.getProperty(KEY_E_NR);
            this.txtHighlight.setText(h);
            this.txtSignature.setText(s);
            this.txtENr.setText(e);
            this.txtLocationDescription.setText(l);
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error while reading the InscriberCache", t);
        }
    }

    private void writeInscriberCache() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    A4HMap1Picture.this.cache.store(new FileOutputStream(A4HMap1Picture.this.cacheFile), "Saved: " + System.currentTimeMillis());
                }
                catch (Throwable t) {
                    A4HMap1Picture.this.log.warn((Object)"Error while writing the InscriberCache", t);
                }
            }
        };
        CismetThreadPool.execute((Runnable)r);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            boolean isAccepted = false;
            for (int i = 0; i < flavors.length; ++i) {
                String tmp;
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(dtde.getDropAction());
                    List files = (List)tr.getTransferData(flavors[i]);
                    if (files != null && files.size() > 0) {
                        this.setFile((File)files.get(0));
                    }
                    dtde.dropComplete(true);
                    return;
                }
                if (!flavors[i].isRepresentationClassInputStream()) continue;
                if (!isAccepted) {
                    dtde.acceptDrop(dtde.getDropAction());
                    isAccepted = true;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tr.getTransferData(flavors[i])));
                ArrayList<File> fileList = new ArrayList<File>();
                while ((tmp = br.readLine()) != null) {
                    if (!tmp.trim().startsWith(FILE_PROTOCOL_PREFIX)) continue;
                    File f = new File(tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()));
                    if (f.exists()) {
                        fileList.add(f);
                        continue;
                    }
                    f = new File(URLDecoder.decode(tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()), "UTF-8"));
                    if (f.exists()) {
                        fileList.add(f);
                        continue;
                    }
                    this.log.warn((Object)("File " + f.toString() + " does not exist."));
                }
                br.close();
                if (fileList.size() <= 0) continue;
                this.setFile((File)fileList.get(0));
                dtde.dropComplete(true);
                return;
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)ex, (Throwable)ex);
        }
        dtde.rejectDrop();
    }

    private void setFile(File imageFile) {
        try {
            BufferedImage image = ImageIO.read(imageFile);
            if (image != null) {
                this.file = imageFile;
                this.lblFile.setText(imageFile.getName());
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.setFile().null.message"), NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.setFile().null.title"), 0);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read image", (Throwable)e);
            ErrorInfo errorInfo = new ErrorInfo(NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.setFile().exception.title"), NbBundle.getMessage(A4HMap1Picture.class, (String)"A4HMap1Picture.setFile().exception.message"), null, null, (Throwable)e, Level.ALL, null);
            JXErrorPane.showDialog((Component)CismapBroker.getInstance().getMappingComponent(), (ErrorInfo)errorInfo);
        }
    }

    public void addFilenameChangeListener(FilenamePrintingInscriberListener listener) {
        this.listeners.add(listener);
    }

    public String getFileName() {
        return this.txtHighlight.getText();
    }
}

