/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.templateinscriber;

import de.cismet.cids.custom.clientutils.ConversionUtils;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.printing.AbstractPrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FileNameChangedEvent;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriberListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openide.util.NbBundle;

public class A4HMapMultiPicture
extends AbstractPrintingInscriber
implements DropTargetListener,
FilenamePrintingInscriber {
    public static final String KEY_HEAD = "Ueberschrift";
    public static final String KEY_TITLE = "Titel";
    public static final String KEY_DATE = "Datum";
    public static final String KEY_NAME = "Name";
    public static final String KEY_PUBLISHER = "Herausgeber";
    public static final String KEY_COPYRIGHT = "Copyright";
    public static final String KEY_COPYRIGHT_NAME = "Copyright Name";
    public static final String KEY_DATASOURCES = "Datenquellen";
    private static final String COPYRIGHT_PROPERTIES = "/copyrights.xml";
    private static final Logger LOG = Logger.getLogger(A4HMapMultiPicture.class);
    private static final String FILE_PROTOCOL_PREFIX = "file://";
    private static final String IMAGE1 = "Bild1";
    private static final String IMAGE2 = "Bild2";
    private static final String IMAGE3 = "Bild3";
    private static final String SIGNATURE1 = "Unterschrift1";
    private static final String SIGNATURE2 = "Unterschrift2";
    private static final String SIGNATURE3 = "Unterschrift3";
    String cacheFile = "";
    Properties cache = new Properties();
    private final ArrayList<JCheckBox> chkDataSourcesList;
    private final Logger log = Logger.getLogger(this.getClass());
    private String lastPath = null;
    private CustomTableModel model = new CustomTableModel();
    private final Map<String, String> copyrightMap = new HashMap<String, String>();
    private DropTarget dropTarget;
    private List<FilenamePrintingInscriberListener> listeners = new ArrayList<FilenamePrintingInscriberListener>();
    private String oldText = "";
    private JComboBox cboCopyright;
    private JPanel filePanel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblData;
    private JLabel lblData1;
    private JLabel lblDataSources;
    private JLabel lblENr;
    private JLabel lblHighlight;
    private JLabel lblHighlight1;
    private JLabel lblLocationDescription;
    private JLabel lblSignature;
    private JPanel pnlDataSources;
    private JTable tabFile;
    private JTextField txtAuthor;
    private JTextField txtDate;
    private JTextField txtHead;
    private JTextField txtName;
    private JTextField txtTitle;

    public A4HMapMultiPicture() {
        this.initComponents();
        this.cacheFile = CismapBroker.getInstance().getCismapFolderPath() + System.getProperty("file.separator") + "multiPictureinscriberCache";
        this.readInscriberCache();
        this.chkDataSourcesList = new ArrayList();
        this.setUpDataSourceChks();
        this.setUpDataCbo();
        this.tabFile.setModel(this.model);
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modelRow = Integer.valueOf(e.getActionCommand());
                File file = StaticSwingTools.chooseFile((String)A4HMapMultiPicture.this.lastPath, (boolean)false, null, (String)"Alle Dateien", (Component)((Object)A4HMapMultiPicture.this));
                if (file != null) {
                    A4HMapMultiPicture.this.lastPath = file.getParent();
                    A4HMapMultiPicture.this.setFile(file, modelRow);
                } else {
                    A4HMapMultiPicture.this.model.setFileName(modelRow, "");
                    A4HMapMultiPicture.this.model.setValueAt("", modelRow, 0);
                    A4HMapMultiPicture.this.model.fireContentsChanged();
                }
            }
        };
        ButtonColumn bc = new ButtonColumn(this.tabFile, a, 1);
        this.tabFile.getColumn(this.tabFile.getColumnName(1)).setCellRenderer(bc);
        this.tabFile.getColumn(this.tabFile.getColumnName(1)).setCellEditor(bc);
        this.tabFile.getColumn(this.tabFile.getColumnName(1)).setPreferredWidth(25);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                A4HMapMultiPicture.this.setColWidth();
            }
        });
        this.tabFile.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                A4HMapMultiPicture.this.setColWidth();
            }
        });
        this.dropTarget = new DropTarget((Component)((Object)this), this);
        new DropTarget(this.tabFile, this);
        this.oldText = this.txtTitle.getText();
        this.txtTitle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            private void onChange(DocumentEvent e) {
                FileNameChangedEvent event = new FileNameChangedEvent(A4HMapMultiPicture.this.oldText, A4HMapMultiPicture.this.txtTitle.getText());
                for (FilenamePrintingInscriberListener listener : A4HMapMultiPicture.this.listeners) {
                    listener.fileNameChanged(event);
                }
                A4HMapMultiPicture.this.oldText = A4HMapMultiPicture.this.txtTitle.getText();
            }
        });
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.setColWidth();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setColWidth();
    }

    private void setColWidth() {
        if (this.tabFile.getSize().getWidth() > 30.0) {
            this.tabFile.getColumn(this.tabFile.getColumnName(0)).setWidth(((int)this.tabFile.getSize().getWidth() - 25) / 2);
            this.tabFile.getColumn(this.tabFile.getColumnName(1)).setWidth(25);
            this.tabFile.getColumn(this.tabFile.getColumnName(2)).setWidth(((int)this.tabFile.getSize().getWidth() - 25) / 2);
            this.tabFile.getColumn(this.tabFile.getColumnName(0)).setMinWidth(((int)this.tabFile.getSize().getWidth() - 25) / 2);
            this.tabFile.getColumn(this.tabFile.getColumnName(1)).setMinWidth(25);
            this.tabFile.getColumn(this.tabFile.getColumnName(2)).setMinWidth(((int)this.tabFile.getSize().getWidth() - 25) / 2);
        }
    }

    private void setUpDataSourceChks() {
        CismapBroker broker = CismapBroker.getInstance();
        MappingComponent mapComp = broker.getMappingComponent();
        MappingModel mapModel = mapComp.getMappingModel();
        TreeMap rasterServices = mapModel.getRasterServices();
        for (Object v : rasterServices.values()) {
            boolean retrievalServiceLayerCheck;
            boolean serviceLayerCheck = v instanceof ServiceLayer && ((ServiceLayer)v).isEnabled() && ((ServiceLayer)v).getTranslucency() > 0.0f || !(v instanceof ServiceLayer);
            boolean bl = retrievalServiceLayerCheck = v instanceof RetrievalServiceLayer && ((RetrievalServiceLayer)v).getPNode().getVisible() || !(v instanceof MapService);
            if (!serviceLayerCheck || !retrievalServiceLayerCheck) continue;
            JCheckBox chkDataSource = new JCheckBox(v.toString());
            chkDataSource.setSelected(true);
            this.pnlDataSources.add((Component)chkDataSource, 0);
            this.chkDataSourcesList.add(chkDataSource);
        }
        Collections.reverse(this.chkDataSourcesList);
    }

    private void setUpDataCbo() {
        InputStream in = this.getClass().getResourceAsStream(COPYRIGHT_PROPERTIES);
        if (in == null) {
            LOG.error((Object)"Can not configuration file '/copyrights.xml' in classpath. -> data combo box is empty");
        } else {
            try {
                SAXBuilder builder = new SAXBuilder(false);
                Document doc = builder.build(in);
                Element rootObject = doc.getRootElement();
                for (Object entry : rootObject.getChildren("copyrightEntry")) {
                    if (!(entry instanceof Element)) continue;
                    Element copyrightEntry = (Element)entry;
                    String name = copyrightEntry.getChildText("name");
                    String text = copyrightEntry.getChildText("text");
                    this.cboCopyright.addItem(name);
                    this.copyrightMap.put(name, text);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while reading the list with the recently opened files", (Throwable)e);
            }
        }
    }

    private String getSelectedDataSourcesString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirstIter = true;
        for (JCheckBox chk : this.chkDataSourcesList) {
            if (!chk.isSelected()) continue;
            if (isFirstIter) {
                isFirstIter = false;
            } else {
                stringBuilder.append('\n');
            }
            stringBuilder.append("- ").append(chk.getText());
        }
        return stringBuilder.toString();
    }

    public HashMap<String, String> getValues() {
        BufferedImage image;
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put(KEY_NAME, this.txtName.getText());
        hm.put(KEY_HEAD, this.txtHead.getText());
        hm.put(KEY_DATE, this.txtDate.getText());
        hm.put(KEY_TITLE, this.txtTitle.getText());
        hm.put(KEY_PUBLISHER, this.txtAuthor.getText());
        hm.put(KEY_COPYRIGHT_NAME, String.valueOf(this.cboCopyright.getSelectedItem()));
        hm.put(KEY_COPYRIGHT, this.copyrightMap.get(String.valueOf(this.cboCopyright.getSelectedItem())));
        hm.put(KEY_DATASOURCES, this.getSelectedDataSourcesString());
        String imageString = null;
        try {
            imageString = this.model.getFileName(0);
            if (imageString != null && !imageString.equals("")) {
                image = ImageIO.read(new File(imageString));
                hm.put(IMAGE1, ConversionUtils.image2String(image));
                hm.put(SIGNATURE1, (String)this.model.getValueAt(0, 2));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read image", (Throwable)e);
        }
        try {
            imageString = this.model.getFileName(1);
            if (imageString != null && !imageString.equals("")) {
                image = ImageIO.read(new File(imageString));
                hm.put(IMAGE2, ConversionUtils.image2String(image));
                hm.put(SIGNATURE2, (String)this.model.getValueAt(1, 2));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read image", (Throwable)e);
        }
        try {
            imageString = this.model.getFileName(2);
            if (imageString != null && !imageString.equals("")) {
                image = ImageIO.read(new File(imageString));
                hm.put(IMAGE3, ConversionUtils.image2String(image));
                hm.put(SIGNATURE3, (String)this.model.getValueAt(2, 2));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read image", (Throwable)e);
        }
        this.cache.setProperty(KEY_NAME, this.txtName.getText());
        this.cache.setProperty(KEY_HEAD, this.txtHead.getText());
        this.cache.setProperty(KEY_DATE, this.txtDate.getText());
        this.cache.setProperty(KEY_TITLE, this.txtTitle.getText());
        this.cache.setProperty(KEY_PUBLISHER, this.txtAuthor.getText());
        this.cache.setProperty(KEY_COPYRIGHT_NAME, String.valueOf(this.cboCopyright.getSelectedItem()));
        this.writeInscriberCache();
        return hm;
    }

    private void initComponents() {
        this.lblHighlight = new JLabel();
        this.txtName = new JTextField();
        this.lblSignature = new JLabel();
        this.txtDate = new JTextField();
        this.lblENr = new JLabel();
        this.txtHead = new JTextField();
        this.lblLocationDescription = new JLabel();
        this.txtTitle = new JTextField();
        this.lblData = new JLabel();
        this.cboCopyright = new JComboBox();
        this.lblDataSources = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.pnlDataSources = new JPanel();
        this.lblData1 = new JLabel();
        this.filePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tabFile = new JTable();
        this.lblHighlight1 = new JLabel();
        this.txtAuthor = new JTextField();
        this.setPreferredSize(new Dimension(312, 245));
        this.setLayout(new GridBagLayout());
        this.lblHighlight.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblHighlight.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblHighlight, gridBagConstraints);
        this.lblHighlight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblHighlight.AccessibleContext.accessibleName"));
        this.txtName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                A4HMapMultiPicture.this.txtNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.txtName, gridBagConstraints);
        this.lblSignature.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblSignature.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblSignature, gridBagConstraints);
        this.lblSignature.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblSignature.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.txtDate, gridBagConstraints);
        this.lblENr.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblENr.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 0);
        this.add(this.lblENr, gridBagConstraints);
        this.lblENr.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblENr.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 10);
        this.add(this.txtHead, gridBagConstraints);
        this.lblLocationDescription.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblLocationDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblLocationDescription, gridBagConstraints);
        this.lblLocationDescription.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblLocationDescription.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.txtTitle, gridBagConstraints);
        this.lblData.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblData.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblData, gridBagConstraints);
        this.lblData.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblData.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.cboCopyright, gridBagConstraints);
        this.lblDataSources.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblDataSources.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add(this.lblDataSources, gridBagConstraints);
        this.lblDataSources.getAccessibleContext().setAccessibleName(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblDataSources.AccessibleContext.accessibleName"));
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane2.setMinimumSize(new Dimension(125, 56));
        this.jScrollPane2.setOpaque(false);
        this.pnlDataSources.setFocusTraversalPolicyProvider(true);
        this.pnlDataSources.setMinimumSize(new Dimension(123, 20));
        this.pnlDataSources.setLayout(new BoxLayout(this.pnlDataSources, 1));
        this.jScrollPane2.setViewportView(this.pnlDataSources);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add(this.jScrollPane2, gridBagConstraints);
        this.lblData1.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblData1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblData1, gridBagConstraints);
        this.filePanel.setMaximumSize(new Dimension(452, 70));
        this.filePanel.setMinimumSize(new Dimension(452, 70));
        this.filePanel.setPreferredSize(new Dimension(452, 70));
        this.filePanel.setLayout(new GridBagLayout());
        this.tabFile.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tabFile);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.filePanel, gridBagConstraints);
        this.lblHighlight1.setText(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.lblHighlight1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.lblHighlight1, gridBagConstraints);
        this.txtAuthor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                A4HMapMultiPicture.this.txtAuthorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add(this.txtAuthor, gridBagConstraints);
    }

    private void txtNameActionPerformed(ActionEvent evt) {
    }

    private void txtAuthorActionPerformed(ActionEvent evt) {
    }

    private void setFile(File imageFile, int index) {
        try {
            BufferedImage image = ImageIO.read(imageFile);
            if (image != null) {
                this.model.setValueAt(imageFile.getName(), index, 0);
                this.model.setFileName(index, imageFile.getAbsolutePath());
                this.model.fireContentsChanged();
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.setFile().null.message"), NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.setFile().null.title"), 0);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read image", (Throwable)e);
            ErrorInfo errorInfo = new ErrorInfo(NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.setFile().exception.title"), NbBundle.getMessage(A4HMapMultiPicture.class, (String)"A4HMapMultiPicture.setFile().exception.message"), null, null, (Throwable)e, Level.ALL, null);
            JXErrorPane.showDialog((Component)CismapBroker.getInstance().getMappingComponent(), (ErrorInfo)errorInfo);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            boolean isAccepted = false;
            for (int i = 0; i < flavors.length; ++i) {
                String tmp;
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(dtde.getDropAction());
                    List files = (List)tr.getTransferData(flavors[i]);
                    if (files != null && files.size() > 0) {
                        int row = this.tabFile.rowAtPoint(dtde.getLocation());
                        this.setFile((File)files.get(0), row);
                    }
                    dtde.dropComplete(true);
                    return;
                }
                if (!flavors[i].isRepresentationClassInputStream()) continue;
                if (!isAccepted) {
                    dtde.acceptDrop(dtde.getDropAction());
                    isAccepted = true;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tr.getTransferData(flavors[i])));
                ArrayList<File> fileList = new ArrayList<File>();
                while ((tmp = br.readLine()) != null) {
                    if (!tmp.trim().startsWith(FILE_PROTOCOL_PREFIX)) continue;
                    File f = new File(tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()));
                    if (f.exists()) {
                        fileList.add(f);
                        continue;
                    }
                    f = new File(URLDecoder.decode(tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()), "UTF-8"));
                    if (f.exists()) {
                        fileList.add(f);
                        continue;
                    }
                    this.log.warn((Object)("File " + f.toString() + " does not exist."));
                }
                br.close();
                if (fileList.size() <= 0) continue;
                int row = this.tabFile.rowAtPoint(dtde.getLocation());
                this.setFile((File)fileList.get(0), row);
                dtde.dropComplete(true);
                return;
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)ex, (Throwable)ex);
        }
        dtde.rejectDrop();
    }

    private void readInscriberCache() {
        try {
            this.cache.load(new FileInputStream(this.cacheFile));
            String n = this.cache.getProperty(KEY_NAME);
            String d = this.cache.getProperty(KEY_DATE);
            String t = this.cache.getProperty(KEY_TITLE);
            String h = this.cache.getProperty(KEY_HEAD);
            String a = this.cache.getProperty(KEY_PUBLISHER);
            String copyright = this.cache.getProperty(KEY_COPYRIGHT_NAME);
            this.txtName.setText(n);
            this.txtDate.setText(d);
            this.txtHead.setText(h);
            this.txtTitle.setText(t);
            this.txtAuthor.setText(a);
            this.cboCopyright.setSelectedItem(copyright);
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error while reading the InscriberCache", t);
        }
    }

    private void writeInscriberCache() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    A4HMapMultiPicture.this.cache.store(new FileOutputStream(A4HMapMultiPicture.this.cacheFile), "Saved: " + System.currentTimeMillis());
                }
                catch (Throwable t) {
                    A4HMapMultiPicture.this.log.warn((Object)"Error while writing the InscriberCache", t);
                }
            }
        };
        CismetThreadPool.execute((Runnable)r);
    }

    public void addFilenameChangeListener(FilenamePrintingInscriberListener listener) {
        this.listeners.add(listener);
    }

    public String getFileName() {
        return this.txtTitle.getText();
    }

    public class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener,
    MouseListener {
        private JTable table;
        private Action action;
        private int mnemonic;
        private Border originalBorder;
        private Border focusBorder;
        private JButton renderButton;
        private JButton editButton;
        private Object editorValue;
        private boolean isButtonColumnEditor;

        public ButtonColumn(JTable table, Action action, int column) {
            this.table = table;
            this.action = action;
            this.renderButton = new JButton();
            this.editButton = new JButton();
            this.editButton.setFocusPainted(false);
            this.editButton.addActionListener(this);
            this.originalBorder = this.editButton.getBorder();
            this.setFocusBorder(new LineBorder(Color.BLUE));
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(column).setCellRenderer(this);
            columnModel.getColumn(column).setCellEditor(this);
            table.addMouseListener(this);
        }

        public Border getFocusBorder() {
            return this.focusBorder;
        }

        public void setFocusBorder(Border focusBorder) {
            this.focusBorder = focusBorder;
            this.editButton.setBorder(focusBorder);
        }

        public int getMnemonic() {
            return this.mnemonic;
        }

        public void setMnemonic(int mnemonic) {
            this.mnemonic = mnemonic;
            this.renderButton.setMnemonic(mnemonic);
            this.editButton.setMnemonic(mnemonic);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.editButton.setText("");
                this.editButton.setIcon(null);
            } else if (value instanceof Icon) {
                this.editButton.setText("");
                this.editButton.setIcon((Icon)value);
            } else {
                this.editButton.setText(value.toString());
                this.editButton.setIcon(null);
            }
            this.editorValue = value;
            return this.editButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.renderButton.setForeground(table.getSelectionForeground());
                this.renderButton.setBackground(table.getSelectionBackground());
            } else {
                this.renderButton.setForeground(table.getForeground());
                this.renderButton.setBackground(UIManager.getColor("Button.background"));
            }
            if (hasFocus) {
                this.renderButton.setBorder(this.focusBorder);
            } else {
                this.renderButton.setBorder(this.originalBorder);
            }
            if (value == null) {
                this.renderButton.setText("");
                this.renderButton.setIcon(null);
            } else if (value instanceof Icon) {
                this.renderButton.setText("");
                this.renderButton.setIcon((Icon)value);
            } else {
                this.renderButton.setText(value.toString());
                this.renderButton.setIcon(null);
            }
            return this.renderButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = this.table.convertRowIndexToModel(this.table.getEditingRow());
            this.fireEditingStopped();
            ActionEvent event = new ActionEvent(this.table, 1001, "" + row);
            this.action.actionPerformed(event);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.table.isEditing() && this.table.getCellEditor() == this) {
                this.isButtonColumnEditor = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isButtonColumnEditor && this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.isButtonColumnEditor = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class CustomTableModel
    implements TableModel {
        protected final List<TableModelListener> listener = new ArrayList<TableModelListener>();
        private final String[] colNames = new String[]{"Bilddatei", " ", "Bildunterschrift"};
        private final String[][] values = new String[][]{{"", ""}, {"", ""}, {"", ""}};
        private String[] fileName = new String[]{"", "", ""};

        private CustomTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.values.length;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.colNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return JButton.class;
            }
            return String.class;
        }

        public void setFileName(int index, String path) {
            this.fileName[index] = path;
        }

        public String getFileName(int index) {
            return this.fileName[index];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 || columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.values[rowIndex][0];
                }
                case 1: {
                    return "...";
                }
                case 2: {
                    return this.values[rowIndex][1];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue instanceof String) {
                if (columnIndex == 2) {
                    this.values[rowIndex][1] = (String)aValue;
                }
                if (columnIndex == 0) {
                    this.values[rowIndex][0] = (String)aValue;
                }
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        public void fireContentsChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener tmp : this.listener) {
                tmp.tableChanged(e);
            }
        }
    }
}

