/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.treeicons.wunda_blau;

import Sirius.navigator.types.treenode.ClassTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.types.treenode.PureTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.CidsTreeObjectIconFactory;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.Static2DTools;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class Alb_baulastIconFactory
implements CidsTreeObjectIconFactory {
    private static final Logger log = Logger.getLogger(Alb_baulastIconFactory.class);
    private static ImageIcon FALLBACK = new ImageIcon(Alb_baulastIconFactory.class.getResource("/res/16/BaulastGrau.png"));
    volatile SwingWorker<Void, Void> objectRetrievingWorker = null;
    final WeakHashMap<ObjectTreeNode, ExecutorService> listOfRetrievingObjectWorkers = new WeakHashMap();
    private final ExecutorService objectRetrievalExecutor = Executors.newFixedThreadPool(15);
    private final ImageIcon DELETED_ICON;
    private final ImageIcon CLOSED_ICON;
    private final ImageIcon WARNING_ICON;
    private final Object objectRetrievingLock = new Object();

    public Alb_baulastIconFactory() {
        this.DELETED_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit-delete.png"));
        this.CLOSED_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/encrypted.png"));
        this.WARNING_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/dialog-warning.png"));
    }

    public Icon getClosedPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getLeafPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconFromState(otn);
    }

    public Icon getClosedObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconFromState(otn);
    }

    public Icon getLeafObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconFromState(otn);
    }

    public Icon getClassNodeIcon(ClassTreeNode dmtn) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon generateIconFromState(final ObjectTreeNode node) {
        Icon result = null;
        if (node != null) {
            MetaObject baulastMO = node.getMetaObject(false);
            if (baulastMO != null) {
                CidsBean baulastBean = baulastMO.getBean();
                result = node.getLeafIcon();
                Overlay ovl = Alb_baulastIconFactory.getOverlayForBaulast(baulastBean);
                switch (ovl) {
                    case CROSS: {
                        ImageIcon overlay = Static2DTools.createOverlayIcon((ImageIcon)this.DELETED_ICON, (int)result.getIconWidth(), (int)result.getIconHeight());
                        result = Static2DTools.mergeIcons((Icon)result, (Icon)overlay);
                        break;
                    }
                    case LOCKED: {
                        ImageIcon overlay = Static2DTools.createOverlayIcon((ImageIcon)this.CLOSED_ICON, (int)result.getIconWidth(), (int)result.getIconHeight());
                        result = Static2DTools.mergeIcons((Icon)result, (Icon)overlay);
                        break;
                    }
                    case WARN: {
                        ImageIcon overlay = Static2DTools.createOverlayIcon((ImageIcon)this.WARNING_ICON, (int)result.getIconWidth(), (int)result.getIconHeight());
                        result = Static2DTools.mergeIcons((Icon)result, (Icon)overlay);
                    }
                }
                return result;
            }
            if (!this.listOfRetrievingObjectWorkers.containsKey(node) && !this.listOfRetrievingObjectWorkers.containsKey(node)) {
                this.listOfRetrievingObjectWorkers.put(node, this.objectRetrievalExecutor);
                WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = this.listOfRetrievingObjectWorkers;
                synchronized (weakHashMap) {
                    this.objectRetrievalExecutor.execute(new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            if (node != null) {
                                if (node.getPath()[0].equals(ComponentRegistry.getRegistry().getSearchResultsTree().getModel().getRoot())) {
                                    if (ComponentRegistry.getRegistry().getSearchResultsTree().containsNode(node.getNode())) {
                                        node.getMetaObject(true);
                                    }
                                } else {
                                    node.getMetaObject(true);
                                }
                            }
                            return null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void done() {
                            try {
                                Void result = (Void)this.get();
                                if (node.getPath()[0].equals(ComponentRegistry.getRegistry().getSearchResultsTree().getModel().getRoot())) {
                                    ((DefaultTreeModel)ComponentRegistry.getRegistry().getSearchResultsTree().getModel()).nodeChanged((TreeNode)node);
                                } else {
                                    ((DefaultTreeModel)ComponentRegistry.getRegistry().getCatalogueTree().getModel()).nodeChanged((TreeNode)node);
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)"Fehler beim Laden des MetaObjects", (Throwable)e);
                            }
                            finally {
                                WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = Alb_baulastIconFactory.this.listOfRetrievingObjectWorkers;
                                synchronized (weakHashMap) {
                                    Alb_baulastIconFactory.this.listOfRetrievingObjectWorkers.remove(node);
                                }
                            }
                        }
                    });
                }
            }
            return FALLBACK;
        }
        return null;
    }

    private static boolean hasBaulastHistoricLandparcels(CidsBean baulastBean) {
        List belastete = baulastBean.getBeanCollectionProperty("flurstuecke_belastet");
        List beguenstigte = baulastBean.getBeanCollectionProperty("flurstuecke_beguenstigt");
        for (CidsBean fs : belastete) {
            if (fs.getProperty("historisch") == null) continue;
            return true;
        }
        for (CidsBean fs : beguenstigte) {
            if (fs.getProperty("historisch") == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isBaulastGeprueft(CidsBean baulastBean) {
        Boolean geprueft = (Boolean)baulastBean.getProperty("geprueft");
        if (geprueft == null) {
            return false;
        }
        return geprueft;
    }

    public static Overlay getOverlayForBaulast(CidsBean baulastBean) {
        if (Alb_baulastIconFactory.isBaulastGeprueft(baulastBean) && baulastBean.getProperty("loeschungsdatum") != null) {
            return Overlay.CROSS;
        }
        if (Alb_baulastIconFactory.isBaulastGeprueft(baulastBean) && baulastBean.getProperty("geschlossen_am") != null) {
            return Overlay.LOCKED;
        }
        if (!Alb_baulastIconFactory.isBaulastGeprueft(baulastBean) || Alb_baulastIconFactory.hasBaulastHistoricLandparcels(baulastBean)) {
            return Overlay.WARN;
        }
        return Overlay.NONE;
    }

    public static enum Overlay {
        CROSS,
        LOCKED,
        WARN,
        NONE;

    }
}

