/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.virtualcitymap;

import Sirius.navigator.connection.SessionManager;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.virtualcitymap.VCMProperties;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.features.ChildNodesProvider;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.RequestForHidingHandles;
import de.cismet.cismap.commons.features.RequestForNonreflectingFeature;
import de.cismet.cismap.commons.features.RequestForRotatingPivotLock;
import de.cismet.cismap.commons.features.RequestForUnaddableHandles;
import de.cismet.cismap.commons.features.RequestForUnmoveableHandles;
import de.cismet.cismap.commons.features.RequestForUnremovableHandles;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeriveRule;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedCommandArea;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedFixedPImage;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedFixedPImageCommandArea;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.Static2DTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Image;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class VCMControlFeature
extends DefaultStyledFeature
implements XStyledFeature,
ChildNodesProvider,
RequestForUnaddableHandles,
RequestForUnmoveableHandles,
RequestForUnremovableHandles,
RequestForRotatingPivotLock,
RequestForNonreflectingFeature,
RequestForHidingHandles,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(VCMControlFeature.class);
    static final ImageIcon ARROWII = new ImageIcon(VCMControlFeature.class.getResource("/de/cismet/cids/custom/virtualcitymap/vcm.control.png"));
    static final Image ARROW = ARROWII.getImage();
    static final Image OPENVCM = new ImageIcon(VCMControlFeature.class.getResource("/de/cismet/cids/custom/virtualcitymap/vcm22.png")).getImage();
    static final Image ROTATE = new ImageIcon(VCMControlFeature.class.getResource("/de/cismet/cids/custom/virtualcitymap/turn.png")).getImage();
    static final Image REMOVE = new ImageIcon(VCMControlFeature.class.getResource("/de/cismet/cids/custom/virtualcitymap/remove.png")).getImage();
    ArrayList<PNode> children = new ArrayList();
    private final MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
    private final VCMProperties properties = VCMProperties.getInstance();
    private final ConnectionContext connectionContext;
    private boolean reloadConfig = true;
    private int rotationIndex = 3;
    private int[] headings = new int[]{45, 135, 225, 315};
    private double[][] sweetSpots = new double[][]{{1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {0.0, 0.0}};
    private FixedPImage arrow;

    public VCMControlFeature(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.setEditable(true);
        this.setCanBeSelected(true);
        this.setLinePaint(new Color(0, 0, 0, 0));
        this.setHighlightingEnabled(false);
        if (this.properties != null) {
            this.rotationIndex = this.properties.getRotationIndex();
            this.headings = this.properties.getHeadings();
            this.sweetSpots = this.properties.getSweetSpots();
        } else {
            LOG.warn((Object)"VCMProperties == null. Use default values.");
        }
    }

    public ImageIcon getIconImage() {
        return null;
    }

    public String getType() {
        return "VirtualCityMap Steuerung";
    }

    public JComponent getInfoComponent(Refreshable r) {
        return null;
    }

    public Stroke getLineStyle() {
        return null;
    }

    public String getName() {
        return "VirtualCityMap Steuerung";
    }

    public Collection<PNode> provideChildren(PFeature parent) {
        if (this.children.isEmpty()) {
            this.initPNodeChildren(parent);
        }
        return this.children;
    }

    private void initPNodeChildren(PFeature parent) {
        this.children.add((PNode)this.createArrow(parent));
        this.children.add((PNode)this.createMover(parent));
        this.children.add((PNode)this.createRotateArea(parent));
        this.children.add((PNode)this.createLinkArea(parent));
        this.children.add((PNode)this.createCloseArea(parent));
        this.rotate();
    }

    private DerivedMoveArea createMover(PFeature parent) {
        DerivedMoveArea mover = new DerivedMoveArea(parent);
        return mover;
    }

    private FixedPImage createArrow(PFeature parent) {
        this.arrow = new DerivedFixedPImage(ARROW, parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                return in.getCentroid();
            }
        });
        this.arrow.setSweetSpotX(0.5);
        this.arrow.setSweetSpotY(0.0);
        return this.arrow;
    }

    private FixedPImage createRotateArea(PFeature parent) {
        DerivedFixedPImageCommandArea rotateArea = new DerivedFixedPImageCommandArea(ROTATE, parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                Coordinate[] cs = in.buffer(in.getEnvelopeInternal().getHeight() * -0.1).getEnvelope().getCoordinates();
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                Point point = factory.createPoint(cs[3]);
                return point;
            }
        }){

            public void mousePressed(PInputEvent event) {
                VCMControlFeature.this.rotate();
            }
        };
        rotateArea.setSweetSpotX(0.5);
        rotateArea.setSweetSpotY(0.5);
        return rotateArea;
    }

    private FixedPImage createLinkArea(PFeature parent) {
        DerivedFixedPImageCommandArea linkArea = new DerivedFixedPImageCommandArea(OPENVCM, parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                Coordinate[] cs = in.buffer(in.getEnvelopeInternal().getHeight() * -0.1).getEnvelope().getCoordinates();
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                Point point = factory.createPoint(cs[0]);
                return point;
            }
        }){

            public void mousePressed(PInputEvent event) {
                VCMControlFeature.this.openVCM();
            }
        };
        linkArea.setSweetSpotX(0.5);
        linkArea.setSweetSpotY(0.5);
        return linkArea;
    }

    private FixedPImage createCloseArea(PFeature parent) {
        DerivedFixedPImageCommandArea closeArea = new DerivedFixedPImageCommandArea(REMOVE, parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                Coordinate[] cs = in.buffer(in.getEnvelopeInternal().getHeight() * -0.1).getEnvelope().getCoordinates();
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                Point point = factory.createPoint(cs[2]);
                return point;
            }
        }){

            public void mousePressed(PInputEvent event) {
                VCMControlFeature.this.removeFeature();
            }
        };
        closeArea.setSweetSpotX(0.5);
        closeArea.setSweetSpotY(0.5);
        return closeArea;
    }

    public void removeFeature() {
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)this);
    }

    public void openVCM() {
        String url;
        int currentSrid;
        if (this.properties.isEmpty() | this.reloadConfig) {
            LOG.warn((Object)("openVCM openVCM(). properties are empty. you should check this server_resource: " + WundaBlauServerResources.VCM_PROPERTIES.getValue()));
            LOG.info((Object)"trying to load the properties from server_resource");
            this.properties.load(this.getConnectionContext());
            this.reloadConfig = this.properties.isReloadConfigEveryTime();
        }
        Point point = this.getGeometry().getCentroid();
        double distance = CrsTransformer.transformToMetricCrs((Geometry)this.getGeometry()).getEnvelopeInternal().getHeight() * 1.1;
        String user = this.properties.getUser();
        String password = this.properties.getPassword();
        double groundPosX = point.getX();
        double groundPosY = point.getY();
        double groundPosZ = 192.2062;
        int heading = this.headings[this.rotationIndex];
        double camPosX = groundPosX;
        double camPosY = groundPosY;
        double camPosZ = 192.2062 + distance;
        int epsg = currentSrid = CrsTransformer.extractSridFromCrs((String)this.mappingComponent.getMappingModel().getSrs().getCode());
        Boolean useNewUrl = this.properties.isNewUrl();
        Boolean useAuthentification = this.properties.isWithAuthentication();
        Boolean withJwt = this.properties.isWithJWT();
        if (useNewUrl.booleanValue()) {
            point = (Point)CrsTransformer.transformToGivenCrs((Geometry)point, (String)"EPSG:4326");
            groundPosX = point.getX();
            groundPosY = point.getY();
            if (useAuthentification.booleanValue()) {
                if (withJwt.booleanValue()) {
                    String jwt = SessionManager.getSession().getUser().getJwsToken();
                    url = String.format(this.properties.getNewUrlTemplate(), jwt, String.valueOf(groundPosX), String.valueOf(groundPosY), String.valueOf(groundPosX), String.valueOf(groundPosY), String.valueOf(Math.round(distance)), String.valueOf(heading));
                } else {
                    url = String.format(this.properties.getNewUrlTemplate(), user, password, String.valueOf(groundPosX), String.valueOf(groundPosY), String.valueOf(groundPosX), String.valueOf(groundPosY), String.valueOf(Math.round(distance)), String.valueOf(heading));
                }
            } else {
                url = String.format(this.properties.getNewUrlTemplate(), String.valueOf(groundPosX), String.valueOf(groundPosY), String.valueOf(groundPosX), String.valueOf(groundPosY), String.valueOf(Math.round(distance)), String.valueOf(heading));
            }
        } else {
            url = String.format(this.properties.getUrlTemplate(), user, password, groundPosX + "", groundPosY + "", "192.2062", distance + "", heading + "", camPosX + "", camPosY + "", camPosZ + "", epsg + "");
        }
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (Exception ex) {
            LOG.error((Object)("error while browserlaunching url: " + url), (Throwable)ex);
        }
    }

    public void rotate() {
        this.rotationIndex = this.rotationIndex >= 3 ? 0 : ++this.rotationIndex;
        ImageIcon rotated = Static2DTools.rotate((ImageIcon)ARROWII, (double)this.headings[this.rotationIndex], (boolean)false);
        this.arrow.setImage(rotated.getImage());
        this.arrow.setSweetSpotX(this.sweetSpots[this.rotationIndex][0]);
        this.arrow.setSweetSpotY(this.sweetSpots[this.rotationIndex][1]);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public class DerivedMoveArea
    extends DerivedCommandArea {
        private PFeature parentFeature;

        public DerivedMoveArea(PFeature parent) {
            super(parent, new DeriveRule(){

                public Geometry derive(Geometry in) {
                    return VCMControlFeature.this.getGeometry().buffer(in.getEnvelopeInternal().getHeight() * -0.05);
                }
            });
            this.setPaint(Color.white);
            this.setStroke(null);
            this.setTransparency(0.3f);
            this.parentFeature = parent;
        }

        public void mousePressed(PInputEvent event) {
            super.mousePressed(event);
            ((PBasicInputEventHandler)VCMControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mousePressed(event);
        }

        public void mouseDragged(PInputEvent event) {
            super.mouseDragged(event);
            ((PBasicInputEventHandler)VCMControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseDragged(event);
        }

        public void mouseReleased(PInputEvent event) {
            super.mouseReleased(event);
            ((PBasicInputEventHandler)VCMControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseReleased(event);
            VCMControlFeature.this.mappingComponent.ensureVisibilityOfSpecialFeatures(VCMControlFeature.class, true);
        }

        public void mouseMoved(PInputEvent event) {
            super.mouseMoved(event);
            ((PBasicInputEventHandler)VCMControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseMoved(event);
        }
    }
}

