/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda.oab;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.capabilities.CapabilitiesCache;
import de.cismet.cismap.commons.features.DefaultXStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.commons.wms.capabilities.WMSCapabilitiesFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.CalculationCache;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class OabUtilities {
    private static final Logger log = Logger.getLogger(OabUtilities.class);
    public static final DateFormat COMMON_DATE_FORMAT = DateFormat.getDateInstance(2);
    public static final int CRS = 25832;
    public static final String EPSG = "EPSG:25832";
    public static final String BEAN_CLIENT_PROPERTY = "__prop_bean__";
    public static final String GOTO_USEROBJECT_COMMAND = "GOTO_USEROBJECT";
    public static final String OAB_GEWAESSEREINZUGSGEBIET_TABLE_NAME = "OAB_GEWAESSEREINZUGSGEBIET";
    public static final String OAB_PROJEKT_TABLE_NAME = "OAB_PROJEKT";
    public static final String OAB_ZUSTAND_MASSNAHME_TABLE_NAME = "OAB_ZUSTAND_MASSNAHME";
    public static final String OAB_BERECHNUNG_TABLE_NAME = "OAB_BERECHNUNG";
    public static final String OAB_PREVIEW_BACKGROUND_LAYER_CAP_PREFIX = "OabUtilities.previewWMS.backgroundLayer.capabilities.";
    public static final String OAB_PREVIEW_BACKGROUND_LAYER_NAME_PREFIX = "OabUtilities.previewWMS.backgroundLayer.layername.";

    private OabUtilities() {
    }

    public static ImageIcon loadImageIcon(Class c, String name) {
        return ImageUtilities.loadImageIcon((String)(c.getPackage().getName().replaceAll("\\.", "/") + "/" + name), (boolean)false);
    }

    public static void initGotoBeanHyperlinkList(CidsBean sourceBean, String collectionProperty, JPanel listPanel, EventListenerList refHolderList) {
        OabUtilities.initGotoBeanHyperlinkList(sourceBean, collectionProperty, "name", null, null, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                if (o1 == null || !(o1.getProperty("name") instanceof String) || o2 == null || !(o2.getProperty("name") instanceof String)) {
                    throw new IllegalStateException("bean without valid name [obj1=" + o1 + "|obj2=" + o2 + "]");
                }
                return ((String)o1.getProperty("name")).compareTo((String)o2.getProperty("name"));
            }
        }, listPanel, refHolderList);
    }

    public static void initGotoBeanHyperlinkList(CidsBean sourceBean, String collectionProperty, final String displayProperty, JPanel listPanel, EventListenerList refHolderList) {
        OabUtilities.initGotoBeanHyperlinkList(sourceBean, collectionProperty, displayProperty, null, null, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                if (o1 == null || !(o1.getProperty(displayProperty) instanceof String) || o2 == null || !(o2.getProperty(displayProperty) instanceof String)) {
                    throw new IllegalStateException("bean without valid property: [property=" + displayProperty + "|obj1=" + o1 + "|obj2=" + o2 + "]");
                }
                return ((String)o1.getProperty(displayProperty)).compareTo((String)o2.getProperty(displayProperty));
            }
        }, listPanel, refHolderList);
    }

    public static CidsBean getBean(CidsBean source, String backlinkProperty, ConnectionContext connectionContext) {
        if (source.getProperty(backlinkProperty) == null) {
            try {
                MetaObject mo = source.getMetaObject();
                MetaObject copy = SessionManager.getConnection().getMetaObject(SessionManager.getSession().getUser(), mo.getID(), mo.getClassID(), mo.getDomain(), connectionContext);
                return copy.getBean();
            }
            catch (ConnectionException ex) {
                throw new IllegalStateException("cannot re-fetch cidsbean", ex);
            }
        }
        return source;
    }

    public static void toGotoBeanHyperlinkButton(JButton btn, CidsBean gotoBean, EventListenerList refHolderList) {
        if (btn == null || gotoBean == null || refHolderList == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("must only be called from EDT");
        }
        btn.setText("<html><font color=#000099><u>" + btn.getText() + "</u></font></html>");
        btn.setHorizontalAlignment(2);
        btn.setHorizontalTextPosition(2);
        btn.setOpaque(false);
        btn.setBorderPainted(false);
        btn.setCursor(Cursor.getPredefinedCursor(12));
        btn.putClientProperty(BEAN_CLIENT_PROPERTY, gotoBean);
        GotoBeanListener gotoL = new GotoBeanListener();
        refHolderList.add(ActionListener.class, gotoL);
        btn.addActionListener((ActionListener)WeakListeners.create(ActionListener.class, (EventListener)gotoL, (Object)btn));
    }

    public static JButton createGotoBeanHyperlinkButton(String name, CidsBean gotoBean, EventListenerList refHolderList) {
        if (name == null || gotoBean == null || refHolderList == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("must only be called from EDT");
        }
        JButton btn = new JButton(name);
        OabUtilities.toGotoBeanHyperlinkButton(btn, gotoBean, refHolderList);
        return btn;
    }

    public static void initGotoBeanHyperlinkList(CidsBean sourceBean, String collectionProperty, String displayProperty, String displayPropertyPrefix, String displayPropertySuffix, Comparator<CidsBean> sorter, JPanel pnlList, EventListenerList refHolderList) {
        if (sourceBean == null || collectionProperty == null || displayProperty == null || sorter == null || refHolderList == null || pnlList == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("must only be called from EDT");
        }
        List c = sourceBean.getBeanCollectionProperty(collectionProperty);
        if (c == null || c.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no collection found: [sourceBean=" + sourceBean + "|prop=" + collectionProperty + "]"));
            }
            return;
        }
        Collections.sort(c, sorter);
        pnlList.removeAll();
        pnlList.setLayout(new GridBagLayout());
        String prefix = displayPropertyPrefix == null ? "" : displayPropertyPrefix;
        String suffix = displayPropertySuffix == null ? "" : displayPropertySuffix;
        int i = 0;
        while (i < c.size()) {
            CidsBean bean = (CidsBean)c.get(i);
            JButton btn = OabUtilities.createGotoBeanHyperlinkButton(prefix + bean.getProperty(displayProperty) + suffix, bean, refHolderList);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.gridy = i++;
            constraints.insets = new Insets(5, 5, 5, 5);
            pnlList.add((Component)btn, constraints);
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 3;
        constraints.gridx = 0;
        constraints.gridy = c.size();
        constraints.weighty = 1.0;
        pnlList.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE)), constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        pnlList.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0)), constraints);
    }

    public static void initPreviewMap(CidsBean sourceBean, String geomProperty, MappingComponent map, JLabel titleComponent) {
        OabUtilities.initPreviewMap(sourceBean, geomProperty, map, titleComponent, null, null);
    }

    public static void initPreviewMap(final CidsBean sourceBean, String geomProperty, MappingComponent map, JLabel titleComponent, final Action mapClickAction, RetrievalServiceLayer ... additionalLayers) {
        if (sourceBean == null || geomProperty == null || map == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        Geometry geom = (Geometry)sourceBean.getProperty(geomProperty);
        if (geom == null) {
            throw new IllegalStateException("null geometry: [bean=" + sourceBean + "|geomProperty=" + geomProperty + "]");
        }
        XBoundingBox bbox = new XBoundingBox(geom.getEnvelope().buffer(50.0), EPSG, true);
        ActiveLayerModel mappingModel = new ActiveLayerModel();
        mappingModel.setSrs(new Crs(EPSG, EPSG, EPSG, true, true));
        mappingModel.addHome(bbox);
        List<RetrievalServiceLayer> backgroundLayers = OabUtilities.createBackgroupLayers();
        if (backgroundLayers != null) {
            for (RetrievalServiceLayer backgroundLayer : backgroundLayers) {
                if (backgroundLayer == null) continue;
                mappingModel.addLayer(backgroundLayer);
            }
        }
        if (additionalLayers != null) {
            for (RetrievalServiceLayer additionalLayer : additionalLayers) {
                if (additionalLayer == null) continue;
                mappingModel.addLayer(additionalLayer);
            }
        }
        map.setMappingModel((MappingModel)mappingModel);
        map.gotoInitialBoundingBox();
        DefaultXStyledFeature feature = new DefaultXStyledFeature(null, "Geometrie", "Polygon", null, (Stroke)new BasicStroke());
        feature.setFillingPaint((Paint)Color.RED);
        feature.setTransparency(0.2f);
        feature.setGeometry(geom);
        map.getFeatureCollection().addFeature((Feature)feature);
        map.unlock();
        map.addCustomInputListener(GOTO_USEROBJECT_COMMAND, new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent evt) {
                if (evt.getClickCount() > 1 && mapClickAction != null && mapClickAction.isEnabled()) {
                    mapClickAction.actionPerformed(new ActionEvent(sourceBean, 1001, OabUtilities.GOTO_USEROBJECT_COMMAND));
                }
            }
        });
        map.setInteractionMode(GOTO_USEROBJECT_COMMAND);
        map.gotoInitialBoundingBox();
    }

    private static List<RetrievalServiceLayer> createBackgroupLayers() {
        boolean layerfound = true;
        int i = 0;
        ArrayList<RetrievalServiceLayer> mapServices = new ArrayList<RetrievalServiceLayer>();
        while (layerfound) {
            ++i;
            String capLink = null;
            String name = null;
            try {
                capLink = NbBundle.getMessage(OabUtilities.class, (String)(OAB_PREVIEW_BACKGROUND_LAYER_CAP_PREFIX + i));
                name = NbBundle.getMessage(OabUtilities.class, (String)(OAB_PREVIEW_BACKGROUND_LAYER_NAME_PREFIX + i));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (capLink == null || name == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no link or name found: [capLink=" + capLink + "|name=" + name + "|capProp=" + OAB_PREVIEW_BACKGROUND_LAYER_CAP_PREFIX + i + "|nameProp=" + OAB_PREVIEW_BACKGROUND_LAYER_NAME_PREFIX + i + "]"));
                }
                layerfound = false;
                continue;
            }
            RetrievalServiceLayer layer = OabUtilities.createWMSLayer(capLink, name);
            if (layer == null) continue;
            mapServices.add(layer);
        }
        return mapServices;
    }

    public static RetrievalServiceLayer createWMSLayer(String capabilities, String layername) {
        SlidableWMSServiceLayerGroup service;
        WMSCapabilities caps;
        if (capabilities == null || layername == null) {
            throw new IllegalArgumentException("no argument must be null");
        }
        WMSCapabilitiesFactory capFactory = new WMSCapabilitiesFactory((CalculationCache)CapabilitiesCache.getInstance());
        try {
            caps = capFactory.createCapabilities(capabilities);
        }
        catch (Exception ex) {
            log.warn((Object)("improper capabilities link: " + capabilities), (Throwable)ex);
            return null;
        }
        Layer rootLayer = caps.getLayer();
        TreePath layerPath = new TreePath(rootLayer);
        if (!layername.equals(rootLayer.getName())) {
            layerPath = OabUtilities.findLayer(layerPath, layername);
        }
        if (layerPath == null) {
            service = null;
        } else {
            ArrayList<TreePath> path = new ArrayList<TreePath>(1);
            path.add(layerPath);
            if (OabUtilities.isSlidableWMSLayer((Layer)layerPath.getLastPathComponent())) {
                service = new SlidableWMSServiceLayerGroup(path);
                service.setCapabilitiesUrl(caps.getURL().toString());
                service.setWmsCapabilities(caps);
            } else {
                service = new WMSServiceLayer(path);
                ((WMSServiceLayer)service).setCapabilitiesUrl(caps.getURL().toString());
                ((WMSServiceLayer)service).setWmsCapabilities(caps);
            }
        }
        return service;
    }

    public static boolean isSlidableWMSLayer(Layer layer) {
        String[] keywords;
        if (layer == null) {
            throw new IllegalArgumentException("layer must not be null");
        }
        boolean slidable = layer.getName().endsWith("[]");
        if (!slidable && (keywords = layer.getKeywords()) != null) {
            for (int i = 0; i < keywords.length && !slidable; ++i) {
                slidable = "cismapSlidingLayerGroup".equals(keywords[i]);
            }
        }
        return slidable;
    }

    private static TreePath findLayer(TreePath path, String layername) {
        Layer[] layers = ((Layer)path.getLastPathComponent()).getChildren();
        TreePath result = null;
        for (int i = 0; i < layers.length && result == null; ++i) {
            TreePath newPath = path.pathByAddingChild(layers[i]);
            result = layername.equals(layers[i].getName()) ? newPath : OabUtilities.findLayer(newPath, layername);
        }
        return result;
    }

    public static final class GotoBeanListener
    implements ActionListener {
        private static final Logger log = Logger.getLogger(GotoBeanListener.class);

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComponent) {
                JComponent source = (JComponent)e.getSource();
                Object cp = source.getClientProperty(OabUtilities.BEAN_CLIENT_PROPERTY);
                if (cp instanceof CidsBean) {
                    ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(((CidsBean)cp).getMetaObject(), ((CidsBean)cp).toString());
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("source does not contain bean client property: " + source));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("source is no jcomponent: " + e.getSource()));
            }
        }
    }

    public static final class DateToStringConverter
    extends Converter<Date, String> {
        public String convertForward(Date s) {
            return COMMON_DATE_FORMAT.format(s);
        }

        public Date convertReverse(String t) {
            try {
                return COMMON_DATE_FORMAT.parse(t);
            }
            catch (ParseException ex) {
                throw new IllegalStateException("cannot parse previously converted date", ex);
            }
        }
    }
}

