/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.wunda_blau.search.AlboFlaecheArtSearchPanel;
import de.cismet.cids.custom.wunda_blau.search.abfrage.AbstractAbfragePanel;
import de.cismet.cids.custom.wunda_blau.search.server.AlboFlaecheSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class AlboFlaecheSearchPanel
extends AbstractAbfragePanel<AlboFlaecheSearch.Configuration> {
    private static final Logger LOG = Logger.getLogger(AlboFlaecheSearchPanel.class);
    private final boolean showVorgaenge;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final Collection<AlboFlaecheArtSearchPanel> artInfoPanels = new ArrayList<AlboFlaecheArtSearchPanel>();
    private Bean bean;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox<String> cbFlaechenstatus;
    private JComboBox<String> cbFlaechentyp;
    private JComboBox<String> cbFlaechenzuordnung;
    private JCheckBox cbGreater;
    private JCheckBox cbOnlyVorgang;
    private JCheckBox cbSmaller;
    private JCheckBox cbVorgang;
    private Box.Filler filler1;
    private Box.Filler filler10;
    private Box.Filler filler11;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private Box.Filler filler6;
    private Box.Filler filler7;
    private Box.Filler filler8;
    private Box.Filler filler9;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JPanel pnlPruefung;
    private JTextField txtFisAlboNr;
    private JTextField txtGreater;
    private JTextField txtSmaller;
    private BindingGroup bindingGroup;

    public AlboFlaecheSearchPanel() {
        this(true, true);
    }

    public AlboFlaecheSearchPanel(boolean editable) {
        this(editable, false);
    }

    public AlboFlaecheSearchPanel(boolean editable, boolean showVorgaenge) {
        super(editable);
        this.showVorgaenge = showVorgaenge;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.bean = new Bean();
        this.initComponents();
        boolean editable = this.isEditable();
        this.jPanel7.setVisible(this.showVorgaenge);
        RendererTools.makeReadOnly(this.jRadioButton1, !editable);
        RendererTools.makeReadOnly(this.jRadioButton2, !editable);
        RendererTools.makeReadOnly(this.jRadioButton5, !editable);
        RendererTools.makeReadOnly(this.jRadioButton6, !editable);
        RendererTools.makeReadOnly(this.jCheckBox1, !editable);
        RendererTools.makeReadOnly(this.jTextField1, !editable);
        RendererTools.makeReadOnly(this.jTextField2, !editable);
        RendererTools.makeReadOnly(this.txtFisAlboNr, !editable);
        RendererTools.makeReadOnly(this.cbFlaechenstatus, !editable);
        RendererTools.makeReadOnly(this.cbFlaechentyp, !editable);
        RendererTools.makeReadOnly(this.cbFlaechenzuordnung, !editable);
        RendererTools.makeReadOnly(this.cbVorgang, !editable);
        this.txtGreater.setEnabled(this.cbGreater.isSelected());
        this.txtSmaller.setEnabled(this.cbSmaller.isSelected());
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Bean getBean() {
        return this.bean;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.filler2 = new Box.Filler(new Dimension(600, 0), new Dimension(600, 0), new Dimension(600, Short.MAX_VALUE));
        this.pnlPruefung = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel6 = new JLabel();
        this.txtFisAlboNr = new JTextField();
        this.jLabel15 = new JLabel();
        this.cbFlaechentyp = new DefaultBindableReferenceCombo(ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"albo_flaechentyp", (ConnectionContext)this.getConnectionContext()), true, false);
        this.jLabel13 = new JLabel();
        this.cbFlaechenstatus = new DefaultBindableReferenceCombo(ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"albo_flaechenstatus", (ConnectionContext)this.getConnectionContext()), true, false);
        this.jLabel14 = new JLabel();
        this.cbFlaechenzuordnung = new DefaultBindableReferenceCombo(ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"albo_flaechenzuordnung", (ConnectionContext)this.getConnectionContext()), true, false);
        this.jLabel3 = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel4 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.filler9 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel7 = new JPanel();
        this.cbVorgang = new JCheckBox();
        this.cbOnlyVorgang = new JCheckBox();
        this.filler10 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton3 = new JButton();
        this.jLabel5 = new JLabel();
        this.jPanel6 = new JPanel();
        this.filler8 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.filler5 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler7 = new Box.Filler(new Dimension(300, 1), new Dimension(400, 1), new Dimension(500, 1));
        this.filler6 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel8 = new JPanel();
        this.cbGreater = new JCheckBox();
        this.cbSmaller = new JCheckBox();
        this.filler11 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txtGreater = new JTextField();
        this.txtSmaller = new JTextField();
        this.filler2.setName("filler2");
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.pnlPruefung.setBorder(BorderFactory.createTitledBorder("Suche nach Fl\u00e4chen mit:"));
        this.pnlPruefung.setName("pnlPruefung");
        this.pnlPruefung.setOpaque(false);
        this.pnlPruefung.setLayout(new GridBagLayout());
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setText("<html>Erhebungsnummer: <i>*");
        this.jLabel1.setName("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextField1.setName("jTextField1");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${bean.erhebungsnummer}"), (Object)this.jTextField1, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jTextField1, gridBagConstraints);
        this.jLabel2.setText("<html>Vorgangsnummer: <i>*");
        this.jLabel2.setName("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextField2.setName("jTextField2");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${bean.vorgangsnummer}"), (Object)this.jTextField2, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jTextField2, gridBagConstraints);
        this.jLabel6.setText("<html>FisAlBo-Nr.: <i>*");
        this.jLabel6.setName("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.txtFisAlboNr.setName("txtFisAlboNr");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${bean.fisalbonummer}"), (Object)this.txtFisAlboNr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.txtFisAlboNr, gridBagConstraints);
        this.jLabel15.setText("Fl\u00e4chentyp:");
        this.jLabel15.setName("jLabel15");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel15, gridBagConstraints);
        this.cbFlaechentyp.setName("cbFlaechentyp");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${bean.fkTyp}"), this.cbFlaechentyp, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add(this.cbFlaechentyp, gridBagConstraints);
        this.jLabel13.setText("Fl\u00e4chenstatus:");
        this.jLabel13.setName("jLabel13");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel13, gridBagConstraints);
        this.cbFlaechenstatus.setName("cbFlaechenstatus");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${bean.fkStatus}"), this.cbFlaechenstatus, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add(this.cbFlaechenstatus, gridBagConstraints);
        this.jLabel14.setText("Fl\u00e4chenzuordnung:");
        this.jLabel14.setName("jLabel14");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel14, gridBagConstraints);
        this.cbFlaechenzuordnung.setName("cbFlaechenzuordnung");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${bean.fkZuordnung}"), this.cbFlaechenzuordnung, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add(this.cbFlaechenzuordnung, gridBagConstraints);
        this.jLabel3.setText("<html><i>(*) Das Zeichen '%' kann als Platzhalter verwendet werden.");
        this.jLabel3.setName("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlPruefung.add((Component)this.jPanel3, gridBagConstraints);
        this.filler1.setName("filler1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlPruefung.add((Component)this.filler1, gridBagConstraints);
        this.filler3.setName("filler3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlPruefung.add((Component)this.filler3, gridBagConstraints);
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel4.setName("jLabel4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("und");
        this.jRadioButton1.setContentAreaFilled(false);
        this.jRadioButton1.setName("jRadioButton1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jRadioButton1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("oder");
        this.jRadioButton2.setContentAreaFilled(false);
        this.jRadioButton2.setName("jRadioButton2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jRadioButton2, gridBagConstraints);
        this.filler4.setName("filler4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.filler4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.pnlPruefung.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.pnlPruefung, gridBagConstraints);
        this.pnlPruefung.getAccessibleContext().setAccessibleName("Verkehrszeichen");
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Unterdr\u00fcckte Fl\u00e4chen:"));
        this.jPanel4.setName("jPanel4");
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jCheckBox1.setText("unterdr\u00fcckte Fl\u00e4chen mit einbeziehen");
        this.jCheckBox1.setName("jCheckBox1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox2.setText("ausschlie\u00dflich diese");
        this.jCheckBox2.setName("jCheckBox2");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jCheckBox1, (Property)ELProperty.create((String)"${selected}"), (Object)this.jCheckBox2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 12, 2, 2);
        this.jPanel4.add((Component)this.jCheckBox2, gridBagConstraints);
        this.filler9.setName("filler9");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.filler9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Vorg\u00e4nge"));
        this.jPanel7.setName("jPanel7");
        this.jPanel7.setLayout(new GridBagLayout());
        this.cbVorgang.setText("Vorg\u00e4nge mit einbeziehen");
        this.cbVorgang.setMinimumSize(new Dimension(291, 23));
        this.cbVorgang.setName("cbVorgang");
        this.cbVorgang.setPreferredSize(new Dimension(291, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cbVorgang, gridBagConstraints);
        this.cbOnlyVorgang.setText("ausschlie\u00dflich diese");
        this.cbOnlyVorgang.setName("cbOnlyVorgang");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.cbVorgang, (Property)ELProperty.create((String)"${selected}"), (Object)this.cbOnlyVorgang, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 12, 2, 2);
        this.jPanel7.add((Component)this.cbOnlyVorgang, gridBagConstraints);
        this.filler10.setName("filler10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.filler10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Fl\u00e4chenartspezifische Suche:"));
        this.jPanel5.setName("jPanel5");
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 5, 20);
        this.jPanel5.add((Component)this.jPanel2, gridBagConstraints);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/add.png")));
        this.jButton3.setName("jButton3");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlboFlaecheSearchPanel.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel5.add((Component)this.jButton3, gridBagConstraints);
        this.jButton3.setVisible(this.isEditable());
        this.jLabel5.setText("Bedingung hinzuf\u00fcgen");
        this.jLabel5.setName("jLabel5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel5.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel6.setName("jPanel6");
        this.jPanel6.setOpaque(false);
        this.jPanel6.setLayout(new GridBagLayout());
        this.filler8.setName("filler8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.filler8, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButton5);
        this.jRadioButton5.setSelected(true);
        this.jRadioButton5.setText("und");
        this.jRadioButton5.setContentAreaFilled(false);
        this.jRadioButton5.setName("jRadioButton5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.jRadioButton5, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButton6);
        this.jRadioButton6.setText("oder");
        this.jRadioButton6.setContentAreaFilled(false);
        this.jRadioButton6.setName("jRadioButton6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.jRadioButton6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.filler5.setName("filler5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.filler5, gridBagConstraints);
        this.filler7.setName("filler7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.filler7, gridBagConstraints);
        this.filler6.setName("filler6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler6, gridBagConstraints);
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("Fl\u00e4chengr\u00f6\u00dfe"));
        this.jPanel8.setName("jPanel8");
        this.jPanel8.setLayout(new GridBagLayout());
        this.cbGreater.setText("gr\u00f6\u00dfer");
        this.cbGreater.setMinimumSize(new Dimension(100, 23));
        this.cbGreater.setName("cbGreater");
        this.cbGreater.setPreferredSize(new Dimension(100, 23));
        this.cbGreater.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AlboFlaecheSearchPanel.this.cbGreaterStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel8.add((Component)this.cbGreater, gridBagConstraints);
        this.cbSmaller.setText("kleiner");
        this.cbSmaller.setMinimumSize(new Dimension(100, 23));
        this.cbSmaller.setName("cbSmaller");
        this.cbSmaller.setPreferredSize(new Dimension(100, 23));
        this.cbSmaller.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AlboFlaecheSearchPanel.this.cbSmallerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        this.jPanel8.add((Component)this.cbSmaller, gridBagConstraints);
        this.filler11.setName("filler11");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel8.add((Component)this.filler11, gridBagConstraints);
        this.txtGreater.setName("txtGreater");
        this.txtGreater.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel8.add((Component)this.txtGreater, gridBagConstraints);
        this.txtSmaller.setName("txtSmaller");
        this.txtSmaller.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel8.add((Component)this.txtSmaller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel8, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.artInfoPanels.add(new AlboFlaecheArtSearchPanel(this, this.isEditable()));
        this.refreshArtInfoPanels();
    }

    private void cbGreaterStateChanged(ChangeEvent evt) {
        this.txtGreater.setEnabled(this.cbGreater.isSelected());
    }

    private void cbSmallerStateChanged(ChangeEvent evt) {
        this.txtSmaller.setEnabled(this.cbSmaller.isSelected());
    }

    @Override
    public AlboFlaecheSearch.Configuration createConfiguration() {
        AlboFlaecheSearch.Configuration configuration = new AlboFlaecheSearch.Configuration();
        configuration.setSearchModeMain(this.jRadioButton1.isSelected() ? AlboFlaecheSearch.SearchMode.AND : AlboFlaecheSearch.SearchMode.OR);
        configuration.setSearchModeArt(this.jRadioButton5.isSelected() ? AlboFlaecheSearch.SearchMode.AND : AlboFlaecheSearch.SearchMode.OR);
        configuration.setErhebungsNummer(this.jTextField1.getText());
        configuration.setVorgangSchluessel(this.jTextField2.getText());
        configuration.setFisAlboNr(this.txtFisAlboNr.getText());
        configuration.setStatusSchluessel(this.cbFlaechenstatus.getSelectedItem() instanceof CidsBean ? (String)((CidsBean)this.cbFlaechenstatus.getSelectedItem()).getProperty("schluessel") : null);
        configuration.setTypSchluessel(this.cbFlaechentyp.getSelectedItem() instanceof CidsBean ? (String)((CidsBean)this.cbFlaechentyp.getSelectedItem()).getProperty("schluessel") : null);
        configuration.setZuordnungSchluessel(this.cbFlaechenzuordnung.getSelectedItem() instanceof CidsBean ? (String)((CidsBean)this.cbFlaechenzuordnung.getSelectedItem()).getProperty("schluessel") : null);
        configuration.setArtInfos(this.createArtInfos());
        configuration.setUnterdrueckt(this.jCheckBox2.isSelected() ? Boolean.TRUE : (!this.jCheckBox1.isSelected() ? Boolean.FALSE : null));
        configuration.setVorgaenge(this.cbOnlyVorgang.isSelected() ? Boolean.TRUE : (this.cbVorgang.isSelected() ? Boolean.FALSE : null));
        Double smaller = null;
        Double greater = null;
        try {
            smaller = Double.parseDouble(this.txtSmaller.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            greater = Double.parseDouble(this.txtGreater.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        configuration.setSmaller(this.cbSmaller.isSelected() && smaller != null ? smaller : null);
        configuration.setGreater(this.cbGreater.isSelected() && greater != null ? greater : null);
        return configuration;
    }

    public AlboFlaecheSearch getServerSearch(Geometry geometry) {
        if (geometry != null) {
            Geometry transformedBoundingBox = CrsTransformer.transformToDefaultCrs((Geometry)geometry);
            transformedBoundingBox.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        } else {
            Object transformedBoundingBox = null;
        }
        AlboFlaecheSearch search = new AlboFlaecheSearch(this.createConfiguration());
        search.setGeometry(geometry);
        return search;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebind() {
        BindingGroup bindingGroup = this.bindingGroup;
        synchronized (bindingGroup) {
            try {
                for (Binding binding : this.bindingGroup.getBindings()) {
                    if (!binding.isBound()) continue;
                    binding.unbind();
                    binding.bind();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
    }

    @Override
    public void initFromConfiguration(final AlboFlaecheSearch.Configuration configuration) {
        this.bean = new Bean();
        this.artInfoPanels.clear();
        if (configuration != null) {
            new SwingWorker<CidsBean, Void>(){

                @Override
                protected CidsBean doInBackground() throws Exception {
                    return AlboFlaecheSearchPanel.getSchluesselBean("albo_flaechenstatus", configuration.getStatusSchluessel(), AlboFlaecheSearchPanel.this.getConnectionContext());
                }

                @Override
                protected void done() {
                    try {
                        AlboFlaecheSearchPanel.this.bean.setFkStatus((CidsBean)this.get());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    AlboFlaecheSearchPanel.this.rebind();
                }
            }.execute();
            new SwingWorker<CidsBean, Void>(){

                @Override
                protected CidsBean doInBackground() throws Exception {
                    return AlboFlaecheSearchPanel.getSchluesselBean("albo_flaechenzuordnung", configuration.getZuordnungSchluessel(), AlboFlaecheSearchPanel.this.getConnectionContext());
                }

                @Override
                protected void done() {
                    try {
                        AlboFlaecheSearchPanel.this.bean.setFkZuordnung((CidsBean)this.get());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    AlboFlaecheSearchPanel.this.rebind();
                }
            }.execute();
            new SwingWorker<CidsBean, Void>(){

                @Override
                protected CidsBean doInBackground() throws Exception {
                    return AlboFlaecheSearchPanel.getSchluesselBean("albo_flaechentyp", configuration.getTypSchluessel(), AlboFlaecheSearchPanel.this.getConnectionContext());
                }

                @Override
                protected void done() {
                    try {
                        AlboFlaecheSearchPanel.this.bean.setFkTyp((CidsBean)this.get());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    AlboFlaecheSearchPanel.this.rebind();
                }
            }.execute();
            this.bean.setErhebungsnummer(configuration.getErhebungsNummer());
            this.bean.setVorgangsnummer(configuration.getVorgangSchluessel());
            this.bean.setFisalbonummer(configuration.getFisAlboNr());
            this.buttonGroup1.setSelected(this.jRadioButton1.getModel(), AlboFlaecheSearch.SearchMode.AND.equals((Object)configuration.getSearchModeMain()));
            this.buttonGroup1.setSelected(this.jRadioButton2.getModel(), AlboFlaecheSearch.SearchMode.OR.equals((Object)configuration.getSearchModeMain()));
            this.buttonGroup2.setSelected(this.jRadioButton5.getModel(), AlboFlaecheSearch.SearchMode.AND.equals((Object)configuration.getSearchModeArt()));
            this.buttonGroup2.setSelected(this.jRadioButton6.getModel(), AlboFlaecheSearch.SearchMode.OR.equals((Object)configuration.getSearchModeArt()));
            if (configuration.getArtInfos() != null) {
                for (AlboFlaecheSearch.ArtInfo artInfo : configuration.getArtInfos()) {
                    AlboFlaecheArtSearchPanel artInfoPanel = new AlboFlaecheArtSearchPanel(this, this.isEditable());
                    artInfoPanel.initFromArtInfo(artInfo);
                    this.artInfoPanels.add(artInfoPanel);
                }
            }
            this.jCheckBox1.setSelected(!Boolean.FALSE.equals(configuration.getUnterdrueckt()));
            this.jCheckBox2.setSelected(Boolean.TRUE.equals(configuration.getUnterdrueckt()));
        }
        this.rebind();
        this.refreshArtInfoPanels();
    }

    public static CidsBean getSchluesselBean(String tablename, String schluessel, ConnectionContext connectionContext) {
        if (schluessel == null || tablename == null) {
            return null;
        }
        try {
            String query = String.format("SELECT (SELECT id FROM cs_class WHERE table_name ilike '%1$s') AS class_id, %1$s.id AS id FROM %1$s WHERE %1$s.schluessel = '%2$s';", tablename, schluessel);
            MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(query, 0, connectionContext);
            CidsBean schluesselBean = mos != null && mos.length > 0 && mos[0] != null ? mos[0].getBean() : null;
            return schluesselBean;
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    private void refreshArtInfoPanels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlboFlaecheSearchPanel.this.jPanel2.removeAll();
                int count = 0;
                for (AlboFlaecheArtSearchPanel artInfoPanel : AlboFlaecheSearchPanel.this.artInfoPanels) {
                    int artNumber = ++count;
                    artInfoPanel.setName(String.format("artPanel%d", artNumber));
                    JPanel panel = new JPanel();
                    panel.setOpaque(false);
                    panel.setBorder(BorderFactory.createTitledBorder(String.format("Fl\u00e4chenart-Bedingung %d", artNumber)));
                    panel.setLayout(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    panel.add((Component)artInfoPanel, gridBagConstraints);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = -1;
                    gridBagConstraints.insets = new Insets(5, 0, 0, 0);
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    AlboFlaecheSearchPanel.this.jPanel2.add((Component)panel, gridBagConstraints);
                }
                AlboFlaecheSearchPanel.this.revalidate();
            }
        });
    }

    private Collection<AlboFlaecheSearch.ArtInfo> createArtInfos() {
        ArrayList<AlboFlaecheSearch.ArtInfo> artInfos = new ArrayList<AlboFlaecheSearch.ArtInfo>();
        for (Component comp : this.jPanel2.getComponents()) {
            if (!(comp instanceof JPanel)) continue;
            for (Component subComp : ((JPanel)comp).getComponents()) {
                if (!(subComp instanceof AlboFlaecheArtSearchPanel)) continue;
                artInfos.add(((AlboFlaecheArtSearchPanel)subComp).createArtInfo());
            }
        }
        return artInfos;
    }

    public void removeArtPanel(AlboFlaecheArtSearchPanel artPanel) {
        this.artInfoPanels.remove(artPanel);
        this.refreshArtInfoPanels();
    }

    @Override
    public String getTableName() {
        return "albo_flaeche";
    }

    @Override
    public void initFromConfiguration(Object configuration) {
        this.initFromConfiguration((AlboFlaecheSearch.Configuration)configuration);
    }

    @Override
    public ObjectMapper getConfigurationMapper() {
        return AlboFlaecheSearch.OBJECT_MAPPER;
    }

    @Override
    public AlboFlaecheSearch.Configuration readConfiguration(String confJson) throws Exception {
        return (AlboFlaecheSearch.Configuration)this.getConfigurationMapper().readValue(confJson, AlboFlaecheSearch.Configuration.class);
    }

    public class Bean {
        private String erhebungsnummer;
        private String vorgangsnummer;
        private String fisalbonummer;
        private CidsBean fkStatus;
        private CidsBean fkTyp;
        private CidsBean fkZuordnung;
        private Boolean andMain;
        private Boolean andArt;

        public String getErhebungsnummer() {
            return this.erhebungsnummer;
        }

        public String getVorgangsnummer() {
            return this.vorgangsnummer;
        }

        public String getFisalbonummer() {
            return this.fisalbonummer;
        }

        public CidsBean getFkStatus() {
            return this.fkStatus;
        }

        public CidsBean getFkTyp() {
            return this.fkTyp;
        }

        public CidsBean getFkZuordnung() {
            return this.fkZuordnung;
        }

        public Boolean getAndMain() {
            return this.andMain;
        }

        public Boolean getAndArt() {
            return this.andArt;
        }

        public void setErhebungsnummer(String erhebungsnummer) {
            this.erhebungsnummer = erhebungsnummer;
        }

        public void setVorgangsnummer(String vorgangsnummer) {
            this.vorgangsnummer = vorgangsnummer;
        }

        public void setFisalbonummer(String fisalbonummer) {
            this.fisalbonummer = fisalbonummer;
        }

        public void setFkStatus(CidsBean fkStatus) {
            this.fkStatus = fkStatus;
        }

        public void setFkTyp(CidsBean fkTyp) {
            this.fkTyp = fkTyp;
        }

        public void setFkZuordnung(CidsBean fkZuordnung) {
            this.fkZuordnung = fkZuordnung;
        }

        public void setAndMain(Boolean andMain) {
            this.andMain = andMain;
        }

        public void setAndArt(Boolean andArt) {
            this.andArt = andArt;
        }
    }
}

