/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.actiontag.ActionTagProtected;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.BaumCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.BaumSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.server.BaumAnsprechpartnerLightweightSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BaumGebietAnsprechpartnerSearch;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class BaumWindowSearch
extends JPanel
implements CidsWindowSearch,
ActionTagProtected,
SearchControlListener,
PropertyChangeListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BaumWindowSearch.class);
    private static final String ACTION_TAG = "custom.baum.search@WUNDA_BLAU";
    private MetaClass metaClass;
    private ImageIcon icon;
    private JPanel pnlSearchCancel;
    private GeoSearchButton btnGeoSearch;
    private MappingComponent mappingComponent;
    private boolean geoSearchEnabled;
    private final BaumAnsprechpartnerLightweightSearch apSearch = new BaumAnsprechpartnerLightweightSearch();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private ButtonGroup buttonGroup1;
    private JCheckBox cbMapSearch;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JScrollPane jScrollPane1;
    private JLabel lblAp;
    private JLabel lblBemerkung;
    private JLabel lblFiller6;
    private JLabel lblIcon;
    private JLabel lblMail;
    private JLabel lblOrt;
    private JLabel lblStrasse;
    private JPanel pnlAp;
    private JPanel pnlButtons;
    private JPanel pnlScrollPane;
    private JTextField txtAp;
    private JTextField txtBemerkung;
    private JTextField txtMail;
    private JTextField txtOrt;
    private JTextField txtStrasse;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.initComponents();
            this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.getConnectionContext());
            Dimension max = this.pnlSearchCancel.getMaximumSize();
            Dimension min = this.pnlSearchCancel.getMinimumSize();
            Dimension pre = this.pnlSearchCancel.getPreferredSize();
            this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
            this.pnlButtons.add(this.pnlSearchCancel);
            this.metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"baum_gebiet", (ConnectionContext)this.getConnectionContext());
            byte[] iconDataFromMetaclass = new byte[]{};
            if (this.metaClass != null) {
                iconDataFromMetaclass = this.metaClass.getIconData();
            }
            if (iconDataFromMetaclass.length > 0) {
                LOG.info((Object)"Using icon from metaclass.");
                this.icon = new ImageIcon(this.metaClass.getIconData());
            } else {
                LOG.warn((Object)"Metaclass icon is not set. Trying to load default icon.");
                URL urlToIcon = this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/search/search.png");
                this.icon = urlToIcon != null ? new ImageIcon(urlToIcon) : new ImageIcon(new byte[0]);
            }
            this.pnlButtons.add(Box.createHorizontalStrut(5));
            this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
            boolean bl = this.geoSearchEnabled = this.mappingComponent != null;
            if (this.geoSearchEnabled) {
                BaumCreateSearchGeometryListener geometryListener = new BaumCreateSearchGeometryListener(this.mappingComponent, new BaumSearchTooltip(this.icon));
                geometryListener.addPropertyChangeListener(this);
                this.btnGeoSearch = new GeoSearchButton("BAUM_GEBIET_CREATE_SEARCH_GEOMETRY", this.mappingComponent, null, "Geo-Suche nach Baum Gebiet");
                this.pnlButtons.add((Component)this.btnGeoSearch);
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)"Error in Constructor of BaumSearch. Search will not work properly.", e);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.pnlScrollPane = new JPanel();
        this.pnlAp = new JPanel();
        this.lblIcon = new JLabel();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.lblAp = new JLabel();
        this.txtAp = new JTextField();
        this.lblStrasse = new JLabel();
        this.txtStrasse = new JTextField();
        this.lblOrt = new JLabel();
        this.txtOrt = new JTextField();
        this.lblMail = new JLabel();
        this.txtMail = new JTextField();
        this.lblBemerkung = new JLabel();
        this.txtBemerkung = new JTextField();
        this.pnlButtons = new JPanel();
        this.cbMapSearch = new JCheckBox();
        this.lblFiller6 = new JLabel();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setPreferredSize(new Dimension(591, 454));
        this.pnlScrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.pnlScrollPane.setPreferredSize(new Dimension(587, 350));
        this.pnlScrollPane.setLayout(new GridBagLayout());
        this.pnlAp.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.pnlAp.border.title")));
        this.pnlAp.setMaximumSize(new Dimension(550, Integer.MAX_VALUE));
        this.pnlAp.setMinimumSize(new Dimension(550, 96));
        this.pnlAp.setPreferredSize(new Dimension(550, 196));
        this.pnlAp.setLayout(new GridBagLayout());
        this.lblIcon.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.lblIcon.text"));
        this.lblIcon.setMaximumSize(new Dimension(64, 64));
        this.lblIcon.setMinimumSize(new Dimension(64, 64));
        this.lblIcon.setPreferredSize(new Dimension(64, 64));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlAp.add((Component)this.lblIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlAp.add((Component)this.filler3, gridBagConstraints);
        this.lblAp.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.lblAp.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnlAp.add((Component)this.lblAp, gridBagConstraints);
        this.txtAp.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.txtAp.text"));
        this.txtAp.setMinimumSize(new Dimension(70, 27));
        this.txtAp.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.pnlAp.add((Component)this.txtAp, gridBagConstraints);
        this.lblStrasse.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.lblStrasse.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnlAp.add((Component)this.lblStrasse, gridBagConstraints);
        this.txtStrasse.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.txtStrasse.text"));
        this.txtStrasse.setMinimumSize(new Dimension(70, 27));
        this.txtStrasse.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.pnlAp.add((Component)this.txtStrasse, gridBagConstraints);
        this.lblOrt.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.lblOrt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnlAp.add((Component)this.lblOrt, gridBagConstraints);
        this.txtOrt.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.txtOrt.text"));
        this.txtOrt.setMinimumSize(new Dimension(70, 27));
        this.txtOrt.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.pnlAp.add((Component)this.txtOrt, gridBagConstraints);
        this.lblMail.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.lblMail.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnlAp.add((Component)this.lblMail, gridBagConstraints);
        this.txtMail.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.txtMail.text"));
        this.txtMail.setMinimumSize(new Dimension(70, 27));
        this.txtMail.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.pnlAp.add((Component)this.txtMail, gridBagConstraints);
        this.lblBemerkung.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.lblBemerkung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pnlAp.add((Component)this.lblBemerkung, gridBagConstraints);
        this.txtBemerkung.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.txtBemerkung.text"));
        this.txtBemerkung.setMinimumSize(new Dimension(70, 27));
        this.txtBemerkung.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 20);
        this.pnlAp.add((Component)this.txtBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 20);
        this.pnlScrollPane.add((Component)this.pnlAp, gridBagConstraints);
        this.pnlAp.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.pnlAp.AccessibleContext.accessibleName"));
        this.pnlButtons.setLayout(new BoxLayout(this.pnlButtons, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 20);
        this.pnlScrollPane.add((Component)this.pnlButtons, gridBagConstraints);
        this.cbMapSearch.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.cbMapSearch.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 25, 0, 25);
        this.pnlScrollPane.add((Component)this.cbMapSearch, gridBagConstraints);
        this.lblFiller6.setText(NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.lblFiller6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlScrollPane.add((Component)this.lblFiller6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlScrollPane.add((Component)this.filler2, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.pnlScrollPane);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    private MetaObjectNodeServerSearch getServerSearch(Geometry geometry) {
        Geometry transformedBoundingBox;
        Object geometryToSearchFor = geometry != null ? geometry : (this.cbMapSearch.isSelected() ? ((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry() : null);
        if (geometryToSearchFor != null) {
            transformedBoundingBox = CrsTransformer.transformToDefaultCrs((Geometry)geometryToSearchFor);
            transformedBoundingBox.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        } else {
            transformedBoundingBox = null;
        }
        BaumGebietAnsprechpartnerSearch search = new BaumGebietAnsprechpartnerSearch();
        search.setGeom(transformedBoundingBox);
        search.setAnsprechpartnerName(this.txtAp.getText());
        search.setAnsprechpartnerStrasse(this.txtStrasse.getText());
        search.setAnsprechpartnerOrt(this.txtOrt.getText());
        search.setAnsprechpartnerMail(this.txtMail.getText());
        search.setAnsprechpartnerBemerkung(this.txtBemerkung.getText());
        return search;
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return this.getServerSearch(null);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean checkActionTag() {
        return ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext());
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    public void searchStarted() {
    }

    public void searchDone(int numberOfResults) {
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(BaumWindowSearch.class, (String)"BaumWindowSearch.name");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }
}

