/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.actiontag.ActionTagProtected;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.MeasurementPointCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.MeasurementPointSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.server.CidsMeasurementPointSearchStatement;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MeasurementPointWindowSearch
extends JPanel
implements CidsWindowSearch,
ActionTagProtected,
SearchControlListener,
PropertyChangeListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(MeasurementPointWindowSearch.class);
    private static final String ACTION_TAG = "custom.measurement.pointsearch@WUNDA_BLAU";
    private static final String ACTION_POINTTYPE_ALLE = "cmdAllePunkte";
    private static final String ACTION_POINTTYPE_ANSCHLUSS = "cmdAnschlussPunkte";
    private static final String ACTION_POINTTYPE_GRENZUNDGEBAEUDE = "cmdGrenzUndGebaeudePunkte";
    private static final String ACTION_POINTTYPE_GEBAEUDEUNDBAUWERK = "cmdGebaeudeUndBauwerksPunkte";
    private static final String ACTION_POINTTYPE_HOEHENFEST = "cmdHoehenfestPunkte";
    private boolean geoSearchEnabled;
    private MetaClass metaClass;
    private ImageIcon icon;
    private MappingComponent mappingComponent;
    private SearchControlPanel pnlSearchCancel;
    private GeoSearchButton btnGeoSearch;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private ButtonGroup bgrFilterGST;
    private JButton btnAllePunkte;
    private JButton btnAnschlusspunkte;
    private JButton btnGebaeudeUndBauwerkspunkte;
    private JButton btnGrenzUndGebaudepunkte;
    private JButton btnHoehenfestpunkte;
    private JButton btnNewSearch;
    private JCheckBox chkAufnahmepunkte;
    private JCheckBox chkBesondereBauwerkspunkte;
    private JCheckBox chkBesondereGebaeudepunkte;
    private JCheckBox chkBesondereTopographischePunkte;
    private JCheckBox chkGrenzpunkte;
    private JCheckBox chkNivellementPunkte;
    private JCheckBox chkSearchInCismap;
    private JCheckBox chkSonstigeVermessungspunkte;
    private Box.Filler gluFiller;
    private JLabel lblPointcode;
    private JLabel lblPointcodeWildcardPercent;
    private JLabel lblPointcodeWildcardUnderline;
    private JLabel lblPointcodeWildcards;
    private JPanel pnlButtons;
    private JPanel pnlFilterGST;
    private JPanel pnlFilterPointcode;
    private JPanel pnlFilterPointtype;
    private JPanel pnlPointcodeWildcards;
    private JPanel pnlPointtypeButtons;
    private JPanel pnlPointtypeCheckboxes;
    private JRadioButton rdoFilterGSTAll;
    private JRadioButton rdoFilterGSTLE10;
    private JRadioButton rdoFilterGSTLE2;
    private JRadioButton rdoFilterGSTLE3;
    private JRadioButton rdoFilterGSTLE6;
    private JTextField txtPointcode;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
            this.geoSearchEnabled = this.mappingComponent != null;
            this.metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"ALKIS_POINT", (ConnectionContext)this.getConnectionContext());
            byte[] iconDataFromMetaclass = this.metaClass.getIconData();
            if (iconDataFromMetaclass.length > 0) {
                LOG.info((Object)"Using icon from metaclass.");
                this.icon = new ImageIcon(this.metaClass.getIconData());
            } else {
                LOG.warn((Object)"Metaclass icon is not set. Trying to load default icon.");
                URL urlToIcon = this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/search/search.png");
                this.icon = urlToIcon != null ? new ImageIcon(urlToIcon) : new ImageIcon(new byte[0]);
            }
            this.initComponents();
            this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.getConnectionContext());
            Dimension max = this.pnlSearchCancel.getMaximumSize();
            Dimension min = this.pnlSearchCancel.getMinimumSize();
            Dimension pre = this.pnlSearchCancel.getPreferredSize();
            this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
            this.pnlButtons.add((Component)this.pnlSearchCancel);
            if (this.geoSearchEnabled) {
                MeasurementPointCreateSearchGeometryListener measurementPointCreateSearchGeometryListener = new MeasurementPointCreateSearchGeometryListener(this.mappingComponent, new MeasurementPointSearchTooltip(this.icon));
                measurementPointCreateSearchGeometryListener.addPropertyChangeListener(this);
                this.pnlButtons.add(Box.createHorizontalStrut(5));
                this.btnGeoSearch = new GeoSearchButton("MEASUREMENTPOINT_CREATE_SEARCH_GEOMETRY", this.mappingComponent, null);
                this.btnGeoSearch.setToolTipText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnGeoSearch.toolTipText"));
                this.pnlButtons.add((Component)this.btnGeoSearch);
            } else {
                this.chkSearchInCismap.setVisible(false);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error in constructor of MeasurementPointWindowSearch", (Throwable)e);
            this.mappingComponent = null;
            this.geoSearchEnabled = false;
            this.metaClass = null;
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.bgrFilterGST = new ButtonGroup();
        this.pnlFilterPointcode = new JPanel();
        this.lblPointcode = new JLabel();
        this.txtPointcode = new JTextField();
        this.pnlPointcodeWildcards = new JPanel();
        this.lblPointcodeWildcards = new JLabel();
        this.lblPointcodeWildcardPercent = new JLabel();
        this.lblPointcodeWildcardUnderline = new JLabel();
        this.pnlFilterPointtype = new JPanel();
        this.pnlPointtypeButtons = new JPanel();
        this.btnAllePunkte = new JButton();
        this.btnAnschlusspunkte = new JButton();
        this.btnGrenzUndGebaudepunkte = new JButton();
        this.btnGebaeudeUndBauwerkspunkte = new JButton();
        this.btnHoehenfestpunkte = new JButton();
        this.pnlPointtypeCheckboxes = new JPanel();
        this.chkAufnahmepunkte = new JCheckBox();
        this.chkSonstigeVermessungspunkte = new JCheckBox();
        this.chkGrenzpunkte = new JCheckBox();
        this.chkBesondereGebaeudepunkte = new JCheckBox();
        this.chkBesondereBauwerkspunkte = new JCheckBox();
        this.chkBesondereTopographischePunkte = new JCheckBox();
        this.chkNivellementPunkte = new JCheckBox();
        this.pnlFilterGST = new JPanel();
        this.rdoFilterGSTLE2 = new JRadioButton();
        this.rdoFilterGSTLE3 = new JRadioButton();
        this.rdoFilterGSTLE6 = new JRadioButton();
        this.rdoFilterGSTLE10 = new JRadioButton();
        this.rdoFilterGSTAll = new JRadioButton();
        this.chkSearchInCismap = new JCheckBox();
        this.pnlButtons = new JPanel();
        this.gluFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.btnNewSearch = new JButton();
        this.setLayout(new GridBagLayout());
        this.pnlFilterPointcode.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.pnlFilterPointcode.border.title")));
        this.pnlFilterPointcode.setLayout(new GridBagLayout());
        this.lblPointcode.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.lblPointcode.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterPointcode.add((Component)this.lblPointcode, gridBagConstraints);
        this.txtPointcode.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.txtPointcode.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterPointcode.add((Component)this.txtPointcode, gridBagConstraints);
        this.pnlPointcodeWildcards.setLayout(new GridBagLayout());
        this.lblPointcodeWildcards.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.lblPointcodeWildcards.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlPointcodeWildcards.add((Component)this.lblPointcodeWildcards, gridBagConstraints);
        this.lblPointcodeWildcardPercent.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.lblPointcodeWildcardPercent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.pnlPointcodeWildcards.add((Component)this.lblPointcodeWildcardPercent, gridBagConstraints);
        this.lblPointcodeWildcardUnderline.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.lblPointcodeWildcardUnderline.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.pnlPointcodeWildcards.add((Component)this.lblPointcodeWildcardUnderline, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.pnlFilterPointcode.add((Component)this.pnlPointcodeWildcards, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlFilterPointcode, gridBagConstraints);
        this.pnlFilterPointtype.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.pnlFilterPointtype.border.title")));
        this.pnlFilterPointtype.setLayout(new GridBagLayout());
        this.pnlPointtypeButtons.setLayout(new GridBagLayout());
        this.btnAllePunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnAllePunkte.text"));
        this.btnAllePunkte.setActionCommand(ACTION_POINTTYPE_ALLE);
        this.btnAllePunkte.setFocusPainted(false);
        this.btnAllePunkte.setMaximumSize(new Dimension(85, 25));
        this.btnAllePunkte.setMinimumSize(new Dimension(85, 25));
        this.btnAllePunkte.setPreferredSize(new Dimension(85, 25));
        this.btnAllePunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.btnAllePunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 4, 5);
        this.pnlPointtypeButtons.add((Component)this.btnAllePunkte, gridBagConstraints);
        this.btnAnschlusspunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnAnschlusspunkte.text"));
        this.btnAnschlusspunkte.setActionCommand(ACTION_POINTTYPE_ANSCHLUSS);
        this.btnAnschlusspunkte.setFocusPainted(false);
        this.btnAnschlusspunkte.setMaximumSize(new Dimension(112, 25));
        this.btnAnschlusspunkte.setMinimumSize(new Dimension(112, 25));
        this.btnAnschlusspunkte.setPreferredSize(new Dimension(112, 25));
        this.btnAnschlusspunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.btnAnschlusspunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.pnlPointtypeButtons.add((Component)this.btnAnschlusspunkte, gridBagConstraints);
        this.btnGrenzUndGebaudepunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnGrenzUndGebaudepunkte.text"));
        this.btnGrenzUndGebaudepunkte.setActionCommand(ACTION_POINTTYPE_GRENZUNDGEBAEUDE);
        this.btnGrenzUndGebaudepunkte.setFocusPainted(false);
        this.btnGrenzUndGebaudepunkte.setMaximumSize(new Dimension(150, 25));
        this.btnGrenzUndGebaudepunkte.setMinimumSize(new Dimension(150, 25));
        this.btnGrenzUndGebaudepunkte.setPreferredSize(new Dimension(150, 25));
        this.btnGrenzUndGebaudepunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.btnGrenzUndGebaudepunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.pnlPointtypeButtons.add((Component)this.btnGrenzUndGebaudepunkte, gridBagConstraints);
        this.btnGebaeudeUndBauwerkspunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnGebaeudeUndBauwerkspunkte.text"));
        this.btnGebaeudeUndBauwerkspunkte.setActionCommand(ACTION_POINTTYPE_GEBAEUDEUNDBAUWERK);
        this.btnGebaeudeUndBauwerkspunkte.setFocusPainted(false);
        this.btnGebaeudeUndBauwerkspunkte.setMaximumSize(new Dimension(168, 25));
        this.btnGebaeudeUndBauwerkspunkte.setMinimumSize(new Dimension(168, 25));
        this.btnGebaeudeUndBauwerkspunkte.setPreferredSize(new Dimension(168, 25));
        this.btnGebaeudeUndBauwerkspunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.btnGebaeudeUndBauwerkspunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.pnlPointtypeButtons.add((Component)this.btnGebaeudeUndBauwerkspunkte, gridBagConstraints);
        this.btnHoehenfestpunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnHoehenfestpunkte.text"));
        this.btnHoehenfestpunkte.setActionCommand(ACTION_POINTTYPE_HOEHENFEST);
        this.btnHoehenfestpunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.btnHoehenfestpunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 5, 5);
        this.pnlPointtypeButtons.add((Component)this.btnHoehenfestpunkte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        this.pnlFilterPointtype.add((Component)this.pnlPointtypeButtons, gridBagConstraints);
        this.pnlPointtypeCheckboxes.setLayout(new GridBagLayout());
        this.chkAufnahmepunkte.setSelected(true);
        this.chkAufnahmepunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkAufnahmepunkte.text"));
        this.chkAufnahmepunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.chkAufnahmepunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 5, 2, 5);
        this.pnlPointtypeCheckboxes.add((Component)this.chkAufnahmepunkte, gridBagConstraints);
        this.chkSonstigeVermessungspunkte.setSelected(true);
        this.chkSonstigeVermessungspunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkSonstigeVermessungspunkte.text"));
        this.chkSonstigeVermessungspunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.chkSonstigeVermessungspunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlPointtypeCheckboxes.add((Component)this.chkSonstigeVermessungspunkte, gridBagConstraints);
        this.chkGrenzpunkte.setSelected(true);
        this.chkGrenzpunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkGrenzpunkte.text"));
        this.chkGrenzpunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.chkGrenzpunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlPointtypeCheckboxes.add((Component)this.chkGrenzpunkte, gridBagConstraints);
        this.chkBesondereGebaeudepunkte.setSelected(true);
        this.chkBesondereGebaeudepunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkBesondereGebaeudepunkte.text"));
        this.chkBesondereGebaeudepunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.chkBesondereGebaeudepunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlPointtypeCheckboxes.add((Component)this.chkBesondereGebaeudepunkte, gridBagConstraints);
        this.chkBesondereBauwerkspunkte.setSelected(true);
        this.chkBesondereBauwerkspunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkBesondereBauwerkspunkte.text"));
        this.chkBesondereBauwerkspunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.chkBesondereBauwerkspunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlPointtypeCheckboxes.add((Component)this.chkBesondereBauwerkspunkte, gridBagConstraints);
        this.chkBesondereTopographischePunkte.setSelected(true);
        this.chkBesondereTopographischePunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkBesondereTopographischePunkte.text"));
        this.chkBesondereTopographischePunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.chkBesondereTopographischePunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlPointtypeCheckboxes.add((Component)this.chkBesondereTopographischePunkte, gridBagConstraints);
        this.chkNivellementPunkte.setSelected(true);
        this.chkNivellementPunkte.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkNivellementPunkte.text"));
        this.chkNivellementPunkte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.chkNivellementPunkteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlPointtypeCheckboxes.add((Component)this.chkNivellementPunkte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        this.pnlFilterPointtype.add((Component)this.pnlPointtypeCheckboxes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlFilterPointtype, gridBagConstraints);
        this.pnlFilterGST.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.pnlFilterGST.border.title")));
        this.pnlFilterGST.setLayout(new GridBagLayout());
        this.bgrFilterGST.add(this.rdoFilterGSTLE2);
        this.rdoFilterGSTLE2.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.rdoFilterGSTLE2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 2);
        this.pnlFilterGST.add((Component)this.rdoFilterGSTLE2, gridBagConstraints);
        this.bgrFilterGST.add(this.rdoFilterGSTLE3);
        this.rdoFilterGSTLE3.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.rdoFilterGSTLE3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.pnlFilterGST.add((Component)this.rdoFilterGSTLE3, gridBagConstraints);
        this.bgrFilterGST.add(this.rdoFilterGSTLE6);
        this.rdoFilterGSTLE6.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.rdoFilterGSTLE6.text"));
        this.rdoFilterGSTLE6.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.pnlFilterGST.add((Component)this.rdoFilterGSTLE6, gridBagConstraints);
        this.bgrFilterGST.add(this.rdoFilterGSTLE10);
        this.rdoFilterGSTLE10.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.rdoFilterGSTLE10.text"));
        this.rdoFilterGSTLE10.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.pnlFilterGST.add((Component)this.rdoFilterGSTLE10, gridBagConstraints);
        this.bgrFilterGST.add(this.rdoFilterGSTAll);
        this.rdoFilterGSTAll.setSelected(true);
        this.rdoFilterGSTAll.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.rdoFilterGSTAll.text"));
        this.rdoFilterGSTAll.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 5);
        this.pnlFilterGST.add((Component)this.rdoFilterGSTAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlFilterGST, gridBagConstraints);
        this.chkSearchInCismap.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.chkSearchInCismap.text"));
        this.chkSearchInCismap.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.chkSearchInCismap, gridBagConstraints);
        this.pnlButtons.setLayout(new BoxLayout(this.pnlButtons, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.gluFiller, gridBagConstraints);
        this.btnNewSearch.setText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnNewSearch.text"));
        this.btnNewSearch.setToolTipText(NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.btnNewSearch.toolTipText"));
        this.btnNewSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasurementPointWindowSearch.this.btnNewSearchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.btnNewSearch, gridBagConstraints);
    }

    private void btnAllePunkteActionPerformed(ActionEvent evt) {
        this.changeFilterPointtype(evt.getActionCommand());
    }

    private void btnAnschlusspunkteActionPerformed(ActionEvent evt) {
        this.changeFilterPointtype(evt.getActionCommand());
    }

    private void btnGrenzUndGebaudepunkteActionPerformed(ActionEvent evt) {
        this.changeFilterPointtype(evt.getActionCommand());
    }

    private void btnGebaeudeUndBauwerkspunkteActionPerformed(ActionEvent evt) {
        this.changeFilterPointtype(evt.getActionCommand());
    }

    private void chkAufnahmepunkteActionPerformed(ActionEvent evt) {
        this.changeEnabledStateOfSearchButtons();
    }

    private void chkSonstigeVermessungspunkteActionPerformed(ActionEvent evt) {
        this.changeEnabledStateOfSearchButtons();
    }

    private void chkGrenzpunkteActionPerformed(ActionEvent evt) {
        this.changeEnabledStateOfSearchButtons();
    }

    private void chkBesondereGebaeudepunkteActionPerformed(ActionEvent evt) {
        this.changeEnabledStateOfSearchButtons();
    }

    private void chkBesondereBauwerkspunkteActionPerformed(ActionEvent evt) {
        this.changeEnabledStateOfSearchButtons();
    }

    private void chkBesondereTopographischePunkteActionPerformed(ActionEvent evt) {
        this.changeEnabledStateOfSearchButtons();
    }

    private void btnHoehenfestpunkteActionPerformed(ActionEvent evt) {
        this.changeFilterPointtype(evt.getActionCommand());
    }

    private void chkNivellementPunkteActionPerformed(ActionEvent evt) {
        this.changeEnabledStateOfSearchButtons();
    }

    private void btnNewSearchActionPerformed(ActionEvent evt) {
        this.txtPointcode.setText("");
        this.chkAufnahmepunkte.setSelected(true);
        this.chkBesondereBauwerkspunkte.setSelected(true);
        this.chkBesondereGebaeudepunkte.setSelected(true);
        this.chkBesondereTopographischePunkte.setSelected(true);
        this.chkGrenzpunkte.setSelected(true);
        this.chkNivellementPunkte.setSelected(true);
        this.chkSonstigeVermessungspunkte.setSelected(true);
        this.chkSearchInCismap.setSelected(false);
        this.rdoFilterGSTAll.setSelected(true);
    }

    protected void changeFilterPointtype(String actionCommand) {
        if (ACTION_POINTTYPE_ALLE.equals(actionCommand)) {
            this.chkAufnahmepunkte.setSelected(true);
            this.chkSonstigeVermessungspunkte.setSelected(true);
            this.chkGrenzpunkte.setSelected(true);
            this.chkBesondereGebaeudepunkte.setSelected(true);
            this.chkBesondereBauwerkspunkte.setSelected(true);
            this.chkBesondereTopographischePunkte.setSelected(true);
            this.chkNivellementPunkte.setSelected(false);
        } else if (ACTION_POINTTYPE_ANSCHLUSS.equals(actionCommand)) {
            this.chkAufnahmepunkte.setSelected(true);
            this.chkSonstigeVermessungspunkte.setSelected(true);
            this.chkGrenzpunkte.setSelected(false);
            this.chkBesondereGebaeudepunkte.setSelected(false);
            this.chkBesondereBauwerkspunkte.setSelected(false);
            this.chkBesondereTopographischePunkte.setSelected(false);
            this.chkNivellementPunkte.setSelected(false);
        } else if (ACTION_POINTTYPE_GRENZUNDGEBAEUDE.equals(actionCommand)) {
            this.chkAufnahmepunkte.setSelected(false);
            this.chkSonstigeVermessungspunkte.setSelected(false);
            this.chkGrenzpunkte.setSelected(true);
            this.chkBesondereGebaeudepunkte.setSelected(true);
            this.chkBesondereBauwerkspunkte.setSelected(true);
            this.chkBesondereTopographischePunkte.setSelected(false);
            this.chkNivellementPunkte.setSelected(false);
        } else if (ACTION_POINTTYPE_GEBAEUDEUNDBAUWERK.equals(actionCommand)) {
            this.chkAufnahmepunkte.setSelected(false);
            this.chkSonstigeVermessungspunkte.setSelected(false);
            this.chkGrenzpunkte.setSelected(false);
            this.chkBesondereGebaeudepunkte.setSelected(true);
            this.chkBesondereBauwerkspunkte.setSelected(true);
            this.chkBesondereTopographischePunkte.setSelected(false);
            this.chkNivellementPunkte.setSelected(false);
        } else if (ACTION_POINTTYPE_HOEHENFEST.equals(actionCommand)) {
            this.chkAufnahmepunkte.setSelected(false);
            this.chkSonstigeVermessungspunkte.setSelected(false);
            this.chkGrenzpunkte.setSelected(false);
            this.chkBesondereGebaeudepunkte.setSelected(false);
            this.chkBesondereBauwerkspunkte.setSelected(false);
            this.chkBesondereTopographischePunkte.setSelected(false);
            this.chkNivellementPunkte.setSelected(true);
        }
        this.changeEnabledStateOfSearchButtons();
    }

    protected void changeEnabledStateOfSearchButtons() {
        boolean enableSearchButtons = false;
        enableSearchButtons |= this.chkAufnahmepunkte.isSelected();
        enableSearchButtons |= this.chkSonstigeVermessungspunkte.isSelected();
        enableSearchButtons |= this.chkGrenzpunkte.isSelected();
        enableSearchButtons |= this.chkBesondereGebaeudepunkte.isSelected();
        enableSearchButtons |= this.chkBesondereBauwerkspunkte.isSelected();
        enableSearchButtons |= this.chkBesondereTopographischePunkte.isSelected();
        this.pnlSearchCancel.setEnabled(enableSearchButtons |= this.chkNivellementPunkte.isSelected());
        if (this.geoSearchEnabled) {
            this.btnGeoSearch.setEnabled(enableSearchButtons);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return this.getServerSearch(null);
    }

    public MetaObjectNodeServerSearch getServerSearch(Geometry geometry) {
        Geometry transformedBoundingBox;
        LinkedList<CidsMeasurementPointSearchStatement.Pointtype> pointtypes = new LinkedList<CidsMeasurementPointSearchStatement.Pointtype>();
        if (this.chkAufnahmepunkte.isSelected()) {
            pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.AUFNAHMEPUNKTE);
        }
        if (this.chkSonstigeVermessungspunkte.isSelected()) {
            pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.SONSTIGE_VERMESSUNGSPUNKTE);
        }
        if (this.chkGrenzpunkte.isSelected()) {
            pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.GRENZPUNKTE);
        }
        if (this.chkBesondereGebaeudepunkte.isSelected()) {
            pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.BESONDERE_GEBAEUDEPUNKTE);
        }
        if (this.chkBesondereBauwerkspunkte.isSelected()) {
            pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.BESONDERE_BAUWERKSPUNKTE);
        }
        if (this.chkBesondereTopographischePunkte.isSelected()) {
            pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.BESONDERE_TOPOGRAPHISCHE_PUNKTE);
        }
        if (this.chkNivellementPunkte.isSelected()) {
            pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.NIVELLEMENT_PUNKTE);
        }
        CidsMeasurementPointSearchStatement.GST gst = null;
        if (this.rdoFilterGSTLE2.isSelected()) {
            gst = CidsMeasurementPointSearchStatement.GST.LE2;
        } else if (this.rdoFilterGSTLE3.isSelected()) {
            gst = CidsMeasurementPointSearchStatement.GST.LE3;
        } else if (this.rdoFilterGSTLE6.isSelected()) {
            gst = CidsMeasurementPointSearchStatement.GST.LE6;
        } else if (this.rdoFilterGSTLE10.isSelected()) {
            gst = CidsMeasurementPointSearchStatement.GST.LE10;
        }
        Geometry geometryToSearchFor = null;
        if (geometry != null) {
            geometryToSearchFor = geometry;
        } else if (this.chkSearchInCismap.isSelected()) {
            geometryToSearchFor = ((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry();
        }
        if (geometryToSearchFor != null) {
            transformedBoundingBox = CrsTransformer.transformToDefaultCrs((Geometry)geometryToSearchFor);
            transformedBoundingBox.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        } else {
            transformedBoundingBox = null;
        }
        return new CidsMeasurementPointSearchStatement(this.txtPointcode.getText(), pointtypes, gst, transformedBoundingBox);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(MeasurementPointWindowSearch.class, (String)"MeasurementPointWindowSearch.name");
    }

    public boolean checkActionTag() {
        return ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext());
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    public void searchStarted() {
    }

    public void searchDone(int result) {
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }
}

