/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.actiontag.ActionTagProtected;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objecteditors.utils.VermessungRissUtils;
import de.cismet.cids.custom.objecteditors.wunda_blau.VermessungFlurstueckSelectionDialog;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.VermessungRissCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.VermessungRissSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.server.CidsVermessungRissArtSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.CidsVermessungRissSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class VermessungRissWindowSearch
extends JPanel
implements CidsWindowSearch,
ActionTagProtected,
SearchControlListener,
PropertyChangeListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(VermessungRissWindowSearch.class);
    private static final String ACTION_TAG = "custom.vermessungsriss.windowsearch@WUNDA_BLAU";
    private static final String VERAENDERUNGSART_ALL_CODE = " ";
    private static Collection<CidsBean> veraenderungsarts = new LinkedList<CidsBean>();
    private boolean geoSearchEnabled;
    private MetaClass metaClass;
    private ImageIcon icon;
    private MappingComponent mappingComponent;
    private SearchControlPanel pnlSearchCancel;
    private GeoSearchButton btnGeoSearch;
    private VermessungFlurstueckSelectionDialog flurstueckDialog;
    private DefaultListModel flurstuecksvermessungFilterModel = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnAddFlurstueck;
    private JButton btnFilterSchluessel505To508;
    private JButton btnFilterSchluesselAll;
    private JButton btnNewSearch;
    private JButton btnRemoveFlurstueck;
    private JCheckBox chkFilterSchluessel501;
    private JCheckBox chkFilterSchluessel502;
    private JCheckBox chkFilterSchluessel503;
    private JCheckBox chkFilterSchluessel504;
    private JCheckBox chkFilterSchluessel505;
    private JCheckBox chkFilterSchluessel506;
    private JCheckBox chkFilterSchluessel507;
    private JCheckBox chkFilterSchluessel508;
    private JCheckBox chkFilterSchluessel600;
    private JCheckBox chkSearchInCismap;
    private JLabel lblBlatt;
    private JLabel lblFilterRissWildcardPercent;
    private JLabel lblFilterRissWildcardUnderline;
    private JLabel lblFilterRissWildcards;
    private JLabel lblFlur;
    private JLabel lblGemarkung;
    private JLabel lblSchluessel;
    private JList lstFlurstuecke;
    private JPanel pnlButtons;
    private JPanel pnlFilterFlurstuecke;
    private JPanel pnlFilterRiss;
    private JPanel pnlFilterRissWildcards;
    private JPanel pnlFilterSchluessel;
    private JPanel pnlFilterSchluesselControls;
    private JPopupMenu popChangeVeraenderungsart;
    private JScrollPane scpFlurstuecke;
    private JTextField txtBlatt;
    private JTextField txtFlur;
    private JTextField txtGemarkung;
    private JTextField txtSchluessel;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        block12: {
            this.connectionContext = connectionContext;
            try {
                this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
                this.geoSearchEnabled = this.mappingComponent != null;
                this.metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"vermessung_riss", (ConnectionContext)this.getConnectionContext());
                if (this.metaClass == null) break block12;
                byte[] iconDataFromMetaclass = new byte[]{};
                if (this.metaClass != null) {
                    iconDataFromMetaclass = this.metaClass.getIconData();
                }
                if (iconDataFromMetaclass.length > 0) {
                    LOG.info((Object)"Using icon from metaclass.");
                    this.icon = new ImageIcon(this.metaClass.getIconData());
                } else {
                    LOG.warn((Object)"Metaclass icon is not set. Trying to load default icon.");
                    URL urlToIcon = this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/search/search.png");
                    this.icon = urlToIcon != null ? new ImageIcon(urlToIcon) : new ImageIcon(new byte[0]);
                }
                this.initComponents();
                new CidsBeanDropTarget((Component)((DropAwareJList)this.lstFlurstuecke));
                this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.getConnectionContext());
                Dimension max = this.pnlSearchCancel.getMaximumSize();
                Dimension min = this.pnlSearchCancel.getMinimumSize();
                Dimension pre = this.pnlSearchCancel.getPreferredSize();
                this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
                this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
                this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
                this.pnlButtons.add((Component)this.pnlSearchCancel);
                if (this.geoSearchEnabled) {
                    VermessungRissCreateSearchGeometryListener vermessungRissCreateSearchGeometryListener = new VermessungRissCreateSearchGeometryListener(this.mappingComponent, new VermessungRissSearchTooltip(this.icon));
                    vermessungRissCreateSearchGeometryListener.addPropertyChangeListener(this);
                    this.pnlButtons.add(Box.createHorizontalStrut(5));
                    this.btnGeoSearch = new GeoSearchButton("VERMESSUNGRISS_CREATE_SEARCH_GEOMETRY", this.mappingComponent, null);
                    this.btnGeoSearch.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnGeoSearch.toolTipText"));
                    this.pnlButtons.add((Component)this.btnGeoSearch);
                } else {
                    this.chkSearchInCismap.setVisible(false);
                }
                this.flurstuecksvermessungFilterModel = new DefaultListModel();
                this.lstFlurstuecke.setModel(this.flurstuecksvermessungFilterModel);
                this.flurstueckDialog = new VermessungFlurstueckSelectionDialog(false, this.getConnectionContext()){

                    @Override
                    public void okHook() {
                        VermessungRissWindowSearch.this.flurstuecksvermessungFilterModel.clear();
                        for (CidsBean flurstuecksvermessung : this.getCurrentListToAdd()) {
                            VermessungRissWindowSearch.this.flurstuecksvermessungFilterModel.addElement(flurstuecksvermessung);
                        }
                    }
                };
                this.flurstueckDialog.pack();
                if (veraenderungsarts == null || veraenderungsarts.isEmpty()) {
                    Collection result;
                    try {
                        result = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new CidsVermessungRissArtSearchStatement(SessionManager.getSession().getUser()), this.getConnectionContext());
                    }
                    catch (ConnectionException ex) {
                        LOG.warn((Object)"Could not fetch veranederungsart entries. Editing flurstuecksvermessung will not work.", (Throwable)ex);
                        return;
                    }
                    for (Object veraenderungsart : result) {
                        veraenderungsarts.add(((MetaObject)veraenderungsart).getBean());
                    }
                }
                CidsBean veraenderungsartAll = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"vermessung_art", (ConnectionContext)this.getConnectionContext());
                veraenderungsartAll.setProperty("code", (Object)VERAENDERUNGSART_ALL_CODE);
                String text = NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.veraenderungsart_all.name");
                veraenderungsartAll.setProperty("name", (Object)text);
                this.popChangeVeraenderungsart.add(new ChangeVeraenderungsartAction(veraenderungsartAll));
                for (CidsBean veraenderungsart : veraenderungsarts) {
                    this.popChangeVeraenderungsart.add(new ChangeVeraenderungsartAction(veraenderungsart));
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)"Error in Constructor of VermessungsRissWindowSearch. Search will not work properly.", e);
                this.geoSearchEnabled = false;
                this.metaClass = null;
                this.mappingComponent = null;
            }
        }
    }

    private void initComponents() {
        this.popChangeVeraenderungsart = new JPopupMenu();
        this.pnlFilterRiss = new JPanel();
        this.lblSchluessel = new JLabel();
        this.lblGemarkung = new JLabel();
        this.lblFlur = new JLabel();
        this.lblBlatt = new JLabel();
        this.txtSchluessel = new JTextField();
        this.txtGemarkung = new JTextField();
        this.txtFlur = new JTextField();
        this.txtBlatt = new JTextField();
        this.pnlFilterRissWildcards = new JPanel();
        this.lblFilterRissWildcards = new JLabel();
        this.lblFilterRissWildcardPercent = new JLabel();
        this.lblFilterRissWildcardUnderline = new JLabel();
        this.pnlFilterSchluessel = new JPanel();
        this.chkFilterSchluessel501 = new JCheckBox();
        this.chkFilterSchluessel502 = new JCheckBox();
        this.chkFilterSchluessel503 = new JCheckBox();
        this.chkFilterSchluessel504 = new JCheckBox();
        this.chkFilterSchluessel505 = new JCheckBox();
        this.chkFilterSchluessel506 = new JCheckBox();
        this.chkFilterSchluessel507 = new JCheckBox();
        this.chkFilterSchluessel508 = new JCheckBox();
        this.chkFilterSchluessel600 = new JCheckBox();
        this.pnlFilterSchluesselControls = new JPanel();
        this.btnFilterSchluesselAll = new JButton();
        this.btnFilterSchluessel505To508 = new JButton();
        this.pnlFilterFlurstuecke = new JPanel();
        this.scpFlurstuecke = new JScrollPane();
        this.lstFlurstuecke = new DropAwareJList();
        this.btnAddFlurstueck = new JButton();
        this.btnRemoveFlurstueck = new JButton();
        this.chkSearchInCismap = new JCheckBox();
        this.pnlButtons = new JPanel();
        this.btnNewSearch = new JButton();
        this.setLayout(new GridBagLayout());
        this.pnlFilterRiss.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.pnlFilterRiss.border.title")));
        this.pnlFilterRiss.setLayout(new GridBagLayout());
        this.lblSchluessel.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.lblSchluessel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.lblSchluessel, gridBagConstraints);
        this.lblGemarkung.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.lblGemarkung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.lblGemarkung, gridBagConstraints);
        this.lblFlur.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.lblFlur.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.lblFlur, gridBagConstraints);
        this.lblBlatt.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.lblBlatt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.lblBlatt, gridBagConstraints);
        this.txtSchluessel.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.txtSchluessel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.txtSchluessel, gridBagConstraints);
        this.txtGemarkung.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.txtGemarkung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 70;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.txtGemarkung, gridBagConstraints);
        this.txtFlur.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.txtFlur.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.txtFlur, gridBagConstraints);
        this.txtBlatt.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.txtBlatt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRiss.add((Component)this.txtBlatt, gridBagConstraints);
        this.pnlFilterRissWildcards.setLayout(new GridBagLayout());
        this.lblFilterRissWildcards.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.lblFilterRissWildcards.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFilterRissWildcards.add((Component)this.lblFilterRissWildcards, gridBagConstraints);
        this.lblFilterRissWildcardPercent.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.lblFilterRissWildcardPercent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.pnlFilterRissWildcards.add((Component)this.lblFilterRissWildcardPercent, gridBagConstraints);
        this.lblFilterRissWildcardUnderline.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.lblFilterRissWildcardUnderline.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.pnlFilterRissWildcards.add((Component)this.lblFilterRissWildcardUnderline, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.pnlFilterRiss.add((Component)this.pnlFilterRissWildcards, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlFilterRiss, gridBagConstraints);
        this.pnlFilterSchluessel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.pnlFilterSchluessel.border.title")));
        this.pnlFilterSchluessel.setLayout(new GridBagLayout());
        this.chkFilterSchluessel501.setSelected(true);
        this.chkFilterSchluessel501.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel501.text"));
        this.chkFilterSchluessel501.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel501.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel501, gridBagConstraints);
        this.chkFilterSchluessel502.setSelected(true);
        this.chkFilterSchluessel502.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel502.text"));
        this.chkFilterSchluessel502.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel502.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel502, gridBagConstraints);
        this.chkFilterSchluessel503.setSelected(true);
        this.chkFilterSchluessel503.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel503.text"));
        this.chkFilterSchluessel503.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel503.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel503, gridBagConstraints);
        this.chkFilterSchluessel504.setSelected(true);
        this.chkFilterSchluessel504.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel504.text"));
        this.chkFilterSchluessel504.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel504.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel504, gridBagConstraints);
        this.chkFilterSchluessel505.setSelected(true);
        this.chkFilterSchluessel505.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel505.text"));
        this.chkFilterSchluessel505.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel505.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel505, gridBagConstraints);
        this.chkFilterSchluessel506.setSelected(true);
        this.chkFilterSchluessel506.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel506.text"));
        this.chkFilterSchluessel506.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel506.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel506, gridBagConstraints);
        this.chkFilterSchluessel507.setSelected(true);
        this.chkFilterSchluessel507.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel507.text"));
        this.chkFilterSchluessel507.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel507.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel507, gridBagConstraints);
        this.chkFilterSchluessel508.setSelected(true);
        this.chkFilterSchluessel508.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel508.text"));
        this.chkFilterSchluessel508.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel508.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel508, gridBagConstraints);
        this.chkFilterSchluessel600.setSelected(true);
        this.chkFilterSchluessel600.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel600.text"));
        this.chkFilterSchluessel600.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkFilterSchluessel600.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.pnlFilterSchluessel.add((Component)this.chkFilterSchluessel600, gridBagConstraints);
        this.btnFilterSchluesselAll.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnFilterSchluesselAll.text"));
        this.btnFilterSchluesselAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungRissWindowSearch.this.btnFilterSchluesselAllActionPerformed(evt);
            }
        });
        this.pnlFilterSchluesselControls.add(this.btnFilterSchluesselAll);
        this.btnFilterSchluessel505To508.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnFilterSchluessel505To508.text"));
        this.btnFilterSchluessel505To508.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungRissWindowSearch.this.btnFilterSchluessel505To508ActionPerformed(evt);
            }
        });
        this.pnlFilterSchluesselControls.add(this.btnFilterSchluessel505To508);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 23;
        this.pnlFilterSchluessel.add((Component)this.pnlFilterSchluesselControls, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlFilterSchluessel, gridBagConstraints);
        this.pnlFilterFlurstuecke.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.pnlFilterFlurstuecke.border.title")));
        this.pnlFilterFlurstuecke.setLayout(new GridBagLayout());
        this.scpFlurstuecke.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scpFlurstuecke.setMinimumSize(new Dimension(266, 138));
        this.scpFlurstuecke.setOpaque(false);
        this.lstFlurstuecke.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VermessungRissWindowSearch.this.lstFlurstueckeMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                VermessungRissWindowSearch.this.lstFlurstueckeMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                VermessungRissWindowSearch.this.lstFlurstueckeMouseReleased(evt);
            }
        });
        this.lstFlurstuecke.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                VermessungRissWindowSearch.this.lstFlurstueckeValueChanged(evt);
            }
        });
        this.scpFlurstuecke.setViewportView(this.lstFlurstuecke);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 0.1;
        this.pnlFilterFlurstuecke.add((Component)this.scpFlurstuecke, gridBagConstraints);
        this.btnAddFlurstueck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        this.btnAddFlurstueck.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnAddFlurstueck.text"));
        this.btnAddFlurstueck.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnAddFlurstueck.toolTipText"));
        this.btnAddFlurstueck.setFocusPainted(false);
        this.btnAddFlurstueck.setMaximumSize(new Dimension(43, 25));
        this.btnAddFlurstueck.setMinimumSize(new Dimension(43, 25));
        this.btnAddFlurstueck.setPreferredSize(new Dimension(43, 25));
        this.btnAddFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungRissWindowSearch.this.btnAddFlurstueckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 0, 10, 2);
        this.pnlFilterFlurstuecke.add((Component)this.btnAddFlurstueck, gridBagConstraints);
        this.btnRemoveFlurstueck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        this.btnRemoveFlurstueck.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnRemoveFlurstueck.text"));
        this.btnRemoveFlurstueck.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnRemoveFlurstueck.toolTipText"));
        this.btnRemoveFlurstueck.setEnabled(false);
        this.btnRemoveFlurstueck.setFocusPainted(false);
        this.btnRemoveFlurstueck.setMaximumSize(new Dimension(43, 25));
        this.btnRemoveFlurstueck.setMinimumSize(new Dimension(43, 25));
        this.btnRemoveFlurstueck.setPreferredSize(new Dimension(43, 25));
        this.btnRemoveFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungRissWindowSearch.this.btnRemoveFlurstueckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 2, 10, 10);
        this.pnlFilterFlurstuecke.add((Component)this.btnRemoveFlurstueck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlFilterFlurstuecke, gridBagConstraints);
        this.chkSearchInCismap.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.chkSearchInCismap.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.chkSearchInCismap, gridBagConstraints);
        this.pnlButtons.setLayout(new BoxLayout(this.pnlButtons, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnlButtons, gridBagConstraints);
        this.btnNewSearch.setText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnNewSearch.text"));
        this.btnNewSearch.setToolTipText(NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.btnNewSearch.toolTipText"));
        this.btnNewSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungRissWindowSearch.this.btnNewSearchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.btnNewSearch, gridBagConstraints);
    }

    private void btnFilterSchluesselAllActionPerformed(ActionEvent evt) {
        this.chkFilterSchluessel501.setSelected(true);
        this.chkFilterSchluessel502.setSelected(true);
        this.chkFilterSchluessel503.setSelected(true);
        this.chkFilterSchluessel504.setSelected(true);
        this.chkFilterSchluessel505.setSelected(true);
        this.chkFilterSchluessel506.setSelected(true);
        this.chkFilterSchluessel507.setSelected(true);
        this.chkFilterSchluessel508.setSelected(true);
        this.chkFilterSchluessel600.setSelected(true);
    }

    private void lstFlurstueckeValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.btnRemoveFlurstueck.setEnabled(this.lstFlurstuecke.getSelectedIndex() > -1);
        }
    }

    private void btnAddFlurstueckActionPerformed(ActionEvent evt) {
        ArrayList<CidsBean> result = new ArrayList<CidsBean>(1);
        for (Object flurstuecksvermessung : this.flurstuecksvermessungFilterModel.toArray()) {
            result.add((CidsBean)flurstuecksvermessung);
        }
        Collections.sort(result, AlphanumComparator.getInstance());
        this.flurstueckDialog.setCurrentListToAdd(result);
        StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)this), (JDialog)this.flurstueckDialog, (boolean)true);
    }

    private void btnRemoveFlurstueckActionPerformed(ActionEvent evt) {
        Object[] selection;
        for (Object flurstueck : selection = this.lstFlurstuecke.getSelectedValues()) {
            this.flurstuecksvermessungFilterModel.removeElement(flurstueck);
        }
    }

    private void btnFilterSchluessel505To508ActionPerformed(ActionEvent evt) {
        this.chkFilterSchluessel501.setSelected(false);
        this.chkFilterSchluessel502.setSelected(false);
        this.chkFilterSchluessel503.setSelected(false);
        this.chkFilterSchluessel504.setSelected(false);
        this.chkFilterSchluessel505.setSelected(true);
        this.chkFilterSchluessel506.setSelected(true);
        this.chkFilterSchluessel507.setSelected(true);
        this.chkFilterSchluessel508.setSelected(true);
        this.chkFilterSchluessel600.setSelected(false);
    }

    private void lstFlurstueckeMouseClicked(MouseEvent evt) {
    }

    private void lstFlurstueckeMousePressed(MouseEvent evt) {
        if (this.popChangeVeraenderungsart.isPopupTrigger(evt)) {
            int indexUnderMouse = this.lstFlurstuecke.locationToIndex(evt.getPoint());
            int[] selection = this.lstFlurstuecke.getSelectedIndices();
            boolean selectValueUnderMouse = true;
            if (selection != null && selection.length > 0) {
                for (int index : selection) {
                    if (index != indexUnderMouse) continue;
                    selectValueUnderMouse = false;
                }
            }
            if (selectValueUnderMouse) {
                this.lstFlurstuecke.setSelectedIndex(this.lstFlurstuecke.locationToIndex(evt.getPoint()));
                selection = this.lstFlurstuecke.getSelectedIndices();
            }
            if (selection != null && selection.length > 0) {
                this.popChangeVeraenderungsart.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private void lstFlurstueckeMouseReleased(MouseEvent evt) {
        this.lstFlurstueckeMousePressed(evt);
    }

    private void btnNewSearchActionPerformed(ActionEvent evt) {
        this.txtBlatt.setText("");
        this.txtFlur.setText("");
        this.txtGemarkung.setText("");
        this.txtSchluessel.setText("");
        this.chkFilterSchluessel501.setSelected(true);
        this.chkFilterSchluessel502.setSelected(true);
        this.chkFilterSchluessel503.setSelected(true);
        this.chkFilterSchluessel504.setSelected(true);
        this.chkFilterSchluessel505.setSelected(true);
        this.chkFilterSchluessel506.setSelected(true);
        this.chkFilterSchluessel507.setSelected(true);
        this.chkFilterSchluessel508.setSelected(true);
        this.chkFilterSchluessel600.setSelected(true);
        this.chkSearchInCismap.setSelected(false);
        this.flurstuecksvermessungFilterModel.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return this.getServerSearch(null);
    }

    public MetaObjectNodeServerSearch getServerSearch(Geometry geometry) {
        Geometry transformedBoundingBox;
        String schluessel = this.txtSchluessel.getText();
        String gemarkung = this.txtGemarkung.getText();
        String flur = this.txtFlur.getText();
        String blatt = this.txtBlatt.getText();
        LinkedList<String> schluesselCollection = new LinkedList<String>();
        if (this.chkFilterSchluessel501.isSelected()) {
            schluesselCollection.add("501");
        }
        if (this.chkFilterSchluessel502.isSelected()) {
            schluesselCollection.add("502");
        }
        if (this.chkFilterSchluessel503.isSelected()) {
            schluesselCollection.add("503");
        }
        if (this.chkFilterSchluessel504.isSelected()) {
            schluesselCollection.add("504");
        }
        if (this.chkFilterSchluessel505.isSelected()) {
            schluesselCollection.add("505");
        }
        if (this.chkFilterSchluessel506.isSelected()) {
            schluesselCollection.add("506");
        }
        if (this.chkFilterSchluessel507.isSelected()) {
            schluesselCollection.add("507");
        }
        if (this.chkFilterSchluessel508.isSelected()) {
            schluesselCollection.add("508");
        }
        if (this.chkFilterSchluessel600.isSelected()) {
            schluesselCollection.add("600");
        }
        LinkedList flurstuecke = new LinkedList();
        for (int i = 0; i < this.flurstuecksvermessungFilterModel.size(); ++i) {
            CidsBean flurstuecksvermessungBean = (CidsBean)this.flurstuecksvermessungFilterModel.getElementAt(i);
            HashMap<String, String> flurstueckMap = new HashMap<String, String>();
            try {
                CidsBean flurstueckBean;
                if (flurstuecksvermessungBean.getProperty("veraenderungsart") instanceof CidsBean) {
                    flurstueckMap.put("veraenderungsart", flurstuecksvermessungBean.getProperty("veraenderungsart.id").toString());
                }
                if ("VERMESSUNG_FLURSTUECK_KICKER".equalsIgnoreCase((flurstueckBean = (CidsBean)flurstuecksvermessungBean.getProperty("flurstueck")).getMetaObject().getMetaClass().getTableName())) {
                    if (flurstueckBean.getProperty("gemarkung") != null) {
                        flurstueckMap.put("gemarkung", flurstueckBean.getProperty("gemarkung.id").toString());
                    }
                    if (flurstueckBean.getProperty("flur") != null) {
                        flurstueckMap.put("flur", flurstueckBean.getProperty("flur").toString());
                    }
                    if (flurstueckBean.getProperty("zaehler") != null) {
                        flurstueckMap.put("zaehler", flurstueckBean.getProperty("zaehler").toString());
                    }
                    if (flurstueckBean.getProperty("nenner") != null) {
                        flurstueckMap.put("nenner", flurstueckBean.getProperty("nenner").toString());
                    }
                } else if ("FLURSTUECK".equalsIgnoreCase(flurstueckBean.getMetaObject().getMetaClass().getTableName())) {
                    if (flurstueckBean.getProperty("gemarkungs_nr") != null) {
                        flurstueckMap.put("gemarkung", flurstueckBean.getProperty("gemarkungs_nr").toString());
                    }
                    if (flurstueckBean.getProperty("flur") != null) {
                        flurstueckMap.put("flur", flurstueckBean.getProperty("flur").toString());
                    }
                    if (flurstueckBean.getProperty("fstnr_z") != null) {
                        flurstueckMap.put("zaehler", flurstueckBean.getProperty("fstnr_z").toString());
                    }
                    if (flurstueckBean.getProperty("fstnr_n") != null) {
                        flurstueckMap.put("nenner", flurstueckBean.getProperty("fstnr_n").toString());
                    }
                }
                flurstuecke.add(flurstueckMap);
                continue;
            }
            catch (Exception ex) {
                LOG.error((Object)("Can not parse information from Flurstueck bean: " + flurstuecksvermessungBean), (Throwable)ex);
            }
        }
        Geometry geometryToSearchFor = null;
        if (geometry != null) {
            geometryToSearchFor = geometry;
        } else if (this.chkSearchInCismap.isSelected()) {
            geometryToSearchFor = ((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry();
        }
        if (geometryToSearchFor != null) {
            transformedBoundingBox = CrsTransformer.transformToDefaultCrs((Geometry)geometryToSearchFor);
            transformedBoundingBox.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        } else {
            transformedBoundingBox = null;
        }
        return new CidsVermessungRissSearchStatement(schluessel, gemarkung, flur, blatt, schluesselCollection, transformedBoundingBox, flurstuecke);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(VermessungRissWindowSearch.class, (String)"VermessungRissWindowSearch.name");
    }

    public boolean checkActionTag() {
        return ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext());
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    public void searchStarted() {
    }

    public void searchDone(int result) {
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    class DropAwareJList
    extends JList
    implements CidsBeanDropListener {
        public DropAwareJList() {
        }

        public DropAwareJList(ListModel dataModel) {
            super(dataModel);
        }

        public DropAwareJList(Object[] listData) {
            super(listData);
        }

        public DropAwareJList(Vector listData) {
            super(listData);
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            try {
                for (CidsBean dropped : beans) {
                    CidsBean newEntry = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"vermessung_flurstuecksvermessung", (ConnectionContext)VermessungRissWindowSearch.this.getConnectionContext());
                    newEntry.setProperty("veraenderungsart", null);
                    newEntry.setProperty("tmp_lp_orig", (Object)dropped);
                    VermessungRissUtils.setFluerstueckKickerInVermessung(newEntry, VermessungRissWindowSearch.this.getConnectionContext());
                    VermessungRissWindowSearch.this.flurstuecksvermessungFilterModel.addElement(newEntry);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Problem when adding the DroppedBeans", (Throwable)ex);
            }
        }
    }

    private final class ChangeVeraenderungsartAction
    extends AbstractAction {
        private final CidsBean veraenderungsart;

        public ChangeVeraenderungsartAction(CidsBean veraenderungsart) {
            this.veraenderungsart = veraenderungsart;
            String veranderungsArtCode = (String)this.veraenderungsart.getProperty("code");
            if (veranderungsArtCode.equals(VermessungRissWindowSearch.VERAENDERUNGSART_ALL_CODE)) {
                this.putValue("Name", this.veraenderungsart.getProperty("name"));
            } else {
                this.putValue("Name", veranderungsArtCode + " - " + this.veraenderungsart.getProperty("name"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Object flurstuecksvermessung : VermessungRissWindowSearch.this.lstFlurstuecke.getSelectedValues()) {
                try {
                    String veraenderungsArtCode = (String)this.veraenderungsart.getProperty("code");
                    if (veraenderungsArtCode.equals(VermessungRissWindowSearch.VERAENDERUNGSART_ALL_CODE)) {
                        ((CidsBean)flurstuecksvermessung).setProperty("veraenderungsart", null);
                    } else {
                        ((CidsBean)flurstuecksvermessung).setProperty("veraenderungsart", (Object)this.veraenderungsart);
                    }
                    VermessungRissWindowSearch.this.lstFlurstuecke.clearSelection();
                    VermessungRissWindowSearch.this.lstFlurstuecke.revalidate();
                    VermessungRissWindowSearch.this.lstFlurstuecke.repaint();
                }
                catch (Exception ex) {
                    LOG.info((Object)("Couldn't set veraenderungsart to '" + this.veraenderungsart + "' for flurstuecksvermessung '" + flurstuecksvermessung + "'."), (Throwable)ex);
                }
            }
        }
    }
}

