/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.actiontag.ActionTagProtected;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.utils.vzkat.VzkatUtils;
import de.cismet.cids.custom.wunda_blau.search.VzkatSchildCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.VzkatSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.server.VzkatSchilderSearch;
import de.cismet.cids.custom.wunda_blau.search.server.VzkatZeichenLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.FastBindableReferenceCombo;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class VzkatWindowSearch
extends JPanel
implements CidsWindowSearch,
ActionTagProtected,
SearchControlListener,
PropertyChangeListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(VzkatWindowSearch.class);
    private static final String ACTION_TAG = "custom.vzkat.search@WUNDA_BLAU";
    private static final ImageIcon ERROR_ICON = new ImageIcon(VzkatWindowSearch.class.getResource("/res/vzkat/error_64.png"));
    public static final String ICON_PATH_TEMPLATE = "/de/cismet/cids/custom/wunda_blau/res/vzkat-bilder/64x64/%s.png";
    private static final Map<String, ImageIcon> ICONS = new WeakHashMap<String, ImageIcon>();
    private SwingWorker<ImageIcon, Void> iconLoadingWorker = null;
    private boolean cbStvoActionListenerEnabled = true;
    private MetaClass metaClass;
    private ImageIcon icon;
    private JPanel pnlSearchCancel;
    private GeoSearchButton btnGeoSearch;
    private MappingComponent mappingComponent;
    private boolean geoSearchEnabled;
    private final VzkatZeichenLightweightSearch verkehrszeichenSearch = new VzkatZeichenLightweightSearch();
    private MetaClass mcVzkatStvo = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private ButtonGroup buttonGroup1;
    private JCheckBox cbMapSearch;
    DefaultBindableReferenceCombo cbStvo;
    private FastBindableReferenceCombo cbVerkehrszeichen;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JLabel lblFiller6;
    private JLabel lblIcon;
    private JPanel pnlButtons;
    private JPanel pnlPruefung;
    private JPanel pnlScrollPane;

    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.initComponents();
            this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.getConnectionContext());
            Dimension max = this.pnlSearchCancel.getMaximumSize();
            Dimension min = this.pnlSearchCancel.getMinimumSize();
            Dimension pre = this.pnlSearchCancel.getPreferredSize();
            this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
            this.pnlButtons.add(this.pnlSearchCancel);
            this.metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"vzkat_standort", (ConnectionContext)this.getConnectionContext());
            byte[] iconDataFromMetaclass = new byte[]{};
            if (this.metaClass != null) {
                iconDataFromMetaclass = this.metaClass.getIconData();
            }
            if (iconDataFromMetaclass.length > 0) {
                LOG.info((Object)"Using icon from metaclass.");
                this.icon = new ImageIcon(this.metaClass.getIconData());
            } else {
                LOG.warn((Object)"Metaclass icon is not set. Trying to load default icon.");
                URL urlToIcon = this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/search/search.png");
                this.icon = urlToIcon != null ? new ImageIcon(urlToIcon) : new ImageIcon(new byte[0]);
            }
            this.pnlButtons.add(Box.createHorizontalStrut(5));
            this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
            boolean bl = this.geoSearchEnabled = this.mappingComponent != null;
            if (this.geoSearchEnabled) {
                VzkatSchildCreateSearchGeometryListener geometryListener = new VzkatSchildCreateSearchGeometryListener(this.mappingComponent, new VzkatSearchTooltip(this.icon));
                geometryListener.addPropertyChangeListener(this);
                this.btnGeoSearch = new GeoSearchButton("VZKAT_SCHILD_CREATE_SEARCH_GEOMETRY", this.mappingComponent, null, "Geo-Suche nach Verkehrszeichen");
                this.pnlButtons.add((Component)this.btnGeoSearch);
            }
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    VzkatWindowSearch.this.mcVzkatStvo = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"VZKAT_STVO", (ConnectionContext)connectionContext);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        VzkatWindowSearch.this.cbStvo.setMetaClass(VzkatWindowSearch.this.mcVzkatStvo);
                        VzkatWindowSearch.this.cbStvo.reload();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }.execute();
        }
        catch (Throwable e) {
            LOG.warn((Object)"Error in Constructor of VzkatStandortWindowSearch. Search will not work properly.", e);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.pnlScrollPane = new JPanel();
        this.pnlPruefung = new JPanel();
        this.jLabel7 = new JLabel();
        this.cbStvo = new DefaultBindableReferenceCombo(this.mcVzkatStvo, true, false);
        this.cbVerkehrszeichen = new FastBindableReferenceCombo((LightweightMetaObjectsSearch)this.verkehrszeichenSearch, this.verkehrszeichenSearch.getRepresentationPattern(), this.verkehrszeichenSearch.getRepresentationFields());
        this.lblIcon = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jLabel8 = new JLabel();
        this.pnlButtons = new JPanel();
        this.cbMapSearch = new JCheckBox();
        this.lblFiller6 = new JLabel();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.setPreferredSize(new Dimension(70, 20));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.pnlScrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.pnlScrollPane.setLayout(new GridBagLayout());
        this.pnlPruefung.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatWindowSearch.pnlPruefung.border.title")));
        this.pnlPruefung.setMaximumSize(new Dimension(550, Integer.MAX_VALUE));
        this.pnlPruefung.setMinimumSize(new Dimension(550, 96));
        this.pnlPruefung.setPreferredSize(new Dimension(550, 96));
        this.pnlPruefung.setLayout(new GridBagLayout());
        this.jLabel7.setText(NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatWindowSearch.jLabel7.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlPruefung.add((Component)this.jLabel7, gridBagConstraints);
        this.cbStvo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VzkatWindowSearch.this.cbStvoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.pnlPruefung.add((Component)this.cbStvo, gridBagConstraints);
        this.cbVerkehrszeichen.setMetaClassFromTableName("WUNDA_BLAU", "vzkat_zeichen");
        this.cbVerkehrszeichen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VzkatWindowSearch.this.cbVerkehrszeichenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.pnlPruefung.add((Component)this.cbVerkehrszeichen, gridBagConstraints);
        this.lblIcon.setText(NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatWindowSearch.lblIcon.text"));
        this.lblIcon.setMaximumSize(new Dimension(64, 64));
        this.lblIcon.setMinimumSize(new Dimension(64, 64));
        this.lblIcon.setPreferredSize(new Dimension(64, 64));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlPruefung.add((Component)this.lblIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlPruefung.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlPruefung.add((Component)this.filler3, gridBagConstraints);
        this.jLabel8.setText(NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatWindowSearch.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlPruefung.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 20);
        this.pnlScrollPane.add((Component)this.pnlPruefung, gridBagConstraints);
        this.pnlPruefung.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatWindowSearch.pnlPruefung.AccessibleContext.accessibleName"));
        this.pnlButtons.setLayout(new BoxLayout(this.pnlButtons, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 20);
        this.pnlScrollPane.add((Component)this.pnlButtons, gridBagConstraints);
        this.cbMapSearch.setText(NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatWindowSearch.cbMapSearch.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 25, 0, 25);
        this.pnlScrollPane.add((Component)this.cbMapSearch, gridBagConstraints);
        this.lblFiller6.setText(NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatWindowSearch.lblFiller6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlScrollPane.add((Component)this.lblFiller6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlScrollPane.add((Component)this.filler2, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.pnlScrollPane);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cbStvoActionPerformed(ActionEvent evt) {
        if (this.cbStvoActionListenerEnabled) {
            CidsBean stvoBean = (CidsBean)this.cbStvo.getSelectedItem();
            this.verkehrszeichenSearch.setStvoId(stvoBean != null ? (Integer)stvoBean.getProperty("id") : null);
            this.cbVerkehrszeichen.setSelectedItem(null);
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    VzkatWindowSearch.this.cbVerkehrszeichen.refreshModel();
                    return null;
                }
            }.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cbVerkehrszeichenActionPerformed(ActionEvent evt) {
        String text;
        JTextField txt = (JTextField)this.cbVerkehrszeichen.getEditor().getEditorComponent();
        CidsBean selectedZeichen = (CidsBean)this.cbVerkehrszeichen.getSelectedItem();
        if (selectedZeichen != null) {
            text = VzkatUtils.createZeichenToString((CidsBean)selectedZeichen);
            CidsBean selectedStvo = this.cbStvo.getSelectedItem() instanceof CidsBean ? (CidsBean)this.cbStvo.getSelectedItem() : null;
            CidsBean stvoOfSelectedZeichen = (CidsBean)selectedZeichen.getProperty("fk_stvo");
            if (!Objects.equals(stvoOfSelectedZeichen, selectedStvo)) {
                try {
                    this.cbStvoActionListenerEnabled = false;
                    this.cbStvo.setSelectedItem((Object)stvoOfSelectedZeichen);
                }
                finally {
                    this.cbStvoActionListenerEnabled = true;
                }
            }
            this.refreshIcon(VzkatUtils.createZeichenKey((CidsBean)selectedZeichen));
        } else {
            text = "";
            this.refreshIcon(null);
        }
        txt.setText(text);
    }

    public ImageIcon loadZeichenIcon(String key) throws Exception {
        InputStream is = this.getClass().getResourceAsStream(String.format(ICON_PATH_TEMPLATE, key));
        return new ImageIcon(ImageIO.read(is));
    }

    private void refreshIcon(final String key) {
        if (key != null) {
            this.iconLoadingWorker = new SwingWorker<ImageIcon, Void>(){

                @Override
                protected ImageIcon doInBackground() throws Exception {
                    return VzkatWindowSearch.this.loadZeichenIcon(key);
                }

                @Override
                protected void done() {
                    if (this.equals(VzkatWindowSearch.this.iconLoadingWorker)) {
                        try {
                            ImageIcon icon = (ImageIcon)this.get();
                            ICONS.put(key, icon);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                            ICONS.put(key, ERROR_ICON);
                        }
                        VzkatWindowSearch.this.lblIcon.setIcon((Icon)ICONS.get(key));
                    }
                }
            };
            this.iconLoadingWorker.execute();
        } else {
            this.lblIcon.setIcon(null);
        }
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    private MetaObjectNodeServerSearch getServerSearch(Geometry geometry) {
        Geometry transformedBoundingBox;
        VzkatSchilderSearch.SearchMode mode = VzkatSchilderSearch.SearchMode.AND;
        Object geometryToSearchFor = geometry != null ? geometry : (this.cbMapSearch.isSelected() ? ((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry() : null);
        if (geometryToSearchFor != null) {
            transformedBoundingBox = CrsTransformer.transformToDefaultCrs((Geometry)geometryToSearchFor);
            transformedBoundingBox.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        } else {
            transformedBoundingBox = null;
        }
        VzkatSchilderSearch search = new VzkatSchilderSearch();
        search.setSearchFor(VzkatSchilderSearch.SearchFor.SCHILD);
        search.setGeom(transformedBoundingBox);
        search.setSearchMode(mode);
        search.setZeichenId(this.cbVerkehrszeichen.getSelectedItem() != null ? (Integer)((CidsBean)this.cbVerkehrszeichen.getSelectedItem()).getProperty("id") : null);
        return search;
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return this.getServerSearch(null);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean checkActionTag() {
        return ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext());
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    public void searchStarted() {
    }

    public void searchDone(int numberOfResults) {
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(VzkatWindowSearch.class, (String)"VzkatStandortWindowSearch.name");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }
}

